/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.cdtinterface.errorparsers;

import java.util.StringTokenizer;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class LaheyFortranErrorParser
implements IErrorParser {
    private boolean laheyFlag = false;

    public boolean processLine(String line, ErrorParserManager epm) {
        if (line.startsWith("Lahey/Fujitsu")) {
            this.laheyFlag = true;
        }
        if (!this.laheyFlag) {
            return false;
        }
        if (line.length() < 5) {
            return false;
        }
        String s4 = line.substring(4);
        if (s4.startsWith("-S:")) {
            StringTokenizer tokenizer = new StringTokenizer(line, ":");
            try {
                tokenizer.nextToken();
                String severityString = "Error";
                String fileString = tokenizer.nextToken(",").substring(2).trim();
                String lineString = tokenizer.nextToken(",:").substring(1).trim();
                String message = tokenizer.nextToken("\r\n").substring(2).trim();
                int severity = severityString.equals("Error") ? 2 : 1;
                String lineNumberString = lineString.substring(5);
                int lineNumber = Integer.parseInt(lineNumberString);
                fileString = fileString.substring(1, fileString.length() - 1);
                IFile file = epm.findFilePath(fileString);
                epm.generateMarker((IResource)file, lineNumber, message, severity, null);
            }
            catch (Throwable throwable) {}
        }
        return false;
    }
}

