/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.jdt.MavenJdtPlugin;
import org.eclipse.m2e.jdt.internal.BuildPathManager;
import org.eclipse.m2e.jdt.internal.MavenClasspathHelpers;
import org.eclipse.m2e.jdt.internal.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenClasspathContainerInitializer
extends ClasspathContainerInitializer {
    private static final Logger log = LoggerFactory.getLogger(MavenClasspathContainerInitializer.class);

    public void initialize(IPath containerPath, IJavaProject project) {
        if (MavenClasspathHelpers.isMaven2ClasspathContainer(containerPath)) {
            try {
                IClasspathContainer mavenContainer = this.getBuildPathManager().getSavedContainer(project.getProject());
                if (mavenContainer != null) {
                    JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{mavenContainer}, (IProgressMonitor)new NullProgressMonitor());
                    return;
                }
            }
            catch (CoreException ex) {
                log.error("Exception initializing classpath container " + containerPath.toString(), (Throwable)ex);
            }
            IMavenConfiguration configuration = MavenPlugin.getMavenConfiguration();
            MavenUpdateRequest request = new MavenUpdateRequest(project.getProject(), configuration.isOffline(), false);
            this.getMavenProjectManager().refresh(request);
        }
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void requestClasspathContainerUpdate(IPath containerPath, final IJavaProject project, final IClasspathContainer containerSuggestion) {
        new Job(Messages.MavenClasspathContainerInitializer_job_name){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    MavenClasspathContainerInitializer.this.getBuildPathManager().persistAttachedSourcesAndJavadoc(project, containerSuggestion, monitor);
                }
                catch (CoreException ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                    return new Status(4, "org.eclipse.m2e.core", 0, Messages.MavenClasspathContainerInitializer_error_cannot_persist, (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    BuildPathManager getBuildPathManager() {
        return (BuildPathManager)MavenJdtPlugin.getDefault().getBuildpathManager();
    }

    IMavenProjectRegistry getMavenProjectManager() {
        return MavenPlugin.getMavenProjectRegistry();
    }
}

