/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import java.util.HashMap;
import org.eclipse.cdt.internal.ui.refactoring.rename.HeaderFileReferenceAdjuster;
import org.eclipse.cdt.internal.ui.refactoring.rename.RenameMessages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class HeaderFileRenameParticipant
extends RenameParticipant {
    private IResource renamedResource;
    private Change change;

    protected boolean initialize(Object element) {
        if (element instanceof IResource) {
            this.renamedResource = (IResource)element;
            return true;
        }
        return false;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        RenameArguments args = this.getArguments();
        if (!args.getUpdateReferences()) {
            return null;
        }
        if (this.renamedResource.isLinked()) {
            return null;
        }
        String newName = args.getNewName();
        try {
            final HashMap<IFile, IFile> movedFiles = new HashMap<IFile, IFile>();
            if (this.renamedResource instanceof IContainer) {
                final IPath oldPath = this.renamedResource.getFullPath();
                final IPath newPath = oldPath.removeLastSegments(1).append(newName);
                final IWorkspaceRoot workspaceRoot = this.renamedResource.getWorkspace().getRoot();
                ((IContainer)this.renamedResource).accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        if (proxy.isLinked()) {
                            return false;
                        }
                        if (proxy.getType() == 1) {
                            IFile file = (IFile)proxy.requestResource();
                            IPath path = HeaderFileRenameParticipant.replacePrefix(file.getFullPath(), oldPath.segmentCount(), newPath);
                            movedFiles.put(file, workspaceRoot.getFile(path));
                            return false;
                        }
                        return true;
                    }
                }, 0);
            } else if (this.renamedResource instanceof IFile) {
                IFile file = (IFile)this.renamedResource;
                movedFiles.put(file, file.getParent().getFile((IPath)new Path(newName)));
            }
            HeaderFileReferenceAdjuster includeAdjuster = new HeaderFileReferenceAdjuster(movedFiles);
            this.change = includeAdjuster.createChange(context, pm);
        }
        catch (CoreException e) {
            return RefactoringStatus.create((IStatus)e.getStatus());
        }
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.done();
        return this.change;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.done();
        return null;
    }

    public String getName() {
        return RenameMessages.HeaderFileRenameParticipant_name;
    }

    private static IPath replacePrefix(IPath path, int prefixLength, IPath newPrefix) {
        return newPrefix.append(path.removeFirstSegments(prefixLength));
    }
}

