/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.ASTCommenter;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;
import org.eclipse.cdt.internal.core.dom.rewrite.util.ASTNodes;
import org.eclipse.cdt.internal.core.util.TextUtil;
import org.eclipse.cdt.internal.corext.codemanipulation.IncludeInfo;
import org.eclipse.cdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.cdt.internal.corext.codemanipulation.StyledInclude;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeCreationContext;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeGroupStyle;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludePreferences;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.cdt.ui.refactoring.CTextFileChange;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class HeaderFileReferenceAdjuster {
    private static final int PARSE_MODE = 167;
    private final Map<IFile, IFile> movedFiles;
    private final Map<String, IPath> movedFilesByLocation;
    private IIndex index;
    private int indexLockCount;

    public HeaderFileReferenceAdjuster(Map<IFile, IFile> movedFiles) {
        this.movedFiles = movedFiles;
        this.movedFilesByLocation = new HashMap<String, IPath>();
        for (Map.Entry<IFile, IFile> entry : movedFiles.entrySet()) {
            this.movedFilesByLocation.put(entry.getKey().getLocation().toOSString(), entry.getValue().getLocation());
        }
    }

    public Change createChange(CheckConditionsContext context, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        CompositeChange change = null;
        HashSet<IFile> affectedFiles = new HashSet<IFile>();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.lockIndex();
        try {
            for (Map.Entry<IFile, IFile> entry : this.movedFiles.entrySet()) {
                IIndexFile[] indexFiles;
                IFile newFile;
                IFile oldFile = entry.getKey();
                if (HeaderFileReferenceAdjuster.areIncludeGuardsAffected(oldFile, newFile = entry.getValue())) {
                    affectedFiles.add(oldFile);
                }
                IIndexFileLocation indexFileLocation = IndexLocationFactory.getWorkspaceIFL((IFile)oldFile);
                IIndexFile[] iIndexFileArray = indexFiles = this.index.getFiles(indexFileLocation);
                int n = indexFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexInclude[] includes;
                    IIndexFile indexFile = iIndexFileArray[n2];
                    IIndexInclude[] iIndexIncludeArray = includes = this.index.findIncludedBy(indexFile);
                    int n3 = includes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource resource;
                        IIndexInclude include = iIndexIncludeArray[n4];
                        IIndexFileLocation includeLocation = include.getIncludedByLocation();
                        String path = includeLocation.getFullPath();
                        if (path != null && (resource = workspaceRoot.findMember(path)).getType() == 1) {
                            IFile includer = (IFile)resource;
                            affectedFiles.add(includer);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            IWorkingCopyManager workingCopyManager = CUIPlugin.getDefault().getWorkingCopyManager();
            IWorkingCopy[] workingCopies = workingCopyManager.getSharedWorkingCopies();
            progress.worked(1);
            progress = SubMonitor.convert((IProgressMonitor)progress.newChild(9), (int)(workingCopies.length + affectedFiles.size()));
            ArrayList<Change> changes = new ArrayList<Change>();
            ValidateEditChecker checker = (ValidateEditChecker)context.getChecker(ValidateEditChecker.class);
            IWorkingCopy[] iWorkingCopyArray = workingCopies;
            int n = workingCopies.length;
            int indexFiles = 0;
            while (indexFiles < n) {
                IWorkingCopy tu = iWorkingCopyArray[indexFiles];
                this.addFileChange((ITranslationUnit)tu, changes, checker, (IProgressMonitor)progress.newChild(1));
                ++indexFiles;
            }
            CoreModel coreModel = CoreModel.getDefault();
            for (IFile file : affectedFiles) {
                ITranslationUnit tu = (ITranslationUnit)coreModel.create(file);
                if (workingCopyManager.findSharedWorkingCopy(tu) != null) continue;
                this.addFileChange(tu, changes, checker, (IProgressMonitor)progress.newChild(1));
            }
            if (!changes.isEmpty()) {
                change = new CompositeChange("", changes.toArray(new Change[changes.size()]));
                change.markAsSynthetic();
            }
        }
        finally {
            this.unlockIndex();
            pm.done();
        }
        return change;
    }

    private void addFileChange(ITranslationUnit tu, List<Change> changes, ValidateEditChecker checker, IProgressMonitor pm) throws CoreException {
        TextEdit edit = this.createEdit(tu, pm);
        if (edit != null) {
            CTextFileChange fileChange = new CTextFileChange(tu.getElementName(), tu);
            fileChange.setEdit(edit);
            changes.add((Change)fileChange);
            checker.addFile(fileChange.getFile());
        }
    }

    /*
     * Unable to fully structure code
     */
    private TextEdit createEdit(ITranslationUnit tu, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        block6: {
            block4: {
                block5: {
                    HeaderFileReferenceAdjuster.checkCanceled(pm);
                    sharedAst = null;
                    progress = SubMonitor.convert((IProgressMonitor)pm, (int)2);
                    try {
                        ast = ASTProvider.getASTProvider().acquireSharedAST(tu, this.index, ASTProvider.WAIT_ACTIVE_ONLY, (IProgressMonitor)progress.newChild(1));
                        if (ast != null) break block4;
                        HeaderFileReferenceAdjuster.checkCanceled(pm);
                        ast = tu.getAST(this.index, 167);
                        if (ast != null) ** GOTO lbl23
                        if (sharedAst == null) break block5;
                        ASTProvider.getASTProvider().releaseSharedAST(sharedAst);
                    }
                    catch (Throwable var6_7) {
                        if (sharedAst != null) {
                            ASTProvider.getASTProvider().releaseSharedAST(sharedAst);
                        }
                        pm.done();
                        throw var6_7;
                    }
                }
                pm.done();
                return null;
            }
            sharedAst = ast;
lbl23:
            // 2 sources

            var7_6 = this.createEdit(ast, tu, (IProgressMonitor)progress.newChild(1));
            if (sharedAst == null) break block6;
            ASTProvider.getASTProvider().releaseSharedAST(sharedAst);
        }
        pm.done();
        return var7_6;
    }

    /*
     * WARNING - void declaration
     */
    private TextEdit createEdit(IASTTranslationUnit ast, ITranslationUnit tu, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        void var13_23;
        IPath header;
        IASTPreprocessorIncludeStatement[] existingIncludes;
        IncludeCreationContext context = new IncludeCreationContext(tu, this.index);
        String contents = context.getSourceContents();
        MultiTextEdit rootEdit = this.createIncludeGuardEdit(ast, tu, contents);
        IdentityHashMap<IASTPreprocessorIncludeStatement, IPath> affectedIncludes = new IdentityHashMap<IASTPreprocessorIncludeStatement, IPath>();
        IASTPreprocessorIncludeStatement[] iASTPreprocessorIncludeStatementArray = existingIncludes = ast.getIncludeDirectives();
        int n = existingIncludes.length;
        int n2 = 0;
        while (n2 < n) {
            block38: {
                void var13_15;
                Object newLocation;
                IASTPreprocessorIncludeStatement include;
                block40: {
                    block39: {
                        include = iASTPreprocessorIncludeStatementArray[n2];
                        if (!include.isPartOfTranslationUnitFile()) break block38;
                        if (!include.isActive()) break block39;
                        String n4 = include.getPath();
                        if (!n4.isEmpty()) break block40;
                        break block38;
                    }
                    String name = new String(include.getName().getSimpleID());
                    IncludeInfo includeInfo = new IncludeInfo(name, include.isSystemInclude());
                    IPath path = context.resolveInclude(includeInfo);
                    if (path == null) break block38;
                    String string = path.toString();
                }
                if ((newLocation = this.movedFilesByLocation.get(var13_15)) != null) {
                    affectedIncludes.put(include, (IPath)newLocation);
                }
            }
            ++n2;
        }
        if (affectedIncludes.isEmpty()) {
            return rootEdit;
        }
        NodeCommentMap commentedNodeMap = ASTCommenter.getCommentedNodeMap((IASTTranslationUnit)ast);
        IRegion includeRegion = IncludeUtil.getSafeIncludeReplacementRegion(contents, ast, commentedNodeMap);
        IncludePreferences preferences = context.getPreferences();
        if (rootEdit == null) {
            rootEdit = new MultiTextEdit();
        }
        context.addHeadersIncludedPreviously(existingIncludes);
        if (preferences.allowReordering) {
            void var18_35;
            Object include;
            ArrayList<Object> modifiedIncludes = new ArrayList<Object>();
            for (Map.Entry entry : affectedIncludes.entrySet()) {
                IASTPreprocessorIncludeStatement existingInclude = (IASTPreprocessorIncludeStatement)entry.getKey();
                if (!IncludeUtil.isContainedInRegion((IASTNode)existingInclude, includeRegion)) continue;
                header = (IPath)entry.getValue();
                IncludeGroupStyle style = context.getIncludeStyle(header);
                IncludeInfo includeInfo = context.createIncludeInfo(header, style);
                include = new StyledInclude(header, includeInfo, style, existingInclude);
                modifiedIncludes.add(include);
            }
            Collections.sort(modifiedIncludes, preferences);
            List<StyledInclude> list = IncludeUtil.getIncludesInRegion(existingIncludes, includeRegion, context);
            ArrayDeque<DeleteEdit> deletes = new ArrayDeque<DeleteEdit>();
            int deleteOffset = -1;
            boolean emptyLineEncountered = false;
            int j = 0;
            boolean bl = false;
            while (var18_35 < list.size()) {
                include = list.get((int)var18_35);
                IASTPreprocessorIncludeStatement existingInclude = ((StyledInclude)include).getExistingInclude();
                int offset = ASTNodes.offset((IASTNode)existingInclude);
                boolean previousLineBlank = TextUtil.isPreviousLineBlank((String)contents, (int)offset);
                if (affectedIncludes.containsKey(existingInclude)) {
                    if (deleteOffset < 0) {
                        deleteOffset = offset;
                    } else if (!emptyLineEncountered && previousLineBlank) {
                        deletes.add(new DeleteEdit(deleteOffset, offset - deleteOffset));
                        deleteOffset = -1;
                    }
                    emptyLineEncountered |= previousLineBlank;
                } else {
                    if (deleteOffset >= 0) {
                        if (!emptyLineEncountered && previousLineBlank) {
                            offset = TextUtil.getPreviousLineStart((String)contents, (int)offset);
                        }
                        deletes.add(new DeleteEdit(deleteOffset, offset - deleteOffset));
                        deleteOffset = -1;
                    }
                    emptyLineEncountered = false;
                    if (j < var18_35) {
                        list.set(j, (StyledInclude)include);
                    }
                    ++j;
                }
                ++var18_35;
            }
            while (j < list.size()) {
                list.remove(list.size() - 1);
            }
            if (deleteOffset >= 0) {
                deletes.add(new DeleteEdit(deleteOffset, includeRegion.getOffset() + includeRegion.getLength() - deleteOffset));
            }
            for (StyledInclude styledInclude : modifiedIncludes) {
                if (!IncludeUtil.isContainedInRegion((IASTNode)styledInclude.getExistingInclude(), includeRegion)) continue;
                int i2 = list.size();
                while (--i2 >= 0 && preferences.compare(styledInclude, list.get(i2)) < 0) {
                }
                list.add(i2 + 1, styledInclude);
            }
            int n3 = includeRegion.getOffset();
            StringBuilder text = new StringBuilder();
            StyledInclude previousInclude = null;
            for (StyledInclude include3 : list) {
                int n4;
                IASTPreprocessorIncludeStatement existingInclude = include3.getExistingInclude();
                if (affectedIncludes.containsKey(existingInclude)) {
                    if (previousInclude != null) {
                        IASTPreprocessorIncludeStatement previousNode = previousInclude.getExistingInclude();
                        if (!affectedIncludes.containsKey(previousNode)) {
                            n4 = ASTNodes.skipToNextLineAfterNode((String)contents, (IASTNode)previousNode);
                            this.flushEditBuffer(n4, text, deletes, rootEdit);
                            if (contents.charAt(n4 - 1) != '\n') {
                                text.append(context.getLineDelimiter());
                            }
                        }
                        if (HeaderFileReferenceAdjuster.isBlankLineNeededBetween(previousInclude, include3, preferences)) {
                            if (TextUtil.isLineBlank((String)contents, (int)n4)) {
                                int oldOffset = n4;
                                if ((n4 = TextUtil.skipToNextLine((String)contents, (int)n4)) == oldOffset || contents.charAt(n4 - 1) != '\n') {
                                    text.append(context.getLineDelimiter());
                                }
                            } else {
                                text.append(context.getLineDelimiter());
                            }
                        }
                    }
                    text.append(include3.getIncludeInfo().composeIncludeStatement());
                    List comments = commentedNodeMap.getTrailingCommentsForNode((IASTNode)existingInclude);
                    for (IASTComment comment : comments) {
                        text.append(ASTNodes.getPrecedingWhitespaceInLine((String)contents, (IASTNode)comment));
                        text.append(comment.getRawSignature());
                    }
                    text.append(context.getLineDelimiter());
                } else {
                    if (previousInclude != null && affectedIncludes.containsKey(previousInclude.getExistingInclude()) && HeaderFileReferenceAdjuster.isBlankLineNeededBetween(previousInclude, include3, preferences) && TextUtil.findBlankLine((String)contents, (int)n4, (int)ASTNodes.offset((IASTNode)existingInclude)) < 0) {
                        text.append(context.getLineDelimiter());
                    }
                    this.flushEditBuffer(n4, text, deletes, rootEdit);
                }
                previousInclude = include3;
            }
            if (includeRegion.getLength() == 0 && !TextUtil.isLineBlank((String)contents, (int)includeRegion.getOffset())) {
                text.append(context.getLineDelimiter());
            }
            int n5 = includeRegion.getOffset() + includeRegion.getLength();
            this.flushEditBuffer(n5, text, deletes, rootEdit);
        }
        IASTPreprocessorIncludeStatement[] iASTPreprocessorIncludeStatementArray2 = existingIncludes;
        int n6 = existingIncludes.length;
        boolean bl = false;
        while (var13_23 < n6) {
            IASTPreprocessorIncludeStatement existingInclude = iASTPreprocessorIncludeStatementArray2[var13_23];
            header = (IPath)affectedIncludes.get(existingInclude);
            if (!(header == null || preferences.allowReordering && IncludeUtil.isContainedInRegion((IASTNode)existingInclude, includeRegion))) {
                IncludeGroupStyle style = context.getIncludeStyle(header);
                IncludeInfo includeInfo = context.createIncludeInfo(header, style);
                IASTName name = existingInclude.getName();
                int offset = ASTNodes.offset((IASTNode)name) - 1;
                int length = ASTNodes.endOffset((IASTNode)name) + 1 - offset;
                rootEdit.addChild((TextEdit)new ReplaceEdit(offset, length, includeInfo.toString()));
            }
            ++var13_23;
        }
        return rootEdit;
    }

    private static boolean isBlankLineNeededBetween(StyledInclude include1, StyledInclude include2, IncludePreferences preferences) {
        return include2.getStyle().isBlankLineNeededAfter(include1.getStyle(), preferences.includeStyles);
    }

    private MultiTextEdit createIncludeGuardEdit(IASTTranslationUnit ast, ITranslationUnit tu, String contents) {
        IResource resource = tu.getResource();
        IFile newFile = this.movedFiles.get(resource);
        if (newFile == null) {
            return null;
        }
        boolean guardsAffected = HeaderFileReferenceAdjuster.areIncludeGuardsAffected((IFile)resource, newFile);
        if (!guardsAffected) {
            return null;
        }
        ArrayList<IRegion> includeGuardPositions = new ArrayList<IRegion>();
        String oldGuard = IncludeUtil.findIncludeGuard(contents, ast, includeGuardPositions);
        if (oldGuard == null) {
            return null;
        }
        if (!oldGuard.equals(StubUtility.generateIncludeGuardSymbol(resource, tu.getCProject()))) {
            return null;
        }
        IProject newProject = newFile.getProject();
        ICProject newCProject = CoreModel.getDefault().create(newProject);
        if (newCProject == null) {
            return null;
        }
        String guard = StubUtility.generateIncludeGuardSymbol((IResource)newFile, newCProject);
        if (guard.equals(oldGuard)) {
            return null;
        }
        MultiTextEdit rootEdit = new MultiTextEdit();
        for (IRegion region : includeGuardPositions) {
            rootEdit.addChild((TextEdit)new ReplaceEdit(region.getOffset(), region.getLength(), guard));
        }
        return rootEdit;
    }

    private void flushEditBuffer(int offset, StringBuilder text, Deque<DeleteEdit> deletes, MultiTextEdit edit) {
        this.consumeDeletesUpTo(offset, deletes, edit);
        if (text.length() != 0) {
            edit.addChild((TextEdit)new InsertEdit(offset, text.toString()));
            text.delete(0, text.length());
        }
    }

    private void consumeDeletesUpTo(int offset, Deque<DeleteEdit> deletes, MultiTextEdit rootEdit) {
        while (!deletes.isEmpty()) {
            DeleteEdit edit = deletes.peek();
            if (edit.getOffset() > offset) break;
            deletes.remove();
            rootEdit.addChild((TextEdit)edit);
        }
    }

    private void lockIndex() throws CoreException, OperationCanceledException {
        if (this.indexLockCount == 0) {
            if (this.index == null) {
                ICProject[] projects = CoreModel.getDefault().getCModel().getCProjects();
                this.index = CCorePlugin.getIndexManager().getIndex(projects, 1024);
            }
            try {
                this.index.acquireReadLock();
            }
            catch (InterruptedException interruptedException) {
                throw new OperationCanceledException();
            }
        }
        ++this.indexLockCount;
    }

    private void unlockIndex() {
        if (--this.indexLockCount <= 0) {
            if (this.index != null) {
                this.index.releaseReadLock();
            }
            this.index = null;
        }
    }

    private static void checkCanceled(IProgressMonitor pm) throws OperationCanceledException {
        if (pm != null && pm.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private static boolean areIncludeGuardsAffected(IFile oldfile, IFile newFile) {
        String filename = oldfile.getLocation().lastSegment();
        if (!CoreModel.isValidHeaderUnitName(null, (String)filename)) {
            return false;
        }
        IPreferencesService preferences = Platform.getPreferencesService();
        IScopeContext[] scopes = PreferenceConstants.getPreferenceScopes(oldfile.getProject());
        int schema = preferences.getInt("org.eclipse.cdt.ui", "codetemplates.includeGuardGenerationScheme", 0, scopes);
        switch (schema) {
            case 2: {
                return true;
            }
            case 0: {
                return !filename.equals(newFile.getName());
            }
        }
        return false;
    }
}

