/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.includes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorPragmaStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.util.CharArrayIntMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;
import org.eclipse.cdt.internal.core.dom.rewrite.util.ASTNodes;
import org.eclipse.cdt.internal.core.parser.scanner.AbstractCharArray;
import org.eclipse.cdt.internal.core.parser.scanner.CharArray;
import org.eclipse.cdt.internal.core.parser.scanner.IncludeGuardDetection;
import org.eclipse.cdt.internal.core.parser.scanner.Lexer;
import org.eclipse.cdt.internal.core.util.TextUtil;
import org.eclipse.cdt.internal.corext.codemanipulation.IncludeInfo;
import org.eclipse.cdt.internal.corext.codemanipulation.InclusionContext;
import org.eclipse.cdt.internal.corext.codemanipulation.StyledInclude;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeGroupStyle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class IncludeUtil {
    private IncludeUtil() {
    }

    public static boolean isSource(IIndexFile file, IProject project) throws CoreException {
        return IncludeUtil.isSource(IncludeUtil.getPath(file), project);
    }

    public static boolean isSource(String filename, IProject project) {
        String id;
        IContentType ct = CCorePlugin.getContentType((IProject)project, (String)filename);
        return ct != null && ("org.eclipse.cdt.core.cSource".equals(id = ct.getId()) || "org.eclipse.cdt.core.cxxSource".equals(id));
    }

    public static String getPath(IIndexFile file) throws CoreException {
        return IncludeUtil.getPath(file.getLocation());
    }

    public static String getPath(IIndexFileLocation fileLocation) {
        return IndexLocationFactory.getAbsolutePath((IIndexFileLocation)fileLocation).toOSString();
    }

    public static boolean isContainedInRegion(IASTNode node, IRegion region) {
        return ASTNodes.offset((IASTNode)node) >= region.getOffset() && ASTNodes.endOffset((IASTNode)node) <= region.getOffset() + region.getLength();
    }

    public static IRegion getSafeIncludeReplacementRegion(String contents, IASTTranslationUnit ast, NodeCommentMap commentMap) {
        int maxSafeOffset = ast.getFileLocation().getNodeLength();
        IASTDeclaration[] declarations = ast.getDeclarations(true);
        if (declarations.length != 0) {
            maxSafeOffset = declarations[0].getFileLocation().getNodeOffset();
        }
        boolean topCommentSkipped = false;
        int includeOffset = -1;
        int includeEndOffset = -1;
        int includeGuardStatementsToSkip = IncludeUtil.getNumberOfIncludeGuardStatementsToSkip(contents, ast);
        int includeGuardEndOffset = -1;
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = ast.getAllPreprocessorStatements();
        int n = iASTPreprocessorStatementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorStatement statement = iASTPreprocessorStatementArray[n2];
            if (statement.isPartOfTranslationUnitFile()) {
                IASTFileLocation fileLocation = statement.getFileLocation();
                int offset = fileLocation.getNodeOffset();
                if (offset >= maxSafeOffset) break;
                int endOffset = offset + fileLocation.getNodeLength();
                if (includeGuardStatementsToSkip > 0) {
                    --includeGuardStatementsToSkip;
                    includeGuardEndOffset = endOffset;
                    if (!commentMap.getLeadingCommentsForNode((IASTNode)statement).isEmpty()) {
                        topCommentSkipped = true;
                    }
                } else {
                    if (!(statement instanceof IASTPreprocessorIncludeStatement)) break;
                    if (includeOffset < 0) {
                        includeOffset = offset;
                    }
                    includeEndOffset = endOffset;
                    includeGuardStatementsToSkip = 0;
                }
            }
            ++n2;
        }
        if (includeOffset < 0) {
            includeOffset = includeGuardEndOffset >= 0 ? TextUtil.skipToNextLine((String)contents, (int)includeGuardEndOffset) : 0;
            if (!topCommentSkipped) {
                includeOffset = IncludeUtil.skipStandaloneCommentBlock(contents, includeOffset, maxSafeOffset, ast.getComments(), commentMap);
            }
            includeEndOffset = includeOffset;
        } else {
            includeEndOffset = TextUtil.skipToNextLine((String)contents, (int)includeEndOffset);
        }
        return new Region(includeOffset, includeEndOffset - includeOffset);
    }

    public static List<StyledInclude> getIncludesInRegion(IASTPreprocessorIncludeStatement[] existingIncludes, IRegion region, InclusionContext inclusionContext) {
        ArrayList<StyledInclude> includes = new ArrayList<StyledInclude>();
        IASTPreprocessorIncludeStatement[] iASTPreprocessorIncludeStatementArray = existingIncludes;
        int n = existingIncludes.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorIncludeStatement include = iASTPreprocessorIncludeStatementArray[n2];
            if (include.isPartOfTranslationUnitFile() && IncludeUtil.isContainedInRegion((IASTNode)include, region)) {
                String name = new String(include.getName().getSimpleID());
                IncludeInfo includeInfo = new IncludeInfo(name, include.isSystemInclude());
                String path = include.getPath();
                IPath header = path.isEmpty() ? null : Path.fromOSString((String)path);
                IncludeGroupStyle style = header != null ? inclusionContext.getIncludeStyle(header) : inclusionContext.getIncludeStyle(includeInfo);
                StyledInclude prototype = new StyledInclude(header, includeInfo, style, include);
                includes.add(prototype);
            }
            ++n2;
        }
        return includes;
    }

    public static String findIncludeGuard(String contents, IASTTranslationUnit ast, List<IRegion> includeGuardPositions) {
        char[] guardChars;
        includeGuardPositions.clear();
        IASTPreprocessorStatement[] preprocessorStatements = ast.getAllPreprocessorStatements();
        int i = 0;
        while (true) {
            if (i >= preprocessorStatements.length) {
                return null;
            }
            if (preprocessorStatements[i].isPartOfTranslationUnitFile()) break;
            ++i;
        }
        IASTPreprocessorStatement statement = preprocessorStatements[i];
        int offset = 0;
        if (IncludeUtil.isPragmaOnce(statement)) {
            offset = ASTNodes.endOffset((IASTNode)statement);
            ++i;
        }
        if ((guardChars = IncludeUtil.detectIncludeGuard(contents, offset)) == null) {
            return null;
        }
        String guard = new String(guardChars);
        int count = 0;
        IASTPreprocessorStatement lastStatement = null;
        while (i < preprocessorStatements.length) {
            statement = preprocessorStatements[i];
            if (statement.isPartOfTranslationUnitFile()) {
                if (count < 2) {
                    IncludeUtil.findGuardInRange(contents, guard, ASTNodes.offset((IASTNode)statement), ASTNodes.endOffset((IASTNode)statement), includeGuardPositions);
                    ++count;
                } else {
                    lastStatement = statement;
                }
            }
            ++i;
        }
        if (lastStatement != null) {
            IncludeUtil.findGuardInRange(contents, guard, ASTNodes.offset(lastStatement), contents.length(), includeGuardPositions);
        }
        return guard;
    }

    private static int getNumberOfIncludeGuardStatementsToSkip(String contents, IASTTranslationUnit ast) {
        char[] guard;
        IASTPreprocessorStatement statement = IncludeUtil.findFirstPreprocessorStatement(ast);
        if (statement == null) {
            return 0;
        }
        int num = 0;
        int offset = 0;
        if (IncludeUtil.isPragmaOnce(statement)) {
            ++num;
            offset = ASTNodes.endOffset((IASTNode)statement);
        }
        if ((guard = IncludeUtil.detectIncludeGuard(contents, offset)) != null) {
            num += 2;
        }
        return num;
    }

    private static char[] detectIncludeGuard(String contents, int offset) {
        char[] contentsChars = contents.toCharArray();
        if (offset != 0) {
            contentsChars = Arrays.copyOfRange(contentsChars, offset, contentsChars.length);
        }
        CharArrayIntMap ppKeywords = new CharArrayIntMap(40, -1);
        Keywords.addKeywordsPreprocessor((CharArrayIntMap)ppKeywords);
        char[] guardChars = IncludeGuardDetection.detectIncludeGuard((AbstractCharArray)new CharArray(contentsChars), (Lexer.LexerOptions)new Lexer.LexerOptions(), (CharArrayIntMap)ppKeywords);
        return guardChars;
    }

    private static void findGuardInRange(String contents, String guard, int offset, int endOffset, List<IRegion> includeGuardPositions) {
        int pos = contents.indexOf(guard, offset);
        if (pos >= 0 && pos + guard.length() <= endOffset) {
            includeGuardPositions.add((IRegion)new Region(pos, guard.length()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int skipStandaloneCommentBlock(String contents, int offset, int endOffset, IASTComment[] comments, NodeCommentMap commentMap) {
        void var7_10;
        HashMap<IASTComment, Object> inverseLeadingMap = new HashMap<IASTComment, Object>();
        for (Map.Entry entry : commentMap.getLeadingMap().entrySet()) {
            IASTNode node = (IASTNode)entry.getKey();
            if (ASTNodes.offset((IASTNode)node) > endOffset) continue;
            for (IASTComment comment : (List)entry.getValue()) {
                inverseLeadingMap.put(comment, node);
            }
        }
        HashMap<IASTComment, IASTNode> inverseFreestandingMap = new HashMap<IASTComment, IASTNode>();
        for (Map.Entry entry : commentMap.getFreestandingMap().entrySet()) {
            IASTNode node = (IASTNode)entry.getKey();
            if (ASTNodes.endOffset((IASTNode)node) >= endOffset) continue;
            for (IASTComment comment : (List)entry.getValue()) {
                inverseFreestandingMap.put(comment, node);
            }
        }
        boolean bl = false;
        while (var7_10 < comments.length) {
            IASTComment comment = comments[var7_10];
            int commentOffset = ASTNodes.offset((IASTNode)comment);
            if (commentOffset >= offset) {
                int j;
                IASTComment previous;
                if (commentOffset >= endOffset) break;
                IASTNode node = (IASTNode)inverseLeadingMap.get(comment);
                if (node != null) {
                    List leadingComments = (List)commentMap.getLeadingMap().get(node);
                    previous = (IASTComment)leadingComments.get(0);
                    j = 1;
                    while (j < leadingComments.size()) {
                        comment = (IASTComment)leadingComments.get(j);
                        if (ASTNodes.getStartingLineNumber((IASTNode)comment) > ASTNodes.getEndingLineNumber((IASTNode)previous) + 1) {
                            return ASTNodes.skipToNextLineAfterNode((String)contents, (IASTNode)previous);
                        }
                        previous = comment;
                        ++j;
                    }
                    if (ASTNodes.getStartingLineNumber((IASTNode)node) > ASTNodes.getEndingLineNumber((IASTNode)previous) + 1) {
                        return ASTNodes.skipToNextLineAfterNode((String)contents, (IASTNode)previous);
                    }
                }
                if ((node = (IASTNode)inverseFreestandingMap.get(comment)) != null) {
                    List freestandingComments = (List)commentMap.getFreestandingMap().get(node);
                    previous = (IASTComment)freestandingComments.get(0);
                    j = 1;
                    while (j < freestandingComments.size()) {
                        comment = (IASTComment)freestandingComments.get(j);
                        if (ASTNodes.getStartingLineNumber((IASTNode)comment) > ASTNodes.getEndingLineNumber((IASTNode)previous) + 1) {
                            return ASTNodes.skipToNextLineAfterNode((String)contents, (IASTNode)previous);
                        }
                        previous = comment;
                        ++j;
                    }
                }
            }
            ++var7_10;
        }
        return offset;
    }

    private static IASTPreprocessorStatement findFirstPreprocessorStatement(IASTTranslationUnit ast) {
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = ast.getAllPreprocessorStatements();
        int n = iASTPreprocessorStatementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorStatement statement = iASTPreprocessorStatementArray[n2];
            if (statement.isPartOfTranslationUnitFile()) {
                return statement;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isPragmaOnce(IASTPreprocessorStatement statement) {
        if (!(statement instanceof IASTPreprocessorPragmaStatement)) {
            return false;
        }
        return CharArrayUtils.equals((char[])((IASTPreprocessorPragmaStatement)statement).getMessage(), (String)"once");
    }
}

