/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.widgets;

import java.util.ListIterator;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.ui.internal.widgets.Dialog;
import org.eclipse.jpt.common.utility.node.Node;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValidatingDialog<T extends Node>
extends Dialog<T> {
    public ValidatingDialog(Shell parentShell, ResourceManager resourceManager) {
        super(parentShell, resourceManager);
    }

    public ValidatingDialog(Shell parentShell, ResourceManager resourceManager, String title) {
        super(parentShell, resourceManager, title);
    }

    @Override
    final Node.Validator buildValidator() {
        return new Node.Validator(){

            public void pause() {
            }

            public void resume() {
            }

            public void validate() {
                ValidatingDialog.this.validate();
            }
        };
    }

    protected final void clearMessage() {
        this.setMessage(this.getDescription());
    }

    protected final void clearErrorMessage() {
        this.setErrorMessage(null);
    }

    protected String getDescription() {
        return null;
    }

    protected Image getDescriptionImage() {
        return null;
    }

    protected String getDescriptionTitle() {
        return null;
    }

    protected Point getInitialSize() {
        Point result = this.getShell().computeSize(-1, -1);
        Point paneSize = this.getPane().getControl().computeSize(-1, -1);
        int width = this.convertHorizontalDLUsToPixels(400);
        result.x = Math.max(width, paneSize.x);
        return result;
    }

    @Override
    protected final boolean hasTitleArea() {
        return true;
    }

    @Override
    protected void initializeUI() {
        Image image;
        String description;
        super.initializeUI();
        String descriptionTitle = this.getDescriptionTitle();
        if (descriptionTitle != null) {
            this.setTitle(descriptionTitle);
        }
        if ((description = this.getDescription()) != null) {
            this.setMessage(description);
        }
        if ((image = this.getDescriptionImage()) != null) {
            this.setTitleImage(image);
        }
    }

    protected final void setErrorMessage(String errorMessage, Object ... arguments) {
        this.setErrorMessage(NLS.bind((String)errorMessage, (Object[])arguments));
    }

    protected final void setWarningMessage(String warningMessage, Object ... arguments) {
        this.setMessage(NLS.bind((String)warningMessage, (Object[])arguments), 2);
    }

    private void updateMessage() {
        if (this.getSubject().branchProblemsSize() == 0) {
            this.clearMessage();
        } else {
            ListIterator problems = this.getSubject().branchProblems();
            while (problems.hasNext()) {
                Node.Problem problem = (Node.Problem)problems.next();
                if (problem.messageType() == 3) {
                    this.setErrorMessage(problem.messageKey(), problem.messageArguments());
                    continue;
                }
                if (problem.messageType() != 2) continue;
                this.setWarningMessage(problem.messageKey(), problem.messageArguments());
            }
        }
        if (!this.containsErrorMessage()) {
            this.clearErrorMessage();
        }
    }

    public final boolean containsErrorMessage() {
        boolean error = false;
        ListIterator problems = this.getSubject().branchProblems();
        while (problems.hasNext()) {
            Node.Problem problem = (Node.Problem)problems.next();
            if (problem.messageType() != 3) continue;
            error = true;
        }
        return error;
    }

    void validate() {
        this.getSubject().validateBranch();
        this.updateMessage();
        this.getButton(0).setEnabled(!this.containsErrorMessage());
    }
}

