/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.telnet.ui;

import com.unisys.telnet.lib.Messages;
import com.unisys.telnet.ui.CertDialogData;
import java.security.cert.X509Certificate;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class CertDialogUI {
    private Font font;
    Button acceptButton;
    Button denyButton;
    private static CertDialogData UIData;
    private CertDialogUI instance;
    Shell shell;
    private Listener acceptbuttonClicked = new Listener(){

        public void handleEvent(Event event) {
            CertDialogUI.this.clickAcceptButton();
        }
    };
    private Listener denybuttonClicked = new Listener(){

        public void handleEvent(Event event) {
            CertDialogUI.this.clickDenyButton();
        }
    };

    public CertDialogUI() {
        try {
            this.font = JFaceResources.getFont((String)"org.eclipse.jface.dialogfont");
        }
        catch (Exception exception) {}
    }

    private void clickAcceptButton() {
        CertDialogUI.UIData.accept = true;
        this.shell.close();
    }

    private void clickDenyButton() {
        CertDialogUI.UIData.accept = false;
        this.shell.close();
    }

    public synchronized void createCertDialogUI(CertDialogData certDialogData) {
        this.instance = this;
        UIData = certDialogData;
        final CertDialogData certDialogData2 = certDialogData;
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){
            private TabFolder folder;
            private TabItem mainTab;
            private TabItem certTab;
            private TabItem helpTab;
            private HelpListener helpListen = new HelpListener(){

                public void helpRequested(HelpEvent helpEvent) {
                    folder.setSelection(helpTab);
                }
            };

            @Override
            public void run() {
                CertDialogUI.this.shell = new Shell(display, 65616);
                CertDialogUI.this.shell.setFont(CertDialogUI.this.font);
                CertDialogUI.this.shell.setText(Messages.getString("CertDialogUI_0"));
                GridLayout gridLayout = new GridLayout();
                gridLayout.numColumns = 1;
                CertDialogUI.this.shell.setLayout((Layout)gridLayout);
                GridLayout gridLayout2 = new GridLayout();
                gridLayout2.numColumns = 1;
                GridData gridData = new GridData(256);
                gridData.widthHint = 500;
                gridData.grabExcessHorizontalSpace = true;
                Group group = new Group((Composite)CertDialogUI.this.shell, 0);
                group.setLayout((Layout)gridLayout2);
                group.setLayoutData((Object)gridData);
                group.addHelpListener(this.helpListen);
                this.folder = new TabFolder((Composite)group, 2064);
                GridData gridData2 = new GridData(768);
                gridData2.widthHint = 500;
                this.folder.setLayoutData((Object)gridData2);
                this.folder.setLayout((Layout)new TabLayout());
                this.mainTab = new TabItem(this.folder, 0);
                this.certTab = new TabItem(this.folder, 0);
                this.mainTab.setText(Messages.getString("CertDialogUI_1"));
                Composite composite = new Composite((Composite)this.mainTab.getParent(), 2048);
                GridLayout gridLayout3 = new GridLayout();
                gridLayout3.numColumns = 1;
                composite.setLayout((Layout)gridLayout3);
                GridData gridData3 = new GridData(4, 4, true, true);
                gridData3.widthHint = 500;
                composite.setLayoutData((Object)gridData3);
                this.mainTab.setControl((Control)composite);
                Label label = new Label(composite, 272);
                label.setText(String.valueOf(Messages.getString("CertDialogUI_2")) + Messages.getString("CertDialogUI_3") + Messages.getString("CertDialogUI_4") + Messages.getString("CertDialogUI_5"));
                this.certTab.setText(Messages.getString("CertDialogUI_6"));
                Composite composite2 = new Composite((Composite)this.certTab.getParent(), 2048);
                composite2.setLayout((Layout)gridLayout3);
                composite2.setLayoutData((Object)gridData2);
                this.certTab.setControl((Control)composite2);
                X509Certificate x509Certificate = certDialogData2.x509Cert;
                Text text = new Text(composite2, 2818);
                GridData gridData4 = new GridData(4, 4, true, true);
                gridData4.widthHint = 500;
                gridData4.heightHint = 500;
                text.setLayoutData((Object)gridData4);
                String string = x509Certificate.toString();
                text.setText(CertDialogUI.this.insertLines(string));
                text.setEditable(false);
                Font font = text.getFont();
                Font font2 = new Font(font.getDevice(), "Courier New", 8, 0);
                text.setFont(font2);
                String string2 = "     " + Messages.getString("CertHelp1");
                string2 = String.valueOf(string2) + "\n     " + Messages.getString("CertHelp2");
                string2 = String.valueOf(string2) + "\n     " + Messages.getString("CertHelp3");
                this.helpTab = new TabItem(this.folder, 0);
                this.helpTab.setText("Help");
                Composite composite3 = new Composite((Composite)this.helpTab.getParent(), 0);
                composite3.setLayout((Layout)gridLayout3);
                composite3.setLayoutData((Object)gridData2);
                this.helpTab.setControl((Control)composite3);
                Text text2 = new Text(composite3, 66);
                text2.setEditable(false);
                text2.setLayoutData((Object)gridData4);
                text2.setText(string2);
                CertDialogUI.this.acceptButton = new Button((Composite)group, 8);
                CertDialogUI.this.acceptButton.setText(Messages.getString("CertDialogUI_7"));
                CertDialogUI.this.acceptButton.addListener(13, CertDialogUI.this.acceptbuttonClicked);
                CertDialogUI.this.denyButton = new Button((Composite)group, 8);
                CertDialogUI.this.denyButton.setText(Messages.getString("CertDialogUI_8"));
                CertDialogUI.this.denyButton.addListener(13, CertDialogUI.this.denybuttonClicked);
                CertDialogUI.this.shell.setDefaultButton(CertDialogUI.this.acceptButton);
                CertDialogUI.this.shell.pack();
                CertDialogUI.this.shell.open();
                while (!CertDialogUI.this.shell.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
    }

    String insertLines(String string) {
        String[] stringArray = string.split(",");
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(String.valueOf(stringArray[n]) + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    private class TabLayout
    extends Layout {
        private TabLayout() {
        }

        protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
            if (n != -1 && n2 != -1) {
                return new Point(n, n2);
            }
            Control[] controlArray = composite.getChildren();
            int n3 = controlArray.length;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n3) {
                Control control = controlArray[n6];
                Point point = control.computeSize(-1, -1, bl);
                n4 = Math.max(n4, point.x);
                n5 = Math.max(n5, point.y);
                ++n6;
            }
            if (n != -1) {
                n4 = n;
            }
            if (n2 != -1) {
                n5 = n2;
            }
            if (n4 < n5) {
                n4 = n5;
            }
            return new Point(n4, n5);
        }

        protected void layout(Composite composite, boolean bl) {
            Rectangle rectangle = composite.getClientArea();
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                controlArray[n].setBounds(rectangle);
                ++n;
            }
        }
    }
}

