/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.telnet.lib.session;

import com.unisys.telnet.lib.Messages;
import com.unisys.telnet.lib.TelnetLogger;
import com.unisys.telnet.lib.TelnetSocket.TelnetSocket;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import com.unisys.telnet.lib.session.Session;
import com.unisys.telnet.lib.session.TelnetListener;

public class TelnetSession
extends Session {
    private static final int NO = 0;
    private static final int YES = 1;
    private static final int RETRY = 2;
    private volatile int waitingforSOE = 0;
    private static final int MAXRETRY = 3;
    private volatile int retrycount = 0;
    private boolean myLocalEcho = false;
    private long sTime;
    private long fTime;
    private TelnetSocket telnet = new TelnetSocket();
    String lastOutput;

    public TelnetSession(LoginAccount loginAccount) {
        super(loginAccount);
        this.ProtocolListener = new TelnetListener(this, this.telnet);
    }

    @Override
    public String Login() {
        String string = "";
        String string2 = "";
        boolean bl = false;
        int n = 0;
        String string3 = "";
        String string4 = "";
        this.MyHostAccount = this.MyLoginAccount.getHostAccount();
        try {
            if (this.MyLoginAccount.ValidateHostAccount()) {
                string = this.MyHostAccount.getHostId();
                string2 = this.MyProtocol.getProperty("Property.Port");
                string3 = this.MyProtocol.getProperty("Property.CharSet");
                bl = this.MyProtocol.getSecureSocket();
                this.telnet.setCharSet(string3);
                if (!string2.equals("")) {
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        string2 = "23";
                        n = Integer.parseInt(string2);
                        TelnetLogger.log(2, Messages.getString("TelnetSession.4", string2, "23"));
                    }
                } else {
                    string2 = "23";
                    n = Integer.parseInt(string2);
                    TelnetLogger.log(2, Messages.getString("TelnetSession.6", "23"));
                }
                string4 = this.telnet.open(string, n, bl);
                if (string4.length() == 0) {
                    TelnetLogger.log(1, "telnet open, " + string + " " + string2);
                    this.ProtocolListener.start();
                    string4 = super.Login();
                } else {
                    TelnetLogger.log(5, Messages.getString("TelnetSession.1", String.valueOf(string) + "/" + string2, string4));
                    this.fireNewOutput(string4);
                }
            } else {
                string4 = Messages.getString("TelnetSession.5", string);
                TelnetLogger.log(5, Messages.getString("TelnetSession.5", string));
            }
        }
        catch (Exception exception) {
            string4 = Messages.getString("TelnetSession.7");
            TelnetLogger.log(5, (Object)Messages.getString("InternalError"), exception);
        }
        TelnetLogger.log(1, "Telnet Login exit");
        return string4;
    }

    @Override
    public int Logout() {
        try {
            super.Logout();
            if (this.telnet != null) {
                this.telnet.close();
            }
            this.telnet = null;
        }
        catch (Exception exception) {
            TelnetLogger.log(2, (Object)Messages.getString("TelnetSession.2"), exception);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int SendCommand_ProtocolSpecific(String string, boolean bl) {
        Object object;
        int n = 0;
        if (this.telnet == null) {
            return 1;
        }
        if (!this.myLocalEcho && this.telnet.getLocalEcho()) {
            this.fireNewOutput(string);
            TelnetLogger.log(1, "SendCommand: " + string);
        } else if (string.contains("/")) {
            object = string.substring(0, string.indexOf("/"));
            if (!((String)object).contains(" ")) {
                TelnetLogger.log(1, "SendCommand: (telnet) uid/pwd");
            } else {
                TelnetLogger.log(1, "SendCommand: (telnet) " + string);
            }
        } else {
            TelnetLogger.log(1, "SendCommand: (telnet) " + string);
        }
        if (bl) {
            this.waitingforSOE = 0;
        } else {
            object = this;
            synchronized (object) {
                this.waitingforSOE = 1;
            }
            this.addOutputListener(this);
            TelnetLogger.log(1, "SOE wait loop");
        }
        this.telnet.sendLine(string);
        object = this;
        synchronized (object) {
            while (this.waitingforSOE != 0) {
                if (!this.CommandCancel) {
                    try {
                        this.wait();
                        if (this.waitingforSOE == 2) {
                            if (this.retrycount < 3) {
                                this.waitingforSOE = 1;
                                TelnetLogger.log(1, "command retry");
                                try {
                                    Thread.sleep(this.retrycount * 1000);
                                }
                                catch (Exception exception) {}
                                this.telnet.sendLine(string);
                                continue;
                            }
                            if (this.telnet.getLocalEcho()) {
                                TelnetLogger.log(5, Messages.getString("TelnetSession.5", string));
                            } else {
                                TelnetLogger.log(5, Messages.getString("TelnetSession.22"));
                            }
                            n = 1;
                            break;
                        }
                        String string2 = this.lastOutput;
                        boolean bl2 = true;
                        while (bl2) {
                            this.wait(500L);
                            if (this.lastOutput.equals(string2)) {
                                bl2 = false;
                            }
                            string2 = this.lastOutput;
                        }
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        TelnetLogger.log(1, "synchronous command interrupted");
                        n = 1;
                        break;
                    }
                    catch (Exception exception) {
                        TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
                        n = 1;
                        break;
                    }
                }
                TelnetLogger.log(1, "synchronous command canceled");
                n = 1;
                break;
            }
        }
        if (!bl) {
            this.removeOutputListener(this);
        }
        TelnetLogger.log(1, "SendCommand(ps) exit:" + n);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newOutput(String string) {
        TelnetSession telnetSession = this;
        synchronized (telnetSession) {
            try {
                if (this.waitingforSOE != 0) {
                    if (string.endsWith(this.SOE)) {
                        TelnetLogger.log(1, "found SOE");
                        this.waitingforSOE = 0;
                        this.lastOutput = string;
                        this.notifyAll();
                    } else if (this.MyHostAccount.getOS2200() && this.Compareit("*WAIT-LAST INPUT IGNORED*", string)) {
                        TelnetLogger.log(1, "Retry command");
                        this.waitingforSOE = 2;
                        ++this.retrycount;
                        this.notifyAll();
                    } else if (!this.loggedon && this.MyHostAccount.getOS2200() && (string.startsWith("*NO RUN ACTIVE*") || string.startsWith("*ILLEGAL ACCOUNT") || string.startsWith("*MISSING ACCOUNT"))) {
                        this.waitingforSOE = 0;
                        this.notifyAll();
                    }
                }
            }
            catch (Exception exception) {
                try {
                    this.notifyAll();
                }
                catch (Exception exception2) {}
                TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
            }
        }
    }

    @Override
    public void Break() {
        if (this.telnet != null) {
            this.telnet.Break();
        }
    }

    @Override
    public void InterruptProcess() {
        this.CommandCancel = true;
        if (this.telnet != null) {
            this.telnet.InterruptProcess();
        }
    }

    @Override
    public void AbortOutput() {
        if (this.telnet != null) {
            this.telnet.AbortOutput();
        }
    }

    @Override
    public void setLocalEcho(boolean bl) {
        if (this.telnet != null) {
            this.myLocalEcho = bl;
        }
        this.telnet.setLocalEcho(bl);
    }

    @Override
    public boolean getLocalEcho() {
        if (this.telnet != null) {
            return this.telnet.getLocalEcho();
        }
        return true;
    }

    @Override
    public boolean active() {
        return this.telnet != null;
    }
}

