/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.telnet.lib.session;

import com.unisys.tde.core.characterset.OS2200CharSetPlugin;
import com.unisys.telnet.lib.Messages;
import com.unisys.telnet.lib.TelnetLogger;
import com.unisys.telnet.lib.TelnetSocket.TelnetSocket;
import com.unisys.telnet.lib.hostaccount.Protocol;
import com.unisys.telnet.lib.session.ISession;
import com.unisys.telnet.lib.session.TelnetSession;

public class TelnetListener
extends Thread {
    ISession session;
    TelnetSocket telnet;
    static final int maxretry = 20;
    int retrycount = 0;
    public volatile boolean running = false;

    public TelnetListener(ISession iSession, TelnetSocket telnetSocket) {
        this.session = iSession;
        this.telnet = telnetSocket;
    }

    @Override
    public void run() {
        TelnetLogger.log(1, "Telnetlistener ... run");
        this.running = true;
        byte[] byArray = new byte[16384];
        int n = 0;
        int n2 = 0;
        while (!this.isInterrupted()) {
            try {
                n = this.telnet.getLine(byArray);
                if (n > 0) {
                    n2 = 0;
                    String string = null;
                    string = this.getCharConv().equalsIgnoreCase(OS2200CharSetPlugin.JAPANESE) ? new String(byArray, 0, n, "LETSJ") : new String(byArray, 0, n, "UTF-16");
                    this.session.fireNewOutput(string);
                    continue;
                }
                if (++n2 <= 10) continue;
                this.session.fireNewOutput("------ Session Path Closed ------");
                this.session.Logout();
            }
            catch (Exception exception) {
                TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
                if (this.retrycount++ <= 10) continue;
            }
            break;
        }
        TelnetLogger.log(1, "TelnetListener ... stop");
        this.running = false;
    }

    private String getCharConv() {
        TelnetSession telnetSession = (TelnetSession)this.session;
        Protocol protocol = telnetSession.MyProtocol;
        return protocol.getProperty("Property.CharSet");
    }
}

