/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.telnet.lib.session;

import com.unisys.tde.core.characterset.OS2200CharSetPlugin;
import com.unisys.telnet.lib.Messages;
import com.unisys.telnet.lib.TelnetLogger;
import com.unisys.telnet.lib.hostaccount.HostAccount;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import com.unisys.telnet.lib.hostaccount.Protocol;
import com.unisys.telnet.lib.hostaccount.Scriptlet;
import com.unisys.telnet.lib.session.IOutputListener;
import com.unisys.telnet.lib.session.ISession;
import com.unisys.telnet.lib.session.TelnetSession;
import com.unisys.telnet.ui.UserPrompt;
import com.unisys.telnet.ui.UserPromptData;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.swt.graphics.Point;

public abstract class Session
implements ISession,
IOutputListener {
    public static long sleepnumber1 = 0L;
    public static long sleepnumber2 = 0L;
    private Vector ClientListeners = new Vector();
    public volatile boolean CommandCancel = false;
    private volatile String commandoutput = "";
    public LoginAccount MyLoginAccount;
    public HostAccount MyHostAccount;
    public Protocol MyProtocol;
    public Thread ProtocolListener;
    public boolean loggedon;
    public String SOE = ">";
    private String SOE2 = "129";
    private byte[] bSOE2;
    boolean switchSOE;
    private Vector script;
    public UserPrompt prompt;
    private UserPromptData data;
    private boolean recording;

    @Override
    public void setPoint(Point point) {
        this.prompt.MyLocation = point;
    }

    public Session(LoginAccount loginAccount) {
        byte[] byArray = new byte[2];
        byArray[1] = -127;
        this.bSOE2 = byArray;
        this.switchSOE = false;
        this.script = new Vector();
        this.prompt = new UserPrompt();
        this.data = new UserPromptData();
        this.recording = false;
        this.MyLoginAccount = loginAccount;
        this.commandoutput = "";
    }

    @Override
    public String getLastError() {
        return TelnetLogger.LastError;
    }

    public static ISession New(LoginAccount loginAccount) {
        TelnetLogger.log(1, "New Session");
        TelnetSession telnetSession = null;
        try {
            if (loginAccount.ValidateHostAccount()) {
                Protocol[] protocolArray = loginAccount.getProtocols();
                TelnetLogger.log(1, "Find Protocol");
                int n = 0;
                while (n < protocolArray.length) {
                    TelnetLogger.log(1, "Protocol " + protocolArray[n].getConnectionType().toString());
                    if (protocolArray[n].getConnectionType() == "Telnet") {
                        TelnetLogger.log(1, "new Telnet Session");
                        telnetSession = new TelnetSession(loginAccount);
                        telnetSession.MyProtocol = protocolArray[n];
                        break;
                    }
                    ++n;
                }
                if (telnetSession != null) {
                    String string = telnetSession.MyProtocol.getProperty("Property.SOE");
                    telnetSession.SOE = string.length() > 0 ? string : ">";
                } else {
                    TelnetLogger.log(5, Messages.getString("InternalError"));
                    TelnetLogger.log(1, "Login information incomplete.  Missing protocol object.");
                }
            }
        }
        catch (Exception exception) {
            TelnetLogger.log(5, (Object)Messages.getString("InternalError"), exception);
            telnetSession = null;
        }
        return telnetSession;
    }

    @Override
    public int addOutputListener(IOutputListener iOutputListener) {
        int n = 0;
        TelnetLogger.log(1, "Session addoutputlistener " + iOutputListener.toString());
        boolean bl = this.ClientListeners.add(iOutputListener);
        if (!bl) {
            n = 1;
        }
        return n;
    }

    @Override
    public int removeOutputListener(IOutputListener iOutputListener) {
        int n = 0;
        TelnetLogger.log(1, "Session removeoutputlistener " + iOutputListener.toString());
        boolean bl = this.ClientListeners.remove(iOutputListener);
        if (!bl) {
            n = 1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireNewOutput(String string) {
        Object object = this;
        synchronized (object) {
            this.commandoutput = String.valueOf(this.commandoutput) + string;
        }
        object = (Vector)this.ClientListeners.clone();
        int n = 0;
        while (n < ((Vector)object).size()) {
            try {
                IOutputListener iOutputListener = (IOutputListener)((Vector)object).get(n);
                iOutputListener.newOutput(string);
            }
            catch (Exception exception) {
                TelnetLogger.log(1, (Object)"Internal error, session listener exception", exception);
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOutput() {
        String string = "";
        Session session = this;
        synchronized (session) {
            string = this.commandoutput;
            this.commandoutput = "";
        }
        return string;
    }

    @Override
    public String LoginRecord() {
        this.recording = true;
        String string = this.Login();
        this.recording = false;
        return string;
    }

    @Override
    public String Login() {
        TelnetLogger.log(1, "super.Login");
        String string = "";
        int n = 0;
        String string2 = "";
        int n2 = 0;
        this.loggedon = false;
        this.switchSOE = false;
        try {
            Scriptlet[] scriptletArray = this.recording ? new Scriptlet[]{} : this.MyProtocol.getScripts();
            int n3 = 0;
            int n4 = -1;
            if (this.MyHostAccount == null) {
                n2 = 7;
            } else if (this.MyHostAccount.getUserId().length() == 0) {
                n2 = 7;
            }
            if (this.recording && !this.MyHostAccount.getOS2200()) {
                this.data.donebutton = true;
            }
            block19: while (n2 != 7) {
                if (this.CommandCancel) {
                    TelnetLogger.log(2, Messages.getString("Session.19"));
                    string = Messages.getString("Session.19");
                    n2 = 7;
                    break;
                }
                if (n2 != n4) {
                    n4 = n2;
                    TelnetLogger.log(1, "--login_state: " + n2);
                }
                if (this.MyHostAccount.getOS2200()) {
                    if (this.Compareit("DATE: TIME: ", this.commandoutput)) {
                        this.loggedon = true;
                        if (scriptletArray.length > 0) {
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    } else if (this.Compareit("*ILLEGAL ACCOUNT", this.commandoutput)) {
                        TelnetLogger.log(4, Messages.getString("Session.34"));
                        string = String.valueOf(Messages.getString("Session.34")) + "\n";
                        if (this.recording) {
                            n2 = 0;
                            this.SendCommandAsync("\n");
                            this.script = new Vector();
                            Thread.sleep(1000L);
                        } else {
                            n2 = 7;
                        }
                    }
                }
                switch (n2) {
                    case 0: {
                        TelnetLogger.log(2, "Enter " + this.commandoutput);
                        if (this.commandoutput.length() == 0) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue block19;
                        }
                        if (this.Compareit("Enter your user-id/password", this.commandoutput)) {
                            if (this.MyHostAccount.getOS2200()) {
                                n2 = 2;
                                break;
                            }
                            string = Messages.getString("Session.32");
                            n2 = 7;
                            break;
                        }
                        if (this.Compareit("login:", this.commandoutput)) {
                            if (!this.MyHostAccount.getOS2200()) {
                                n2 = 1;
                                break;
                            }
                            string = Messages.getString("Session.33");
                            n2 = 7;
                            break;
                        }
                        n2 = 5;
                        break;
                    }
                    case 1: {
                        if (this.MyHostAccount.getOS2200()) {
                            n2 = 7;
                            break;
                        }
                        this.SendCommandAsync(String.valueOf(this.MyHostAccount.getUserId()) + "\n");
                        this.SimulatedSynchronous();
                        String string3 = this.commandoutput.trim();
                        if (string3.endsWith("Password:")) {
                            n2 = 2;
                            break;
                        }
                        n2 = 5;
                        break;
                    }
                    case 2: {
                        String string3;
                        if (n > 0 || this.MyHostAccount.getPassword().length() == 0) {
                            string3 = "";
                            string3 = n == 0 ? Messages.getString("Session.29", this.MyHostAccount.getUserId()) : Messages.getString("Session.30", this.MyHostAccount.getUserId());
                            this.data.echo = false;
                            this.data.Prompt = string3;
                            string = "";
                            if (!this.prompt.show(this.data)) {
                                TelnetLogger.log(2, Messages.getString("Session.19"));
                                n2 = 7;
                                string = Messages.getString("Session.19");
                                break;
                            }
                            string2 = this.data.Reply;
                            ++n;
                        } else {
                            string2 = this.MyHostAccount.getPassword();
                        }
                        if (!this.MyHostAccount.getOS2200()) {
                            this.SendCommandAsync(String.valueOf(string2) + "\n");
                            this.SimulatedSynchronous();
                            string3 = this.commandoutput.trim();
                            if (string3.endsWith("login:")) {
                                n2 = 1;
                                ++n;
                                break;
                            }
                            if (n > 0) {
                                n2 = 4;
                                break;
                            }
                            n2 = 5;
                            break;
                        }
                        if (this.getLocalEcho()) {
                            try {
                                Thread.sleep(2000L);
                                ++sleepnumber1;
                            }
                            catch (Exception exception) {}
                        }
                        this.SendCommand(String.valueOf(this.MyHostAccount.getUserId()) + "/" + string2 + "\n");
                        if (this.Compareit("Enter your user-id/password", this.commandoutput)) {
                            ++n;
                            break;
                        }
                        if (this.Compareit("Enter your new password:", this.commandoutput)) {
                            n2 = 3;
                            break;
                        }
                        if (!this.getLocalEcho()) {
                            try {
                                Thread.currentThread();
                                Thread.sleep(2000L);
                                ++sleepnumber2;
                            }
                            catch (Exception exception) {}
                        }
                        if (n > 0) {
                            n2 = 4;
                            break;
                        }
                        n2 = 5;
                        break;
                    }
                    case 3: {
                        if (!this.MyHostAccount.getOS2200()) {
                            TelnetLogger.log(5, Messages.getString("InternalError"));
                            string = Messages.getString("Session.31");
                            n2 = 7;
                            break;
                        }
                        this.data.echo = false;
                        this.data.Prompt = String.valueOf(string) + this.commandoutput;
                        string = "";
                        if (!this.prompt.show(this.data)) {
                            TelnetLogger.log(2, Messages.getString("Session.19"));
                            string = Messages.getString("Session.19");
                            n2 = 7;
                            break;
                        }
                        string2 = this.data.Reply;
                        ++n;
                        this.SendCommand(String.valueOf(string2) + "\n");
                        if (this.Compareit("Enter new password", this.commandoutput)) break;
                        n2 = 4;
                        break;
                    }
                    case 4: {
                        TelnetLogger.log(1, "Password saved");
                        this.MyHostAccount.setPassword(string2);
                        this.MyHostAccount.setCifsPassword(string2);
                        HostAccount.Save();
                        n2 = 5;
                        break;
                    }
                    case 5: {
                        String string3;
                        if (this.recording) {
                            n2 = 6;
                            break;
                        }
                        if (n3 < scriptletArray.length) {
                            TelnetLogger.log(1, "Script:" + scriptletArray[n3].getHostPrompt() + " > " + scriptletArray[n3].getClientResponse());
                            string3 = scriptletArray[n3].getHostPrompt();
                            if (this.Compareit(string3, this.commandoutput)) {
                                String string4 = scriptletArray[n3].getClientResponse();
                                if (this.MyHostAccount.getOS2200()) {
                                    this.SendCommandAsync(String.valueOf(string4) + "\n");
                                    this.SimulatedSynchronous();
                                } else {
                                    string4 = this.unixsubstitution(string4);
                                    this.SendCommandAsync(String.valueOf(string4) + "\n");
                                    this.SimulatedSynchronous();
                                }
                            } else if (!scriptletArray[n3].getOptional()) {
                                n2 = 6;
                            }
                            ++n3;
                            break;
                        }
                        if (this.MyHostAccount.getOS2200()) {
                            if (this.loggedon) {
                                n2 = 7;
                                break;
                            }
                            n2 = 6;
                            break;
                        }
                        n2 = 7;
                        break;
                    }
                    case 6: {
                        String string3;
                        if (this.loggedon) {
                            n2 = 7;
                            break;
                        }
                        this.data.echo = true;
                        this.data.Prompt = String.valueOf(string) + this.commandoutput;
                        string = "";
                        if (this.prompt.show(this.data)) {
                            string3 = this.data.Reply;
                            if (this.recording) {
                                this.recordscript(true, this.commandoutput, string3);
                                if (this.data.done) {
                                    n2 = 7;
                                }
                            }
                            if (this.MyHostAccount.getOS2200()) {
                                this.SendCommandAsync(String.valueOf(string3) + "\n");
                                this.SimulatedSynchronous();
                                break;
                            }
                            this.SendCommandAsync(String.valueOf(string3) + "\n");
                            this.SimulatedSynchronous();
                            break;
                        }
                        n2 = 7;
                    }
                }
            }
        }
        catch (Exception exception) {
            TelnetLogger.log(5, (Object)Messages.getString("InternalError"), exception);
            string = Messages.getString("TelnetSession.7");
        }
        TelnetLogger.log(1, "Login return, " + string);
        if (this.MyHostAccount.getOS2200() && this.loggedon) {
            this.switchSOE = true;
        }
        return string;
    }

    private void recordscript(boolean bl, String string, String string2) {
        Scriptlet scriptlet = new Scriptlet();
        if (bl) {
            String string3 = "";
            String string4 = "";
            char[] cArray = string.toCharArray();
            boolean bl2 = true;
            int n = cArray.length - 1;
            while (n >= 0) {
                byte by = (byte)cArray[n];
                if (Character.isWhitespace(cArray[n])) {
                    if (string4.length() >= 1) {
                        if (bl2) {
                            string3 = String.valueOf(string4) + " " + string3;
                        }
                        string4 = "";
                        bl2 = true;
                    } else if ((by == 10 || by == 13) && string3.length() > 2) {
                        break;
                    }
                } else {
                    string4 = String.valueOf(cArray[n]) + string4;
                }
                --n;
            }
            scriptlet.setHostPrompt(string3);
        } else {
            scriptlet.setHostPrompt(string);
        }
        scriptlet.setClientResponse(string2);
        this.script.add(scriptlet);
    }

    @Override
    public Scriptlet[] getLoginScripts() {
        Scriptlet[] scriptletArray = new Scriptlet[this.script.size()];
        int n = 0;
        while (n < this.script.size()) {
            Scriptlet scriptlet = (Scriptlet)this.script.get(n);
            scriptlet.setSequenceNumber(n);
            scriptletArray[n] = scriptlet;
            ++n;
        }
        return scriptletArray;
    }

    private String unixsubstitution(String string) {
        String string2;
        if (string.indexOf("%userid%") >= 0) {
            TelnetLogger.log(1, "userid substitution");
            string2 = this.MyHostAccount.getUserId();
        } else if (string.indexOf("%password%") >= 0) {
            TelnetLogger.log(1, "password substitution");
            string2 = this.MyHostAccount.getPassword();
        } else {
            string2 = string;
        }
        return string2;
    }

    private void SimulatedSynchronous() {
        int n = 5000;
        int n2 = 1000;
        int n3 = 300;
        int n4 = n / n3;
        int n5 = n2 / n3;
        int n6 = -1;
        String string = "";
        String string2 = "";
        while (n6 < n4) {
            ++n6;
            string2 = this.commandoutput.trim();
            if (string2.length() != 0) {
                if (!string.equals(string2)) {
                    string = string2;
                    n6 = 0;
                } else if (n6 > n5) break;
            }
            try {
                Thread.sleep(n3);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    public boolean Compareit(String string, String string2) {
        boolean bl = true;
        String string3 = "";
        int n = 0;
        String string4 = String.valueOf(string) + " ";
        char[] cArray = string4.toCharArray();
        int n2 = 0;
        while (n2 < cArray.length) {
            if (Character.isWhitespace(cArray[n2])) {
                if (string3.length() > 0) {
                    int n3 = string2.indexOf(string3, n);
                    if (n3 < 0) {
                        bl = false;
                        break;
                    }
                    n = n3 + string3.length();
                    string3 = "";
                }
            } else {
                string3 = String.valueOf(string3) + cArray[n2];
            }
            ++n2;
        }
        return bl;
    }

    @Override
    public int Logout() {
        TelnetLogger.log(1, "Session Logout");
        try {
            this.ProtocolListener.interrupt();
            this.ClientListeners.removeAllElements();
            this.loggedon = false;
        }
        catch (Exception exception) {
            TelnetLogger.log(1, (Object)Messages.getString("InternalError"), exception);
        }
        return 0;
    }

    @Override
    public int SendCommand(String string) {
        TelnetLogger.log(1, "Session SendCommand");
        if (this.switchSOE) {
            this.switchSOE = false;
            try {
                this.SOE = new String(this.bSOE2, "UTF-16");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.SOE = new String(this.bSOE2);
            }
            try {
                Thread.sleep(300L);
            }
            catch (Exception exception) {}
            this.SendCommandCommon("@@TTY S," + this.SOE2 + "\n", true);
            try {
                Thread.sleep(300L);
            }
            catch (Exception exception) {}
        }
        int n = this.SendCommandCommon(string, false);
        return n;
    }

    @Override
    public int SendCommandAsync(String string) {
        TelnetLogger.log(1, "Session SendCommandAsync");
        int n = this.SendCommandCommon(string, true);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int SendCommandCommon(String string, boolean bl) {
        Session session = this;
        synchronized (session) {
            this.commandoutput = "";
        }
        this.CommandCancel = false;
        int n = this.SendCommand_ProtocolSpecific(string, bl);
        return n;
    }

    @Override
    public void setLog(Logger logger) {
        TelnetLogger.logger = logger;
        OS2200CharSetPlugin.logger = logger;
    }
}

