/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.telnet.lib.hostaccount;

import com.unisys.telnet.lib.Messages;
import com.unisys.telnet.lib.TelnetLogger;
import com.unisys.telnet.lib.hostaccount.Property;
import com.unisys.telnet.lib.hostaccount.Scriptlet;
import java.util.Vector;

public class Protocol {
    private String _type = "Telnet";
    private Vector _properties = new Vector();
    private Vector _loginscript = new Vector();
    private boolean _OS2200 = true;
    public static final String USERID = "%userid%";
    public static final String PASSWORD = "%password%";

    public Protocol() {
        this.setPropertyDefaults();
    }

    public synchronized Property[] getProperties() {
        Property[] propertyArray = new Property[this._properties.size()];
        try {
            int n = 0;
            while (n < this._properties.size()) {
                propertyArray[n] = (Property)this._properties.get(n);
                ++n;
            }
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
        }
        return propertyArray;
    }

    public synchronized String getProperty(String string) {
        String string2 = "";
        try {
            int n = 0;
            while (n < this._properties.size()) {
                Property property = (Property)this._properties.get(n);
                if (property.getName().equals(string)) {
                    string2 = property.getValue();
                    break;
                }
                ++n;
            }
            if (string2 == null && string.equals("Property.CharSet")) {
                string2 = "<NONE>";
            }
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
        }
        return string2;
    }

    public synchronized void setProperty(String string, String string2) {
        boolean bl = false;
        try {
            Property property;
            int n = 0;
            while (n < this._properties.size()) {
                property = (Property)this._properties.get(n);
                if (property.getName().equals(string)) {
                    bl = true;
                    property.setValue(string2);
                    break;
                }
                ++n;
            }
            if (!bl) {
                property = new Property();
                property.setName(string);
                property.setValue(string2);
                this._properties.add(property);
            }
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
        }
    }

    public synchronized Property getPropertyObject(String string) {
        Property property = null;
        try {
            int n = 0;
            while (n < this._properties.size()) {
                Property property2 = (Property)this._properties.get(n);
                if (property2.getName().equals(string)) {
                    property = property2;
                    break;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            property = new Property();
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
        }
        return property;
    }

    public synchronized void removeProperty(String string) {
        try {
            int n = 0;
            while (n < this._properties.size()) {
                Property property = (Property)this._properties.get(n);
                if (property.getName().equals(string)) {
                    this._properties.remove(property);
                    break;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
        }
    }

    public boolean getSecureSocket() {
        String string = this.getProperty("Property.SecureSSL");
        boolean bl = false;
        try {
            bl = Boolean.parseBoolean(string);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public synchronized Scriptlet[] getScripts() {
        Scriptlet[] scriptletArray = new Scriptlet[this._loginscript.size()];
        try {
            int n = 0;
            while (n <= this._loginscript.size()) {
                int n2 = 0;
                while (n2 < this._loginscript.size()) {
                    Scriptlet scriptlet = (Scriptlet)this._loginscript.get(n2);
                    if (scriptlet.getSequenceNumber() == n + 1) {
                        scriptletArray[n] = (Scriptlet)this._loginscript.get(n2);
                        break;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
            scriptletArray = null;
        }
        return scriptletArray;
    }

    public synchronized boolean addScript(Scriptlet scriptlet) {
        boolean bl = false;
        try {
            if (scriptlet._parent == null) {
                int n = scriptlet.getSequenceNumber();
                if (n == 0 || n > this._loginscript.size()) {
                    n = this._loginscript.size() + 1;
                    scriptlet.setSequenceNumber(n);
                }
                int n2 = 0;
                while (n2 < this._loginscript.size()) {
                    Scriptlet scriptlet2 = (Scriptlet)this._loginscript.get(n2);
                    if (scriptlet2.getSequenceNumber() >= scriptlet.getSequenceNumber()) {
                        scriptlet2._sequencenumber = scriptlet2.getSequenceNumber() + 1;
                    }
                    ++n2;
                }
                this._loginscript.add(scriptlet);
                scriptlet._parent = this;
                bl = true;
            } else {
                TelnetLogger.log(1, "dup!");
            }
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
        }
        return bl;
    }

    public synchronized void removeAllScripts() {
        int n = 0;
        while (n < this._loginscript.size()) {
            Scriptlet scriptlet = (Scriptlet)this._loginscript.get(n);
            scriptlet._parent = null;
            ++n;
        }
        this._loginscript.removeAllElements();
    }

    public synchronized void removeScript(Scriptlet scriptlet) {
        try {
            int n = scriptlet.getSequenceNumber();
            this._loginscript.remove(scriptlet);
            scriptlet._parent = null;
            int n2 = 0;
            while (n2 < this._loginscript.size()) {
                Scriptlet scriptlet2 = (Scriptlet)this._loginscript.get(n2);
                if (scriptlet2.getSequenceNumber() > n) {
                    scriptlet2._sequencenumber = scriptlet2.getSequenceNumber() - 1;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
        }
    }

    public String getConnectionType() {
        return this._type;
    }

    public synchronized void setConnectionType(String string) {
        this._type = "Telnet".compareTo(string) > -1 ? "Telnet" : "undefined";
    }

    public boolean getOS2200deprecated() {
        return this._OS2200;
    }

    public void setOS2200(boolean bl) {
        TelnetLogger.log(1, "**Deprecated method is being used: Protocol.setOS2200()");
        this._OS2200 = bl;
    }

    private void setPropertyDefaults() {
        if (this._type == "Telnet") {
            if (this.getProperty("Property.Port").equals("")) {
                this.setProperty("Property.Port", "23");
            }
            this.setProperty("Property.SOE", ">");
            this.removeAllScripts();
            this.setProperty("Property.CharSet", "<NONE>");
            this.setProperty("Property.SecureSSL", Boolean.toString(false));
            this.setProperty("Property.MHFS", Boolean.toString(false));
        } else if (this._type != "undefined") {
            TelnetLogger.log(4, Messages.getString("Protocol.1"));
        }
    }
}

