/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.telnet.lib.hostaccount;

import com.unisys.telnet.lib.Messages;
import com.unisys.telnet.lib.TelnetLogger;
import com.unisys.telnet.lib.hostaccount.CryptoUtils;
import com.unisys.telnet.lib.hostaccount.HostAccount;
import com.unisys.telnet.lib.hostaccount.LoginAccountDelegate;
import com.unisys.telnet.lib.hostaccount.Protocol;
import com.unisys.telnet.lib.hostaccount.ProtocolDelegate;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Iterator;
import java.util.Vector;

public class LoginAccount {
    private static final String SAVEFILE = "LoginAccount.xml";
    public static Vector _loginaccounts = new Vector();
    public static boolean doRestore = true;
    private static boolean reSave = false;
    private String _Name = "";
    private HostAccount _HostAccount = null;
    private Vector _protocols = new Vector();

    public static synchronized void Save() {
        TelnetLogger.log(1, "LoginAccount Save");
        FileOutputStream fileOutputStream = null;
        XMLEncoder xMLEncoder = null;
        try {
            fileOutputStream = new FileOutputStream(String.valueOf(HostAccount.PrivateUserPath()) + SAVEFILE);
            xMLEncoder = new XMLEncoder(new BufferedOutputStream(fileOutputStream));
            LoginAccountDelegate loginAccountDelegate = new LoginAccountDelegate();
            xMLEncoder.setPersistenceDelegate(LoginAccount.class, loginAccountDelegate);
            ProtocolDelegate protocolDelegate = new ProtocolDelegate();
            xMLEncoder.setPersistenceDelegate(Protocol.class, protocolDelegate);
            int n = 0;
            while (n < _loginaccounts.size()) {
                xMLEncoder.writeObject(_loginaccounts.get(n));
                ++n;
            }
            xMLEncoder.flush();
            xMLEncoder.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("LoginAccount.1"), exception);
            try {
                xMLEncoder.close();
            }
            catch (Exception exception2) {}
            try {
                fileOutputStream.close();
            }
            catch (Exception exception3) {}
        }
    }

    private static synchronized void Restore() {
        doRestore = false;
        TelnetLogger.log(1, "LoginAccount Restore");
        FileInputStream fileInputStream = null;
        XMLDecoder xMLDecoder = null;
        try {
            fileInputStream = new FileInputStream(String.valueOf(HostAccount.PrivateUserPath()) + SAVEFILE);
            xMLDecoder = new XMLDecoder(fileInputStream);
            boolean bl = false;
            while (!bl) {
                try {
                    LoginAccount loginAccount = (LoginAccount)xMLDecoder.readObject();
                    HostAccount hostAccount = HostAccount.getHostAccount(loginAccount.getName());
                    loginAccount.setHostAccount(hostAccount);
                    _loginaccounts.add(loginAccount);
                }
                catch (Exception exception) {
                    bl = true;
                }
            }
            xMLDecoder.close();
            fileInputStream.close();
            if (reSave) {
                TelnetLogger.log(1, "LoginAccount Resave");
                reSave = false;
                HostAccount.Save();
                LoginAccount.Save();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("LoginAccount.2"), exception);
            try {
                xMLDecoder.close();
            }
            catch (Exception exception2) {}
            try {
                fileInputStream.close();
            }
            catch (Exception exception3) {}
        }
    }

    public static synchronized LoginAccount[] getLoginAccounts() {
        TelnetLogger.log(1, "getLoginAccounts");
        LoginAccount[] loginAccountArray = null;
        try {
            if (doRestore) {
                LoginAccount.Restore();
            }
            loginAccountArray = new LoginAccount[_loginaccounts.size()];
            int n = 0;
            while (n < _loginaccounts.size()) {
                loginAccountArray[n] = (LoginAccount)_loginaccounts.get(n);
                ++n;
            }
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
        }
        return loginAccountArray;
    }

    public static synchronized LoginAccount getLoginAccount(String string) {
        TelnetLogger.log(1, "getLoginAccount with Connection Name");
        LoginAccount loginAccount = null;
        string = string.trim();
        try {
            if (doRestore) {
                LoginAccount.Restore();
            }
            int n = 0;
            while (n < _loginaccounts.size()) {
                LoginAccount loginAccount2 = (LoginAccount)_loginaccounts.get(n);
                if (loginAccount2.getName().equalsIgnoreCase(string)) {
                    loginAccount = loginAccount2;
                    break;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
        }
        return loginAccount;
    }

    public static synchronized LoginAccount getLoginAccount(HostAccount hostAccount) {
        TelnetLogger.log(1, "getLoginAccount from HostAccount");
        try {
            if (doRestore) {
                LoginAccount.Restore();
            }
            int n = 0;
            while (n < _loginaccounts.size()) {
                LoginAccount loginAccount = (LoginAccount)_loginaccounts.get(n);
                if (loginAccount.getHostAccount().getHostId().equalsIgnoreCase(hostAccount.getHostId()) && loginAccount.getHostAccount().getUserId().equalsIgnoreCase(hostAccount.getUserId()) && loginAccount.getHostAccount().getConnectionName().equalsIgnoreCase(hostAccount.getConnectionName())) {
                    return loginAccount;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
        }
        return null;
    }

    public static synchronized String Add(LoginAccount loginAccount) {
        TelnetLogger.log(1, "add LoginAccount " + loginAccount);
        String string = "";
        try {
            LoginAccount loginAccount2;
            if (doRestore) {
                LoginAccount.Restore();
            }
            if ((loginAccount2 = LoginAccount.getLoginAccount(loginAccount.getName())) != null) {
                TelnetLogger.log(1, "duplicate LoginAccount" + loginAccount);
                string = Messages.getString("LoginAccount.7");
            }
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
            string = Messages.getString("InternalError");
        }
        return string;
    }

    public static synchronized void update(LoginAccount loginAccount) {
        if (doRestore) {
            LoginAccount.Restore();
        }
        boolean bl = false;
        LoginAccount loginAccount2 = null;
        Iterator iterator = _loginaccounts.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            loginAccount2 = (LoginAccount)iterator.next();
            if (loginAccount2.getName().equalsIgnoreCase(loginAccount.getName())) {
                _loginaccounts.set(n, loginAccount);
                bl = true;
            }
            ++n;
        }
        if (bl) {
            LoginAccount.Save();
        }
    }

    public static synchronized boolean Remove(String string) {
        TelnetLogger.log(1, "Remove LoginAccount " + string);
        boolean bl = false;
        try {
            int n = 0;
            while (n < _loginaccounts.size()) {
                LoginAccount loginAccount = (LoginAccount)_loginaccounts.get(n);
                if (loginAccount.getName().equals(string)) {
                    HostAccount hostAccount = HostAccount.getHostAccount(loginAccount.getName());
                    HostAccount.Remove(hostAccount);
                    _loginaccounts.remove(loginAccount);
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                TelnetLogger.log(4, Messages.getString("InternalError"));
            }
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
        }
        LoginAccount.Save();
        return bl;
    }

    public synchronized boolean addProtocol(Protocol protocol) {
        TelnetLogger.log(1, "addProtocol " + protocol);
        boolean bl = false;
        boolean bl2 = false;
        try {
            int n = 0;
            while (n < this._protocols.size()) {
                Protocol protocol2 = (Protocol)this._protocols.get(n);
                if (protocol2.getConnectionType().compareTo(protocol.getConnectionType()) > -1) {
                    bl = true;
                    TelnetLogger.log(1, "duplicate Protocol" + protocol);
                    break;
                }
                ++n;
            }
            if (!bl) {
                this._protocols.add(protocol);
                bl2 = true;
            }
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
        }
        this.OS2200fromProtocoltoHostAccount();
        return bl2;
    }

    public synchronized boolean removeProtocol(Protocol protocol) {
        TelnetLogger.log(1, "removeProtocol " + protocol);
        boolean bl = false;
        try {
            int n = 0;
            while (n < this._protocols.size()) {
                Protocol protocol2 = (Protocol)this._protocols.get(n);
                if (protocol2 == protocol) {
                    this._protocols.remove(n);
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                TelnetLogger.log(2, "Internal error. Unable to remove: " + protocol);
            }
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
        }
        return bl;
    }

    public synchronized Protocol[] getProtocols() {
        TelnetLogger.log(1, "getProtocols");
        Protocol[] protocolArray = null;
        try {
            protocolArray = new Protocol[this._protocols.size()];
            int n = 0;
            while (n < this._protocols.size()) {
                protocolArray[n] = (Protocol)this._protocols.get(n);
                ++n;
            }
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
        }
        return protocolArray;
    }

    public String getName() {
        return this._Name;
    }

    public String setName(String string) {
        string = string.trim();
        String string2 = "";
        int n = -1;
        LoginAccount loginAccount = null;
        TelnetLogger.log(1, "SetName " + this.getName() + "/" + string);
        int n2 = 0;
        while (n2 < _loginaccounts.size()) {
            LoginAccount loginAccount2 = (LoginAccount)_loginaccounts.get(n2);
            if (loginAccount2 == this) {
                n = n2;
            } else if (loginAccount2.getName().equalsIgnoreCase(string)) {
                loginAccount = loginAccount2;
            }
            ++n2;
        }
        if (n >= 0 && loginAccount != null) {
            TelnetLogger.log(1, "duplicate loginaccount: " + loginAccount.getName());
            string2 = Messages.getString("LoginAccount.7");
        } else {
            this._Name = string;
            string2 = "";
        }
        return string2;
    }

    public boolean ValidateHostAccount() {
        boolean bl = false;
        HostAccount hostAccount = this.getHostAccount();
        if (hostAccount != null) {
            String string = hostAccount.getHostId();
            if (!string.equals("")) {
                bl = true;
            } else {
                TelnetLogger.log(5, Messages.getString("LoginAccount.3"));
            }
        } else {
            TelnetLogger.log(5, Messages.getString("LoginAccount.4"));
        }
        return bl;
    }

    public HostAccount getHostAccount() {
        return this._HostAccount;
    }

    public void setHostAccount(HostAccount hostAccount) {
        this._HostAccount = hostAccount;
        this.OS2200fromProtocoltoHostAccount();
    }

    public void setHostAccount(String string, String string2, String string3, boolean bl, String string4, String string5, String string6, boolean bl2, String string7) {
        HostAccount hostAccount;
        this._HostAccount = hostAccount = HostAccount.getMatchingHostAccount(string4, string5, string7);
        if (this._HostAccount == null) {
            TelnetLogger.log(1, "host account lost: " + string4 + " " + string5);
            hostAccount = new HostAccount();
            hostAccount.setCifsHostId(string);
            try {
                hostAccount.setCifsUserId(CryptoUtils.decrypt(string2));
                hostAccount.setCifsPassword(CryptoUtils.decrypt(string3));
                hostAccount.setUserId(CryptoUtils.decrypt(string5));
                hostAccount.setPassword(CryptoUtils.decrypt(string6));
            }
            catch (GeneralSecurityException generalSecurityException) {
                generalSecurityException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            hostAccount.setCifsSavePw(bl);
            hostAccount.setHostId(string4);
            hostAccount.setSavePw(bl2);
            hostAccount.setConnectionName(string7);
            HostAccount.Add(hostAccount);
            HostAccount.Save();
        }
        this.OS2200fromProtocoltoHostAccount();
    }

    private void OS2200fromProtocoltoHostAccount() {
        if (this._HostAccount != null && !this._HostAccount.getOS2200explicit() && this._protocols.size() > 0) {
            TelnetLogger.log(1, "Migrate OS2200 to " + this._HostAccount.getHostId() + " " + this._HostAccount.getUserId());
            Protocol protocol = (Protocol)this._protocols.get(0);
            this._HostAccount.setOS2200(protocol.getOS2200deprecated());
            reSave = true;
        }
    }
}

