/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.telnet.lib.hostaccount;

import com.unisys.telnet.lib.Messages;
import com.unisys.telnet.lib.TelnetLogger;
import com.unisys.telnet.lib.hostaccount.CryptoUtils;
import com.unisys.telnet.lib.hostaccount.HostAccountDelegate;
import com.unisys.telnet.lib.hostaccount.LoginAccount;
import com.unisys.telnet.lib.hostaccount.Property;
import com.unisys.telnet.lib.hostaccount.Protocol;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.security.GeneralSecurityException;
import java.util.Vector;
import javax.swing.filechooser.FileSystemView;

public final class HostAccount {
    public static Vector _hostaccounts = new Vector();
    private static final String SaveFile = "HostAccount.xml";
    public static String _savedir = "\\Local Settings\\Application Data\\Unisys\\os2200\\ide\\";
    public static boolean doRestore = true;
    private boolean _OS2200 = true;
    private String _hostid = "";
    private String _userid = "";
    private String _password = "";
    private boolean _savepw = false;
    private String _cifshostid = "";
    private String _cifsuserid = "";
    private String _cifspassword = "";
    private boolean _cifssavepw = false;
    private String _ConnectionName = "";
    public static Protocol protocol;
    private boolean _OS2200explicit = false;

    public static String PrivateUserPath() {
        String string = "";
        try {
            FileSystemView fileSystemView = FileSystemView.getFileSystemView();
            File file = fileSystemView.getHomeDirectory();
            String string2 = file.getParent();
            string = String.valueOf(string2) + _savedir;
            File file2 = new File(string);
            file2.mkdirs();
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
        }
        return string;
    }

    public static synchronized void Save() {
        TelnetLogger.log(1, "HostAccount.Save");
        FileOutputStream fileOutputStream = null;
        XMLEncoder xMLEncoder = null;
        try {
            fileOutputStream = new FileOutputStream(String.valueOf(HostAccount.PrivateUserPath()) + SaveFile);
            xMLEncoder = new XMLEncoder(new BufferedOutputStream(fileOutputStream));
            HostAccountDelegate hostAccountDelegate = new HostAccountDelegate();
            xMLEncoder.setPersistenceDelegate(HostAccount.class, hostAccountDelegate);
            int n = 0;
            while (n < _hostaccounts.size()) {
                xMLEncoder.writeObject(_hostaccounts.get(n));
                ++n;
            }
            xMLEncoder.flush();
            xMLEncoder.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("HostAccount.1"), exception);
            try {
                xMLEncoder.close();
            }
            catch (Exception exception2) {}
            try {
                fileOutputStream.close();
            }
            catch (Exception exception3) {}
        }
    }

    private static synchronized void Restore() {
        doRestore = false;
        TelnetLogger.log(1, "HostAccount Restore ... Enter");
        FileInputStream fileInputStream = null;
        XMLDecoder xMLDecoder = null;
        try {
            fileInputStream = new FileInputStream(String.valueOf(HostAccount.PrivateUserPath()) + SaveFile);
            xMLDecoder = new XMLDecoder(fileInputStream);
            boolean bl = false;
            while (!bl) {
                try {
                    HostAccount hostAccount = (HostAccount)xMLDecoder.readObject();
                    if (hostAccount._cifshostid.length() < 1) {
                        hostAccount._cifshostid = hostAccount._hostid;
                        hostAccount._hostid = CryptoUtils.decrypt(hostAccount._userid);
                        hostAccount._password = CryptoUtils.decrypt(hostAccount._password);
                        hostAccount._cifsuserid = CryptoUtils.decrypt(hostAccount._cifsuserid);
                        hostAccount._cifspassword = CryptoUtils.decrypt(hostAccount._cifspassword);
                        hostAccount._cifssavepw = hostAccount._cifssavepw;
                        hostAccount._ConnectionName = hostAccount._ConnectionName;
                    }
                    hostAccount.setCifsPassword(CryptoUtils.decrypt(hostAccount.getCifsPassword()));
                    hostAccount.setPassword(CryptoUtils.decrypt(hostAccount.getPassword()));
                    hostAccount.setCifsUserId(CryptoUtils.decrypt(hostAccount.getCifsUserId()));
                    hostAccount.setUserId(hostAccount.getUserId());
                    _hostaccounts.add(hostAccount);
                }
                catch (Exception exception) {
                    bl = true;
                }
            }
            xMLDecoder.close();
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("HostAccount.5"), exception);
            try {
                xMLDecoder.close();
            }
            catch (Exception exception2) {}
            try {
                fileInputStream.close();
            }
            catch (Exception exception3) {}
        }
        TelnetLogger.log(1, "HostAccount Restore ... Exit");
        LoginAccount.getLoginAccount("");
    }

    public static synchronized HostAccount[] getHostAccounts() {
        TelnetLogger.log(1, "getHostAccounts");
        HostAccount[] hostAccountArray = null;
        try {
            if (doRestore) {
                HostAccount.Restore();
            }
            hostAccountArray = new HostAccount[_hostaccounts.size()];
            int n = 0;
            while (n < _hostaccounts.size()) {
                hostAccountArray[n] = (HostAccount)_hostaccounts.get(n);
                ++n;
            }
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
        }
        return hostAccountArray;
    }

    public static synchronized HostAccount getHostAccount(String string, String string2, String string3) {
        TelnetLogger.log(1, "getHostAccount");
        HostAccount hostAccount = null;
        string = string.trim();
        string2 = string2.trim();
        try {
            if (doRestore) {
                HostAccount.Restore();
            }
            int n = 0;
            while (n < _hostaccounts.size()) {
                HostAccount hostAccount2 = (HostAccount)_hostaccounts.get(n);
                if (hostAccount2.getHostId().equalsIgnoreCase(string) && hostAccount2.getUserId().equalsIgnoreCase(string2) && hostAccount2.getConnectionName().equalsIgnoreCase(string3)) {
                    hostAccount = hostAccount2;
                    break;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
        }
        return hostAccount;
    }

    public static synchronized HostAccount getHostAccount(HostAccount hostAccount) {
        TelnetLogger.log(1, "getHostAccount");
        HostAccount hostAccount2 = null;
        String string = hostAccount.getHostId().trim();
        String string2 = hostAccount.getUserId().trim();
        try {
            if (doRestore) {
                HostAccount.Restore();
            }
            int n = 0;
            while (n < _hostaccounts.size()) {
                HostAccount hostAccount3 = (HostAccount)_hostaccounts.get(n);
                if (hostAccount3.getHostId().equalsIgnoreCase(string) && hostAccount3.getUserId().equalsIgnoreCase(string2)) {
                    hostAccount2 = hostAccount3;
                    break;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
        }
        return hostAccount2;
    }

    public static synchronized HostAccount getMatchingHostAccount(String string, String string2, String string3) {
        TelnetLogger.log(1, "getMatchingHostAccount");
        HostAccount hostAccount = null;
        string = string.trim();
        string2 = string2.trim();
        string3 = string3.trim();
        try {
            if (doRestore) {
                HostAccount.Restore();
            }
            int n = 0;
            while (n < _hostaccounts.size()) {
                HostAccount hostAccount2 = (HostAccount)_hostaccounts.get(n);
                if (hostAccount2.getHostId().equalsIgnoreCase(string) && hostAccount2.getUserId().equalsIgnoreCase(string2) && hostAccount2.getConnectionName().equalsIgnoreCase(string3)) {
                    return hostAccount2;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
        }
        return hostAccount;
    }

    public static String loginForHostExists(HostAccount hostAccount) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        LoginAccount[] loginAccountArray = LoginAccount.getLoginAccounts();
        int n = 0;
        while (n < loginAccountArray.length) {
            if (loginAccountArray != null && protocol != null) {
                Property[] propertyArray = loginAccountArray[n].getProtocols()[0].getProperties();
                string = propertyArray[0].getValue();
                string2 = propertyArray[1].getValue();
                string3 = propertyArray[2].getValue();
                string4 = propertyArray[3].getValue();
                Property[] propertyArray2 = protocol.getProperties();
                String string5 = propertyArray2[0].getValue();
                String string6 = propertyArray2[1].getValue();
                String string7 = propertyArray2[2].getValue();
                String string8 = propertyArray2[3].getValue();
                if (string.equalsIgnoreCase(string5) && string3.equalsIgnoreCase(string7) && string4.equalsIgnoreCase(string8) && string2.equalsIgnoreCase(string6)) {
                    return loginAccountArray[n].getName();
                }
            }
            ++n;
        }
        return "";
    }

    public static synchronized String Add(HostAccount hostAccount) {
        String string;
        if (doRestore) {
            HostAccount.Restore();
        }
        if ((string = HostAccount._add(hostAccount)).length() == 0) {
            HostAccount.Save();
        }
        return string;
    }

    public static synchronized void update(HostAccount hostAccount, HostAccount hostAccount2) {
        if (doRestore) {
            HostAccount.Restore();
        }
        HostAccount hostAccount3 = HostAccount.getHostAccount(hostAccount.getHostId(), hostAccount.getUserId(), hostAccount.getConnectionName());
        _hostaccounts.remove(hostAccount3);
        _hostaccounts.add(hostAccount2);
        LoginAccount loginAccount = LoginAccount.getLoginAccount(hostAccount);
        loginAccount.setHostAccount(hostAccount2);
        LoginAccount.update(loginAccount);
        HostAccount.Save();
    }

    private static synchronized String _add(HostAccount hostAccount) {
        TelnetLogger.log(1, "add hostaccount:" + hostAccount.getHostId() + "|" + hostAccount.getUserId() + "|");
        String string = "";
        try {
            HostAccount hostAccount2 = HostAccount.getHostAccount(hostAccount.getHostId(), hostAccount.getUserId(), hostAccount.getConnectionName());
            if (hostAccount2 == null) {
                TelnetLogger.log(1, "add hostaccount " + hostAccount.getHostId() + " " + hostAccount.getUserId());
                _hostaccounts.add(hostAccount);
            } else {
                TelnetLogger.log(1, "duplicate hostaccount " + hostAccount.getHostId() + " " + hostAccount.getUserId());
                string = Messages.getString("HostAccount.7");
            }
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized boolean Remove(String string, String string2, String string3) {
        TelnetLogger.log(1, "Remove hostaccount: " + string + " " + string2);
        boolean bl = false;
        try {
            int n = 0;
            while (n < _hostaccounts.size()) {
                HostAccount hostAccount = (HostAccount)_hostaccounts.get(n);
                if (hostAccount.getHostId().equals(string) && hostAccount.getUserId().equals(string2) && hostAccount.getConnectionName().equals(string3)) {
                    TelnetLogger.log(1, "remove host: " + hostAccount.getHostId() + "-" + hostAccount.getUserId());
                    LoginAccount loginAccount = LoginAccount.getLoginAccount(string3);
                    if (loginAccount == null) {
                        TelnetLogger.log(4, "Deleting/Removing login with connection name : " + string3 + " failed.");
                        return false;
                    }
                    TelnetLogger.log(1, "remove login: " + loginAccount.getName());
                    LoginAccount.Remove(loginAccount.getName());
                    HostAccount.Remove(hostAccount);
                    LoginAccount.Save();
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                TelnetLogger.log(4, Messages.getString("HostAccount.4", string, string2));
            }
        }
        catch (Exception exception) {
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), exception);
        }
        HostAccount.Save();
        return bl;
    }

    public static void Remove(HostAccount hostAccount) {
        int n = 0;
        while (n < _hostaccounts.size()) {
            HostAccount hostAccount2 = (HostAccount)_hostaccounts.get(n);
            if (hostAccount == hostAccount2) {
                _hostaccounts.remove(hostAccount);
                break;
            }
            ++n;
        }
    }

    public String getHostId() {
        return this._hostid;
    }

    public void setHostId(String string) {
        this._hostid = string.trim();
    }

    public String getUserId() {
        return this._userid;
    }

    public String setUserId(String string) {
        try {
            string = CryptoUtils.decrypt(string);
        }
        catch (GeneralSecurityException generalSecurityException) {
            generalSecurityException.printStackTrace();
        }
        catch (Exception exception) {}
        string = string.trim();
        String string2 = "";
        int n = -1;
        HostAccount hostAccount = null;
        TelnetLogger.log(1, "SetUserId " + this.getHostId() + " " + this.getUserId() + "/" + string);
        int n2 = 0;
        while (n2 < _hostaccounts.size()) {
            HostAccount hostAccount2 = (HostAccount)_hostaccounts.get(n2);
            if (hostAccount2 == this) {
                n = n2;
            } else if (hostAccount2.getHostId().equalsIgnoreCase(this.getHostId()) && hostAccount2.getUserId().equalsIgnoreCase(string)) {
                hostAccount = hostAccount2;
            }
            ++n2;
        }
        if (n >= 0 && hostAccount != null) {
            TelnetLogger.log(1, "duplicate hostaccount: " + hostAccount.getHostId() + " " + hostAccount.getUserId());
            string2 = Messages.getString("HostAccount.7");
        } else {
            this._userid = string.trim();
            string2 = "";
        }
        return string2;
    }

    public boolean getSavePw() {
        return this._savepw;
    }

    public void setSavePw(boolean bl) {
        this._savepw = bl;
    }

    public synchronized String getPassword() {
        return this._password;
    }

    public synchronized void setPassword(String string) {
        this._password = string;
    }

    public String getCifsHostId() {
        return this._cifshostid;
    }

    public void setCifsHostId(String string) {
        this._cifshostid = string.trim();
    }

    public String getCifsUserId() {
        return this._cifsuserid;
    }

    public void setCifsUserId(String string) {
        this._cifsuserid = string.trim();
    }

    public boolean getCifsSavePw() {
        return this._cifssavepw;
    }

    public void setCifsSavePw(boolean bl) {
        this._cifssavepw = bl;
    }

    public synchronized String getCifsPassword() {
        return this._cifspassword;
    }

    public synchronized void setCifsPassword(String string) {
        this._cifspassword = string;
    }

    public boolean getOS2200explicit() {
        return this._OS2200explicit;
    }

    public boolean getOS2200() {
        return this._OS2200;
    }

    public void setConnectionName(String string) {
        this._ConnectionName = string;
    }

    public String getConnectionName() {
        return this._ConnectionName;
    }

    public void setOS2200(boolean bl) {
        this._OS2200 = bl;
        this._OS2200explicit = true;
    }

    public LoginAccount[] getLoginAccounts() {
        int n = 0;
        LoginAccount[] loginAccountArray = LoginAccount.getLoginAccounts();
        int n2 = 0;
        while (n2 < loginAccountArray.length) {
            if (loginAccountArray[n2].getHostAccount() == this) {
                ++n;
            }
            ++n2;
        }
        LoginAccount[] loginAccountArray2 = new LoginAccount[n];
        n = 0;
        int n3 = 0;
        while (n3 < loginAccountArray.length) {
            if (loginAccountArray[n3].getHostAccount() == this) {
                loginAccountArray2[n] = loginAccountArray[n3];
                ++n;
            }
            ++n3;
        }
        return loginAccountArray2;
    }

    public static synchronized HostAccount getHostAccount(String string) {
        HostAccount hostAccount = null;
        int n = 0;
        while (n < _hostaccounts.size()) {
            hostAccount = (HostAccount)_hostaccounts.get(n);
            if (hostAccount.getConnectionName().equalsIgnoreCase(string)) {
                return hostAccount;
            }
            ++n;
        }
        return hostAccount;
    }

    public static synchronized boolean savePassword(HostAccount hostAccount, String string) {
        HostAccount hostAccount2 = HostAccount.getHostAccount(hostAccount.getCifsHostId(), hostAccount.getCifsUserId(), hostAccount.getConnectionName());
        if (hostAccount2 != null) {
            hostAccount.setCifsPassword(string);
            if (hostAccount.getCifsHostId().equalsIgnoreCase(hostAccount.getHostId()) && hostAccount.getCifsUserId().equalsIgnoreCase(hostAccount.getUserId())) {
                hostAccount.setPassword(string);
            }
            HostAccount.Save();
            return true;
        }
        return false;
    }
}

