/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.telnet.lib.TelnetSocket;

import com.unisys.tde.core.characterset.OS2200CharSetPlugin;
import com.unisys.telnet.lib.Messages;
import com.unisys.telnet.lib.TelnetLogger;
import com.unisys.telnet.lib.TelnetSocket.TelnetConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;

public class TelnetSocket
implements TelnetConstants {
    protected Socket telnetSocket;
    protected InputStream InStream;
    protected OutputStream OutStream;
    private int blockCount = 0;
    private byte[] subnbuf = new byte[256];
    private ArrayList terminalTypes = new ArrayList(3);
    private int currentTermType = 0;
    private boolean TOM_TXBINARY = false;
    private boolean TOM_LOCAL_ECHO = true;
    private boolean TOM_NOGA = false;
    private String TOM_TERMTYPE = "dumb";
    private byte subneg_type;
    private int fsmState = 1;
    private String strCharSet = "<NONE>";
    int[] crlf = new int[3];

    public TelnetSocket() {
        TelnetLogger.log(1, "");
    }

    /*
     * Exception decompiling
     */
    public String open(String var1_1, int var2_2, boolean var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setCharSet(String string) {
        this.strCharSet = string;
    }

    public void close() {
        TelnetLogger.log(1, "");
        this.closeSocket();
    }

    private boolean closeSocket() {
        boolean bl = true;
        int n = 0;
        try {
            try {
                if (n < 1) {
                    n = 1;
                    if (this.InStream != null) {
                        this.InStream.close();
                        TelnetLogger.log(1, "InStream closed.");
                    } else {
                        TelnetLogger.log(1, "InStream null.");
                    }
                }
                if (n < 2) {
                    n = 2;
                    if (this.OutStream != null) {
                        this.OutStream.close();
                        TelnetLogger.log(1, "OutStream closed.");
                    } else {
                        TelnetLogger.log(1, "OutStream null.");
                    }
                }
                if (n < 3) {
                    n = 3;
                    if (this.telnetSocket != null) {
                        this.telnetSocket.close();
                        TelnetLogger.log(1, "telnetSocket closed.");
                    } else {
                        TelnetLogger.log(1, "telnetSocket null.");
                    }
                }
            }
            catch (IOException iOException) {
                TelnetLogger.log(1, (Object)"Internal Exception", iOException);
                bl = false;
                this.fsmState = 1;
            }
            catch (Throwable throwable) {
                TelnetLogger.log(1, (Object)Messages.getString("TelnetSocket_31"), throwable);
                bl = false;
                this.fsmState = 1;
            }
        }
        finally {
            this.fsmState = 1;
        }
        return bl;
    }

    public void addTermType(String string) {
        TelnetLogger.log(1, "Terminal type is: " + string);
        String string2 = string.trim();
        try {
            if (string2.length() > 40) {
                TelnetLogger.log(4, Messages.getString("TelnetSocket.12", string2));
                string2 = string2.substring(0, 40);
            }
            int n = 0;
            while (n < this.terminalTypes.size()) {
                if (string2.compareToIgnoreCase((String)this.terminalTypes.get(n)) == 0) {
                    TelnetLogger.log(1, "This is a duplicate terminal type: " + string);
                    return;
                }
                ++n;
            }
            this.terminalTypes.add(string);
        }
        catch (Throwable throwable) {
            TelnetLogger.log(5, (Object)Messages.getString("InternalError"), throwable);
        }
    }

    public int getLine(byte[] byArray) {
        int n;
        int n2;
        int n3;
        block8: {
            block7: {
                n3 = 0;
                n2 = 0;
                n = 0;
                if (byArray != null) break block7;
                TelnetLogger.log(4, Messages.getString("TelnetSocket.16"));
                return -1;
            }
            n3 = byArray.length;
            if (n3 > 0) break block8;
            TelnetLogger.log(4, Messages.getString("TelnetSocket.17"));
            return -1;
        }
        try {
            if (n3 > 0) {
                byte[] byArray2 = new byte[n3 / 2];
                byte[] byArray3 = new byte[n3 / 2];
                n2 = this.InStream.read(byArray2);
                n = this.IAC_check(byArray2, n2, byArray3);
                if (n > 0) {
                    byte[] byArray4 = OS2200CharSetPlugin.ConvertBufferToUnicode((byte[])byArray3, (int)n, (String)this.strCharSet);
                    System.arraycopy(byArray4, 0, byArray, 0, byArray4.length);
                    return byArray4.length;
                }
                return 0;
            }
            return 0;
        }
        catch (SocketException socketException) {
            TelnetLogger.log(2, socketException);
            return -1;
        }
        catch (Throwable throwable) {
            TelnetLogger.log(4, (Object)Messages.getString("InternalError"), throwable);
            return -1;
        }
    }

    public boolean sendLine(String string) {
        TelnetLogger.log(1, "");
        try {
            if (!string.isEmpty()) {
                byte[] byArray = OS2200CharSetPlugin.ConvertBufferToUnisysNoSring((String)string, (String)this.strCharSet);
                this.sendData(byArray);
            }
        }
        catch (Throwable throwable) {
            TelnetLogger.log(5, (Object)Messages.getString("InternalError"), throwable);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshStatus() {
        TelnetLogger.log(1, "");
        TelnetSocket telnetSocket = this;
        synchronized (telnetSocket) {
            this.sendCmd((byte)-1);
            this.sendCmd((byte)-3);
            this.sendCmd((byte)5);
        }
    }

    public boolean getLocalEcho() {
        TelnetLogger.log(1, "Echo setting is: " + this.TOM_LOCAL_ECHO);
        return this.TOM_LOCAL_ECHO;
    }

    public String getTermType() {
        TelnetLogger.log(1, "TermType setting is: " + this.TOM_TERMTYPE);
        return this.TOM_TERMTYPE;
    }

    public boolean getTextBinary() {
        TelnetLogger.log(1, "Text Binary setting is:" + this.TOM_TXBINARY);
        return this.TOM_TXBINARY;
    }

    public void setLocalEcho(boolean bl) {
        TelnetLogger.log(1, "Setting echo to " + bl);
        if (bl == this.TOM_LOCAL_ECHO) {
            return;
        }
        this.TOM_LOCAL_ECHO = bl;
        byte[] byArray = new byte[3];
        if (!bl) {
            TelnetLogger.log(1, "CLIENT: DO ECHO");
            byArray[1] = -3;
        } else {
            TelnetLogger.log(1, "CLIENT: DONT ECHO");
            byArray[1] = -2;
        }
        byArray[0] = -1;
        byArray[2] = 1;
        TelnetLogger.log(1, "Bytes sent are: " + byArray);
        this.sendCmd(byArray);
    }

    public void Break() {
        byte[] byArray = new byte[]{-1, -13};
        this.sendCmd(byArray);
    }

    public void InterruptProcess() {
        byte[] byArray = new byte[]{-1, -12};
        this.sendCmd(byArray);
    }

    public void AbortOutput() {
        byte[] byArray = new byte[]{-1, -11};
        this.sendCmd(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int IAC_check(byte[] byArray, int n, byte[] byArray2) {
        int n2 = 0;
        byte[] byArray3 = new byte[3];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            n2 = 0;
            byte by = byArray[n4];
            long l = by;
            if (l < 0L) {
                l += 256L;
            }
            block2 : switch (this.fsmState) {
                case 2: {
                    if (by == -1) {
                        this.fsmState = 3;
                        break;
                    }
                    if (by == 0) break;
                    byArray2[n3++] = by;
                    break;
                }
                case 3: {
                    switch (by) {
                        case -1: {
                            byArray2[n3++] = by;
                            this.fsmState = 2;
                            break block2;
                        }
                        case -5: {
                            this.fsmState = 4;
                            break block2;
                        }
                        case -4: {
                            this.fsmState = 5;
                            break block2;
                        }
                        case -3: {
                            this.fsmState = 6;
                            break block2;
                        }
                        case -2: {
                            this.fsmState = 7;
                            break block2;
                        }
                        case -17: {
                            this.fsmState = 2;
                            break block2;
                        }
                        case -6: {
                            this.blockCount = 0;
                            this.fsmState = 8;
                            break block2;
                        }
                    }
                    this.fsmState = 2;
                    break;
                }
                case 4: {
                    switch (by) {
                        case 1: {
                            TelnetLogger.log(1, "HOST: WILL ECHO");
                            this.fsmState = 2;
                            n2 = 0;
                            if (!this.TOM_LOCAL_ECHO) break;
                            this.TOM_LOCAL_ECHO = false;
                            n2 = -3;
                            break;
                        }
                        case -17: 
                        case 0: 
                        case 3: {
                            n2 = -2;
                            this.fsmState = 2;
                            break;
                        }
                        case 5: {
                            n2 = 0;
                            TelnetSocket telnetSocket = this;
                            synchronized (telnetSocket) {
                                byArray3[0] = -1;
                                byArray3[1] = -6;
                                byArray3[2] = 5;
                                this.sendCmd(byArray3);
                                byArray3[0] = 1;
                                byArray3[1] = -1;
                                byArray3[2] = -16;
                                this.sendCmd(byArray3);
                            }
                            this.fsmState = 2;
                            break;
                        }
                        default: {
                            n2 = -2;
                            this.fsmState = 2;
                        }
                    }
                    if (n2 == 0) break;
                    byArray3[0] = -1;
                    byArray3[1] = n2;
                    byArray3[2] = by;
                    this.sendCmd(byArray3);
                    break;
                }
                case 5: {
                    switch (by) {
                        case 1: {
                            TelnetLogger.log(1, "HOST: WONT ECHO");
                            n2 = 0;
                            this.fsmState = 2;
                            if (this.TOM_LOCAL_ECHO) break;
                            n2 = -2;
                            this.TOM_LOCAL_ECHO = true;
                            break;
                        }
                        case -17: 
                        case 0: 
                        case 3: {
                            n2 = -2;
                            this.fsmState = 2;
                            break;
                        }
                        default: {
                            n2 = -2;
                            this.fsmState = 2;
                        }
                    }
                    if (n2 == 0) break;
                    byArray3[0] = -1;
                    byArray3[1] = n2;
                    byArray3[2] = by;
                    this.sendCmd(byArray3);
                    break;
                }
                case 6: {
                    switch (by) {
                        case 24: {
                            n2 = -5;
                            this.fsmState = 2;
                            break;
                        }
                        default: {
                            n2 = -4;
                            this.fsmState = 2;
                        }
                    }
                    if (n2 == 0) break;
                    byArray3[0] = -1;
                    byArray3[1] = n2;
                    byArray3[2] = by;
                    this.sendCmd(byArray3);
                    break;
                }
                case 7: {
                    switch (by) {
                        case 1: {
                            TelnetLogger.log(1, "HOST: DONT ECHO");
                            this.TOM_LOCAL_ECHO = false;
                            n2 = -4;
                            this.fsmState = 2;
                            break;
                        }
                        default: {
                            n2 = -4;
                            this.fsmState = 2;
                        }
                    }
                    if (n2 == 0) break;
                    byArray3[0] = -1;
                    byArray3[1] = n2;
                    byArray3[2] = by;
                    this.sendCmd(byArray3);
                    break;
                }
                case 8: {
                    switch (by) {
                        case -1: {
                            this.fsmState = 9;
                            break block2;
                        }
                    }
                    this.blockCount = 0;
                    this.subneg_type = by;
                    this.fsmState = 10;
                    break;
                }
                case 9: {
                    switch (by) {
                        case -1: {
                            this.blockCount = 0;
                            this.subneg_type = by;
                            this.fsmState = 10;
                            break block2;
                        }
                    }
                    this.fsmState = 2;
                    break;
                }
                case 10: {
                    if (this.blockCount >= 99) {
                        this.handleSB(this.subneg_type, this.subnbuf, this.blockCount);
                        this.blockCount = 0;
                    }
                    switch (by) {
                        case -1: {
                            this.fsmState = 11;
                            break block2;
                        }
                    }
                    this.subnbuf[this.blockCount++] = by;
                    break;
                }
                case 11: {
                    switch (by) {
                        case -1: {
                            this.subnbuf[this.blockCount++] = by;
                            this.fsmState = 10;
                            break block2;
                        }
                        case -6: {
                            this.handleSB(this.subneg_type, this.subnbuf, this.blockCount);
                            this.fsmState = 8;
                            break block2;
                        }
                        case -16: {
                            this.handleSB(this.subneg_type, this.subnbuf, this.blockCount);
                            this.fsmState = 2;
                            this.subneg_type = 0;
                            break block2;
                        }
                    }
                    this.fsmState = 2;
                    break;
                }
            }
            ++n4;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSB(byte by, byte[] byArray, int n) {
        TelnetLogger.log(1, "length is: " + n);
        if (n <= 0) {
            return;
        }
        switch (by) {
            case 24: {
                TelnetLogger.log(1, "Type is TerminalType");
                TelnetSocket telnetSocket = this;
                synchronized (telnetSocket) {
                    this.sendCmd((byte)-1);
                    this.sendCmd((byte)-6);
                    this.sendCmd((byte)24);
                    this.sendCmd((byte)0);
                    String string = this.getNextTermType();
                    if (string == null) {
                        string = this.TOM_TERMTYPE;
                    }
                    TelnetLogger.log(1, "Adding " + string + " to list.");
                    this.sendCmd(string.getBytes());
                    this.sendCmd((byte)-1);
                    this.sendCmd((byte)-16);
                    break;
                }
            }
            case 5: {
                TelnetLogger.log(1, "Type is Status Send ");
                if (n < 3) {
                    TelnetLogger.log(1, "Malformed subneg clause.");
                    return;
                }
                if (byArray[0] != 0) break;
                int n2 = 1;
                while (n2 < n) {
                    switch (byArray[n2 + 1]) {
                        case 1: {
                            this.TOM_LOCAL_ECHO = byArray[n2] == 4;
                            TelnetLogger.log(1, "Setting Local Echo to " + this.TOM_LOCAL_ECHO);
                            break;
                        }
                        case 3: {
                            this.TOM_NOGA = byArray[n2] == 4;
                            TelnetLogger.log(1, "Setting SGA to " + this.TOM_NOGA);
                            break;
                        }
                        case 0: {
                            this.TOM_TXBINARY = byArray[n2] == 4;
                            TelnetLogger.log(1, "Setting TXBINARY to " + this.TOM_TXBINARY);
                            break;
                        }
                        default: {
                            TelnetLogger.log(1, "Unknown STATUS byte " + byArray[n2 + 1]);
                        }
                    }
                    n2 += 2;
                }
                break;
            }
        }
    }

    private String getNextTermType() {
        TelnetLogger.log(1, "");
        String string = null;
        try {
            if (this.currentTermType >= this.terminalTypes.size()) {
                string = (String)this.terminalTypes.get(this.terminalTypes.size());
                this.currentTermType = 0;
                return string;
            }
            string = (String)this.terminalTypes.get(this.currentTermType);
        }
        catch (Throwable throwable) {
            TelnetLogger.log(5, (Object)Messages.getString("InternalError"), throwable);
            string = null;
        }
        TelnetLogger.log(1, "Returning: " + string);
        return string;
    }

    private boolean sendCmd(byte by) {
        try {
            long l = by;
            if (l < 0L) {
                l += 256L;
            }
            TelnetLogger.log(1, "sendCmd() of one byte " + l);
            this.OutStream.write(by);
        }
        catch (IOException iOException) {
            TelnetLogger.log(5, (Object)Messages.getString("TelnetSocket.49"), iOException);
            this.closeSocket();
            return false;
        }
        catch (Throwable throwable) {
            TelnetLogger.log(5, (Object)Messages.getString("InternalError"), throwable);
            this.closeSocket();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendCmd(byte[] byArray) {
        try {
            TelnetSocket telnetSocket = this;
            synchronized (telnetSocket) {
                this.OutStream.write(byArray);
            }
            TelnetLogger.log(1, "sendCmd() of " + this.strByte(byArray));
        }
        catch (IOException iOException) {
            TelnetLogger.log(5, (Object)Messages.getString("TelnetSocket.49"), iOException);
            this.closeSocket();
            return false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            TelnetLogger.log(5, (Object)Messages.getString("InternalError"), throwable);
            this.closeSocket();
            return false;
        }
        return true;
    }

    private String strByte(byte[] byArray) {
        String string = "";
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n];
            if (n2 < 0) {
                n2 += 256;
            }
            string = String.valueOf(string) + " " + Integer.toString(n2);
            ++n;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendData(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        try {
            TelnetSocket telnetSocket = this;
            synchronized (telnetSocket) {
                int n3 = 0;
                while (n3 < byArray.length) {
                    ++n2;
                    if (byArray[n3] == -1) {
                        this.OutStream.write(byArray, n, n2);
                        this.OutStream.write(-1);
                        TelnetLogger.log(1, "Number of bytes written to stream: " + n2 + ", followed by IAC");
                        n = n3 + 1;
                        n2 = 0;
                    }
                    ++n3;
                }
                if (n2 > 0) {
                    this.OutStream.write(byArray, n, n2);
                    TelnetLogger.log(1, "Number of bytes written to stream:" + n2);
                }
            }
        }
        catch (IOException iOException) {
            TelnetLogger.log(5, (Object)Messages.getString("TelnetSocket.49"), iOException);
            this.closeSocket();
            return false;
        }
        catch (Throwable throwable) {
            TelnetLogger.log(5, (Object)Messages.getString("InternalError"), throwable);
            this.closeSocket();
            return false;
        }
        return true;
    }
}

