/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.telnet.lib.TelnetSocket;

import com.unisys.telnet.ui.CertDialog;
import com.unisys.telnet.ui.CertDialogData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class OS2200X509TrustManager
implements X509TrustManager {
    private KeyStore ks;
    private String storePath;
    private String storePassword;
    X509TrustManager pkixTrustManager;

    public OS2200X509TrustManager(KeyStore keyStore, String string, String string2) throws Exception {
        this.ks = keyStore;
        this.storePath = string;
        this.storePassword = string2;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
        trustManagerFactory.init(this.ks);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        int n = 0;
        while (n < trustManagerArray.length) {
            if (trustManagerArray[n] instanceof X509TrustManager) {
                this.pkixTrustManager = (X509TrustManager)trustManagerArray[n];
                return;
            }
            ++n;
        }
        throw new Exception("Couldn't initialize");
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        block5: {
            X509Certificate x509Certificate = x509CertificateArray[0];
            try {
                this.pkixTrustManager.checkServerTrusted(x509CertificateArray, string);
            }
            catch (CertificateException certificateException) {
                System.out.println(certificateException.getLocalizedMessage());
                if (!this.checkCert(x509Certificate)) {
                    throw certificateException;
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                Throwable throwable = runtimeException.getCause();
                if (!(throwable instanceof InvalidAlgorithmParameterException)) break block5;
                if (!this.checkCert(x509Certificate)) {
                    throw new CertificateException("Certificate Denied");
                }
                return;
            }
        }
    }

    boolean checkCert(X509Certificate x509Certificate) {
        byte[] cfr_ignored_0 = new byte[50];
        try {
            CertDialogData certDialogData = new CertDialogData();
            certDialogData.setCert(x509Certificate);
            CertDialog certDialog = new CertDialog();
            if (certDialog.show(certDialogData)) {
                this.storeNewCert(x509Certificate);
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    void storeNewCert(X509Certificate x509Certificate) throws KeyStoreException {
        this.ks.setCertificateEntry("rs02fe", x509Certificate);
        char[] cArray = this.storePassword.toCharArray();
        File file = new File(this.storePath);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.ks.store(fileOutputStream, cArray);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }
}

