/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.jai.core.wizards;

import com.unisys.jai.core.JavaClasspathHandler;
import com.unisys.os2200.i18nSupport.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class RAPlainConnectionPage
extends WizardPage
implements IWizardPage {
    int typeName;
    public static final String ConnInfoPage = "PlainConnection";
    Label lblIpAdd;
    Text txtIpAdd;
    Label lblPort;
    Text txtPort;
    Label lblSite;
    Text txtSite;
    Label lblLocale;
    Text txtLocale;
    Label lblCharSet;
    Text txtCharSet;
    Label lblBlockSize;
    Text txtBlockSize;
    private Combo lstConnType;
    private static final String[] ctVals = new String[]{"SOCKETS", "SECURE-SOCKETS"};
    Font font;
    Composite panel;
    Composite theParent;
    private static final String defLocale = Messages.getString((String)"defaultLocale");
    private static final String defBlockSize = Messages.getString((String)"defaultBlockSize");
    private static final String defCharSet = Messages.getString((String)"defaultCharSet");
    String blnk;
    private ModifyListener IpAddMod = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            RAPlainConnectionPage.this.checkPage();
        }
    };
    private ModifyListener PortMod = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            RAPlainConnectionPage.this.checkPage();
        }
    };
    private ModifyListener SiteMod = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            RAPlainConnectionPage.this.checkPage();
        }
    };
    private PaintListener lblIpAddPaint = new PaintListener(){

        public void paintControl(PaintEvent paintEvent) {
            RAPlainConnectionPage.this.setSizes();
        }
    };
    Listener pushDefs = new Listener(){

        public void handleEvent(Event event) {
            RAPlainConnectionPage.this.restoreDefaults();
        }
    };

    boolean checkPort() {
        try {
            Integer.parseInt(this.txtPort.getText());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage("The port number must be a number.");
            return false;
        }
    }

    public void checkPage() {
        this.setErrorMessage(null);
        switch (this.typeName) {
            case 1: {
                this.setPageComplete(this.txtIpAdd.getText().trim().length() != 0 && this.txtPort.getText().trim().length() != 0 && this.txtSite.getText().trim().length() != 0 && this.checkPort() && this.checkSite());
                break;
            }
            case 2: {
                this.setPageComplete(this.txtIpAdd.getText().trim().length() != 0 && this.txtPort.getText().trim().length() != 0 && this.checkPort());
            }
        }
    }

    boolean checkSite() {
        String string = this.txtSite.getText();
        int n = string.length();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = this.txtSite.getText().charAt(n2);
            if (!Character.isLetterOrDigit(c)) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (bl) {
            this.setErrorMessage(Messages.getString((String)"RAPlainConnectionPage_0"));
            return false;
        }
        if (this.txtSite.getText().length() > 8) {
            this.setErrorMessage(Messages.getString((String)"RAPlainConnectionPage_1"));
            return false;
        }
        return true;
    }

    public RAPlainConnectionPage(int n) {
        super(ConnInfoPage);
        this.typeName = n;
        this.blnk = JavaClasspathHandler.spaces(200);
    }

    public void setSizes() {
        this.txtIpAdd.setText(this.txtIpAdd.getText().trim());
    }

    public String getConnectionType() {
        return this.lstConnType.getItem(this.lstConnType.getSelectionIndex());
    }

    public void restoreDefaults() {
        this.txtLocale.setText(defLocale);
        this.txtCharSet.setText(defCharSet);
        if (this.typeName == 1) {
            this.txtBlockSize.setText(defBlockSize);
        }
    }

    private void setHelp(Composite composite) {
        String string = "specify_bis_ra_connection_non-wtp";
        if (this.typeName == 2) {
            string = "specify_dms_ra_connection_non-wtp";
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.unisys.jai.core." + string);
    }

    public void createControl(Composite composite) {
        Label label;
        this.theParent = composite;
        this.panel = new Composite(composite, 2048);
        this.setHelp(this.panel);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        this.panel.setLayout((Layout)gridLayout);
        this.lblIpAdd = new Label(this.panel, 0);
        this.txtIpAdd = new Text(this.panel, 2048);
        this.txtIpAdd.setText(this.blnk.substring(0, 70));
        this.lblPort = new Label(this.panel, 0);
        this.txtPort = new Text(this.panel, 2048);
        if (this.typeName == 1) {
            this.lblSite = new Label(this.panel, 0);
            this.txtSite = new Text(this.panel, 2048);
            this.txtSite.setTextLimit(8);
            this.txtSite.addModifyListener(this.SiteMod);
        }
        if (this.typeName == 2) {
            label = new Label(this.panel, 0);
            this.lstConnType = new Combo(this.panel, 12);
            this.lstConnType.setItems(ctVals);
            this.lstConnType.select(0);
            label.setText("Connection Type");
        }
        label = new Label(this.panel, 0);
        Label label2 = new Label(this.panel, 0);
        label.setText("");
        label2.setText("");
        this.lblLocale = new Label(this.panel, 0);
        this.txtLocale = new Text(this.panel, 2048);
        this.lblCharSet = new Label(this.panel, 0);
        this.txtCharSet = new Text(this.panel, 2048);
        if (this.typeName == 1) {
            this.lblBlockSize = new Label(this.panel, 0);
            this.txtBlockSize = new Text(this.panel, 2048);
            this.txtBlockSize.setText(defBlockSize);
        }
        this.txtLocale.setText(defLocale);
        this.txtCharSet.setText(defCharSet);
        Label label3 = new Label(this.panel, 0);
        label3.setText("");
        Button button = new Button(this.panel, 8);
        button.setText(Messages.getString((String)"RestoreDefaults"));
        button.addListener(13, this.pushDefs);
        this.txtIpAdd.addModifyListener(this.IpAddMod);
        this.txtPort.addModifyListener(this.PortMod);
        this.setLabels(this.typeName);
        this.panel.addPaintListener(this.lblIpAddPaint);
        this.setControl((Control)this.panel);
        Dialog.applyDialogFont((Control)composite);
        this.setPageComplete(false);
    }

    private void setLabels(int n) {
        this.lblIpAdd.setText(Messages.getString((String)"PlainIP"));
        this.lblPort.setText(Messages.getString((String)"PlainPort"));
        switch (n) {
            case 1: {
                this.setTitle(Messages.getString((String)"BISConnectionPageTitle"));
                this.setDescription(Messages.getString((String)"BISConnPageDesc"));
                this.lblSite.setText(Messages.getString((String)"PlainSite"));
                this.lblLocale.setText(Messages.getString((String)"BISLocale"));
                this.lblCharSet.setText(Messages.getString((String)"BISCharSet"));
                this.lblBlockSize.setText(Messages.getString((String)"BISBlockSize"));
                break;
            }
            case 2: {
                this.setTitle(Messages.getString((String)"DMSConnectionPageTitle"));
                this.setDescription(Messages.getString((String)"DMSConnPageDesc"));
                this.lblLocale.setText(Messages.getString((String)"DMSLocale"));
                this.lblCharSet.setText(Messages.getString((String)"DMSCharSet"));
            }
        }
    }
}

