/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.jai.core.wizards;

import com.unisys.os2200.i18nSupport.Messages;
import java.util.Arrays;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PlainConnInfoPage
extends WizardPage
implements IWizardPage {
    int typeName;
    private static final String CredPage = "Credential";
    String pageNm;
    Label lblUserid;
    Text txtUserid;
    Label lblPassword;
    Text txtPassword;
    Label lblDepartment;
    Text txtDepartment;
    public Label lblChangeFile;
    public Text txtChangeFile;
    char[] mnyb = new char[200];
    String bigBlank;
    private static final String checkFileErrorMsg = Messages.getString((String)"QualStrFError");
    private Button chkAccessType;
    private static final String[] AccessTypes = new String[]{"UPDATE", "READ"};
    private Combo lstMode;
    private static final String[] mdVals = new String[]{"PRODUCTION", "TEST", "TRAINING", "TEST_TRAINING"};
    private Combo lstRecoveryOption;
    private static final String[] roVals = new String[]{"DEFERRED", "NONE", "COMMAND_LOOKS", "QUICK_LOOKS"};
    Composite credPanel;
    ModifyListener txtListen = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            PlainConnInfoPage.this.checkCreds();
        }
    };
    ModifyListener changeCheck = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            PlainConnInfoPage.this.removeError();
            PlainConnInfoPage.this.checkChange();
        }
    };
    PaintListener trimmer = new PaintListener(){

        public void paintControl(PaintEvent paintEvent) {
            if (PlainConnInfoPage.this.txtChangeFile != null) {
                PlainConnInfoPage.this.txtChangeFile.setText(PlainConnInfoPage.this.txtChangeFile.getText().trim());
            }
        }
    };

    public PlainConnInfoPage(int n) {
        super(CredPage);
        this.typeName = n;
        Arrays.fill(this.mnyb, ' ');
        this.bigBlank = new String(this.mnyb);
    }

    void removeError() {
        this.setErrorMessage(null);
    }

    boolean checkChange() {
        String string = this.txtChangeFile.getText();
        if (string == null || string.trim().length() == 0) {
            return true;
        }
        if (!Character.isLetter(string.charAt(0))) {
            this.setErrorMessage(checkFileErrorMsg);
            return false;
        }
        if (string.charAt(string.length() - 1) != '.') {
            this.setErrorMessage(checkFileErrorMsg);
            return false;
        }
        if (string.indexOf("*") < 1) {
            this.setErrorMessage(checkFileErrorMsg);
            return false;
        }
        int n = 1;
        while (n < string.length() - 1) {
            char c = string.charAt(n);
            if (!Character.isLetterOrDigit(c) && c != '*') {
                this.setErrorMessage(checkFileErrorMsg);
                return false;
            }
            ++n;
        }
        return true;
    }

    public IWizardPage getNextPage() {
        IWizardPage iWizardPage = super.getNextPage();
        if (this.typeName == 2) {
            if (this.checkChange()) {
                return iWizardPage;
            }
            return this;
        }
        return iWizardPage;
    }

    boolean checkDept() {
        String string = this.txtDepartment.getText();
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(Messages.getString((String)"DeptNumber"));
            return false;
        }
    }

    public void checkCreds() {
        this.setErrorMessage(null);
        switch (this.typeName) {
            case 1: {
                this.setPageComplete(this.txtUserid.getText().trim().length() != 0 && this.txtPassword.getText().trim().length() != 0 && this.txtDepartment.getText().trim().length() != 0 && this.checkDept());
                break;
            }
            case 2: {
                this.setPageComplete(this.txtUserid.getText().trim().length() != 0 && this.txtPassword.getText().trim().length() != 0);
            }
        }
    }

    private void setHelp(Composite composite) {
        String string = "specify_bis_credentials_non-wtp";
        if (this.typeName == 2) {
            string = "specify_dms_credentials_non-wtp";
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.unisys.jai.core." + string);
    }

    public void createControl(Composite composite) {
        this.credPanel = new Composite(composite, 2048);
        GridLayout gridLayout = new GridLayout();
        this.setHelp(this.credPanel);
        this.credPanel.setLayout((Layout)gridLayout);
        this.credPanel.addPaintListener(this.trimmer);
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        this.lblUserid = new Label(this.credPanel, 0);
        this.txtUserid = new Text(this.credPanel, 2048);
        this.lblPassword = new Label(this.credPanel, 0);
        this.txtPassword = new Text(this.credPanel, 2048);
        if (this.typeName == 1) {
            this.lblDepartment = new Label(this.credPanel, 0);
            this.txtDepartment = new Text(this.credPanel, 2048);
            this.txtDepartment.addModifyListener(this.txtListen);
        }
        if (this.typeName == 2) {
            Label label = new Label(this.credPanel, 0);
            this.lstMode = new Combo(this.credPanel, 12);
            this.lstMode.setItems(mdVals);
            this.lstMode.select(0);
            label.setText(Messages.getString((String)"Mode"));
            Label label2 = new Label(this.credPanel, 0);
            this.lstRecoveryOption = new Combo(this.credPanel, 12);
            this.lstRecoveryOption.setItems(roVals);
            this.lstRecoveryOption.select(0);
            label2.setText(Messages.getString((String)"RecovAction"));
            this.chkAccessType = new Button(this.credPanel, 32);
            this.chkAccessType.setText(Messages.getString((String)"UpdateAccess"));
            this.chkAccessType.setSelection(false);
            Label label3 = new Label(this.credPanel, 0);
            label3.setText("");
            this.lblChangeFile = new Label(this.credPanel, 0);
            this.txtChangeFile = new Text(this.credPanel, 2048);
            this.txtChangeFile.setText(this.bigBlank.substring(0, 52));
            this.txtChangeFile.addModifyListener(this.changeCheck);
            this.lblChangeFile.setText(Messages.getString((String)"ChangeFile"));
        }
        this.txtUserid.addModifyListener(this.txtListen);
        this.txtPassword.addModifyListener(this.txtListen);
        this.setLabels();
        this.setControl((Control)this.credPanel);
        Dialog.applyDialogFont((Control)composite);
        this.setPageComplete(false);
    }

    public String getUserId() {
        return this.txtUserid.getText();
    }

    public String getPassword() {
        return this.txtPassword.getText();
    }

    public String getDepartment() {
        return this.txtDepartment.getText();
    }

    public String getChangeFile() {
        if (this.txtChangeFile.getText().trim().length() == 0) {
            return null;
        }
        return this.txtChangeFile.getText();
    }

    public String getMode() {
        return this.lstMode.getItem(this.lstMode.getSelectionIndex()).toUpperCase();
    }

    public String getRecoveryOption() {
        return this.lstRecoveryOption.getItem(this.lstRecoveryOption.getSelectionIndex()).toUpperCase();
    }

    public String getAccessType() {
        if (this.chkAccessType.getSelection()) {
            return AccessTypes[0];
        }
        return AccessTypes[1];
    }

    void setLabels() {
        switch (this.typeName) {
            case 1: {
                this.setTitle(Messages.getString((String)"BISCredTitle"));
                this.setDescription(Messages.getString((String)"BISDrecDesc"));
                this.lblUserid.setText(Messages.getString((String)"BISConnUserID"));
                this.lblPassword.setText(Messages.getString((String)"BISConnPassword"));
                this.lblDepartment.setText(Messages.getString((String)"BISConnDepartment"));
                break;
            }
            case 2: {
                this.setTitle(Messages.getString((String)"DMSCredTitle"));
                this.setDescription(Messages.getString((String)"DMSCredDesc"));
                this.lblUserid.setText(Messages.getString((String)"DMSConnUserID"));
                this.lblPassword.setText(Messages.getString((String)"DMSConnPassword"));
            }
        }
    }
}

