/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.jai.core.wizards;

import com.unisys.jai.core.JAICorePlugin;
import com.unisys.jai.core.JavaClasspathHandler;
import com.unisys.jai.core.ProjectFileHandler;
import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PackageListPage
extends WizardPage {
    CoreException exCE;
    IStructuredSelection selection;
    Composite panel;
    Composite twoColPanel;
    Label lblBeanList;
    Combo packageList;
    Label lblClassName;
    Text txtClassName;
    Label lblJarLocation;
    Text txtJarLocation;
    Button btnBrowse;
    Properties projProps;
    String subtype = "";
    Text targetLinkName;
    Button newBut;
    IProject theProj;
    IJavaProject jProj;
    Composite theParent;
    IStructuredSelection select;
    IPackageFragment selectFrag;
    Label waitLabel;
    boolean building = false;
    int typeName;
    char[] bln = new char[200];
    String blank;
    String noJarMessage;
    String wrongJarMessage;
    String noExistJarMessage;
    String raDescription;
    String raTitle;
    ArrayList<IPackageFragment> mList;
    ArrayList<IPackageFragment> omList;
    ModifyListener packageModListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            PackageListPage.this.checkPageReady();
        }
    };
    ModifyListener textModListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            PackageListPage.this.checkPageReady();
        }
    };
    Listener buttonListen = new Listener(){

        public void handleEvent(Event event) {
            FileDialog fileDialog = new FileDialog(PackageListPage.this.panel.getShell(), 4096);
            String string = fileDialog.open();
            if (string != null) {
                PackageListPage.this.txtJarLocation.setText(string);
            }
        }
    };
    private PaintListener bigListen = new PaintListener(){

        public void paintControl(PaintEvent paintEvent) {
            PackageListPage.this.txtClassName.setText(PackageListPage.this.txtClassName.getText().trim());
            PackageListPage.this.txtJarLocation.setText(PackageListPage.this.txtJarLocation.getText().trim());
        }
    };

    public PackageListPage(IProject iProject, IStructuredSelection iStructuredSelection, int n) {
        super("PackageList");
        this.theProj = iProject;
        this.jProj = JavaCore.create((IProject)this.theProj);
        this.typeName = n;
        this.select = iStructuredSelection;
        Arrays.fill(this.bln, ' ');
        this.blank = new String(this.bln);
    }

    boolean checkGoodPackageName() {
        this.setErrorMessage(null);
        String string = this.packageList.getText();
        if (string.trim().length() == 0) {
            return false;
        }
        IStatus iStatus = JavaConventions.validatePackageName((String)string);
        if (iStatus.isOK()) {
            return true;
        }
        this.setErrorMessage(iStatus.getMessage());
        return false;
    }

    boolean checkJarPath() {
        block9: {
            IPath iPath;
            block10: {
                Path path;
                block8: {
                    String string;
                    block7: {
                        if (this.txtJarLocation.getText().trim().length() <= 0) {
                            this.setErrorMessage(this.noJarMessage);
                            return false;
                        }
                        try {
                            string = this.txtJarLocation.getText();
                            path = new Path(string);
                            String string2 = path.lastSegment().toLowerCase();
                            if (string2.equals(this.getRightJarName())) break block7;
                            this.setErrorMessage(this.wrongJarMessage);
                            return false;
                        }
                        catch (Exception exception) {
                            this.setErrorMessage(this.noExistJarMessage);
                            OS2200CorePlugin.logger.debug((Object)"exception checking Jar Path", (Throwable)exception);
                            return false;
                        }
                    }
                    boolean bl = path.isAbsolute();
                    if (!bl) break block8;
                    File file = new File(string);
                    if (!file.exists()) {
                        this.setErrorMessage(this.noExistJarMessage);
                        return false;
                    }
                    break block9;
                }
                String string = path.segment(0);
                iPath = JavaCore.getClasspathVariable((String)string);
                if (iPath != null) break block10;
                this.setErrorMessage(this.wrongJarMessage);
                return false;
            }
            File file = new File(iPath.toPortableString());
            if (file.exists()) break block9;
            this.setErrorMessage(this.noExistJarMessage);
            return false;
        }
        return true;
    }

    String getRightJarName() {
        switch (this.typeName) {
            case 1: {
                return "bisra.jar";
            }
            case 2: {
                return "dmsra.jar";
            }
        }
        return "";
    }

    boolean checkClassName() {
        this.setErrorMessage(null);
        String string = String.valueOf(this.txtClassName.getText().trim()) + ".java";
        IStatus iStatus = JavaConventions.validateCompilationUnitName((String)string);
        if (!iStatus.isOK()) {
            this.setErrorMessage(iStatus.getMessage());
            return false;
        }
        Character c = Character.valueOf(string.charAt(0));
        if (Character.isLowerCase(c.charValue())) {
            this.setErrorMessage(Messages.getString((String)"ErrorLowerStartClassname"));
            return false;
        }
        if (!this.checkClassNotExist(string, this.getPackageFragment())) {
            this.setErrorMessage(Messages.getString((String)"PackageListPage_1"));
            return false;
        }
        this.setMessage(null, 0);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean checkClassNotExist(String string, IPackageFragment iPackageFragment) {
        try {
            if (iPackageFragment == null) {
                return true;
            }
            ICompilationUnit[] iCompilationUnitArray = iPackageFragment.getCompilationUnits();
            if (iCompilationUnitArray == null) {
                return true;
            }
            if (iCompilationUnitArray.length == 0) {
                return true;
            }
            int n = 0;
            while (true) {
                if (n >= iCompilationUnitArray.length) {
                    return true;
                }
                if (iCompilationUnitArray[n].getElementName().equalsIgnoreCase(string)) {
                    return false;
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {
            return true;
        }
    }

    void checkPageReady() {
        this.setPageComplete(this.packageList.getText().trim().length() > 0 && this.checkGoodPackageName() && this.txtClassName.getText().trim().length() > 0 && this.checkClassName() && this.checkJarPath());
    }

    private void setHelp(Composite composite) {
        String string = "bis_identify_package_non-wtp";
        if (this.typeName == 2) {
            string = "dms_identify_package_non-wtp";
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.unisys.jai.core." + string);
    }

    public void createControl(Composite composite) {
        this.theParent = composite;
        this.panel = new Composite(composite, 2048);
        GridLayout gridLayout = new GridLayout();
        this.setTitle(Messages.getString((String)"PackagePageTitle"));
        this.setDescription(Messages.getString((String)"PackagePageDescription"));
        this.panel.setLayout((Layout)gridLayout);
        this.setHelp(this.panel);
        gridLayout.numColumns = 1;
        this.lblBeanList = new Label(this.panel, 0);
        this.lblBeanList.setText(Messages.getString((String)"PackageLabel"));
        this.packageList = new Combo(this.panel, 2624);
        this.fillPackageList();
        this.packageList.addModifyListener(this.packageModListener);
        Label label = new Label(this.panel, 0);
        label.setText("");
        this.lblClassName = new Label(this.panel, 0);
        this.txtClassName = new Text(this.panel, 2048);
        this.lblClassName.setText(Messages.getString((String)"ClassNameLabel"));
        this.txtClassName.addModifyListener(this.textModListener);
        this.txtClassName.setText(this.blank.substring(0, 50));
        this.twoColPanel = new Composite(this.panel, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        this.twoColPanel.setLayout((Layout)gridLayout2);
        this.lblJarLocation = new Label(this.twoColPanel, 0);
        new Label(this.twoColPanel, 0);
        this.txtJarLocation = new Text(this.twoColPanel, 2048);
        String string = JAICorePlugin.pluginPath(this.getRightJarName());
        IPath iPath = JavaClasspathHandler.getEclipseBasedPath((IPath)new Path(string));
        if (iPath == null) {
            this.txtJarLocation.setText(string);
        } else {
            this.txtJarLocation.setText(iPath.toPortableString());
        }
        this.txtJarLocation.addModifyListener(this.textModListener);
        this.btnBrowse = new Button(this.twoColPanel, 8);
        this.btnBrowse.setText(Messages.getString((String)"DMSClassBrowseButton"));
        this.btnBrowse.addListener(13, this.buttonListen);
        this.setJarMessages();
        this.panel.addPaintListener(this.bigListen);
        this.setControl((Control)this.panel);
        this.building = false;
        Dialog.applyDialogFont((Control)composite);
    }

    private void fillPackageList() {
        this.checkSelection();
        this.mList = null;
        this.packageList.removeAll();
        try {
            this.mList = this.getPackages();
            if (this.mList != null) {
                for (IPackageFragment iPackageFragment : this.mList) {
                    if (iPackageFragment.getElementName().trim().length() <= 0) continue;
                    this.packageList.add(iPackageFragment.getElementName().trim());
                    if (this.selectFrag == null || !this.selectFrag.getElementName().equals(iPackageFragment.getElementName())) continue;
                    this.packageList.select(this.packageList.getItemCount() - 1);
                }
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)"Unisys Internal Error");
            OS2200CorePlugin.logger.info((Object)("error filling up with plugins:  " + exception.getMessage()));
        }
        if (this.selectFrag == null && this.packageList.getItemCount() > 0) {
            this.packageList.select(0);
        } else {
            this.setPageComplete(false);
        }
    }

    void checkSelection() {
        this.selectFrag = null;
        if (this.select.getFirstElement() instanceof IPackageFragment) {
            this.selectFrag = (IPackageFragment)this.select.getFirstElement();
        }
    }

    ArrayList<IPackageFragment> getPackages() {
        try {
            ArrayList<IPackageFragment> arrayList = new ArrayList<IPackageFragment>();
            IFolder iFolder = JavaClasspathHandler.findSourceFolder(this.jProj);
            IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)JavaCore.create((IFolder)iFolder);
            if (iFolder != null) {
                IJavaElement[] iJavaElementArray = iPackageFragmentRoot.getChildren();
                int n = 0;
                while (n < iJavaElementArray.length) {
                    if (iJavaElementArray[n] instanceof IPackageFragment && iJavaElementArray[n].getElementName().trim().length() > 0) {
                        arrayList.add((IPackageFragment)iJavaElementArray[n]);
                    }
                    ++n;
                }
                return arrayList;
            }
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public IProject getTheProj() {
        return this.theProj;
    }

    public String getClassName() {
        return this.txtClassName.getText();
    }

    public String getJarLocation() {
        return this.txtJarLocation.getText();
    }

    public IPackageFragment getOrMakePackageFragment() {
        IPackageFragment iPackageFragment = this.getPackageFragment();
        try {
            String string;
            if (iPackageFragment == null && (string = this.packageList.getText()) != null && string.trim().length() > 0) {
                IFolder iFolder = JavaClasspathHandler.findSourceFolder(this.jProj);
                String string2 = String.valueOf(string.replace(".", "/")) + "/";
                IPath iPath = iFolder.getFullPath();
                IPath iPath2 = iPath.append(string2);
                ProjectFileHandler.AddNewPackage(this.theProj, iPath2);
                iPackageFragment = this.jProj.findPackageFragment(iPath2);
                if (iPackageFragment == null) {
                    OS2200CorePlugin.logger.error((Object)NLS.bind((String)Messages.getString((String)"PackageCreateError"), (Object)iPath2.toString()));
                }
            }
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)"Unisys Internal Error");
            OS2200CorePlugin.logger.info((Object)("error filling up with plugins:  " + coreException.getMessage()));
        }
        return iPackageFragment;
    }

    public IPackageFragment getPackageFragment() {
        int n = this.packageList.getSelectionIndex();
        IPackageFragment iPackageFragment = null;
        if (n > -1) {
            iPackageFragment = this.mList.get(this.packageList.getSelectionIndex());
        }
        return iPackageFragment;
    }

    void setJarMessages() {
        switch (this.typeName) {
            case 1: {
                this.lblJarLocation.setText(Messages.getString((String)"PackageListPage_5"));
                this.noJarMessage = Messages.getString((String)"PackageListPage_6");
                this.wrongJarMessage = Messages.getString((String)"PackageListPage_7");
                this.noExistJarMessage = Messages.getString((String)"PackageListPage_8");
                break;
            }
            case 2: {
                this.lblJarLocation.setText(Messages.getString((String)"PackageListPage_9"));
                this.noJarMessage = Messages.getString((String)"PackageListPage_10");
                this.wrongJarMessage = Messages.getString((String)"PackageListPage_11");
                this.noExistJarMessage = Messages.getString((String)"PackageListPage_12");
            }
        }
    }
}

