/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.jai.core.wizards;

import com.unisys.jai.core.JAICorePlugin;
import com.unisys.jai.core.JavaClasspathHandler;
import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.j2ee.ejb.annotation.ui.internal.wizards.AddEjbWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class BeanListPage
extends WizardPage {
    CoreException exCE;
    IStructuredSelection selection;
    Composite panel;
    Label lblBeanList;
    List beanList;
    Label lblJarLocation;
    Text txtJarLocation;
    Button btnBrowse;
    Properties projProps;
    String subtype = "";
    Text targetLinkName;
    Button newBut;
    Font font;
    IProject theProj;
    Composite theParent;
    IStructuredSelection select;
    String noJarMessage;
    String wrongJarMessage;
    String noExistJarMessage;
    boolean building = false;
    int typeName;
    public String raDescription;
    public String raTitle;
    public ArrayList<IFile> mList;
    public ArrayList<IFile> omList;
    public SelectionListener beanSelListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            Combo combo = (Combo)selectionEvent.item;
            int n = combo.getSelectionIndex();
            combo.setData("Selection", (Object)n);
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };
    ModifyListener textModListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            BeanListPage.this.setPageComplete(BeanListPage.this.checkJarPath());
        }
    };
    Listener buttonListen = new Listener(){

        public void handleEvent(Event event) {
            FileDialog fileDialog = new FileDialog(BeanListPage.this.panel.getShell(), 4096);
            String string = fileDialog.open();
            if (string != null) {
                BeanListPage.this.txtJarLocation.setText(string);
            }
        }
    };
    private PaintListener panelPaintListener = new PaintListener(){

        public void paintControl(PaintEvent paintEvent) {
            BeanListPage.this.setListSize();
        }
    };
    private Listener newButListener = new Listener(){

        public void handleEvent(Event event) {
            try {
                Widget widget = event.widget;
                if (widget.equals(BeanListPage.this.newBut)) {
                    BeanListPage.this.omList = BeanListPage.this.mList;
                    BeanListPage.this.beanList.setEnabled(false);
                    BeanListPage.this.newBut.setEnabled(false);
                    AddEjbWizard addEjbWizard = new AddEjbWizard();
                    addEjbWizard.init(PlatformUI.getWorkbench(), BeanListPage.this.select);
                    WizardDialog wizardDialog = new WizardDialog(BeanListPage.this.theParent.getShell(), (IWizard)addEjbWizard);
                    wizardDialog.create();
                    wizardDialog.open();
                    if (!BeanListPage.this.building) {
                        BeanListPage.this.building = true;
                        BeanListPage.this.panel.redraw();
                        BeanListPage.this.exCE = null;
                        final IProject iProject = BeanListPage.this.theProj;
                        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                            public void run(IProgressMonitor iProgressMonitor) {
                                try {
                                    iProject.refreshLocal(2, iProgressMonitor);
                                    iProject.build(15, iProgressMonitor);
                                    iProject.build(6, iProgressMonitor);
                                    iProject.refreshLocal(2, iProgressMonitor);
                                }
                                catch (CoreException coreException) {
                                    (this).BeanListPage.this.exCE = coreException;
                                }
                            }
                        };
                        BeanListPage.this.getContainer().run(true, false, iRunnableWithProgress);
                        BeanListPage.this.fillBeanList();
                        BeanListPage.this.selectNewest();
                        BeanListPage.this.building = false;
                        BeanListPage.this.beanList.setEnabled(true);
                        BeanListPage.this.newBut.setEnabled(true);
                        BeanListPage.this.panel.redraw();
                        BeanListPage.this.setPageComplete(BeanListPage.this.isPageComplete());
                    }
                }
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.equals("Bad eclipse");
                OS2200CorePlugin.logger.info((Object)"error building project in bean list");
            }
        }
    };

    public BeanListPage(IProject iProject, IStructuredSelection iStructuredSelection, int n) {
        super("BeanList");
        this.theProj = iProject;
        this.select = iStructuredSelection;
        this.typeName = n;
    }

    boolean checkJarPath() {
        block9: {
            IPath iPath;
            block10: {
                Path path;
                block8: {
                    String string;
                    block7: {
                        if (this.txtJarLocation.getText().trim().length() <= 0) {
                            this.setErrorMessage(this.noJarMessage);
                            return false;
                        }
                        try {
                            string = this.txtJarLocation.getText();
                            path = new Path(string);
                            String string2 = path.lastSegment().toLowerCase();
                            if (string2.equals(this.getRightJarName())) break block7;
                            this.setErrorMessage(this.wrongJarMessage);
                            return false;
                        }
                        catch (Exception exception) {
                            this.setErrorMessage(this.noExistJarMessage);
                            OS2200CorePlugin.logger.debug((Object)"exception checking Jar Path", (Throwable)exception);
                            return false;
                        }
                    }
                    boolean bl = path.isAbsolute();
                    if (!bl) break block8;
                    File file = new File(string);
                    if (!file.exists()) {
                        this.setErrorMessage(this.noExistJarMessage);
                        return false;
                    }
                    break block9;
                }
                String string = path.segment(0);
                iPath = JavaCore.getClasspathVariable((String)string);
                if (iPath != null) break block10;
                this.setErrorMessage(this.wrongJarMessage);
                return false;
            }
            File file = new File(iPath.toPortableString());
            if (file.exists()) break block9;
            this.setErrorMessage(this.noExistJarMessage);
            return false;
        }
        return true;
    }

    String getRightJarName() {
        switch (this.typeName) {
            case 1: {
                return "bisra.jar";
            }
            case 2: {
                return "dmsra.jar";
            }
        }
        return "";
    }

    public void setListSize() {
        Rectangle rectangle = this.beanList.getBounds();
        rectangle.height = this.beanList.getItemHeight() * this.beanList.getItemCount() + 5;
        this.beanList.setBounds(rectangle);
    }

    private void setHelp(Composite composite) {
        String string = "identify_bis_bean_wtp";
        if (this.typeName == 2) {
            string = "identify_dms_bean_wtp";
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.unisys.jai.core." + string);
    }

    public void createControl(Composite composite) {
        this.theParent = composite;
        this.panel = new Composite(composite, 2048);
        this.setHelp(this.panel);
        GridLayout gridLayout = new GridLayout();
        this.setTitle(this.raTitle);
        this.setDescription(this.raDescription);
        this.panel.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 2;
        this.panel.addPaintListener(this.panelPaintListener);
        this.lblBeanList = new Label(this.panel, 0);
        this.lblBeanList.setText(Messages.getString((String)"EJBListLabel"));
        Label label = new Label(this.panel, 0);
        label.setText("");
        this.beanList = new List(this.panel, 2628);
        this.fillBeanList();
        this.newBut = new Button(this.panel, 8);
        this.newBut.setText(Messages.getString((String)"EJBNewButton"));
        this.newBut.addListener(13, this.newButListener);
        new Label(this.panel, 0);
        new Label(this.panel, 0);
        this.lblJarLocation = new Label(this.panel, 0);
        new Label(this.panel, 0);
        this.txtJarLocation = new Text(this.panel, 2048);
        String string = JAICorePlugin.pluginPath(this.getRightJarName());
        IPath iPath = JavaClasspathHandler.getEclipseBasedPath((IPath)new Path(string));
        if (iPath == null) {
            this.txtJarLocation.setText(string);
        } else {
            this.txtJarLocation.setText(iPath.toPortableString());
        }
        this.txtJarLocation.addModifyListener(this.textModListener);
        this.btnBrowse = new Button(this.panel, 8);
        this.btnBrowse.setText(Messages.getString((String)"DMSClassBrowseButton"));
        this.btnBrowse.addListener(13, this.buttonListen);
        this.setJarMessages();
        this.setControl((Control)this.panel);
        this.building = false;
        Dialog.applyDialogFont((Control)composite);
    }

    public String getBeanName() {
        String string = this.beanList.getItem(this.beanList.getSelectionIndex());
        return string;
    }

    public boolean isPageComplete() {
        return this.beanList.getItemCount() != 0 || !this.checkJarPath();
    }

    public void selectNewest() {
        int n = 0;
        while (n < this.mList.size()) {
            boolean bl = true;
            IFile iFile = this.mList.get(n);
            for (IFile iFile2 : this.omList) {
                if (!this.getFullName(iFile).equals(this.getFullName(iFile2))) continue;
                bl = false;
            }
            if (bl) {
                this.beanList.select(n);
            }
            ++n;
        }
    }

    String getFullName(IFile iFile) {
        ICompilationUnit iCompilationUnit = (ICompilationUnit)JavaCore.create((IFile)iFile);
        String string = iFile.getName();
        String string2 = string.substring(0, string.indexOf("."));
        IType iType = iCompilationUnit.getType(string2);
        return iType.getFullyQualifiedName();
    }

    private void fillBeanList() {
        this.mList = null;
        this.mList = JavaClasspathHandler.findFilesEndingInProject(this.theProj, "bean.java");
        this.beanList.removeAll();
        for (IFile iFile : this.mList) {
            this.beanList.add(this.getFullName(iFile));
        }
        if (this.beanList.getItemCount() > 0) {
            this.beanList.select(0);
        } else {
            this.setPageComplete(false);
        }
    }

    public IProject getTheProj() {
        return this.theProj;
    }

    public IFile getBeanFile() {
        if (this.beanList.getItemCount() < 1) {
            return null;
        }
        if (this.beanList.getSelectionIndex() < 0) {
            return null;
        }
        IFile iFile = this.mList.get(this.beanList.getSelectionIndex());
        return iFile;
    }

    void setJarMessages() {
        switch (this.typeName) {
            case 1: {
                this.lblJarLocation.setText(Messages.getString((String)"PackageListPage_5"));
                this.noJarMessage = Messages.getString((String)"PackageListPage_6");
                this.wrongJarMessage = Messages.getString((String)"PackageListPage_7");
                this.noExistJarMessage = Messages.getString((String)"PackageListPage_8");
                break;
            }
            case 2: {
                this.lblJarLocation.setText(Messages.getString((String)"PackageListPage_9"));
                this.noJarMessage = Messages.getString((String)"PackageListPage_10");
                this.wrongJarMessage = Messages.getString((String)"PackageListPage_11");
                this.noExistJarMessage = Messages.getString((String)"PackageListPage_12");
            }
        }
    }

    String getJarLocation() {
        return this.txtJarLocation.getText().trim();
    }
}

