/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.jai.core;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Messager;
import com.unisys.jai.core.AnnotationSpec;
import com.unisys.jai.core.JAIAnnotationProcessor;
import com.unisys.jai.core.LIBProcessor;
import com.unisys.jai.core.TIP;
import com.unisys.jai.core.Transaction;
import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import java.util.ArrayList;
import java.util.Map;

public class TIPProcessor
extends JAIAnnotationProcessor {
    static final String host = "host";
    static final String port = "port";
    static final String classname = "classname";
    static final String transactions = "transactions";
    static final String factory = "factory";
    static final String connClassName = "connClassName";
    static final String transName = "name";
    static final String transView = "view";
    static final String OS2200Path = "OS2200Path";
    static final String J2EEPath = "J2EEPath";
    static final String los2200 = "os2200.jar";
    static final String lj2ee = "j2ee.jar";
    static final String hostTemp = "%ipAdd";
    static final String portTemp = "%port";
    static final String connClassTemp = "%connClassName";
    static final String factoryTemp = "%factory";
    static final String transTemp = "%transName";
    static final String transClassTemp = "%transClassName";
    static final String viewTemp = "%viewName";
    static final String connectionTempFileFactory = "ConnBaseFactory.txt";
    static final String connectionTempFileNoFactory = "ConnBaseNoFactory.txt";
    static final String transTempFile = "TransBase.txt";
    static final String connectionTypePrefix = "Conn";
    static final String transTypePrefix = "Trans";

    public TIPProcessor(AnnotationProcessorEnvironment annotationProcessorEnvironment) {
        super(annotationProcessorEnvironment);
        this.rootClass = TIP.class;
    }

    @Override
    public boolean checkForErrors(AnnotationSpec annotationSpec, ArrayList<JAIAnnotationProcessor> arrayList) {
        Object object;
        Object object2;
        ArrayList arrayList2;
        int n;
        String string;
        boolean bl = true;
        Messager messager = this._env.getMessager();
        String string2 = annotationSpec.getStringValue(host);
        if (string2 == null || string2.equals("")) {
            string = Messages.getString((String)"TIPProcessor_1");
            messager.printError(annotationSpec.getSourcePosition(host), string);
            bl = false;
        } else if (!TIPProcessor.checkConnBadChars(string2)) {
            string = Messages.getString((String)"TIPProcessor_5");
            messager.printError(annotationSpec.getSourcePosition(host), string);
            bl = false;
        }
        string = annotationSpec.getStringValue(classname);
        if (!TIPProcessor.checkClassBadChars(string)) {
            String string3 = Messages.getString((String)"TIPProcessor_7");
            messager.printError(annotationSpec.getSourcePosition(classname), string3);
            bl = false;
        }
        if ((n = annotationSpec.getIntValue(port)) < 0) {
            messager.printError(annotationSpec.getSourcePosition(port), Messages.getString((String)"TIPProcessor_2"));
            bl = false;
        }
        if ((arrayList2 = annotationSpec.getArrayListValue(transactions)) == null || arrayList2.size() <= 0) {
            object2 = Messages.getString((String)"TIPProcessor_3");
            messager.printError(annotationSpec.specSrcPos, (String)object2);
            bl = false;
        } else {
            boolean bl2 = this.checkTheTransactions(annotationSpec);
            bl = bl && bl2;
        }
        object2 = arrayList.iterator();
        LIBProcessor lIBProcessor = null;
        while (object2.hasNext()) {
            object = (JAIAnnotationProcessor)object2.next();
            if (!(object instanceof LIBProcessor)) continue;
            lIBProcessor = (LIBProcessor)object;
            break;
        }
        if (lIBProcessor.myRoots.size() == 0) {
            object = Messages.getString((String)"NoLibSpec");
            messager.printError(annotationSpec.specSrcPos, (String)object);
            return false;
        }
        boolean bl3 = lIBProcessor.checkTheLib(OS2200Path, los2200, annotationSpec.specSrcPos);
        bl = bl && bl3;
        bl3 = lIBProcessor.checkTheLib(J2EEPath, lj2ee, annotationSpec.specSrcPos);
        bl = bl && bl3;
        return bl;
    }

    public boolean checkTheTransactions(AnnotationSpec annotationSpec) {
        OS2200CorePlugin.logger.debug((Object)"Entering checkTheTransactions");
        boolean bl = true;
        ArrayList arrayList = annotationSpec.getArrayListValue(transactions);
        for (AnnotationSpec annotationSpec2 : arrayList) {
            String string;
            String string2;
            String string3 = annotationSpec2.getStringValue(transName);
            if (string3 == null || string3.trim().equals("")) {
                string2 = Messages.getString((String)"TIPProcessor_4");
                this._msgr.printError(annotationSpec2.getSourcePosition(transName), string2);
                bl = false;
            } else if (!TIPProcessor.checkTransBadChars(string3)) {
                string2 = Messages.getString((String)"TIPProcessor_6");
                this._msgr.printError(annotationSpec2.getSourcePosition(transName), string2);
                bl = false;
            }
            string2 = annotationSpec2.getStringValue(transView);
            if (string2 == null) {
                annotationSpec2.setValue(transView, "");
            } else if (!TIPProcessor.checkClassBadChars(string2)) {
                string = Messages.getString((String)"TIPProcessor_8");
                this._msgr.printError(annotationSpec2.getSourcePosition(transView), string);
                bl = false;
            }
            string = annotationSpec2.getStringValue(classname);
            if (TIPProcessor.checkClassBadChars(string)) continue;
            String string4 = Messages.getString((String)"TIPProcessor_7");
            this._msgr.printError(annotationSpec2.getSourcePosition(classname), string4);
            bl = false;
        }
        return bl;
    }

    @Override
    public AnnotationSpec annoteSpecMaker(String string) {
        AnnotationSpec annotationSpec = null;
        if (string.equals("Transaction")) {
            annotationSpec = new AnnotationSpec("Transaction", false, "TIP", Transaction.class);
            annotationSpec.addSpecEntry(transName, String.class.getSimpleName(), String.class, transTemp);
            annotationSpec.addSpecEntry(transView, String.class.getSimpleName(), String.class, viewTemp);
            annotationSpec.addSpecEntry(classname, String.class.getSimpleName(), String.class, transClassTemp);
            annotationSpec.addSpecEntry(connClassName, String.class.getSimpleName(), String.class, connClassTemp);
        }
        return annotationSpec;
    }

    public static boolean checkConnBadChars(String string) {
        char[] cArray = string.toCharArray();
        boolean bl = true;
        int n = 0;
        while (n < cArray.length) {
            if (!Character.isLetterOrDigit(cArray[n]) && cArray[n] != '-' && cArray[n] != '.') {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    public static boolean checkTransBadChars(String string) {
        char[] cArray = string.toCharArray();
        boolean bl = true;
        int n = 0;
        while (n < cArray.length) {
            if (!Character.isLetterOrDigit(cArray[n]) && cArray[n] != '-') {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    public static boolean checkClassBadChars(String string) {
        if (string == null) {
            return true;
        }
        char[] cArray = string.toCharArray();
        boolean bl = true;
        int n = 0;
        while (n < cArray.length) {
            if (!Character.isLetterOrDigit(cArray[n]) && cArray[n] != '_') {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    @Override
    public AnnotationSpec makeRoot() {
        OS2200CorePlugin.logger.debug((Object)"entering make Root");
        AnnotationSpec annotationSpec = new AnnotationSpec("TIP", true, "TIP", TIP.class);
        annotationSpec.addSpecEntry(host, String.class.getSimpleName(), String.class, hostTemp);
        annotationSpec.addSpecEntry(port, Integer.class.getSimpleName(), Integer.class, portTemp);
        annotationSpec.addSpecEntry(classname, String.class.getSimpleName(), String.class, connClassTemp);
        annotationSpec.addSpecEntry(factory, String.class.getSimpleName(), String.class, factoryTemp);
        annotationSpec.addSpecEntry(transactions, ArrayList.class.getSimpleName(), ArrayList.class, "");
        annotationSpec.addSpecEntry("stuffer", ArrayList.class.getSimpleName(), ArrayList.class, "");
        return annotationSpec;
    }

    @Override
    public void doTheWork() {
        OS2200CorePlugin.logger.debug((Object)"Entering doTheWork");
        for (AnnotationSpec annotationSpec : this.myRoots) {
            String string = annotationSpec.getStringValue(classname);
            if (string != null) {
                OS2200CorePlugin.logger.debug((Object)("classname " + string));
            } else {
                OS2200CorePlugin.logger.debug((Object)"classname is null");
            }
            if (string == null) {
                string = connectionTypePrefix + annotationSpec.getStringValue(host) + annotationSpec.getIntValue(port);
                string = string.replace(".", "_");
                string = string.replace("-", "_");
            }
            if (string.equals("")) {
                string = connectionTypePrefix + annotationSpec.getStringValue(host) + annotationSpec.getIntValue(port);
                string = string.replace(".", "_");
                string = string.replace("-", "_");
            }
            OS2200CorePlugin.logger.debug((Object)("final class name " + string));
            annotationSpec.setValue(classname, string);
            Map<String, String> map = this.buildTempList(annotationSpec);
            String string2 = connectionTempFileFactory;
            if (annotationSpec.getStringValue(factory) == null) {
                string2 = connectionTempFileNoFactory;
            }
            String string3 = "doing build \n" + string + "\n" + map;
            OS2200CorePlugin.logger.debug((Object)string3);
            this.buildCode(string2, string, map);
            ArrayList arrayList = annotationSpec.getArrayListValue(transactions);
            for (AnnotationSpec annotationSpec2 : arrayList) {
                annotationSpec2.setValue(connClassName, string);
                String string4 = annotationSpec2.getStringValue(classname);
                if (string4 == null || string4.equals("")) {
                    string4 = transTypePrefix + annotationSpec2.getStringValue(transName);
                    string4 = string4.replace("-", "_");
                }
                annotationSpec2.setValue(classname, string4);
                Map<String, String> map2 = this.buildTempList(annotationSpec2);
                this.buildCode(transTempFile, string4, map2);
            }
        }
    }
}

