/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.jai.core;

import com.unisys.tde.core.OS2200CorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.osgi.framework.Bundle;

public class RAAction
extends Action {
    private static final String ATT_CLASS = "class";
    private static final String ATT_ICON = "icon";
    private static final String TAG_DESCRIPTION = "description";
    private IConfigurationElement fConfigurationElement;
    private Shell fShell;
    private String myId;
    IStructuredSelection fSelection;

    public RAAction(IConfigurationElement iConfigurationElement) {
        this.fConfigurationElement = iConfigurationElement;
        String string = iConfigurationElement.getAttribute("label");
        this.myId = iConfigurationElement.getAttribute("id");
        this.setId(this.myId);
        this.setText(string);
        String string2 = this.getDescriptionFromConfig(this.fConfigurationElement);
        this.setDescription(string2);
        this.setToolTipText(string2);
        this.setImageDescriptor(this.getIconFromConfig(this.fConfigurationElement));
    }

    public String getID() {
        return this.myId;
    }

    private String getDescriptionFromConfig(IConfigurationElement iConfigurationElement) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren(TAG_DESCRIPTION);
        if (iConfigurationElementArray.length >= 1) {
            return iConfigurationElementArray[0].getValue();
        }
        return "";
    }

    private ImageDescriptor getIconFromConfig(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute(ATT_ICON);
        if (string != null) {
            Bundle bundle = Platform.getBundle((String)iConfigurationElement.getContributor().getName());
            return JavaPluginImages.createImageDescriptor((Bundle)bundle, (IPath)new Path(string), (boolean)true);
        }
        return null;
    }

    public void run() {
        Shell shell = this.getShell();
        try {
            Object object = this.fConfigurationElement.createExecutableExtension(ATT_CLASS);
            IWorkbenchWindowActionDelegate iWorkbenchWindowActionDelegate = (IWorkbenchWindowActionDelegate)object;
            iWorkbenchWindowActionDelegate.run((IAction)this);
        }
        catch (CoreException coreException) {
            String string = NewWizardMessages.AbstractOpenWizardAction_createerror_title;
            String string2 = NewWizardMessages.AbstractOpenWizardAction_createerror_message;
            ExceptionHandler.handle((CoreException)coreException, (Shell)shell, (String)string, (String)string2);
        }
    }

    protected Shell getShell() {
        if (this.fShell == null) {
            return JavaPlugin.getActiveWorkbenchShell();
        }
        return this.fShell;
    }

    public void setShell(Shell shell) {
        this.fShell = shell;
    }

    protected IStructuredSelection getSelection() {
        if (this.fSelection == null) {
            return this.evaluateCurrentSelection();
        }
        return this.fSelection;
    }

    private IStructuredSelection evaluateCurrentSelection() {
        ISelection iSelection;
        IWorkbenchWindow iWorkbenchWindow = JavaPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iSelection = iWorkbenchWindow.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)iSelection;
        }
        return StructuredSelection.EMPTY;
    }

    public IProject getProj() {
        IStructuredSelection iStructuredSelection = this.getSelection();
        IProject iProject = null;
        try {
            if (iStructuredSelection != null && !iStructuredSelection.isEmpty() && iStructuredSelection instanceof StructuredSelection) {
                IPackageFragment iPackageFragment;
                StructuredSelection structuredSelection = (StructuredSelection)iStructuredSelection;
                if (structuredSelection.getFirstElement() instanceof IPackageFragment) {
                    iPackageFragment = (IPackageFragment)iStructuredSelection.getFirstElement();
                    IJavaProject iJavaProject = iPackageFragment.getJavaProject();
                    iProject = iJavaProject.getProject();
                }
                if (structuredSelection.getFirstElement() instanceof IJavaProject) {
                    iPackageFragment = (IJavaProject)structuredSelection.getFirstElement();
                    iProject = iPackageFragment.getProject();
                }
                if (structuredSelection.getFirstElement() instanceof IProject && (iPackageFragment = (IProject)structuredSelection.getFirstElement()) != null && iPackageFragment.isOpen() && iPackageFragment.getNature("org.eclipse.jdt.core.javanature") != null) {
                    iProject = iPackageFragment;
                }
            }
            return iProject;
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)"Unisys Internal Error", (Throwable)coreException);
            return null;
        }
        catch (Throwable throwable) {
            OS2200CorePlugin.logger.error((Object)"Unisys Internal Error", throwable);
            return null;
        }
    }
}

