/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.jai.core;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Messager;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.util.SourcePosition;
import com.unisys.jai.core.AnnotationSpec;
import com.unisys.jai.core.JAIAnnotationProcessor;
import com.unisys.jai.core.JavaClasspathHandler;
import com.unisys.jai.core.LIB;
import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;

public class LIBProcessor
extends JAIAnnotationProcessor {
    static final String OS2200Path = "OS2200Path";
    static final String J2EEPath = "J2EEPath";
    static final String los2200 = "os2200.jar";
    static final String lj2ee = "j2ee.jar";
    static final String BogusPath = "BogPath";
    static final String lboguspath = "bogpath.jar";

    public LIBProcessor(AnnotationProcessorEnvironment annotationProcessorEnvironment) {
        super(annotationProcessorEnvironment);
        this.rootClass = LIB.class;
    }

    public boolean checkTheLib(String string, String string2, SourcePosition sourcePosition) {
        boolean bl = true;
        if (this.myRoots.size() < 1) {
            this._msgr.printError(sourcePosition, Messages.getString((String)"NoLibSpec"));
            return false;
        }
        bl = bl && this.checkIsSet(string, string2);
        bl = bl && this.checkIsCorrect(string, string2);
        bl = bl && this.checkExists(string, string2);
        return bl;
    }

    public boolean checkIsSet(String string, String string2) {
        OS2200CorePlugin.logger.debug((Object)("checkIsSet: " + string + "," + string2));
        AnnotationSpec annotationSpec = (AnnotationSpec)this.myRoots.get(0);
        String string3 = ((AnnotationSpec)this.myRoots.get(0)).getStringValue(string);
        if (string3 == null || string3.equals("")) {
            String string4 = NLS.bind((String)Messages.getString((String)"NoPath"), (Object)string2);
            this._msgr.printError(annotationSpec.getSourcePosition(string), string4);
            return false;
        }
        return true;
    }

    public boolean checkIsCorrect(String string, String string2) {
        OS2200CorePlugin.logger.debug((Object)("checkIsCorrect: " + string + "," + string2));
        AnnotationSpec annotationSpec = (AnnotationSpec)this.myRoots.get(0);
        String string3 = annotationSpec.getStringValue(string);
        String string4 = string3.toLowerCase();
        if (!string4.endsWith(string2.toLowerCase())) {
            String string5 = NLS.bind((String)Messages.getString((String)"PathNotRight"), (Object)string, (Object)string2);
            this._msgr.printError(annotationSpec.getSourcePosition(string), string5);
            return false;
        }
        return true;
    }

    public boolean checkExists(String string, String string2) {
        OS2200CorePlugin.logger.debug((Object)("checkExists: " + string + "," + string2));
        AnnotationSpec annotationSpec = (AnnotationSpec)this.myRoots.get(0);
        String string3 = ((AnnotationSpec)this.myRoots.get(0)).getStringValue(string);
        File file = new File(string3);
        if (!file.exists()) {
            String string4 = NLS.bind((String)Messages.getString((String)"PathNotThere"), (Object)string2);
            this._msgr.printError(annotationSpec.getSourcePosition(string), string4);
            return false;
        }
        return true;
    }

    @Override
    public boolean checkForErrorsLoop(ArrayList<JAIAnnotationProcessor> arrayList) {
        Messager messager = this._env.getMessager();
        boolean bl = true;
        if (this.myRoots.size() > 1) {
            for (AnnotationSpec annotationSpec : this.myRoots) {
                String string = Messages.getString((String)"MoreThanOneLib");
                messager.printError(annotationSpec.specSrcPos, string);
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public AnnotationSpec makeRoot() {
        AnnotationSpec annotationSpec = new AnnotationSpec("LIB", true, "LIB", LIB.class);
        annotationSpec.addSpecEntry(OS2200Path, String.class.getSimpleName(), String.class, "");
        annotationSpec.addSpecEntry(J2EEPath, String.class.getSimpleName(), String.class, "");
        annotationSpec.addSpecEntry(BogusPath, String.class.getSimpleName(), String.class, "");
        return annotationSpec;
    }

    @Override
    public void doTheWork() {
        OS2200CorePlugin.logger.debug((Object)"LIBProcessor doTheWork");
        if (this.myRoots.size() > 0) {
            AnnotationSpec annotationSpec = (AnnotationSpec)this.myRoots.get(0);
            String string = annotationSpec.getStringValue(OS2200Path);
            String string2 = annotationSpec.getStringValue(J2EEPath);
            String string3 = annotationSpec.getStringValue(BogusPath);
            Declaration declaration = annotationSpec.classDecl;
            String string4 = annotationSpec.specSrcPos.file().getAbsolutePath();
            IProject iProject = JavaClasspathHandler.findProject(declaration);
            if (iProject != null) {
                IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
                IPath iPath = JavaClasspathHandler.findLibPathInClasspath(iJavaProject, los2200);
                if (!(string == null || iPath != null && iPath.toOSString().toLowerCase().equals(string.toLowerCase()))) {
                    JavaClasspathHandler.addLibToClasspath(string, iJavaProject, los2200);
                }
                IPath iPath2 = JavaClasspathHandler.findLibPathInClasspath(iJavaProject, lj2ee);
                if (!(string2 == null || iPath2 != null && iPath2.toOSString().toLowerCase().equals(string2.toLowerCase()))) {
                    JavaClasspathHandler.addLibToClasspath(string2, iJavaProject, lj2ee);
                }
                if (string3 != null) {
                    JavaClasspathHandler.addLibToClasspath(string3, iJavaProject, lboguspath);
                }
                OS2200CorePlugin.logger.debug((Object)"Lib:do the work; about to refresh");
                try {
                    iProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {
                    OS2200CorePlugin.logger.error((Object)"Unisys Internal Error", (Throwable)coreException);
                }
                OS2200CorePlugin.logger.debug((Object)"Lib:do the work; about to leave");
            } else {
                OS2200CorePlugin.logger.error((Object)NLS.bind((String)("The project for the annotated file," + string4 + " could not be found. Check the project settings."), (Object)string4));
            }
        }
    }
}

