/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.jai.core;

import com.sun.mirror.declaration.Declaration;
import com.unisys.jai.core.JAICorePlugin;
import com.unisys.tde.core.JREEntry;
import com.unisys.tde.core.JavaLevels;
import com.unisys.tde.core.OS2200CorePlugin;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.jres.JREsUpdater;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;

public class JavaClasspathHandler {
    public static final String standardType = "org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType";
    public static final String containerId = "org.eclipse.jdt.launching.JRE_CONTAINER";
    public static final String uJRE17 = "UNISYSJRE1.7";
    public static final String uJRE16 = "UNISYSJRE1.6";
    public static final String lvl17 = "1.7";
    public static final String lvl16 = "1.6";
    static final String deployable = ".deployables";

    public static void addSrcDirToClassPath(IJavaProject iJavaProject, String string, boolean bl) {
        OS2200CorePlugin.logger.debug((Object)("add src dir to class" + string));
        IProject iProject = iJavaProject.getProject();
        IPath iPath = iProject.getFullPath();
        IPath iPath2 = iPath.append(string);
        Hashtable<String, IClasspathEntry> hashtable = JavaClasspathHandler.getClassPathAsHash(iJavaProject);
        IClasspathEntry iClasspathEntry = hashtable.get(iPath2.toPortableString());
        if (iClasspathEntry == null) {
            IClasspathEntry iClasspathEntry2 = JavaCore.newSourceEntry((IPath)iPath2);
            hashtable.put(iPath2.toPortableString(), iClasspathEntry2);
            if (bl) {
                hashtable = JavaClasspathHandler.excludePath(hashtable, string, iPath);
            }
            JavaClasspathHandler.putClasspathBack(hashtable, iJavaProject);
        }
    }

    public static Hashtable<String, IClasspathEntry> excludePath(Hashtable<String, IClasspathEntry> hashtable, String string, IPath iPath) {
        Collection<IClasspathEntry> collection = hashtable.values();
        IClasspathEntry iPathArray = null;
        for (IClasspathEntry iPathArray2 : collection) {
            if (!iPathArray2.getPath().equals((Object)iPath) || iPathArray2.getEntryKind() != 3) continue;
            iPathArray = iPathArray2;
        }
        if (iPathArray != null) {
            IPath[] iPathArray2;
            if (!string.endsWith("/")) {
                string = String.valueOf(string) + "/";
            }
            if ((iPathArray2 = iPathArray.getExclusionPatterns()).length > 0) {
                int n = 0;
                while (n < iPathArray2.length) {
                    if (iPathArray2[n].toString().endsWith(string)) {
                        return hashtable;
                    }
                    ++n;
                }
            }
            IPath[] iPathArray3 = new IPath[iPathArray2.length + 1];
            if (iPathArray2.length > 0) {
                int iPathArray4 = 0;
                while (iPathArray4 < iPathArray2.length) {
                    iPathArray3[iPathArray4] = iPathArray2[iPathArray4];
                    ++iPathArray4;
                }
            }
            iPathArray3[iPathArray2.length] = new Path(string);
            IPath[] iPathArray4 = iPathArray.getInclusionPatterns();
            IPath iPath2 = iPathArray.getOutputLocation();
            IPath iPath3 = iPathArray.getPath();
            IClasspathEntry iClasspathEntry = JavaCore.newSourceEntry((IPath)iPath3, (IPath[])iPathArray4, (IPath[])iPathArray3, (IPath)iPath2);
            hashtable.remove(iPath3.toPortableString());
            hashtable.put(iPath3.toPortableString(), iClasspathEntry);
        }
        return hashtable;
    }

    public static boolean hasRootlessSrc(IJavaProject iJavaProject) {
        OS2200CorePlugin.logger.debug((Object)"");
        IPath iPath = iJavaProject.getPath();
        Hashtable<String, IClasspathEntry> hashtable = JavaClasspathHandler.getClassPathAsHash(iJavaProject);
        Collection<IClasspathEntry> collection = hashtable.values();
        for (IClasspathEntry iClasspathEntry : collection) {
            if (!iClasspathEntry.getPath().equals((Object)iPath) || iClasspathEntry.getEntryKind() != 3) continue;
            return true;
        }
        return false;
    }

    public static IFolder findSourceFolder(IJavaProject iJavaProject) {
        OS2200CorePlugin.logger.debug((Object)"");
        Hashtable<String, IClasspathEntry> hashtable = JavaClasspathHandler.getClassPathAsHash(iJavaProject);
        Collection<IClasspathEntry> collection = hashtable.values();
        for (IClasspathEntry iClasspathEntry : collection) {
            if (iClasspathEntry.getEntryKind() != 3) continue;
            IPath iPath = iClasspathEntry.getPath();
            IProject iProject = iJavaProject.getProject();
            iPath.makeRelative();
            IPath iPath2 = iPath.removeFirstSegments(1);
            iProject.getFolder(iPath2);
            IResource iResource = iProject.findMember(iPath2);
            IFolder iFolder = (IFolder)iResource;
            return iFolder;
        }
        return null;
    }

    public static void setGenCodeOutput(IJavaProject iJavaProject, String string) {
        Object object;
        OS2200CorePlugin.logger.debug((Object)("setGenCodeOutput " + string));
        String string2 = AptConfig.getGenSrcDir((IJavaProject)iJavaProject);
        IPath iPath = iJavaProject.getProject().getFullPath().append(string2);
        Hashtable<String, IClasspathEntry> hashtable = JavaClasspathHandler.getClassPathAsHash(iJavaProject);
        Collection<IClasspathEntry> collection = hashtable.values();
        Object object2 = null;
        for (IClasspathEntry iPathArray : collection) {
            object = iPathArray.getOutputLocation();
            if (object == null || object.toString().indexOf(string) < 0) continue;
            object2 = object;
            break;
        }
        if (object2 != null) {
            IPath[] iPathArray = new IPath[]{};
            IClasspathEntry iClasspathEntry = JavaCore.newSourceEntry((IPath)iPath, (IPath[])iPathArray, (IPath[])iPathArray, object2);
            object = JavaClasspathHandler.findLibInClasspath(iJavaProject, string2);
            if (object != "") {
                hashtable.remove(object);
            }
            hashtable.put(iPath.toPortableString(), iClasspathEntry);
            JavaClasspathHandler.putClasspathBack(hashtable, iJavaProject);
        }
    }

    public static void setGenCodeOutput(IJavaProject iJavaProject) {
        OS2200CorePlugin.logger.debug((Object)"setGenCodeOutput ");
        JavaClasspathHandler.setGenCodeOutput(iJavaProject, deployable);
    }

    public static void addJarToClasspath(IPath iPath, IJavaProject iJavaProject, String string) {
        OS2200CorePlugin.logger.debug((Object)"");
        if (iPath.isAbsolute()) {
            JavaClasspathHandler.addLibToClasspath(iPath.toPortableString(), iJavaProject, string);
        } else {
            JavaClasspathHandler.addVarToClasspath(iPath.toPortableString(), iJavaProject, string);
        }
    }

    public static IPath cvToAbs(IPath iPath) {
        IPath iPath2 = iPath.removeFirstSegments(1);
        String string = iPath.segment(0);
        IPath iPath3 = JavaCore.getClasspathVariable((String)string);
        if (iPath3 == null) {
            return null;
        }
        IPath iPath4 = iPath3.append(iPath2);
        return iPath4;
    }

    public static IPath getEclipseBasedPath(IPath iPath) {
        OS2200CorePlugin.logger.debug((Object)iPath.toPortableString());
        IPath iPath2 = JavaCore.getClasspathVariable((String)"ECLIPSE_HOME");
        OS2200CorePlugin.logger.debug((Object)("***** home Path" + iPath2.toPortableString()));
        int n = iPath2.matchingFirstSegments(iPath);
        OS2200CorePlugin.logger.debug((Object)("***** matching segs " + n));
        int n2 = iPath2.segmentCount();
        OS2200CorePlugin.logger.debug((Object)("***** home segs " + n2));
        if (n == n2) {
            IPath iPath3 = iPath.removeFirstSegments(n2);
            OS2200CorePlugin.logger.debug((Object)("***** trailing path " + iPath3.toPortableString()));
            IPath iPath4 = new Path("ECLIPSE_HOME").append(iPath3);
            OS2200CorePlugin.logger.debug((Object)("***** new home based path " + iPath4.toPortableString()));
            return iPath4;
        }
        return null;
    }

    public static void addPluginToClasspath(IJavaProject iJavaProject) {
        OS2200CorePlugin.logger.debug((Object)"addPlugintoClasspath ");
        String string = JAICorePlugin.pluginPath("JAICore.jar");
        JavaClasspathHandler.addPluginsJarToClasspath(iJavaProject, string, "JAICore.jar".toLowerCase());
    }

    public static void addPluginsJarToClasspath(IJavaProject iJavaProject, String string, String string2) {
        OS2200CorePlugin.logger.debug((Object)"addPlugintoClasspath ");
        Path path = new Path(string);
        IPath iPath = JavaCore.getClasspathVariable((String)"ECLIPSE_HOME");
        OS2200CorePlugin.logger.debug((Object)("***** home Path" + iPath.toPortableString()));
        int n = iPath.matchingFirstSegments((IPath)path);
        OS2200CorePlugin.logger.debug((Object)("***** matching segs " + n));
        int n2 = iPath.segmentCount();
        OS2200CorePlugin.logger.debug((Object)("***** home segs " + n2));
        if (n == n2) {
            IPath iPath2 = path.removeFirstSegments(n2);
            OS2200CorePlugin.logger.debug((Object)("***** trailing path " + iPath2.toPortableString()));
            IPath iPath3 = new Path("ECLIPSE_HOME").append(iPath2);
            OS2200CorePlugin.logger.debug((Object)("***** new home based path " + iPath3.toPortableString()));
            JavaClasspathHandler.addVarToClasspath(iPath3.toPortableString(), iJavaProject, string2);
        } else {
            JavaClasspathHandler.addLibToClasspath(string, iJavaProject, string2.toLowerCase());
        }
    }

    public static void addFileToProject(IProject iProject, String string) {
        try {
            OS2200CorePlugin.logger.debug((Object)("addFiletoProject " + string));
            IPath iPath = iProject.getLocation();
            IPath iPath2 = iPath.append(string);
            File file = new File(iPath2.toOSString());
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            InputStream inputStream = JAICorePlugin.getDefault().openStream((IPath)new Path(string));
            if (inputStream != null) {
                int n = inputStream.available();
                byte[] byArray = new byte[n];
                int n2 = inputStream.read(byArray);
                fileOutputStream.write(byArray, 0, n2);
                inputStream.close();
                fileOutputStream.flush();
                fileOutputStream.close();
            } else {
                OS2200CorePlugin.logger.info((Object)(String.valueOf(string) + " could not be made as stream"));
                OS2200CorePlugin.logger.error((Object)"Unisys Internal Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            OS2200CorePlugin.logger.info((Object)("error creating ra.xml \n" + fileNotFoundException.getMessage()));
            OS2200CorePlugin.logger.error((Object)"Unisys Internal Error");
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.info((Object)("error creating ra.xml \n" + iOException.getMessage()));
            OS2200CorePlugin.logger.error((Object)"Unisys Internal Error");
        }
    }

    public static Hashtable<String, IClasspathEntry> getClassPathAsHash(IJavaProject iJavaProject) {
        OS2200CorePlugin.logger.debug((Object)"");
        if (iJavaProject != null) {
            OS2200CorePlugin.logger.debug((Object)iJavaProject.getProject().getName());
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.readRawClasspath();
            if (iClasspathEntryArray == null) {
                OS2200CorePlugin.logger.debug((Object)"ces is null");
            }
            int n = iClasspathEntryArray.length;
            OS2200CorePlugin.logger.debug((Object)("ces is " + iClasspathEntryArray.length));
            Hashtable<String, IClasspathEntry> hashtable = new Hashtable<String, IClasspathEntry>();
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
                String string = iClasspathEntry.getPath().toPortableString();
                hashtable.put(string, iClasspathEntry);
                ++n2;
            }
            return hashtable;
        }
        OS2200CorePlugin.logger.debug((Object)"jProj is null");
        return new Hashtable<String, IClasspathEntry>();
    }

    public static ArrayList<IFile> findFilesEndingInProject(IProject iProject, String string) {
        try {
            String string2 = string.toLowerCase();
            ArrayList<IFile> arrayList = new ArrayList<IFile>();
            String string3 = iProject.getLocation().toOSString().toLowerCase();
            OS2200CorePlugin.logger.debug((Object)("findProject: prPath,resPath  " + string3 + "," + string2));
            IResource[] iResourceArray = iProject.members();
            int n = 0;
            while (n < iResourceArray.length) {
                if (iResourceArray[n] instanceof IFolder) {
                    IFolder iFolder = (IFolder)iResourceArray[n];
                    arrayList = JavaClasspathHandler.SearchFolderforFiles(string2, iFolder, arrayList);
                }
                ++n;
            }
            return arrayList;
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)"Unisys Internal Error", (Throwable)coreException);
            OS2200CorePlugin.logger.info((Object)"Exception looking for project ", (Throwable)coreException);
            return null;
        }
    }

    public static ArrayList<IFile> SearchFolderforFiles(String string, IFolder iFolder, ArrayList<IFile> arrayList) {
        try {
            OS2200CorePlugin.logger.debug((Object)iFolder.toString());
            IResource[] iResourceArray = iFolder.members();
            int n = 0;
            while (n < iResourceArray.length) {
                IFile iFile;
                String string2;
                if (iResourceArray[n] instanceof IFile && (string2 = (iFile = (IFile)iResourceArray[n]).getName()).toLowerCase().endsWith(string)) {
                    arrayList.add(iFile);
                }
                if (iResourceArray[n] instanceof IFolder) {
                    iFile = (IFolder)iResourceArray[n];
                    arrayList = JavaClasspathHandler.SearchFolderforFiles(string, (IFolder)iFile, arrayList);
                }
                ++n;
            }
            OS2200CorePlugin.logger.debug((Object)("not found for " + iFolder.toString()));
            return arrayList;
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.info((Object)"Exception searching folders ", (Throwable)coreException);
            return null;
        }
    }

    public static IProject findProject(Declaration declaration) {
        try {
            OS2200CorePlugin.logger.debug((Object)("doing find project with " + declaration.getSimpleName()));
            File file = declaration.getPosition().file();
            String string = file.getCanonicalPath().toLowerCase();
            OS2200CorePlugin.logger.debug((Object)("findProject: resPath  " + string));
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
            IResource[] iResourceArray = iWorkspaceRoot.members();
            int n = 0;
            while (n < iResourceArray.length) {
                IProject iProject = (IProject)iResourceArray[n];
                String string2 = iProject.getLocation().toOSString().toLowerCase();
                OS2200CorePlugin.logger.debug((Object)("findProject: prPath,resPath  " + string2 + "," + string));
                if (iProject.isOpen()) {
                    IResource[] iResourceArray2 = iProject.members();
                    int n2 = 0;
                    while (n2 < iResourceArray2.length) {
                        IFolder iFolder;
                        IFile iFile;
                        if (iResourceArray2[n2] instanceof IFolder && (iFile = JavaClasspathHandler.SearchFolder(string, iFolder = (IFolder)iResourceArray2[n2])) != null) {
                            return iFile.getProject();
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            return null;
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.error((Object)"Unisys Internal Error", (Throwable)iOException);
            OS2200CorePlugin.logger.info((Object)"Exception looking for project ", (Throwable)iOException);
            return null;
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)"Unisys Internal Error", (Throwable)coreException);
            OS2200CorePlugin.logger.info((Object)"Exception looking for project ", (Throwable)coreException);
            return null;
        }
    }

    public static IFile SearchFolder(String string, IFolder iFolder) {
        block6: {
            OS2200CorePlugin.logger.debug((Object)iFolder.toString());
            String string2 = iFolder.getFullPath().toOSString().toLowerCase();
            OS2200CorePlugin.logger.debug((Object)("find " + string2 + " in " + string));
            int n = string.indexOf(string2);
            if (n >= 0) break block6;
            OS2200CorePlugin.logger.debug((Object)"path not found");
            return null;
        }
        try {
            IResource[] iResourceArray = iFolder.members();
            int n = 0;
            while (n < iResourceArray.length) {
                IFile iFile;
                String string3;
                if (iResourceArray[n] instanceof IFile && (string3 = (iFile = (IFile)iResourceArray[n]).getLocation().toOSString()).equalsIgnoreCase(string)) {
                    return iFile;
                }
                if (iResourceArray[n] instanceof IFolder && (string3 = JavaClasspathHandler.SearchFolder(string, (IFolder)(iFile = (IFolder)iResourceArray[n]))) != null) {
                    return string3;
                }
                ++n;
            }
            OS2200CorePlugin.logger.debug((Object)("not found for " + iFolder.toString()));
            return null;
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.info((Object)"Exception searching folders ", (Throwable)coreException);
            return null;
        }
    }

    public static void addLibToClasspath(String string, IJavaProject iJavaProject, String string2) {
        String string32;
        OS2200CorePlugin.logger.debug((Object)("addLibToClasspath:  " + string + "," + string2));
        Path path = new Path(string);
        Hashtable<String, IClasspathEntry> hashtable = JavaClasspathHandler.getClassPathAsHash(iJavaProject);
        Set<String> set = hashtable.keySet();
        String string4 = null;
        for (String string32 : set) {
            if (!string32.toLowerCase().endsWith(string2.toLowerCase())) continue;
            string4 = string32;
            break;
        }
        if (string4 != null) {
            hashtable.remove(string4);
        }
        string32 = JavaCore.newLibraryEntry((IPath)path, null, null);
        hashtable.put(path.toPortableString(), (IClasspathEntry)string32);
        JavaClasspathHandler.putClasspathBack(hashtable, iJavaProject);
    }

    public static void addVarToClasspath(String string, IJavaProject iJavaProject, String string2) {
        String string32;
        OS2200CorePlugin.logger.debug((Object)("addLibToClasspath:  " + string + "," + string2));
        Path path = new Path(string);
        Hashtable<String, IClasspathEntry> hashtable = JavaClasspathHandler.getClassPathAsHash(iJavaProject);
        Set<String> set = hashtable.keySet();
        String string4 = null;
        for (String string32 : set) {
            if (!string32.toLowerCase().endsWith(string2.toLowerCase())) continue;
            string4 = string32;
            break;
        }
        if (string4 != null) {
            hashtable.remove(string4);
        }
        string32 = JavaCore.newVariableEntry((IPath)path, null, null);
        hashtable.put(path.toPortableString(), (IClasspathEntry)string32);
        JavaClasspathHandler.putClasspathBack(hashtable, iJavaProject);
    }

    public static IClasspathEntry findSrcInClasspath(IJavaProject iJavaProject, String string) {
        String string22;
        OS2200CorePlugin.logger.debug((Object)("source dir " + string));
        Hashtable<String, IClasspathEntry> hashtable = JavaClasspathHandler.getClassPathAsHash(iJavaProject);
        Set<String> set = hashtable.keySet();
        String string3 = "";
        for (String string22 : set) {
            if (!string22.toLowerCase().endsWith(string.toLowerCase())) continue;
            string3 = string22;
            break;
        }
        if (string3.equals("")) {
            return null;
        }
        string22 = hashtable.get(string3);
        int n = string22.getEntryKind();
        if (n == 3) {
            return string22;
        }
        return null;
    }

    public static String findLibInClasspath(IJavaProject iJavaProject, String string) {
        OS2200CorePlugin.logger.debug((Object)("findLibInClasspath: " + string));
        Hashtable<String, IClasspathEntry> hashtable = JavaClasspathHandler.getClassPathAsHash(iJavaProject);
        Set<String> set = hashtable.keySet();
        String string2 = "";
        for (String string3 : set) {
            if (!string3.toLowerCase().endsWith(string.toLowerCase())) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    public static IPath findLibPathInClasspath(IJavaProject iJavaProject, String string) {
        OS2200CorePlugin.logger.debug((Object)("findLibInClasspath: " + string));
        Hashtable<String, IClasspathEntry> hashtable = JavaClasspathHandler.getClassPathAsHash(iJavaProject);
        Set<String> set = hashtable.keySet();
        String string2 = "";
        IPath iPath = null;
        for (String string3 : set) {
            if (!string3.toLowerCase().endsWith(string.toLowerCase())) continue;
            string2 = string3;
            break;
        }
        if (!string2.equals("")) {
            iPath = hashtable.get(string2).getPath();
        }
        return iPath;
    }

    public static void dumpCP(IJavaProject iJavaProject) {
        JavaClasspathHandler.dumpCP(iJavaProject, " ");
    }

    public static void dumpCP(IJavaProject iJavaProject, String string) {
        try {
            System.out.println("\n" + string);
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
            int n = 0;
            while (n < iClasspathEntryArray.length) {
                String string2 = String.valueOf(iClasspathEntryArray[n].getPath().toPortableString()) + " ";
                if (iClasspathEntryArray[n].getOutputLocation() != null) {
                    string2 = String.valueOf(string2) + iClasspathEntryArray[n].getOutputLocation().toPortableString();
                }
                System.out.println(string2);
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public static void putClasspathBack(Hashtable<String, IClasspathEntry> hashtable, IJavaProject iJavaProject) {
        OS2200CorePlugin.logger.debug((Object)"putClasspathBack");
        try {
            IClasspathEntry[] iClasspathEntryArray = new IClasspathEntry[hashtable.size()];
            iClasspathEntryArray = hashtable.values().toArray(iClasspathEntryArray);
            iJavaProject.setRawClasspath(iClasspathEntryArray, (IProgressMonitor)new NullProgressMonitor());
            OS2200CorePlugin.logger.debug((Object)"Exit putClasspathBack");
        }
        catch (Throwable throwable) {
            OS2200CorePlugin.logger.error((Object)"Unisys Internal Error");
            OS2200CorePlugin.logger.info((Object)"error putting classpath back", throwable);
        }
    }

    public static void setJREs() {
        OS2200CorePlugin.logger.debug((Object)"setJREs");
        if (!JavaClasspathHandler.findJRE(uJRE17)) {
            JavaClasspathHandler.makeUJRE(lvl17, uJRE17);
        }
        if (!JavaClasspathHandler.findJRE(uJRE16)) {
            JavaClasspathHandler.makeUJRE(lvl16, uJRE16);
        }
    }

    public static void setJREClasspath(IJavaProject iJavaProject, String string) {
        String string22;
        OS2200CorePlugin.logger.debug((Object)("setJREClasspath " + string));
        Hashtable<String, IClasspathEntry> hashtable = JavaClasspathHandler.getClassPathAsHash(iJavaProject);
        Set<String> set = hashtable.keySet();
        String string3 = null;
        for (String string22 : set) {
            if (string22.indexOf(containerId) < 0) continue;
            string3 = string22;
            break;
        }
        string22 = new Path(containerId);
        if (string.trim().length() > 0) {
            string22 = string22.append(standardType);
            string22 = string22.append(string);
        }
        IClasspathEntry iClasspathEntry = JavaCore.newContainerEntry((IPath)string22);
        if (string3 != null) {
            hashtable.remove(string3);
        }
        hashtable.put(string22.toPortableString(), iClasspathEntry);
        JavaClasspathHandler.putClasspathBack(hashtable, iJavaProject);
    }

    public static boolean findJRE(String string) {
        IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
        int n = 0;
        while (n < iVMInstallTypeArray.length) {
            IVMInstallType iVMInstallType = iVMInstallTypeArray[n];
            String string2 = iVMInstallType.getId();
            if (string2.equals(standardType)) {
                IVMInstall iVMInstall = iVMInstallType.findVMInstallByName(string);
                return iVMInstall != null;
            }
            ++n;
        }
        return false;
    }

    public static void makeUJRE(String string, String string2) {
        IVMInstall iVMInstall;
        Object object;
        String string3;
        Object object2;
        Object object3 = new StandardVMType();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
        int n = 0;
        while (n < iVMInstallTypeArray.length) {
            object2 = iVMInstallTypeArray[n];
            string3 = object2.getId();
            if (string3.equals(standardType)) {
                object3 = object2;
                object = object2.getVMInstalls();
                int n2 = 0;
                while (n2 < ((IVMInstall[])object).length) {
                    iVMInstall = object[n2];
                    arrayList.add(new VMStandin(iVMInstall));
                    ++n2;
                }
            }
            ++n;
        }
        IVMInstall iVMInstall2 = JavaRuntime.getDefaultVMInstall();
        if (iVMInstall2 == null) {
            iVMInstall2 = (IVMInstall)arrayList.get(0);
        }
        if ((object2 = JavaLevels.getJRELevels()) == null) {
            return;
        }
        string3 = (JREEntry)((Hashtable)object2).get(string);
        object = null;
        if (string3 != null) {
            object = string3.getJavaPath();
        }
        if (object != null && object != "") {
            IVMInstall iVMInstall3 = object3.createVMInstall(string2);
            iVMInstall3.setInstallLocation(new File((String)object));
            iVMInstall3.setName(string2);
            arrayList.add(iVMInstall3);
            iVMInstall = new JREsUpdater();
            IVMInstall[] iVMInstallArray = new IVMInstall[arrayList.size()];
            iVMInstallArray = arrayList.toArray(iVMInstallArray);
            iVMInstall.updateJRESettings(iVMInstallArray, iVMInstall2);
        }
    }

    public static String spaces(int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }
}

