/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.jai.core;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.Declaration;
import com.unisys.jai.core.AnnotationSpec;
import com.unisys.jai.core.DMS;
import com.unisys.jai.core.DMSClassProject;
import com.unisys.jai.core.JAIAnnotationProcessor;
import com.unisys.jai.core.JavaClasspathHandler;
import com.unisys.jai.core.LIB;
import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileInterface;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.osgi.framework.Bundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DMSProcessor
extends JAIAnnotationProcessor {
    static final String schema = "schemaxml";
    static final String opPath = "dmsfolder";
    static final String dmsClassBuildJarPath = "dmsclassbuildjar";
    static final String dmsJarPath = "dmsjar";
    static final String delayVariable = "com.unisys.jai.core.delayTimeDMS";
    static final String antBuildFile = "\\build.xml";
    static final String antListenerFile = "\\msgBuild.txt";
    static final String antListnerName = "com.unisys.log.AntBuildListen";
    static long lastErrorBuild = 0L;
    static boolean building = false;
    String bigMsg;
    static final String dmsHeader = "dmsSchemaSubschema";
    static final String idDiv = "identificationDivision";
    static final String ssNameTag = "subschemaName";
    static String[] antJarList = new String[]{"ant.jar", "ant-nodeps.jar", "ant-apache-oro.jar", "ant-jai.jar", "ant-junit.jar", "ant-jsch.jar", "ant-weblogic.jar", "ant-antlr.jar", "ant-launcher.jar", "ant-netrexx.jar", "ant-trax.jar", "ant-apache-bsf.jar", "ant-jmf.jar", "ant-jdepend.jar", "ant-swing.jar", "ant-starteam.jar", "ant-commons-net.jar", "ant-stylebook.jar"};
    IClasspathEntry DMSClassSrcEntry = null;

    public DMSProcessor(AnnotationProcessorEnvironment annotationProcessorEnvironment) {
        super(annotationProcessorEnvironment);
        this.rootClass = DMS.class;
    }

    public boolean checkThePath(String string, AnnotationSpec annotationSpec) {
        boolean bl = true;
        bl = bl && this.checkIsSet(string, annotationSpec);
        bl = bl && this.checkExists(string, annotationSpec);
        return bl;
    }

    public boolean checkSourceFolder(String string, AnnotationSpec annotationSpec) {
        boolean bl = true;
        bl = bl && this.checkIsSet(string, annotationSpec);
        bl = bl && this.checkIsSource(string, annotationSpec);
        return bl;
    }

    long lastAnnoteFileBuild(IProject iProject) {
        IFile iFile;
        IFolder iFolder;
        IFolder iFolder2 = iProject.getFolder("bin");
        if (iFolder2 != null && (iFolder = iFolder2.getFolder("os2200annotepkg")) != null && (iFile = iFolder.getFile(String.valueOf(DMSClassProject.DMSClassName) + ".class")) != null) {
            File file = iFile.getRawLocation().toFile();
            long l = file.lastModified();
            return l;
        }
        return 0L;
    }

    String getSSName(IPath iPath, AnnotationSpec annotationSpec) {
        NodeList nodeList;
        block7: {
            OS2200CorePlugin.logger.debug((Object)"");
            File file = iPath.toFile();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            nodeList = document.getElementsByTagName(ssNameTag);
            if (nodeList.getLength() <= 1) break block7;
            OS2200CorePlugin.logger.debug((Object)"returning nul ss Name");
            this._msgr.printError(annotationSpec.getSourcePosition(schema), Messages.getString((String)"DMSProcessor_0"));
            return null;
        }
        try {
            Element element;
            Node node;
            String string;
            Node node2 = nodeList.item(0);
            if (node2 instanceof Element && (string = (node = (element = (Element)node2).getFirstChild()).getNodeValue()) != null) {
                return string.trim();
            }
        }
        catch (DOMException dOMException) {
            OS2200CorePlugin.logger.error((Object)"error Getting ssName", (Throwable)dOMException);
            this._msgr.printError(annotationSpec.getSourcePosition(schema), dOMException.getLocalizedMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            OS2200CorePlugin.logger.error((Object)"error Getting ssName", (Throwable)parserConfigurationException);
            this._msgr.printError(annotationSpec.getSourcePosition(schema), parserConfigurationException.getLocalizedMessage());
        }
        catch (SAXException sAXException) {
            OS2200CorePlugin.logger.error((Object)"error Getting ssName", (Throwable)sAXException);
            this._msgr.printError(annotationSpec.getSourcePosition(schema), sAXException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.error((Object)"error Getting ssName", (Throwable)iOException);
            this._msgr.printError(annotationSpec.getSourcePosition(schema), iOException.getLocalizedMessage());
        }
        OS2200CorePlugin.logger.debug((Object)"returning nul ss Name");
        return null;
    }

    public boolean checkIsSource(String string, AnnotationSpec annotationSpec) {
        OS2200CorePlugin.logger.debug((Object)"");
        Declaration declaration = annotationSpec.classDecl;
        String string2 = annotationSpec.getStringValue(string);
        IProject iProject = JavaClasspathHandler.findProject(declaration);
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        this.DMSClassSrcEntry = JavaClasspathHandler.findSrcInClasspath(iJavaProject, string2);
        if (this.DMSClassSrcEntry == null) {
            String string3 = NLS.bind((String)Messages.getString((String)"DMSProcessor_5"), (Object)string2);
            this._msgr.printError(annotationSpec.getSourcePosition(string), string3);
            return false;
        }
        return true;
    }

    @Override
    public boolean checkForErrors(AnnotationSpec annotationSpec, ArrayList<JAIAnnotationProcessor> arrayList) {
        OS2200CorePlugin.logger.debug((Object)"");
        boolean bl = true;
        bl = bl && this.checkThePath(schema, annotationSpec);
        bl = bl && this.checkThePath(dmsClassBuildJarPath, annotationSpec);
        bl = bl && this.checkThePath(dmsJarPath, annotationSpec);
        return bl;
    }

    public boolean checkIsSet(String string, AnnotationSpec annotationSpec) {
        OS2200CorePlugin.logger.debug((Object)("checkIsSet: " + string));
        String string2 = annotationSpec.getStringValue(string);
        if (string2 == null || string2.equals("")) {
            String string3 = NLS.bind((String)Messages.getString((String)"NoPath"), (Object)string);
            this._msgr.printError(annotationSpec.getSourcePosition(string), string3);
            return false;
        }
        return true;
    }

    public boolean checkExists(String string, AnnotationSpec annotationSpec) {
        OS2200CorePlugin.logger.debug((Object)("checkExists: " + string));
        String string2 = annotationSpec.getStringValue(string);
        Path path = new Path(string2);
        boolean bl = path.isAbsolute();
        if (bl) {
            File file = new File(string2);
            if (!file.exists()) {
                String string3 = NLS.bind((String)Messages.getString((String)"PathNotThere"), (Object)string2);
                this._msgr.printError(annotationSpec.getSourcePosition(string), string3);
                return false;
            }
        } else {
            String string4 = path.segment(0);
            IPath iPath = JavaCore.getClasspathVariable((String)string4);
            if (iPath == null) {
                String string5 = NLS.bind((String)Messages.getString((String)"PathNotThere"), (Object)string2);
                this._msgr.printError(annotationSpec.getSourcePosition(string), string5);
                return false;
            }
            IPath iPath2 = JavaClasspathHandler.cvToAbs((IPath)path);
            File file = new File(iPath2.toPortableString());
            if (!file.exists()) {
                String string6 = NLS.bind((String)Messages.getString((String)"PathNotThere"), (Object)string2);
                this._msgr.printError(annotationSpec.getSourcePosition(string), string6);
                return false;
            }
        }
        return true;
    }

    @Override
    public AnnotationSpec makeRoot() {
        AnnotationSpec annotationSpec = new AnnotationSpec("DMS", true, "DMS", LIB.class);
        annotationSpec.addSpecEntry(schema, String.class.getSimpleName(), String.class, "");
        annotationSpec.addSpecEntry(opPath, String.class.getSimpleName(), String.class, "");
        annotationSpec.addSpecEntry(dmsClassBuildJarPath, String.class.getSimpleName(), String.class, "");
        annotationSpec.addSpecEntry(dmsJarPath, String.class.getSimpleName(), String.class, "");
        return annotationSpec;
    }

    long getMostRecentMod(IFolder iFolder, String string) {
        IResource iResource;
        block7: {
            IFolder iFolder2;
            block6: {
                try {
                    IResource[] iResourceArray;
                    iFolder2 = null;
                    IResource[] iResourceArray2 = iResourceArray = iFolder.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        iResource = iResourceArray2[n2];
                        if (iResource instanceof IFolder && iResource.getName().equals("com")) {
                            iFolder2 = (IFolder)iResource;
                        }
                        ++n2;
                    }
                    if (iFolder2 != null) break block6;
                    return 0L;
                }
                catch (CoreException coreException) {
                    return Long.MAX_VALUE;
                }
            }
            iResource = this.findFirstFile(iFolder2, string);
            if (iResource != null) break block7;
            return 0L;
        }
        long l = iResource.getLocalTimeStamp();
        return l;
    }

    IFile findFirstFile(IFolder iFolder, String string) {
        try {
            int n;
            IFile iFile = null;
            IResource[] iResourceArray = iFolder.members();
            if (iFolder.getName().equalsIgnoreCase(string)) {
                n = 0;
                while (n < iResourceArray.length) {
                    if (iResourceArray[n] instanceof IFile) {
                        return (IFile)iResourceArray[n];
                    }
                    ++n;
                }
            }
            n = 0;
            while (n < iResourceArray.length) {
                if (iResourceArray[n] instanceof IFolder && (iFile = this.findFirstFile((IFolder)iResourceArray[n], string)) != null) {
                    return iFile;
                }
                ++n;
            }
            return iFile;
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.info((Object)"error looking for first generated file", (Throwable)coreException);
            return null;
        }
    }

    @Override
    public void doTheWork() {
        OS2200CorePlugin.logger.debug((Object)"DMSProcessor doTheWork");
        try {
            for (AnnotationSpec annotationSpec : this.myRoots) {
                Declaration declaration = annotationSpec.classDecl;
                File file = annotationSpec.specSrcPos.file();
                IProject iProject = JavaClasspathHandler.findProject(declaration);
                this.cleanBinFolder(iProject);
                String string = annotationSpec.getStringValue(opPath);
                String string2 = annotationSpec.getStringValue(dmsJarPath);
                IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
                Path path = new Path(string2);
                if (path.isAbsolute()) {
                    JavaClasspathHandler.addLibToClasspath(string2, iJavaProject, "dmsra.jar");
                } else {
                    JavaClasspathHandler.addVarToClasspath(string2, iJavaProject, "dmsra.jar");
                }
                IFolder iFolder = iProject.getFolder(string);
                IValueVariable iValueVariable = VariablesPlugin.getDefault().getStringVariableManager().getValueVariable(delayVariable);
                String string3 = iValueVariable.getValue();
                int n = Integer.parseInt(string3);
                long l = this.lastAnnoteFileBuild(iProject);
                long l2 = file.lastModified();
                String string4 = annotationSpec.getStringValue(schema);
                Path path2 = new Path(string4);
                String string5 = this.getSSName((IPath)path2, annotationSpec);
                if (string5 != null) {
                    long l3 = this.getMostRecentMod(iFolder, string5);
                    OS2200CorePlugin.logger.debug((Object)("DMS build checking to see if we will run.lastMod: " + l2 + ", lastTime: " + l3 + ", lastErrorBuild: " + lastErrorBuild + ", lastBuild: " + l + ", delayTime: " + n));
                    if ((l2 > l3 && lastErrorBuild < l2 || l > l3 + (long)n && lastErrorBuild < l) && iProject != null && !building) {
                        OS2200CorePlugin.logger.debug((Object)"DMSBuild: going to do the build");
                        DoWork doWork = new DoWork(iProject, annotationSpec, file);
                        doWork.run();
                    }
                }
                building = false;
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)"Unisys Internal Error", (Throwable)exception);
            OS2200CorePlugin.logger.info((Object)"Error doing DMS", (Throwable)exception);
            building = false;
        }
    }

    private void cleanBinFolder(IProject iProject) {
        try {
            OS2200CorePlugin.logger.debug((Object)"");
            String[] stringArray = new String[]{"BUILD.XML", "JDSSJB.JAR", "MSGBUILD.TXT"};
            String string = String.valueOf(iProject.getLocation().toOSString()) + File.separator + "bin";
            File file = new File(string);
            File file2 = null;
            if (file.exists()) {
                int n = 0;
                while (n < stringArray.length) {
                    file2 = new File(String.valueOf(file.getAbsolutePath()) + File.separator + stringArray[n]);
                    if (file2.exists()) {
                        boolean bl = file2.delete();
                        OS2200CorePlugin.logger.debug((Object)("Deleting " + file2.getAbsolutePath() + " sucessful? " + bl));
                    }
                    file2 = null;
                    ++n;
                }
            }
            string = null;
            file = null;
            file2 = null;
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    URL[] addAntJars(URL uRL, URL uRL2) {
        ArrayList<URL> arrayList = new ArrayList<URL>(antJarList.length + 2);
        URL[] uRLArray = new URL[antJarList.length + 2];
        arrayList.add(uRL);
        arrayList.add(uRL2);
        Bundle bundle = Platform.getBundle((String)"org.apache.ant");
        int n = 2;
        while (n < uRLArray.length) {
            URL uRL3 = FileLocator.find((Bundle)bundle, (IPath)new Path("lib/" + antJarList[n - 2]), null);
            if (uRL3 != null) {
                arrayList.add(uRL3);
            }
            ++n;
        }
        URL[] uRLArray2 = new URL[arrayList.size()];
        int n2 = 0;
        while (n2 < arrayList.size()) {
            uRLArray2[n2] = (URL)arrayList.get(n2);
            ++n2;
        }
        return uRLArray2;
    }

    void setMessageFile(AntRunner antRunner, String string) {
        try {
            String string2 = String.valueOf(string) + antListenerFile;
            FileWriter fileWriter = new FileWriter(string2);
            Calendar calendar = Calendar.getInstance();
            Date date = calendar.getTime();
            String string3 = date.toString();
            String string4 = NLS.bind((String)Messages.getString((String)"DMSProcessor_AntStartBuild"), (Object)string3);
            fileWriter.write(string4);
            fileWriter.close();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("OPLOC", string2);
            antRunner.addUserProperties(hashtable);
            antRunner.addBuildListener(antListnerName);
        }
        catch (IOException iOException) {
            OS2200CorePlugin.logger.error((Object)"Unisys Internal Error", (Throwable)iOException);
            OS2200CorePlugin.logger.info((Object)("Error setting up Ant Listener\n" + iOException));
        }
    }

    public URL getToolsJarEntry() {
        OS2200CorePlugin.logger.debug((Object)"");
        Path path = new Path(System.getProperty("java.home"));
        URL uRL = this.getToolsJarEntry((IPath)path);
        if (uRL == null) {
            IDynamicVariable iDynamicVariable = VariablesPlugin.getDefault().getStringVariableManager().getDynamicVariable("env_var");
            String string = null;
            try {
                if (iDynamicVariable != null) {
                    string = iDynamicVariable.getValue("JAVA_HOME");
                }
                if (string != null) {
                    path = new Path(string);
                    uRL = this.getToolsJarEntry((IPath)path);
                }
            }
            catch (CoreException coreException) {}
        }
        return uRL;
    }

    public URL getToolsJarEntry(IPath iPath) {
        File file;
        OS2200CorePlugin.logger.debug((Object)iPath.toOSString());
        if ("jre".equalsIgnoreCase(iPath.lastSegment())) {
            iPath = iPath.removeLastSegments(1);
        }
        if (!(file = (iPath = iPath.append("lib").append("tools.jar")).toFile()).exists()) {
            iPath = iPath.removeLastSegments(1);
            file = (iPath = iPath.append("classes.zip")).toFile();
            if (!file.exists()) {
                return null;
            }
        }
        try {
            return new URL("file:///" + file.getAbsolutePath());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    boolean checkFileExists(String string) {
        OS2200CorePlugin.logger.debug((Object)string);
        Path path = new Path(string);
        File file = path.toFile();
        return file.exists();
    }

    private class DoWork
    implements Runnable {
        private IProject projon;
        AnnotationSpec onSpec;
        File annoteFile;
        private int buildDone = 0;
        private IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                OS2200CorePlugin.logger.debug((Object)"");
                try {
                    IPath iPath;
                    IPath iPath2;
                    Object object;
                    URI uRI;
                    building = true;
                    Display display = Display.getDefault();
                    String string = DoWork.this.onSpec.getStringValue(DMSProcessor.schema);
                    String string2 = DoWork.this.onSpec.getStringValue(DMSProcessor.opPath);
                    String string3 = DoWork.this.onSpec.getStringValue(DMSProcessor.dmsClassBuildJarPath);
                    String string4 = DoWork.this.onSpec.getStringValue(DMSProcessor.dmsJarPath);
                    String string5 = string3;
                    Path path = new Path(string5);
                    if (!path.isAbsolute()) {
                        uRI = path.removeFirstSegments(1);
                        object = path.segment(0);
                        iPath2 = JavaCore.getClasspathVariable((String)object);
                        iPath = iPath2.append((IPath)uRI);
                        string5 = iPath.toPortableString();
                    }
                    uRI = URIUtil.toURI((String)string5);
                    object = uRI.toURL();
                    iPath2 = DoWork.this.projon.getFolder(string2);
                    iPath = iPath2.getRawLocation();
                    String string6 = iPath.toOSString();
                    String string7 = string;
                    String string8 = string6;
                    final IProgressMonitor iProgressMonitor2 = iProgressMonitor;
                    Object object2 = object;
                    iProgressMonitor.setTaskName(Messages.getString((String)"DMSProcessor_20"));
                    display.syncExec(new Runnable((URL)object2, string7, string8, iProgressMonitor2){
                        private final /* synthetic */ URL val$cbUrlF;
                        private final /* synthetic */ String val$schemaF;
                        private final /* synthetic */ String val$opFolderF;
                        private final /* synthetic */ IProgressMonitor val$mF;
                        {
                            this.val$cbUrlF = uRL;
                            this.val$schemaF = string;
                            this.val$opFolderF = string2;
                            this.val$mF = iProgressMonitor;
                        }

                        @Override
                        public void run() {
                            Calendar calendar = Calendar.getInstance();
                            try {
                                URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{this.val$cbUrlF});
                                Class<?> clazz = uRLClassLoader.loadClass("com.unisys.os2200.dms.classBuilder.ClassBuilder");
                                Method method = clazz.getMethod("setFileOverwriteAbility", Boolean.TYPE);
                                Method method2 = clazz.getMethod("generateCustomClasses", new Class[0]);
                                Constructor<?> constructor = clazz.getConstructor(String.class, String.class);
                                Object obj = constructor.newInstance(this.val$schemaF, this.val$opFolderF);
                                method.invoke(obj, true);
                                this.val$mF.subTask(Messages.getString((String)"DMSProcessor_25"));
                                OS2200CorePlugin.logger.debug((Object)"starting class builder");
                                method2.invoke(obj, new Object[0]);
                                OS2200CorePlugin.logger.debug((Object)"finished with Class building");
                                this.val$mF.subTask(Messages.getString((String)"DMSProcessor_1"));
                                DoWork.this.buildDone = 1;
                            }
                            catch (SecurityException securityException) {
                                DoWork.this.buildDone = -1;
                                OS2200CorePlugin.logger.error((Object)"error running class build", (Throwable)securityException);
                                lastErrorBuild = calendar.getTimeInMillis();
                                ((DoWork)(this).DoWork.this).DMSProcessor.this._msgr.printError((this).DoWork.this.onSpec.getSourcePosition(DMSProcessor.schema), securityException.getLocalizedMessage());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                DoWork.this.buildDone = -1;
                                OS2200CorePlugin.logger.error((Object)"error running class build", (Throwable)illegalArgumentException);
                                lastErrorBuild = calendar.getTimeInMillis();
                                ((DoWork)(this).DoWork.this).DMSProcessor.this._msgr.printError((this).DoWork.this.onSpec.getSourcePosition(DMSProcessor.schema), illegalArgumentException.getLocalizedMessage());
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                DoWork.this.buildDone = -1;
                                OS2200CorePlugin.logger.error((Object)"error running class build", (Throwable)classNotFoundException);
                                lastErrorBuild = calendar.getTimeInMillis();
                                ((DoWork)(this).DoWork.this).DMSProcessor.this._msgr.printError((this).DoWork.this.onSpec.getSourcePosition(DMSProcessor.schema), classNotFoundException.getLocalizedMessage());
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                DoWork.this.buildDone = -1;
                                OS2200CorePlugin.logger.error((Object)"error running class build", (Throwable)noSuchMethodException);
                                lastErrorBuild = calendar.getTimeInMillis();
                                ((DoWork)(this).DoWork.this).DMSProcessor.this._msgr.printError((this).DoWork.this.onSpec.getSourcePosition(DMSProcessor.schema), noSuchMethodException.getLocalizedMessage());
                            }
                            catch (InstantiationException instantiationException) {
                                DoWork.this.buildDone = -1;
                                OS2200CorePlugin.logger.error((Object)"error running class build", (Throwable)instantiationException);
                                lastErrorBuild = calendar.getTimeInMillis();
                                ((DoWork)(this).DoWork.this).DMSProcessor.this._msgr.printError((this).DoWork.this.onSpec.getSourcePosition(DMSProcessor.schema), instantiationException.getLocalizedMessage());
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                DoWork.this.buildDone = -1;
                                OS2200CorePlugin.logger.error((Object)"error running class build", (Throwable)illegalAccessException);
                                lastErrorBuild = calendar.getTimeInMillis();
                                ((DoWork)(this).DoWork.this).DMSProcessor.this._msgr.printError((this).DoWork.this.onSpec.getSourcePosition(DMSProcessor.schema), illegalAccessException.getLocalizedMessage());
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                Throwable throwable = invocationTargetException.getCause();
                                DoWork.this.buildDone = -1;
                                OS2200CorePlugin.logger.error((Object)"error running class build", throwable);
                                lastErrorBuild = calendar.getTimeInMillis();
                                ((DoWork)(this).DoWork.this).DMSProcessor.this._msgr.printError((this).DoWork.this.onSpec.getSourcePosition(DMSProcessor.schema), throwable.getLocalizedMessage());
                            }
                        }
                    });
                    if (DoWork.this.buildDone > 0) {
                        iProgressMonitor.subTask(Messages.getString((String)"DMSProcessor_2"));
                        OS2200CorePlugin.logger.debug((Object)"Class builder done -- finished sleeping");
                        IJavaProject iJavaProject = JavaCore.create((IProject)DoWork.this.projon);
                        final IProject iProject = DoWork.this.projon;
                        display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                OS2200CorePlugin.logger.debug((Object)"about to refresh");
                                try {
                                    iProject.refreshLocal(2, iProgressMonitor2);
                                }
                                catch (CoreException coreException) {
                                    OS2200CorePlugin.logger.error((Object)"error doing refresh of project", (Throwable)coreException);
                                }
                            }
                        });
                        iJavaProject.save(iProgressMonitor, true);
                        iProgressMonitor.subTask(Messages.getString((String)"DMSProcessor_3"));
                        String string9 = String.valueOf(string6) + DMSProcessor.antBuildFile;
                        if (DMSProcessor.this.checkFileExists(string9)) {
                            URL[] uRLArray;
                            Object object3;
                            Object object4;
                            URI uRI2;
                            new File(string9);
                            String string10 = string4;
                            Path path2 = new Path(string4);
                            if (!path2.isAbsolute()) {
                                uRI2 = path2.removeFirstSegments(1);
                                object4 = path2.segment(0);
                                object3 = JavaCore.getClasspathVariable((String)object4);
                                uRLArray = object3.append((IPath)uRI2);
                                string10 = uRLArray.toPortableString();
                            }
                            uRI2 = URIUtil.toURI((String)string10);
                            object4 = uRI2.toURL();
                            object3 = DMSProcessor.this.getToolsJarEntry();
                            uRLArray = DMSProcessor.this.addAntJars((URL)object3, (URL)object4);
                            if (object3 != null) {
                                AntRunner antRunner = new AntRunner();
                                antRunner.setBuildFileLocation(string9);
                                antRunner.setCustomClasspath(uRLArray);
                                DMSProcessor.this.setMessageFile(antRunner, string6);
                                String string11 = iPath2.getFullPath().toString();
                                iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"DMSProcessor_26")) + "\n" + NLS.bind((String)Messages.getString((String)"DMSProcessor_28"), (Object)string11));
                                try {
                                    OS2200CorePlugin.logger.debug((Object)"starting ANT build");
                                    antRunner.run(iProgressMonitor);
                                }
                                catch (Exception exception) {
                                    ((DoWork)DoWork.this).DMSProcessor.this._msgr.printError(DoWork.this.onSpec.getSourcePosition(DMSProcessor.schema), exception.getLocalizedMessage());
                                    Calendar calendar = Calendar.getInstance();
                                    lastErrorBuild = calendar.getTimeInMillis();
                                }
                            } else {
                                ((DoWork)DoWork.this).DMSProcessor.this._msgr.printError(DoWork.this.onSpec.getSourcePosition(DMSProcessor.schema), Messages.getString((String)"DMSProcessor_4"));
                                Calendar calendar = Calendar.getInstance();
                                lastErrorBuild = calendar.getTimeInMillis();
                            }
                        }
                        display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                OS2200CorePlugin.logger.debug((Object)"about to refresh");
                                try {
                                    iProject.refreshLocal(2, iProgressMonitor2);
                                }
                                catch (CoreException coreException) {
                                    OS2200CorePlugin.logger.error((Object)"error doing refresh of project", (Throwable)coreException);
                                }
                            }
                        });
                        DMSProcessor.this.lastAnnoteFileBuild(DoWork.this.projon);
                        building = false;
                    }
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)"error generating classes", (Throwable)exception);
                    building = false;
                }
            }
        };

        DoWork(IProject iProject, AnnotationSpec annotationSpec, File file) {
            this.projon = iProject;
            this.onSpec = annotationSpec;
            this.annoteFile = file;
        }

        @Override
        public void run() {
            try {
                IWorkbenchWindow iWorkbenchWindow = OS2200FileInterface.UIActiveWindow();
                Shell shell = iWorkbenchWindow.getShell();
                Display display = Display.getDefault();
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
                display.syncExec(new Runnable((IRunnableContext)progressMonitorDialog){
                    private final /* synthetic */ IRunnableContext val$context;
                    {
                        this.val$context = iRunnableContext;
                    }

                    @Override
                    public void run() {
                        try {
                            this.val$context.run(true, false, DoWork.this.operation);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            OS2200CorePlugin.logger.warn((Object)"Exception from DoClear", (Throwable)invocationTargetException);
                        }
                        catch (InterruptedException interruptedException) {
                            OS2200CorePlugin.logger.warn((Object)"Exception from DoClear", (Throwable)interruptedException);
                        }
                    }
                });
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.warn((Object)"Exception from DoClear", (Throwable)exception);
            }
        }
    }
}

