/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.viewer.rule;

import de.anbos.eclipse.logviewer.plugin.viewer.rule.ILogFileToolRule;
import de.anbos.eclipse.logviewer.plugin.viewer.rule.LogToolRuleDesc;
import de.anbos.eclipse.logviewer.plugin.viewer.rule.TextAttributeFactory;
import de.anbos.eclipse.logviewer.plugin.viewer.rule.TokenData;
import org.apache.regexp.RE;
import org.apache.regexp.REUtil;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class JakartaRegExpRule
implements IPredicateRule,
ILogFileToolRule {
    private RE regexp;
    private Token successToken;
    private int priority;

    public JakartaRegExpRule(LogToolRuleDesc ruleDesc) {
        this.regexp = REUtil.createRE((String)ruleDesc.getRuleValue());
        int flags = this.regexp.getMatchFlags();
        if (ruleDesc.isCaseInsensitive()) {
            flags = 1;
        }
        this.regexp.setMatchFlags(flags);
        this.priority = ruleDesc.getPriority();
        this.successToken = new Token((Object)new TokenData(TextAttributeFactory.getTextAttribute(ruleDesc), this.priority));
    }

    public IToken getSuccessToken() {
        return this.successToken;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        String line = this.returnNextCompleteLine(scanner);
        if (line != null && this.regexp.match(line)) {
            return this.successToken;
        }
        return Token.UNDEFINED;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    public int getPriority() {
        return this.priority;
    }

    private String returnNextCompleteLine(ICharacterScanner scanner) {
        int c;
        char[][] lineDelimiters = scanner.getLegalLineDelimiters();
        StringBuffer buffer = new StringBuffer();
        while ((c = scanner.read()) != -1) {
            if (this.isEOLCharacter(c, lineDelimiters)) {
                return buffer.toString();
            }
            buffer.append((char)c);
        }
        return null;
    }

    private boolean isEOLCharacter(int c, char[][] eolChars) {
        int i = 0;
        while (i < eolChars.length) {
            if (c == eolChars[i][0]) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

