/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.viewer;

import de.anbos.eclipse.logviewer.plugin.LogViewerPlugin;
import de.anbos.eclipse.logviewer.plugin.Logger;
import de.anbos.eclipse.logviewer.plugin.viewer.rule.TokenData;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.custom.StyleRange;

public class DamageRepairer
implements IPresentationDamager,
IPresentationRepairer {
    private Logger logger = LogViewerPlugin.getDefault().getLogger();
    private ITokenScanner scanner;
    private TextAttribute defaultTextAttribute;
    private IDocument document;

    public DamageRepairer(ITokenScanner scanner) {
        Assert.isNotNull((Object)scanner);
        this.scanner = scanner;
        this.defaultTextAttribute = new TextAttribute(null);
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent event, boolean documentPartitioningChanged) {
        if (!documentPartitioningChanged) {
            try {
                IRegion info = this.document.getLineInformationOfOffset(event.getOffset());
                int start = Math.max(partition.getOffset(), info.getOffset());
                int end = event.getOffset() + (event.getText() == null ? event.getLength() : event.getText().length());
                end = info.getOffset() <= end && end <= info.getOffset() + info.getLength() ? info.getOffset() + info.getLength() : this.endOfLineOf(end);
                end = Math.min(partition.getOffset() + partition.getLength(), end);
                return new Region(start, end - start);
            }
            catch (BadLocationException x) {
                this.logger.logInfo("unable to find location in document to repair a given region", x);
            }
        }
        return partition;
    }

    public void createPresentation(TextPresentation presentation, ITypedRegion region) {
        IToken resultToken;
        int start = region.getOffset();
        int length = 0;
        boolean firstToken = true;
        TextAttribute attribute = this.getTokenTextAttribute(Token.UNDEFINED);
        this.scanner.setRange(this.document, start, region.getLength());
        while (!(resultToken = this.scanner.nextToken()).isEOF()) {
            if (resultToken.equals(Token.UNDEFINED)) continue;
            if (!firstToken) {
                this.addRange(presentation, start, length, attribute, true);
            }
            firstToken = false;
            attribute = this.getTokenTextAttribute(resultToken);
            start = this.scanner.getTokenOffset();
            length = this.scanner.getTokenLength();
        }
        this.addRange(presentation, start, length, attribute, true);
    }

    private int endOfLineOf(int offset) throws BadLocationException {
        IRegion info = this.document.getLineInformationOfOffset(offset);
        if (offset <= info.getOffset() + info.getLength()) {
            return info.getOffset() + info.getLength();
        }
        int line = this.document.getLineOfOffset(offset);
        try {
            info = this.document.getLineInformation(line + 1);
            return info.getOffset() + info.getLength();
        }
        catch (BadLocationException badLocationException) {
            return this.document.getLength();
        }
    }

    private TextAttribute getTokenTextAttribute(IToken token) {
        Object data = token.getData();
        if (data instanceof TokenData) {
            return ((TokenData)data).getTextAttribute();
        }
        return this.defaultTextAttribute;
    }

    private void addRange(TextPresentation presentation, int offset, int length, TextAttribute attr, boolean wholeLine) {
        if (attr != null) {
            int style = attr.getStyle();
            int fontStyle = style & 3;
            if (wholeLine) {
                try {
                    int line = this.document.getLineOfOffset(offset);
                    int start = this.document.getLineOffset(line);
                    length = this.document.getLineLength(line);
                    offset = start;
                }
                catch (BadLocationException badLocationException) {}
            }
            StyleRange styleRange = new StyleRange(offset, length, attr.getForeground(), attr.getBackground(), fontStyle);
            styleRange.strikeout = (style & 0x20000000) != 0;
            styleRange.underline = (style & 0x40000000) != 0;
            presentation.addStyleRange(styleRange);
        }
    }
}

