/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.ui;

import de.anbos.eclipse.logviewer.plugin.LogViewerPlugin;
import de.anbos.eclipse.logviewer.plugin.Logger;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class EncodingDialog
extends Dialog {
    private Logger logger = LogViewerPlugin.getDefault().getLogger();
    private Combo encodingCombo;
    private String oldValue;
    private String value;
    private boolean valueChanged;

    public EncodingDialog(Shell parentShell, String currentEncoding) {
        super(parentShell);
        this.oldValue = currentEncoding;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.value = this.encodingCombo.getText();
            this.valueChanged = !this.value.equals(this.oldValue);
        } else if (buttonId == 3) {
            this.doLoadDefault();
        } else {
            this.value = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(LogViewerPlugin.getResourceString("dialog.encoding.title"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 3, LogViewerPlugin.getResourceString("dialog.encoding.defaults.button"), false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.encodingCombo.setFocus();
        if (this.value != null) {
            this.encodingCombo.setText(this.value);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.encodingCombo = new Combo(composite, 16384);
        GridData data = new GridData(1796);
        this.encodingCombo.setLayoutData((Object)data);
        SortedMap<String, Charset> charsets = Charset.availableCharsets();
        Set<String> keys = charsets.keySet();
        Iterator<String> keyIterator = keys.iterator();
        while (keyIterator.hasNext()) {
            Object obj = charsets.get(keyIterator.next());
            try {
                Method method = obj.getClass().getMethod("displayName", new Class[0]);
                String encoding = (String)method.invoke(obj, new Object[0]);
                this.encodingCombo.add(encoding);
            }
            catch (Exception e) {
                this.logger.logError("problem while resolving all available character encondings for this platform", e);
            }
        }
        this.encodingCombo.setText(this.oldValue);
        EncodingDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void doLoadDefault() {
        if (this.encodingCombo != null) {
            String value = LogViewerPlugin.getDefault().getPreferenceStore().getDefaultString("ENCODING");
            this.encodingCombo.setText(value);
        }
    }

    public boolean isNewValue() {
        return this.valueChanged;
    }

    public String getValue() {
        return this.value;
    }
}

