/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.preferences;

import de.anbos.eclipse.logviewer.plugin.LogViewerPlugin;
import de.anbos.eclipse.logviewer.plugin.ui.EncodingComboEditor;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class LogViewerPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IntegerFieldEditor backlogEditor;
    private IntegerFieldEditor bufferEditor;
    private IntegerFieldEditor readWaitEditor;
    private StringFieldEditor filterExtensionsEditor;
    private EncodingComboEditor encodingComboEditor;
    private ColorFieldEditor colorFieldEditor;
    private FontFieldEditor fontTypeEditor;
    private Button wordWrap;
    private Button showWhenUpdated;
    private Button showTopOfFile;
    private IPropertyChangeListener validityChangeListener;

    public void init(IWorkbench workbench) {
        this.validityChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    LogViewerPreferences.this.updateValidState();
                }
            }
        };
    }

    protected Control createContents(Composite parent) {
        Composite pageComponent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        pageComponent.setLayout((Layout)layout);
        pageComponent.setLayoutData((Object)new GridData(4, 4, true, true));
        Group tailGroup = new Group(pageComponent, 0);
        tailGroup.setText(LogViewerPlugin.getResourceString("preferences.main.tailsettings.title"));
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        tailGroup.setLayoutData((Object)data);
        this.createBacklogField((Composite)tailGroup);
        this.createReadBufferField((Composite)tailGroup);
        this.createReadWaitField((Composite)tailGroup);
        this.createFilterExtensions((Composite)tailGroup);
        Group viewerGroup = new Group(pageComponent, 0);
        viewerGroup.setText(LogViewerPlugin.getResourceString("preferences.main.viewersettings.title"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        viewerGroup.setLayoutData((Object)data);
        layout = new GridLayout(2, true);
        viewerGroup.setLayout((Layout)layout);
        this.createFontSettings((Composite)viewerGroup);
        this.createColorChooser((Composite)viewerGroup);
        this.createEncodingCombo((Composite)viewerGroup);
        this.createWordWarp((Composite)viewerGroup);
        this.createShowWhenUpdated((Composite)viewerGroup);
        this.createShowTopOfFile((Composite)viewerGroup);
        this.updateValidState();
        return pageComponent;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return LogViewerPlugin.getDefault().getPreferenceStore();
    }

    protected void performDefaults() {
        this.backlogEditor.loadDefault();
        this.bufferEditor.loadDefault();
        this.readWaitEditor.loadDefault();
        this.filterExtensionsEditor.loadDefault();
        this.encodingComboEditor.loadDefault();
        this.colorFieldEditor.loadDefault();
        this.fontTypeEditor.loadDefault();
        this.wordWrap.setSelection(this.doGetPreferenceStore().getDefaultBoolean("WORD_WRAP"));
        this.showWhenUpdated.setSelection(this.doGetPreferenceStore().getDefaultBoolean("SHOW_WHEN_UPDATED"));
        this.showTopOfFile.setSelection(this.doGetPreferenceStore().getDefaultBoolean("SHOW_TOP_OF_FILE"));
    }

    protected void performApply() {
        this.performOk();
    }

    public boolean performOk() {
        this.backlogEditor.store();
        this.bufferEditor.store();
        this.readWaitEditor.store();
        this.filterExtensionsEditor.store();
        this.encodingComboEditor.store();
        this.colorFieldEditor.store();
        this.fontTypeEditor.store();
        this.doGetPreferenceStore().setValue("WORD_WRAP", this.wordWrap.getSelection());
        this.doGetPreferenceStore().setValue("SHOW_WHEN_UPDATED", this.showWhenUpdated.getSelection());
        this.doGetPreferenceStore().setValue("SHOW_TOP_OF_FILE", this.showTopOfFile.getSelection());
        return super.performOk();
    }

    private void createBacklogField(Composite composite) {
        this.backlogEditor = new IntegerFieldEditor("BACKLOG", LogViewerPlugin.getResourceString("preferences.backlog.label.text"), composite);
        this.backlogEditor.setPreferenceStore(this.doGetPreferenceStore());
        this.backlogEditor.setPage((DialogPage)this);
        this.backlogEditor.setTextLimit(Integer.toString(200000).length());
        this.backlogEditor.setErrorMessage(LogViewerPlugin.getResourceString("preferences.backlog.label.errortext", new Object[]{new Integer(200000)}));
        this.backlogEditor.setValidateStrategy(0);
        this.backlogEditor.setValidRange(0, 200000);
        this.backlogEditor.load();
        this.backlogEditor.setPropertyChangeListener(this.validityChangeListener);
    }

    private void createReadBufferField(Composite composite) {
        this.bufferEditor = new IntegerFieldEditor("BUFFER", LogViewerPlugin.getResourceString("preferences.buffer.label.text"), composite);
        this.bufferEditor.setPreferenceStore(this.doGetPreferenceStore());
        this.bufferEditor.setPage((DialogPage)this);
        this.bufferEditor.setTextLimit(Integer.toString(4096).length());
        this.bufferEditor.setErrorMessage(LogViewerPlugin.getResourceString("preferences.buffer.label.errortext", new Object[]{new Integer(4096)}));
        this.bufferEditor.setValidateStrategy(0);
        this.bufferEditor.setValidRange(0, 4096);
        this.bufferEditor.load();
        this.bufferEditor.setPropertyChangeListener(this.validityChangeListener);
    }

    private void createReadWaitField(Composite composite) {
        this.readWaitEditor = new IntegerFieldEditor("READWAIT", LogViewerPlugin.getResourceString("preferences.readwait.label.text"), composite);
        this.readWaitEditor.setPreferenceStore(this.doGetPreferenceStore());
        this.readWaitEditor.setPage((DialogPage)this);
        this.readWaitEditor.setTextLimit(Integer.toString(1000000).length());
        this.readWaitEditor.setErrorMessage(LogViewerPlugin.getResourceString("preferences.readwait.label.errortext", new Object[]{new Integer(1000000)}));
        this.readWaitEditor.setValidateStrategy(0);
        this.readWaitEditor.setValidRange(0, 1000000);
        this.readWaitEditor.load();
        this.readWaitEditor.setPropertyChangeListener(this.validityChangeListener);
    }

    private void createFilterExtensions(Composite composite) {
        this.filterExtensionsEditor = new StringFieldEditor("FILTER_EXTENSIONS", LogViewerPlugin.getResourceString("preferences.contenteditor.filterextensions.label.text"), composite);
        this.filterExtensionsEditor.setPreferenceStore(this.doGetPreferenceStore());
        this.filterExtensionsEditor.setPage((DialogPage)this);
        this.filterExtensionsEditor.setTextLimit(128);
        this.filterExtensionsEditor.load();
    }

    private void updateValidState() {
        if (!this.backlogEditor.isValid()) {
            this.setErrorMessage(this.backlogEditor.getErrorMessage());
            this.setValid(false);
        } else if (!this.bufferEditor.isValid()) {
            this.setErrorMessage(this.bufferEditor.getErrorMessage());
            this.setValid(false);
        } else if (!this.readWaitEditor.isValid()) {
            this.setErrorMessage(this.readWaitEditor.getErrorMessage());
            this.setValid(false);
        } else {
            this.setValid(true);
        }
    }

    private void createEncodingCombo(Composite composite) {
        this.encodingComboEditor = new EncodingComboEditor("ENCODING", LogViewerPlugin.getResourceString("preferences.contenteditor.combo.label.text"), composite);
        this.encodingComboEditor.setPreferenceStore(this.doGetPreferenceStore());
        this.encodingComboEditor.setPage((DialogPage)this);
        this.encodingComboEditor.load();
    }

    private void createColorChooser(Composite composite) {
        this.colorFieldEditor = new ColorFieldEditor("CURSOR_LINE_COLOR", LogViewerPlugin.getResourceString("preferences.contenteditor.cursorline.color.chooser.text"), composite);
        this.colorFieldEditor.setPreferenceStore(this.doGetPreferenceStore());
        this.colorFieldEditor.setPage((DialogPage)this);
        this.colorFieldEditor.load();
    }

    private void createFontSettings(Composite composite) {
        Composite panel = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 4;
        panel.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 0x1000000;
        panel.setLayoutData((Object)data);
        this.fontTypeEditor = new FontFieldEditor("EDITOR_FONT_SYLE", LogViewerPlugin.getResourceString("preferences.contenteditor.font.style.text"), panel);
        this.fontTypeEditor.setChangeButtonText(LogViewerPlugin.getResourceString("preferences.contenteditor.fontl.style.button.text"));
        this.fontTypeEditor.setPreferenceStore(this.doGetPreferenceStore());
        this.fontTypeEditor.fillIntoGrid(panel, 3);
        this.fontTypeEditor.setPage((DialogPage)this);
        this.fontTypeEditor.load();
    }

    private void createWordWarp(Composite composite) {
        Label comboLabel = new Label(composite, 16384);
        comboLabel.setLayoutData((Object)new GridData(128));
        comboLabel.setText(LogViewerPlugin.getResourceString("preferences.contenteditor.wordWrap.label.text"));
        this.wordWrap = new Button(composite, 32);
        this.wordWrap.setSelection(this.doGetPreferenceStore().getBoolean("WORD_WRAP"));
    }

    private void createShowWhenUpdated(Composite composite) {
        Label comboLabel = new Label(composite, 16384);
        comboLabel.setLayoutData((Object)new GridData(128));
        comboLabel.setText(LogViewerPlugin.getResourceString("preferences.contenteditor.showwhenupdated.label.text"));
        this.showWhenUpdated = new Button(composite, 32);
        this.showWhenUpdated.setSelection(this.doGetPreferenceStore().getBoolean("SHOW_WHEN_UPDATED"));
    }

    private void createShowTopOfFile(Composite composite) {
        Label comboLabel = new Label(composite, 16384);
        comboLabel.setLayoutData((Object)new GridData(128));
        comboLabel.setText(LogViewerPlugin.getResourceString("preferences.contenteditor.showtopoffile.label.text"));
        this.showTopOfFile = new Button(composite, 32);
        this.showTopOfFile.setSelection(this.doGetPreferenceStore().getBoolean("SHOW_TOP_OF_FILE"));
    }
}

