/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.file;

import de.anbos.eclipse.logviewer.plugin.LogViewerPlugin;
import de.anbos.eclipse.logviewer.plugin.Logger;
import de.anbos.eclipse.logviewer.plugin.ResourceUtils;
import de.anbos.eclipse.logviewer.plugin.file.IFileChangedListener;
import de.anbos.eclipse.logviewer.plugin.file.ThreadInterruptedException;
import java.io.FileNotFoundException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.progress.UIJob;

public class ConsoleTail
implements IDocumentListener,
Runnable {
    private Logger logger = LogViewerPlugin.getDefault().getLogger();
    private String fullName;
    private IFileChangedListener listener;
    private IDocument doc;
    private IConsole con;
    private ITextViewer viewer;
    private boolean isRunning;
    private boolean isFirstTimeRead;

    public ConsoleTail(String myName, IFileChangedListener myListener) {
        this.fullName = myName;
        this.listener = myListener;
        this.isRunning = false;
        this.isFirstTimeRead = true;
        this.doc = null;
    }

    public void setMonitorStatus(boolean monitor) {
        if (this.isRunning == monitor) {
            return;
        }
        this.isRunning = monitor;
        if (this.isRunning) {
            Thread tailThread = new Thread(this);
            tailThread.setDaemon(true);
            tailThread.start();
        }
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getName() {
        return this.fullName.substring(this.fullName.lastIndexOf(System.getProperty("file.separator")) + 1);
    }

    public String getClassName() {
        int idx = this.fullName.indexOf(System.getProperty("file.separator"));
        return idx != -1 ? this.fullName.substring(0, idx) : this.fullName;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        this.listener.contentAboutToBeChanged();
    }

    public void documentChanged(DocumentEvent event) {
        this.listener.fileChanged(event.getText().toCharArray(), this.isFirstTimeRead);
        this.isFirstTimeRead = false;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void run() {
        block24: {
            this.isRunning = true;
            try {
                block25: {
                    readwait = LogViewerPlugin.getDefault().getPreferenceStore().getInt("READWAIT");
                    this.doc = this.openConsole();
                    if (this.doc == null) break block25;
                    this.doc.addDocumentListener((IDocumentListener)this);
                    if (!this.isFirstTimeRead) ** GOTO lbl19
                    this.listener.fileChanged(LogViewerPlugin.getResourceString("tail.loading.file", new String[]{this.fullName}).toCharArray(), true);
                    event = new DocumentEvent();
                    event.fText = this.doc.get();
                    this.documentAboutToBeChanged(event);
                    this.documentChanged(event);
                    if (true) ** GOTO lbl19
                }
                throw new ThreadInterruptedException("document was null");
                do {
                    this.wait(readwait);
lbl19:
                    // 3 sources

                } while (this.isRunning);
            }
            catch (ThreadInterruptedException tie) {
                this.logger.logError(tie);
                this.listener.fileChanged(LogViewerPlugin.getResourceString("tail.loading.file.error", new String[]{this.fullName}).toCharArray(), true);
                try {
                    if (this.doc != null) {
                        this.doc.removeDocumentListener((IDocumentListener)this);
                        this.isFirstTimeRead = true;
                    }
                    break block24;
                }
                catch (Exception v0) {}
                break block24;
            }
            catch (InterruptedException ie) {
                this.logger.logError(ie);
                try {
                    if (this.doc != null) {
                        this.doc.removeDocumentListener((IDocumentListener)this);
                        this.isFirstTimeRead = true;
                    }
                    break block24;
                }
                catch (Exception v1) {}
                break block24;
            }
            catch (NullPointerException npe) {
                this.logger.logError(npe);
                npe.printStackTrace();
                {
                    catch (Throwable var3_6) {
                        try {
                            if (this.doc != null) {
                                this.doc.removeDocumentListener((IDocumentListener)this);
                                this.isFirstTimeRead = true;
                            }
                        }
                        catch (Exception v2) {}
                        throw var3_6;
                    }
                }
                try {
                    if (this.doc != null) {
                        this.doc.removeDocumentListener((IDocumentListener)this);
                        this.isFirstTimeRead = true;
                    }
                    break block24;
                }
                catch (Exception v3) {}
                break block24;
            }
            try {
                if (this.doc != null) {
                    this.doc.removeDocumentListener((IDocumentListener)this);
                    this.isFirstTimeRead = true;
                }
            }
            catch (Exception v4) {}
        }
        this.isRunning = false;
    }

    private synchronized IDocument openConsole() throws ThreadInterruptedException {
        IDocument myDoc = null;
        boolean firstExec = true;
        while (this.isRunning) {
            try {
                this.con = this.findConsole(this.getName());
                if (this.con != null) {
                    myDoc = this.getConsoleDocument();
                }
                this.isFirstTimeRead = true;
                return myDoc;
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    if (firstExec) {
                        this.listener.fileChanged(LogViewerPlugin.getResourceString("tail.loading.file.warning", new String[]{this.fullName}).toCharArray(), true);
                        firstExec = false;
                    }
                    this.wait(500L);
                }
                catch (InterruptedException ie) {
                    throw new ThreadInterruptedException(ie);
                }
            }
        }
        throw new ThreadInterruptedException("no console found");
    }

    private IConsole findConsole(String name) throws FileNotFoundException {
        ConsolePlugin conPlugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = conPlugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return existing[i];
            }
            ++i;
        }
        throw new FileNotFoundException("no console found");
    }

    private IDocument getConsoleDocument() throws FileNotFoundException {
        if (this.con != null) {
            if (this.con instanceof TextConsole) {
                return ((TextConsole)this.con).getDocument();
            }
            UIJob uiJob = new UIJob("Update UI"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IConsoleView view = null;
                    try {
                        view = (IConsoleView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.console.ConsoleView");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                    if (view != null) {
                        view.display(ConsoleTail.this.con);
                        IConsoleView vp = view;
                        if (vp instanceof PageBookView) {
                            IPage page = ((PageBookView)vp).getCurrentPage();
                            ConsoleTail.this.viewer = ResourceUtils.getViewer(page);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            uiJob.schedule();
            if (this.viewer != null) {
                return this.viewer.getDocument();
            }
        }
        throw new FileNotFoundException("no document found");
    }
}

