/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin.action;

import de.anbos.eclipse.logviewer.plugin.LogViewer;
import de.anbos.eclipse.logviewer.plugin.LogViewerPlugin;
import de.anbos.eclipse.logviewer.plugin.Logger;
import de.anbos.eclipse.logviewer.plugin.action.delegate.ILogViewerActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;

public abstract class AbstractWorkbenchAction
implements IWorkbenchWindowActionDelegate {
    protected Logger logger = LogViewerPlugin.getDefault().getLogger();
    private IWorkbenchWindow window;
    private ILogViewerActionDelegate actionDelegate;

    public AbstractWorkbenchAction(ILogViewerActionDelegate actionDelegate) {
        this.actionDelegate = actionDelegate;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction action) {
        if (this.window == null) {
            this.logger.logError("the current window is null, we therefore don't apply any action");
            return;
        }
        Shell shell = this.window.getShell();
        String viewId = "de.anbos.eclipse.logviewer.plugin.LogViewer";
        IViewPart view = null;
        try {
            view = this.window.getActivePage().showView(viewId);
        }
        catch (PartInitException pie) {
            this.logger.logError(pie);
            return;
        }
        if (!(view instanceof LogViewer) | shell == null) {
            this.logger.logError("unable to get current shell or log file view for that matter");
            return;
        }
        this.actionDelegate.run((LogViewer)view, shell);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

