/*
 * Decompiled with CFR 0.152.
 */
package de.anbos.eclipse.logviewer.plugin;

import de.anbos.eclipse.logviewer.plugin.LogViewerPlugin;
import java.io.IOException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class LogViewerConsole
extends IOConsole
implements Runnable {
    private IOConsoleOutputStream outStream = null;
    private IOConsoleInputStream inStream;
    private boolean isRunning;

    public LogViewerConsole(String name, ImageDescriptor imageDescriptor) {
        super(name, imageDescriptor);
    }

    public void run() {
        this.isRunning = true;
        try {
            int readwait = LogViewerPlugin.getDefault().getPreferenceStore().getInt("READWAIT");
            this.inStream = this.getInputStream();
            while (this.isRunning) {
                int available = this.inStream.available();
                if (available > 0) {
                    byte[] readed = new byte[available];
                    this.inStream.read(readed, 0, available);
                    this.outStream.write(readed);
                }
                this.wait(readwait);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IOException iOException) {}
        this.isRunning = false;
    }

    public void setMonitorStatus(boolean monitor) {
        if (this.isRunning == monitor) {
            return;
        }
        this.isRunning = monitor;
        if (this.isRunning) {
            Thread tailThread = new Thread(this);
            tailThread.setDaemon(true);
            tailThread.start();
        }
    }

    public IOConsoleOutputStream getOutStream() {
        if (this.outStream == null) {
            this.outStream = this.newOutputStream();
        }
        return this.outStream;
    }
}

