/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.plus.utils;

import com.unisys.tde.core.OS2200CorePlugin;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public class CaseInsensitiveWordRule
implements IRule {
    protected static final int UNDEFINED = -1;
    protected IWordDetector fDetector;
    protected IToken fDefaultToken;
    protected int fColumn = -1;
    protected Map fWords = new HashMap();
    private StringBuffer fBuffer = new StringBuffer();

    public CaseInsensitiveWordRule(IWordDetector iWordDetector) {
        this(iWordDetector, Token.UNDEFINED);
        OS2200CorePlugin.logger.debug((Object)"constructor IWordDetector");
    }

    public CaseInsensitiveWordRule(IWordDetector iWordDetector, IToken iToken) {
        OS2200CorePlugin.logger.debug((Object)"constructor IWordDetector, IToken");
        Assert.isNotNull((Object)iWordDetector);
        Assert.isNotNull((Object)iToken);
        this.fDetector = iWordDetector;
        this.fDefaultToken = iToken;
    }

    public void addWord(String string, IToken iToken) {
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)iToken);
        this.fWords.put(string.toUpperCase(), iToken);
    }

    public void setColumnConstraint(int n) {
        OS2200CorePlugin.logger.debug((Object)("setColumnConstraint " + n));
        if (n < 0) {
            n = -1;
        }
        this.fColumn = n;
    }

    public IToken evaluate(ICharacterScanner iCharacterScanner) {
        int n = iCharacterScanner.read();
        if (this.fDetector.isWordStart(Character.toUpperCase((char)n))) {
            if (this.fColumn == -1 || this.fColumn <= iCharacterScanner.getColumn() - 1) {
                this.fBuffer.setLength(0);
                do {
                    this.fBuffer.append((char)n);
                } while ((n = iCharacterScanner.read()) != -1 && this.fDetector.isWordPart(Character.toUpperCase((char)n)));
                iCharacterScanner.unread();
                IToken iToken = (IToken)this.fWords.get(this.fBuffer.toString().toUpperCase());
                if (iToken != null) {
                    return iToken;
                }
                if (this.fDefaultToken.isUndefined()) {
                    this.unreadBuffer(iCharacterScanner);
                }
                return this.fDefaultToken;
            }
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append((char)n);
            } while ((n = iCharacterScanner.read()) != -1 && this.fDetector.isWordPart(Character.toUpperCase((char)n)));
            iCharacterScanner.unread();
            return this.fDefaultToken;
        }
        iCharacterScanner.unread();
        return Token.UNDEFINED;
    }

    protected void unreadBuffer(ICharacterScanner iCharacterScanner) {
        int n = this.fBuffer.length() - 1;
        while (n >= 0) {
            iCharacterScanner.unread();
            --n;
        }
    }
}

