/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.plus.editor.plus;

import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.plus.PlusPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;

public class PlusAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private int ifcount = 0;
    private int thencount = 0;
    private String indentPref = "indent_between_begin_end";
    private boolean doIndent = false;

    public PlusAutoIndentStrategy() {
        OS2200CorePlugin.logger.debug((Object)"constructor");
    }

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        try {
            IPreferenceStore iPreferenceStore = PlusPlugin.getDefault().getPreferenceStore();
            this.doIndent = iPreferenceStore.getBoolean(this.indentPref);
            if (documentCommand.length == 0 && documentCommand.text != null && this.endsWithDelimiter(iDocument, documentCommand.text)) {
                if (this.doIndent) {
                    this.stupidIndentAfterNewLine(iDocument, documentCommand);
                } else {
                    this.simpleIndentAfterNewLine(iDocument, documentCommand);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            OS2200CorePlugin.logger.error((Object)badLocationException.getMessage(), (Throwable)badLocationException);
        }
    }

    private void stupidIndentAfterNewLine(IDocument iDocument, DocumentCommand documentCommand) throws BadLocationException {
        int n = iDocument.getLength();
        if (documentCommand.offset == -1 || n == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(documentCommand.text);
        int n2 = documentCommand.offset == iDocument.getLength() ? documentCommand.offset - 1 : documentCommand.offset;
        int n3 = iDocument.getLineOfOffset(n2);
        if (this.isBlockEnd(iDocument, n2)) {
            this.processEndLine(iDocument, n2, documentCommand);
        } else if (this.isEndCaseStatement(iDocument, n2)) {
            this.processEndCase(iDocument, n2, documentCommand);
        } else if (this.isCaseStatement(iDocument, n2)) {
            this.processCaseStatement(iDocument, n2, documentCommand);
        } else {
            int n4 = iDocument.getLineOffset(n3);
            int n5 = this.findEndOfWhiteSpace(iDocument, n4, documentCommand.offset);
            stringBuffer.append(iDocument.get(n4, n5 - n4));
            if (this.isBlockStart(iDocument, n4)) {
                stringBuffer.append("\t");
            }
            documentCommand.text = stringBuffer.toString();
        }
    }

    private String getIndentOfLine(IDocument iDocument, int n) throws BadLocationException {
        if (n > -1) {
            int n2 = iDocument.getLineOffset(n);
            int n3 = n2 + iDocument.getLineLength(n) - 1;
            int n4 = this.findEndOfWhiteSpace(iDocument, n2, n3);
            return iDocument.get(n2, n4 - n2);
        }
        return "";
    }

    private boolean isBlockStart(IDocument iDocument, int n) {
        if (iDocument.getLength() <= 0) {
            return false;
        }
        if (n < 0) {
            return false;
        }
        try {
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            int n2 = iRegion.getOffset();
            String string = iDocument.get(n2, iRegion.getLength());
            string = this.stripComment(string);
            return this.isBegin(string) || this.isCaseentry(string) || this.isIf(string) || this.isFor(string) || this.isThen(string);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isBegin(String string) {
        String string2 = string.toUpperCase();
        return string2.startsWith("BEGIN ") || string2.compareTo("BEGIN") == 0;
    }

    private boolean isCase(String string) {
        String string2 = string.toUpperCase();
        return string2.startsWith("CASE ") || string2.compareTo("CASE") == 0;
    }

    private boolean isProc(String string) {
        String string2 = string.toUpperCase();
        return string2.startsWith("PROCEDURE ") || string2.compareTo("PROCEDURE") == 0;
    }

    private boolean isCaseentry(String string) {
        String string2 = string.toUpperCase();
        return string2.startsWith("CASEENTRY ") || string2.compareTo("CASEENTRY") == 0;
    }

    private boolean isFor(String string) {
        String string2 = string.toUpperCase();
        return string2.startsWith("FOR ") || string2.compareTo("FOR") == 0;
    }

    private boolean isThen(String string) {
        String string2 = string.toUpperCase();
        if (string2.startsWith("THEN ") || string2.compareTo("THEN") == 0) {
            ++this.thencount;
            return true;
        }
        return false;
    }

    private boolean isIf(String string) {
        String string2 = string.toUpperCase();
        if (string2.startsWith("IF ") || string2.compareTo("IF") == 0) {
            ++this.ifcount;
            return true;
        }
        return false;
    }

    private boolean isEnd(String string) {
        String string2 = string.toUpperCase();
        return string2.compareTo("END") == 0 || string2.compareTo("END;") == 0 || string2.startsWith("END ");
    }

    private boolean isEndCase(String string) {
        String string2 = string.toUpperCase();
        return string2.compareTo("ENDCASE") == 0 || string2.compareTo("ENDCASE;") == 0 || string2.startsWith("ENDCASE ");
    }

    /*
     * Unable to fully structure code
     */
    private String stripComment(String var1_1) {
        var2_2 = "";
        var3_3 = 0;
        if ((var1_1 = var1_1.trim()).indexOf(34) >= 0) ** GOTO lbl9
        return var1_1;
lbl-1000:
        // 1 sources

        {
            var2_2 = String.valueOf(var2_2) + var1_1.substring(0, var3_3);
            var4_4 = (var1_1 = var1_1.substring(var3_3 + 1)).indexOf(34);
            if (var4_4 < 0) break;
            var1_1 = var1_1.substring(var4_4 + 1);
lbl9:
            // 2 sources

            ** while ((var3_3 = var1_1.indexOf((int)34)) >= 0)
        }
lbl10:
        // 2 sources

        var4_4 = var2_2.indexOf(59);
        if (var4_4 >= 0) {
            var2_2 = var2_2.substring(0, var4_4);
        }
        var2_2 = var2_2.trim();
        return var2_2;
    }

    private boolean isBlockEnd(IDocument iDocument, int n) {
        if (iDocument.getLength() <= 0) {
            return false;
        }
        if (n <= 0) {
            return false;
        }
        try {
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            int n2 = iRegion.getOffset();
            String string = iDocument.get(n2, iRegion.getLength());
            string = this.stripComment(string);
            return this.isEnd(string);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isEndCaseStatement(IDocument iDocument, int n) {
        if (iDocument.getLength() <= 0) {
            return false;
        }
        if (n <= 0) {
            return false;
        }
        try {
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            int n2 = iRegion.getOffset();
            String string = iDocument.get(n2, iRegion.getLength());
            string = this.stripComment(string);
            return this.isEndCase(string);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private void processEndLine(IDocument iDocument, int n, DocumentCommand documentCommand) throws BadLocationException {
        int n2 = iDocument.getLineOfOffset(n);
        int n3 = iDocument.getLineOffset(n2);
        int n4 = this.findEndOfWhiteSpace(iDocument, n3, documentCommand.offset);
        int n5 = this.findMatchingBegin(iDocument, n2, documentCommand.offset, 0);
        if (n5 != -1 && n5 != n2) {
            int n6 = this.findMatchingBstart(iDocument, n5, n3, 0);
            String string = this.getIndentOfLine(iDocument, n5);
            String string2 = this.getIndentOfLine(iDocument, n6);
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(iDocument.get(n4, documentCommand.offset - n4));
            stringBuffer.append(documentCommand.text);
            stringBuffer.append(string2);
            documentCommand.length = documentCommand.offset - n3;
            documentCommand.offset = n3;
            documentCommand.text = stringBuffer.toString();
        }
    }

    private void processEndCase(IDocument iDocument, int n, DocumentCommand documentCommand) throws BadLocationException {
        int n2 = iDocument.getLineOfOffset(n);
        int n3 = iDocument.getLineOffset(n2);
        int n4 = this.findEndOfWhiteSpace(iDocument, n3, documentCommand.offset);
        int n5 = this.findMatchingCaseEntry(iDocument, n2, documentCommand.offset, 0);
        if (n5 != -1 && n5 != n2) {
            String string = this.getIndentOfLine(iDocument, n5);
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(iDocument.get(n4, documentCommand.offset - n4));
            stringBuffer.append(documentCommand.text);
            stringBuffer.append(string);
            documentCommand.length = documentCommand.offset - n3;
            documentCommand.offset = n3;
            documentCommand.text = stringBuffer.toString();
        }
    }

    private void processCaseStatement(IDocument iDocument, int n, DocumentCommand documentCommand) throws BadLocationException {
        int n2 = iDocument.getLineOfOffset(n);
        int n3 = iDocument.getLineOffset(n2);
        int n4 = this.findEndOfWhiteSpace(iDocument, n3, documentCommand.offset);
        int n5 = this.findMatchingCaseEntry(iDocument, n2, documentCommand.offset, 0);
        if (n5 != -1 && n5 != n2) {
            String string = "\t" + this.getIndentOfLine(iDocument, n5);
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(iDocument.get(n4, documentCommand.offset - n4));
            stringBuffer.append(documentCommand.text);
            stringBuffer.append(String.valueOf(string) + "\t");
            documentCommand.length = documentCommand.offset - n3;
            documentCommand.offset = n3;
            documentCommand.text = stringBuffer.toString();
        }
    }

    private int findMatchingBegin(IDocument iDocument, int n, int n2, int n3) throws BadLocationException {
        int n4 = iDocument.getLineOffset(n);
        int n5 = this.getBeginCount(iDocument, n4, n2, false) - n3;
        while (n5 < 0) {
            if (--n < 0) {
                return -1;
            }
            n4 = iDocument.getLineOffset(n);
            n2 = n4 + iDocument.getLineLength(n) - 1;
            n5 += this.getBeginCount(iDocument, n4, n2, false);
        }
        return n;
    }

    private int findMatchingBstart(IDocument iDocument, int n, int n2, int n3) throws BadLocationException {
        while (n > 0) {
            int n4 = iDocument.getLineOffset(--n);
            n2 = n4 + iDocument.getLineLength(n) - 1;
            int n5 = iDocument.getLineLength(n);
            String string = this.stripComment(iDocument.get(n4, n5));
            if (this.isIf(string) || this.isFor(string) || this.isProc(string) || this.isCase(string)) break;
        }
        return n;
    }

    private int findMatchingCaseEntry(IDocument iDocument, int n, int n2, int n3) throws BadLocationException {
        while (n > 0) {
            int n4 = iDocument.getLineOffset(--n);
            n2 = n4 + iDocument.getLineLength(n) - 1;
            int n5 = iDocument.getLineLength(n);
            String string = this.stripComment(iDocument.get(n4, n5));
            if (this.isCaseentry(string)) break;
        }
        return n;
    }

    private int getBeginCount(IDocument iDocument, int n, int n2, boolean bl) {
        int n3 = 0;
        try {
            int n4 = iDocument.getLineOfOffset(n);
            int n5 = iDocument.getLineOfOffset(n2);
            while (n4 <= n5) {
                int n6 = iDocument.getLineOffset(n4);
                if (this.isTrueBegin(iDocument, n6)) {
                    ++n3;
                    bl = false;
                }
                if (this.isBlockEnd(iDocument, n6) && !bl) {
                    --n3;
                }
                ++n4;
            }
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
        return n3;
    }

    private boolean isTrueBegin(IDocument iDocument, int n) {
        if (iDocument.getLength() <= 0) {
            return false;
        }
        if (n <= 0) {
            return false;
        }
        try {
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            int n2 = iRegion.getOffset();
            String string = iDocument.get(n2, iRegion.getLength());
            string = this.stripComment(string);
            return this.isBegin(string);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isCaseStatement(IDocument iDocument, int n) {
        if (iDocument.getLength() <= 0) {
            return false;
        }
        if (n <= 0) {
            return false;
        }
        try {
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            int n2 = iRegion.getOffset();
            String string = iDocument.get(n2, iRegion.getLength());
            string = this.stripComment(string);
            return this.isCase(string);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean endsWithDelimiter(IDocument iDocument, String string) {
        String[] stringArray = iDocument.getLegalLineDelimiters();
        if (stringArray != null) {
            return TextUtilities.endsWith((String[])stringArray, (String)string) > -1;
        }
        return false;
    }

    private void simpleIndentAfterNewLine(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.offset == -1 || iDocument.getLength() == 0) {
            return;
        }
        try {
            int n = documentCommand.offset == iDocument.getLength() ? documentCommand.offset - 1 : documentCommand.offset;
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            int n2 = iRegion.getOffset();
            int n3 = this.findEndOfWhiteSpace(iDocument, n2, documentCommand.offset);
            StringBuffer stringBuffer = new StringBuffer(documentCommand.text);
            if (n3 > n2) {
                stringBuffer.append(iDocument.get(n2, n3 - n2));
            }
            documentCommand.text = stringBuffer.toString();
        }
        catch (BadLocationException badLocationException) {}
    }
}

