/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.plus.editor;

import com.unisys.tde.plus.editor.SingleCharReader;
import java.io.IOException;
import java.io.Reader;

public abstract class SubstitutionTextReader
extends SingleCharReader {
    protected static final String LINE_DELIM = System.getProperty("line.separator", "\n");
    private Reader fReader;
    private boolean fWasWhiteSpace;
    private int fCharAfterWhiteSpace;
    private boolean fReadFromBuffer;
    private StringBuffer fBuffer;
    private int fIndex;

    protected SubstitutionTextReader(Reader reader) {
        this.fReader = reader;
        this.fBuffer = new StringBuffer();
        this.fIndex = 0;
        this.fReadFromBuffer = false;
        this.fCharAfterWhiteSpace = -1;
        this.fWasWhiteSpace = true;
    }

    protected abstract String computeSubstitution(int var1) throws IOException;

    protected Reader getReader() {
        return this.fReader;
    }

    protected int nextChar() throws IOException {
        boolean bl = this.fReadFromBuffer = this.fBuffer.length() > 0;
        if (this.fReadFromBuffer) {
            char c = this.fBuffer.charAt(this.fIndex++);
            if (this.fIndex >= this.fBuffer.length()) {
                this.fBuffer.setLength(0);
                this.fIndex = 0;
            }
            return c;
        }
        int n = this.fCharAfterWhiteSpace;
        if (n == -1) {
            n = this.fReader.read();
        }
        if (Character.isWhitespace((char)n)) {
            while (Character.isWhitespace((char)(n = this.fReader.read()))) {
            }
            if (n != -1) {
                this.fCharAfterWhiteSpace = n;
                return 32;
            }
        } else {
            this.fCharAfterWhiteSpace = -1;
        }
        return n;
    }

    @Override
    public int read() throws IOException {
        int n;
        block0: do {
            n = this.nextChar();
            while (!this.fReadFromBuffer) {
                String string = this.computeSubstitution(n);
                if (string == null) continue block0;
                if (string.length() > 0) {
                    this.fBuffer.insert(0, string);
                }
                n = this.nextChar();
            }
        } while (this.fWasWhiteSpace && n == 32);
        this.fWasWhiteSpace = n == 32 || n == 13 || n == 10;
        return n;
    }

    @Override
    public boolean ready() throws IOException {
        return this.fReader.ready();
    }

    @Override
    public void close() throws IOException {
        this.fReader.close();
    }

    @Override
    public void reset() throws IOException {
        this.fReader.reset();
        this.fWasWhiteSpace = true;
        this.fCharAfterWhiteSpace = -1;
        this.fBuffer.setLength(0);
        this.fIndex = 0;
    }
}

