/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.plus.editor;

import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.plus.editor.HTMLTextPresenter;
import com.unisys.tde.plus.editor.PlusAnnotationHover;
import com.unisys.tde.plus.editor.plus.PlusAutoIndentStrategy;
import com.unisys.tde.plus.editor.plus.PlusCodeScanner;
import com.unisys.tde.plus.editor.plus.PlusCompletionProcessor;
import com.unisys.tde.plus.utils.PlusColorManager;
import com.unisys.tde.plus.utils.PlusDamagerRepairer;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;

public class PlusSourceViewerConfiguration
extends SourceViewerConfiguration {
    private PlusCodeScanner scanner;
    private PlusColorManager colorManager;

    public PlusSourceViewerConfiguration(PlusColorManager plusColorManager) {
        this.colorManager = plusColorManager;
        OS2200CorePlugin.logger.debug((Object)"constructor");
    }

    public String[] getConfiguredContentTypes(ISourceViewer iSourceViewer) {
        OS2200CorePlugin.logger.debug((Object)"");
        return new String[]{"__dftl_partition_content_type"};
    }

    protected PlusCodeScanner getPlusScanner() {
        OS2200CorePlugin.logger.debug((Object)"");
        if (this.scanner == null) {
            this.scanner = new PlusCodeScanner(this.colorManager);
        }
        return this.scanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer iSourceViewer) {
        OS2200CorePlugin.logger.debug((Object)"");
        PresentationReconciler presentationReconciler = new PresentationReconciler();
        PlusDamagerRepairer plusDamagerRepairer = new PlusDamagerRepairer((ITokenScanner)this.getPlusScanner());
        presentationReconciler.setDamager((IPresentationDamager)plusDamagerRepairer, "__dftl_partition_content_type");
        presentationReconciler.setRepairer((IPresentationRepairer)plusDamagerRepairer, "__dftl_partition_content_type");
        return presentationReconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer iSourceViewer) {
        OS2200CorePlugin.logger.debug((Object)"");
        ContentAssistant contentAssistant = new ContentAssistant();
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)new PlusCompletionProcessor(), "__dftl_partition_content_type");
        contentAssistant.enableAutoActivation(true);
        contentAssistant.setAutoActivationDelay(500);
        contentAssistant.setProposalPopupOrientation(10);
        contentAssistant.setContextInformationPopupOrientation(20);
        contentAssistant.setContextInformationPopupBackground(this.colorManager.getColor(new RGB(150, 150, 0)));
        return contentAssistant;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer iSourceViewer, String string) {
        PlusAutoIndentStrategy plusAutoIndentStrategy = "__dftl_partition_content_type".equals(string) ? new PlusAutoIndentStrategy() : new DefaultIndentLineAutoEditStrategy();
        return new IAutoEditStrategy[]{plusAutoIndentStrategy};
    }

    public String[] getIndentPrefixes(ISourceViewer iSourceViewer, String string) {
        OS2200CorePlugin.logger.debug((Object)"");
        return new String[]{"\t", "    "};
    }

    public int getTabWidth(ISourceViewer iSourceViewer) {
        OS2200CorePlugin.logger.debug((Object)"");
        return 4;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer iSourceViewer) {
        return new PlusAnnotationHover();
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer iSourceViewer) {
        return this.getInformationControlCreator(iSourceViewer, true);
    }

    private IInformationControlCreator getInformationControlCreator(ISourceViewer iSourceViewer, final boolean bl) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                int n = bl ? 0 : 768;
                return new DefaultInformationControl(shell, n, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(bl));
            }
        };
    }

    public IInformationControlCreator getAssistantInformationControlCreator(ISourceViewer iSourceViewer) {
        return super.getInformationControlCreator(iSourceViewer);
    }
}

