/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.plus.editor;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.ExclusiveFileLockChecker;
import com.unisys.os2200.util.MemChecker;
import com.unisys.tde.core.ElementSelectionObject;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileEditorInput;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.core.utils.EditorRelatedUtils;
import com.unisys.tde.plus.PlusPlugin;
import com.unisys.tde.plus.editor.PlusBreakpointRulerAction;
import com.unisys.tde.plus.editor.PlusEditorDocumentProvider;
import com.unisys.tde.plus.editor.PlusLineBreakpoint;
import com.unisys.tde.plus.editor.PlusSourceViewerConfiguration;
import com.unisys.tde.plus.utils.PlusColorManager;
import com.unisys.tde.plus.utils.PlusEditorRefreshAction;
import com.unisys.tde.plus.utils.PlusHelpContextProvider;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceAction;

public class PlusEditor
extends TextEditor {
    private PlusEditorDocumentProvider ueDocProvider = new PlusEditorDocumentProvider();
    private PlusColorManager colorManager;
    private PlusBreakpointRulerAction plusBreakpointRulerAction;
    private static final String LINE_NUMBER_RULER = "lineNumberRuler";
    private String titleToolTip = null;

    public PlusEditor() {
        OS2200CorePlugin.logger.debug((Object)"constructor");
        this.colorManager = new PlusColorManager();
        this.setSourceViewerConfiguration(new PlusSourceViewerConfiguration(this.colorManager));
    }

    public void dispose() {
        OS2200CorePlugin.logger.debug((Object)"");
        this.colorManager.dispose();
        super.dispose();
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider iDocumentProvider = this.getDocumentProvider();
        IAnnotationModel iAnnotationModel = iDocumentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (iAnnotationModel instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)iAnnotationModel;
        }
        return null;
    }

    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        if (iEditorInput == null) {
            super.doSetInput(iEditorInput);
        } else {
            this.setDocumentProvider((IDocumentProvider)this.ueDocProvider);
            super.doSetInput(iEditorInput);
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        OS2200CorePlugin.logger.debug((Object)"");
        try {
            Integer n;
            Object object;
            IDocument iDocument;
            IMarker[] iMarkerArray;
            IResource iResource;
            IDocumentProvider iDocumentProvider = this.getDocumentProvider();
            IEditorInput iEditorInput = this.getEditorInput();
            if (iEditorInput instanceof OS2200FileEditorInput) {
                super.doSave(iProgressMonitor);
                return;
            }
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            IFile iFile = iFileEditorInput.getFile();
            IPath iPath = iFile.getFullPath();
            String string = null;
            try {
                iResource = iFile.getProject().findMember(iPath.segment(1));
                if (iResource instanceof IFile) {
                    iMarkerArray = ((IFile)iResource).getRawLocation();
                    if (iMarkerArray != null) {
                        new FileInputStream(iMarkerArray.toOSString());
                    }
                    string = this.getworkFile((IFile)iResource);
                }
            }
            catch (Exception exception) {
                String string2 = exception.getMessage();
                ExclusiveFileLockChecker.HandleForExclusiveFileHold((String)string2, string, (String)string2);
                return;
            }
            iResource = this.getAnnotationModel();
            iMarkerArray = iFile.findMarkers(null, true, 2);
            int cfr_ignored_0 = iMarkerArray.length;
            ArrayList<MarkerCopy> arrayList = new ArrayList<MarkerCopy>();
            IMarker[] iMarkerArray2 = iMarkerArray;
            int n2 = iMarkerArray.length;
            int n3 = 0;
            while (n3 < n2) {
                iDocument = iMarkerArray2[n3];
                object = iResource.getMarkerPosition((IMarker)iDocument);
                n = object.getOffset();
                MarkerCopy markerCopy = new MarkerCopy(iDocument.getAttributes(), (Integer)iDocument.getAttribute("charEnd"), n, (Integer)iDocument.getAttribute("lineNumber"), iDocument.getType());
                arrayList.add(markerCopy);
                ++n3;
            }
            iDocument = iDocumentProvider.getDocument((Object)iEditorInput);
            StringBuffer stringBuffer = this.expandDoc(iDocument);
            iDocument.set(stringBuffer.toString());
            super.doSave(iProgressMonitor);
            for (MarkerCopy markerCopy : arrayList) {
                object = markerCopy.type;
                if (((String)object).equals("com.unisys.tde.plus.plusLineBreakpointMarker")) {
                    try {
                        n = markerCopy.charStart;
                        int n4 = iDocument.getLineOfOffset(n.intValue()) + 1;
                        Integer n5 = n4;
                        Integer n6 = markerCopy.charEnd;
                        HashMap hashMap = new HashMap(10);
                        new PlusLineBreakpoint((IResource)iFile, n5, n, n6, true, hashMap);
                    }
                    catch (BadLocationException badLocationException) {}
                    continue;
                }
                MarkerUtilities.createMarker((IResource)iFile, (Map)markerCopy.attributes, (String)markerCopy.type);
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    protected void performSave(boolean bl, IProgressMonitor iProgressMonitor) {
        IDocumentProvider iDocumentProvider = this.getDocumentProvider();
        if (iDocumentProvider == null) {
            return;
        }
        try {
            try {
                iDocumentProvider.aboutToChange((Object)this.getEditorInput());
                IEditorInput iEditorInput = this.getEditorInput();
                iDocumentProvider.saveDocument(iProgressMonitor, (Object)iEditorInput, this.getDocumentProvider().getDocument((Object)iEditorInput), bl);
                this.editorSaved();
            }
            catch (CoreException coreException) {
                IStatus iStatus = coreException.getStatus();
                if (iStatus == null || iStatus.getSeverity() != 8) {
                    this.handleExceptionOnSave(coreException, iProgressMonitor);
                }
                iDocumentProvider.changed((Object)this.getEditorInput());
            }
        }
        finally {
            iDocumentProvider.changed((Object)this.getEditorInput());
        }
    }

    protected void validateState(IEditorInput iEditorInput) {
        try {
            if (iEditorInput instanceof IFileEditorInput) {
                IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
                IFile iFile = iFileEditorInput.getFile();
                IMarker[] iMarkerArray = iFile.findMarkers(null, true, 2);
                int cfr_ignored_0 = iMarkerArray.length;
                super.validateState(iEditorInput);
                iMarkerArray = iFile.findMarkers(null, true, 2);
                int cfr_ignored_1 = iMarkerArray.length;
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    protected void initializeEditor() {
        OS2200CorePlugin.logger.debug((Object)"");
        this.setPreferenceStore(this.createCombinedPreferenceStore());
        this.setHelpContextId("com.unisys.tde.plus.core.help");
        this.setEditorContextMenuId("#PlusEditorContext");
        this.setCompatibilityMode(false);
    }

    private IPreferenceStore createCombinedPreferenceStore() {
        OS2200CorePlugin.logger.debug((Object)"");
        IPreferenceStore iPreferenceStore = PlusPlugin.getDefault().getPreferenceStore();
        IPreferenceStore iPreferenceStore2 = EditorsUI.getPreferenceStore();
        return new ChainedPreferenceStore(new IPreferenceStore[]{iPreferenceStore, iPreferenceStore2});
    }

    private int getTabSize() {
        OS2200CorePlugin.logger.debug((Object)"");
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        return iPreferenceStore.getInt("tabWidth");
    }

    protected ISourceViewer createSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, int n) {
        OS2200CorePlugin.logger.debug((Object)"");
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        PlusSourceViewer plusSourceViewer = new PlusSourceViewer(composite, iVerticalRuler, this.getOverviewRuler(), n);
        this.getSourceViewerDecorationSupport((ISourceViewer)plusSourceViewer);
        return plusSourceViewer;
    }

    public void createPartControl(Composite composite) {
        OS2200CorePlugin.logger.debug((Object)"");
        super.createPartControl(composite);
    }

    public IDocument getDocument() {
        OS2200CorePlugin.logger.debug((Object)"");
        IDocumentProvider iDocumentProvider = this.getDocumentProvider();
        IDocument iDocument = iDocumentProvider.getDocument((Object)this.getEditorInput());
        return iDocument;
    }

    protected void initializeKeyBindingScopes() {
        OS2200CorePlugin.logger.debug((Object)"");
        this.setKeyBindingScopes(new String[]{"com.unisys.plus.editor.PlusEditorScope"});
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IContextProvider.class) {
            OS2200CorePlugin.logger.info((Object)("PlusEditor Adapter " + clazz.getName()));
            return new PlusHelpContextProvider();
        }
        return super.getAdapter(clazz);
    }

    private int insertTabString(StringBuffer stringBuffer, int n) {
        int n2 = this.getTabSize();
        int n3 = n % n2;
        n3 = n2 - n3;
        int n4 = 0;
        while (n4 < n3) {
            stringBuffer.append(' ');
            ++n4;
        }
        return n3;
    }

    private String expandTabs(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (c == '\t') {
                n += this.insertTabString(stringBuffer, n);
            } else {
                stringBuffer.append(c);
                ++n;
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    private StringBuffer expandDoc(IDocument iDocument) {
        int n = iDocument.getNumberOfLines();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            try {
                int n3 = iDocument.getLineOffset(n2);
                int n4 = iDocument.getLineLength(n2);
                String string = iDocument.get(n3, n4);
                string = this.expandTabs(string);
                stringBuffer.append(string);
            }
            catch (BadLocationException badLocationException) {
                OS2200CorePlugin.logger.debug((Object)badLocationException);
            }
            ++n2;
        }
        return stringBuffer;
    }

    protected void createActions() {
        super.createActions();
        this.plusBreakpointRulerAction = new PlusBreakpointRulerAction((ITextEditor)this, (IVerticalRulerInfo)this.getVerticalRuler());
        this.setAction("ManagePlusBreakpoints", (IAction)this.plusBreakpointRulerAction);
        this.setAction("RulerDoubleClick", this.getAction("ManagePlusBreakpoints"));
        ResourceAction resourceAction = new ResourceAction(Messages.getResourceBundle(), "PlusEditor.ToggleLineNumbersAction.", 2){

            public void run() {
                PlusEditor.this.toggleLineNumberRuler();
            }
        };
        PlusEditorRefreshAction plusEditorRefreshAction = new PlusEditorRefreshAction((IShellProvider)this.getSite());
        plusEditorRefreshAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
        this.markAsStateDependentAction("org.eclipse.ui.file.refresh", true);
        this.setAction("org.eclipse.ui.file.refresh", (IAction)plusEditorRefreshAction);
        resourceAction.setActionDefinitionId("org.eclipse.ui.editors.lineNumberToggle");
        this.setAction("Linenumbers.Toggle", (IAction)resourceAction);
    }

    private void toggleLineNumberRuler() {
        IPreferenceStore iPreferenceStore = PlusPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setValue(LINE_NUMBER_RULER, !this.isLineNumberRulerVisible());
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent propertyChangeEvent) {
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer == null) {
            return;
        }
        String string = propertyChangeEvent.getProperty();
        if (string.equals(LINE_NUMBER_RULER)) {
            this.initializeLineNumberRulerColumn(this.fLineNumberRulerColumn);
        }
    }

    public boolean isEditorInputReadOnly() {
        return false;
    }

    protected void performSaveAs(IProgressMonitor iProgressMonitor) {
        String string;
        String string2;
        Object object;
        boolean bl;
        IFile iFile;
        IEditorInput iEditorInput;
        block20: {
            Shell shell = this.getSite().getShell();
            SaveAsDialog saveAsDialog = new SaveAsDialog(shell);
            iEditorInput = this.getEditorInput();
            if (iEditorInput instanceof IFileEditorInput) {
                saveAsDialog.setOriginalFile(((IFileEditorInput)iEditorInput).getFile());
            } else if (iEditorInput instanceof OS2200FileEditorInput) {
                saveAsDialog.setOriginalName(((OS2200FileEditorInput)iEditorInput).getName().toUpperCase());
            } else if (iEditorInput instanceof FileStoreEditorInput) {
                saveAsDialog.setOriginalName(((FileStoreEditorInput)iEditorInput).getName().toUpperCase());
            }
            saveAsDialog.open();
            IPath iPath = saveAsDialog.getResult();
            if (iPath == null) {
                if (iProgressMonitor != null) {
                    iProgressMonitor.setCanceled(true);
                }
                return;
            }
            IDocumentProvider iDocumentProvider = this.getDocumentProvider();
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            iFile = iWorkspace.getRoot().getFile(iPath);
            FileEditorInput fileEditorInput = new FileEditorInput(iFile);
            if (iDocumentProvider == null) {
                return;
            }
            bl = false;
            try {
                try {
                    iDocumentProvider.aboutToChange((Object)fileEditorInput);
                    iDocumentProvider.saveDocument(iProgressMonitor, (Object)fileEditorInput, iDocumentProvider.getDocument((Object)iEditorInput), true);
                    bl = true;
                }
                catch (CoreException coreException) {
                    object = coreException.getStatus();
                    if (object == null || object.getSeverity() != 8) {
                        string2 = Messages.getString((String)"PlusEditor_saveAs");
                        string = NLSUtility.format((String)Messages.getString((String)"PlusEditor_saveProblem"), (Object)coreException.getMessage());
                        MessageDialog.openError((Shell)shell, (String)string2, (String)string);
                    }
                    iDocumentProvider.changed((Object)fileEditorInput);
                    break block20;
                }
            }
            catch (Throwable throwable) {
                iDocumentProvider.changed((Object)fileEditorInput);
                throw throwable;
            }
            iDocumentProvider.changed((Object)fileEditorInput);
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.setCanceled(!bl);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        object = "<default>";
        if (iFile.getFileExtension() != null) {
            object = iFile.getFileExtension();
        }
        string2 = new ElementSelectionObject(iFile.getName(), iFile.getName(), (String)object);
        arrayList.add(string2);
        try {
            OS2200ProjectUpdate.addLinks((IProject)iFile.getProject(), arrayList, (IProgressMonitor)iProgressMonitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            operationCanceledException.printStackTrace();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        if (bl) {
            string = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getPages()[0];
            string.closeEditor(string.findEditor(iEditorInput), false);
        }
    }

    public String getPartName() {
        return super.getPartName().toUpperCase();
    }

    protected void setPartName(String string) {
        super.setPartName(string.toUpperCase());
    }

    public String getTitleToolTip() {
        if (this.titleToolTip == null) {
            this.titleToolTip = EditorRelatedUtils.getPathIn2200Format((IEditorInput)this.getEditorInput(), null);
        }
        return this.titleToolTip;
    }

    private String getworkFile(IFile iFile) throws CoreException {
        IProject iProject = iFile.getProject();
        Properties properties = OS2200ProjectUpdate.getProperties((IProject)iProject);
        String string = properties.getProperty("workFile");
        return string;
    }

    class MarkerCopy {
        String type;
        Integer lineNumber;
        Integer charStart;
        Integer charEnd;
        Map attributes;

        MarkerCopy(Map map, Integer n, Integer n2, Integer n3, String string) {
            this.attributes = map;
            this.charEnd = n;
            this.charStart = n2;
            this.lineNumber = n3;
            this.type = string;
        }
    }

    class PlusSourceViewer
    extends SourceViewer {
        public PlusSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, IOverviewRuler iOverviewRuler, int n) {
            super(composite, iVerticalRuler, iOverviewRuler, PlusEditor.this.isOverviewRulerVisible(), n);
            OS2200CorePlugin.logger.debug((Object)"constructor");
        }

        public void changeTextPresentation(TextPresentation textPresentation, boolean bl) {
            if (MemChecker.getInstance().hasEnoughMemory(false, true)) {
                super.changeTextPresentation(textPresentation, bl);
            } else {
                OS2200CorePlugin.logger.warn((Object)"Not enough memory to changeTextPresentation in PlusEditor.");
            }
        }

        public void doOperation(int n) {
            OS2200CorePlugin.logger.debug((Object)"");
            if (this.getTextWidget() == null || !this.redraws()) {
                return;
            }
            switch (n) {
                case 13: {
                    this.fContentAssistant.showPossibleCompletions();
                    return;
                }
            }
            super.doOperation(n);
        }

        protected void print() {
            PrinterData printerData;
            PrintDialog printDialog = new PrintDialog(this.getControl().getShell(), 32768);
            Point point = this.getSelectedRange();
            if (point.y > 0) {
                printDialog.setScope(2);
            }
            if ((printerData = printDialog.open()) != null) {
                final Printer printer = new Printer(printerData);
                final Runnable runnable = this.getTextWidget().print(printer);
                Thread thread = new Thread("Printing"){

                    @Override
                    public void run() {
                        runnable.run();
                        printer.dispose();
                    }
                };
                thread.start();
            }
        }
    }
}

