/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.plus.editor;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.plus.editor.PlusLineBreakpoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerRulerAction;

public class PlusBreakpointRulerAction
extends MarkerRulerAction {
    public static final String PlusLineMarker = "com.unisys.tde.plus.plusLineBreakpointMarker";
    public static final String PlusBrkptRulerAction = "PlusBrkptRulerAction";
    private int fLine;
    private int fStartChar;
    private int fEndChar;
    private IResource fResource;
    private IProject fProjectResource;
    String fFileName = "";
    ITextEditor plusEditor;

    public PlusBreakpointRulerAction(ITextEditor iTextEditor, IVerticalRulerInfo iVerticalRulerInfo) {
        super(Messages.getResourceBundle(), "ManagePluslBreakpoints.", iTextEditor, iVerticalRulerInfo, PlusLineMarker, false);
        this.plusEditor = iTextEditor;
        this.fFileName = this.plusEditor.getEditorInput().getName();
        IFile iFile = (IFile)this.plusEditor.getEditorInput().getAdapter(IFile.class);
        if (iFile != null) {
            this.fResource = iFile;
            this.fProjectResource = this.fResource.getProject();
        }
        this.fLine = 0;
        this.fStartChar = -1;
        this.fEndChar = -1;
    }

    protected boolean breakpointElementInEditor(IBreakpointManager iBreakpointManager, IMarker iMarker) {
        return true;
    }

    protected List getMarkers() {
        ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
        IResource iResource = this.getResource();
        IDocument iDocument = this.getDocument();
        AbstractMarkerAnnotationModel abstractMarkerAnnotationModel = this.getAnnotationModel();
        if (abstractMarkerAnnotationModel != null) {
            try {
                IWorkspaceRoot iWorkspaceRoot;
                IMarker[] iMarkerArray = null;
                if (iResource instanceof IFile) {
                    this.fFileName = iResource.getFullPath().toOSString();
                    iMarkerArray = iResource.findMarkers(PlusLineMarker, true, 2);
                } else {
                    iWorkspaceRoot = OS2200CorePlugin.getWorkspace().getRoot();
                    iMarkerArray = iWorkspaceRoot.findMarkers(PlusLineMarker, true, 2);
                }
                if (iMarkerArray != null) {
                    iWorkspaceRoot = DebugPlugin.getDefault().getBreakpointManager();
                    int n = 0;
                    while (n < iMarkerArray.length) {
                        IBreakpoint iBreakpoint = iWorkspaceRoot.getBreakpoint(iMarkerArray[n]);
                        if (iBreakpoint != null && iWorkspaceRoot.isRegistered(iBreakpoint) && this.breakpointElementInEditor((IBreakpointManager)iWorkspaceRoot, iMarkerArray[n]) && this.includesRulerLine(abstractMarkerAnnotationModel.getMarkerPosition(iMarkerArray[n]), iDocument)) {
                            arrayList.add(iMarkerArray[n]);
                        }
                        ++n;
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        return arrayList;
    }

    protected void addMarker() {
        IEditorInput iEditorInput = this.getTextEditor().getEditorInput();
        if (this.getDocument() == null) {
            return;
        }
        int n = ((Document)this.getDocument()).getNumberOfLines();
        this.fLine = this.getVerticalRulerInfo().getLineOfLastMouseButtonActivity();
        if (this.fLine > n) {
            return;
        }
        try {
            this.fStartChar = this.getDocument().getLineOffset(this.fLine);
            int n2 = 0;
            n2 = this.getDocument().getLineLength(this.fLine);
            this.fEndChar = this.fStartChar + n2;
            if (this.getDocument().getNumberOfLines() != n && n2 != 1 && n2 != 0) {
                this.fEndChar -= 2;
            }
            ++this.fLine;
        }
        catch (BadLocationException badLocationException) {
            OS2200CorePlugin.logger.error((Object)"Bad Location", (Throwable)badLocationException);
            OS2200CorePlugin.logger.info((Object)"Bad Location", (Throwable)badLocationException);
            return;
        }
        if (iEditorInput instanceof IFileEditorInput) {
            Object object;
            if (this.getTextEditor().isDirty()) {
                try {
                    AbstractMarkerAnnotationModel abstractMarkerAnnotationModel;
                    Position position;
                    AbstractMarkerAnnotationModel abstractMarkerAnnotationModel2 = this.getAnnotationModel();
                    object = PlusLineBreakpoint.lineBreakpointMarkerExists(this.fFileName, this.fLine);
                    if (abstractMarkerAnnotationModel2 != null && object != null && abstractMarkerAnnotationModel2 instanceof AbstractMarkerAnnotationModel && (position = (abstractMarkerAnnotationModel = abstractMarkerAnnotationModel2).getMarkerPosition(object)) != null && !position.isDeleted()) {
                        int n3 = position.getOffset();
                        int n4 = this.fLine;
                        try {
                            this.fLine = this.getDocument().getLineOfOffset(n3) + 1;
                        }
                        catch (BadLocationException badLocationException) {
                            this.fLine = n4;
                        }
                    }
                }
                catch (CoreException coreException) {
                    OS2200CorePlugin.logger.error((Object)"Bad Location", (Throwable)coreException);
                    OS2200CorePlugin.logger.info((Object)"Bad Location", (Throwable)coreException);
                }
            }
            IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
            this.fFileName = iFile.getFullPath().toOSString();
            if (iFile != null) {
                this.fResource = iFile;
                this.fProjectResource = this.fResource.getProject();
                object = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                        try {
                            if (!PlusLineBreakpoint.lineBreakpointExists(PlusBreakpointRulerAction.this.fFileName, PlusBreakpointRulerAction.this.fLine)) {
                                HashMap hashMap = new HashMap(10);
                                new PlusLineBreakpoint(PlusBreakpointRulerAction.this.fResource, PlusBreakpointRulerAction.this.fLine, PlusBreakpointRulerAction.this.fStartChar, PlusBreakpointRulerAction.this.fEndChar, true, hashMap);
                            }
                        }
                        catch (CoreException coreException) {
                            OS2200CorePlugin.logger.error((Object)"UnisysInternalError", (Throwable)coreException);
                            OS2200CorePlugin.logger.info((Object)"Error Creating Plus Breakpoint", (Throwable)coreException);
                        }
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)object, null);
                }
                catch (CoreException coreException) {
                    OS2200CorePlugin.logger.error((Object)"UnisysInternalError", (Throwable)coreException);
                    OS2200CorePlugin.logger.info((Object)"Error Creating Plus Breakpoint", (Throwable)coreException);
                }
            }
        }
    }
}

