/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.plus.editor;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.plus.editor.HTML2TextReader;
import com.unisys.tde.plus.editor.LineBreakingReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class HTMLTextPresenter
implements DefaultInformationControl.IInformationPresenter {
    private static final String LINE_DELIM = System.getProperty("line.separator", "\n");
    private int fCounter;
    private boolean fEnforceUpperLineLimit;

    public HTMLTextPresenter(boolean bl) {
        this.fEnforceUpperLineLimit = bl;
    }

    public HTMLTextPresenter() {
        this(true);
    }

    protected Reader createReader(String string, TextPresentation textPresentation) {
        return new HTML2TextReader(new StringReader(string), textPresentation);
    }

    protected void adaptTextPresentation(TextPresentation textPresentation, int n, int n2) {
        int n3 = n;
        int n4 = n + n2 - 1;
        n4 = Math.max(n3, n4);
        Iterator iterator = textPresentation.getAllStyleRangeIterator();
        while (iterator.hasNext()) {
            StyleRange styleRange = (StyleRange)iterator.next();
            int n5 = styleRange.start;
            int n6 = styleRange.start + styleRange.length - 1;
            if ((n6 = Math.max(n5, n6)) < n3) continue;
            if (n5 < n3) {
                styleRange.length += n2;
                continue;
            }
            styleRange.start += n2;
        }
    }

    private void append(StringBuffer stringBuffer, String string, TextPresentation textPresentation) {
        int n = string.length();
        stringBuffer.append(string);
        if (textPresentation != null) {
            this.adaptTextPresentation(textPresentation, this.fCounter, n);
        }
        this.fCounter += n;
    }

    private String getIndent(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n && Character.isWhitespace(string.charAt(n2))) {
            ++n2;
        }
        return String.valueOf(n2 == n ? string : string.substring(0, n2)) + " ";
    }

    public String updatePresentation(Display display, String string, TextPresentation textPresentation, int n, int n2) {
        if (string == null) {
            return null;
        }
        GC gC = new GC((Drawable)display);
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = Math.round(n2 / gC.getFontMetrics().getHeight());
            this.fCounter = 0;
            LineBreakingReader lineBreakingReader = new LineBreakingReader(this.createReader(string, textPresentation), gC, n);
            boolean bl = false;
            String string2 = null;
            String string3 = lineBreakingReader.readLine();
            boolean bl2 = lineBreakingReader.isFormattedLine();
            boolean bl3 = false;
            while (string3 != null) {
                if (this.fEnforceUpperLineLimit && n3 <= 0) break;
                if (bl3) {
                    if (!bl) {
                        this.append(stringBuffer, LINE_DELIM, null);
                    } else {
                        this.append(stringBuffer, LINE_DELIM, textPresentation);
                        if (string2 != null) {
                            this.append(stringBuffer, string2, textPresentation);
                        }
                    }
                }
                this.append(stringBuffer, string3, null);
                bl3 = true;
                bl = bl2;
                if (!bl2) {
                    string2 = null;
                } else if (string2 == null) {
                    string2 = this.getIndent(string3);
                }
                string3 = lineBreakingReader.readLine();
                bl2 = lineBreakingReader.isFormattedLine();
                --n3;
            }
            if (string3 != null) {
                this.append(stringBuffer, LINE_DELIM, (TextPresentation)(bl2 ? textPresentation : null));
                this.append(stringBuffer, Messages.getString((String)"HTMLTextPresenter.ellipsis1"), textPresentation);
            }
            String string4 = this.trim(stringBuffer, textPresentation);
            return string4;
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            gC.dispose();
        }
    }

    private String trim(StringBuffer stringBuffer, TextPresentation textPresentation) {
        int n = stringBuffer.length();
        int n2 = n - 1;
        while (n2 >= 0 && Character.isWhitespace(stringBuffer.charAt(n2))) {
            --n2;
        }
        if (n2 == -1) {
            return "";
        }
        if (n2 < n - 1) {
            stringBuffer.delete(n2 + 1, n);
        } else {
            n2 = n;
        }
        int n3 = 0;
        while (n3 < n2 && Character.isWhitespace(stringBuffer.charAt(n3))) {
            ++n3;
        }
        stringBuffer.delete(0, n3);
        textPresentation.setResultWindow((IRegion)new Region(n3, stringBuffer.length()));
        return stringBuffer.toString();
    }
}

