/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_reset")
class Reset
extends TextBuiltin {
    @Option(name="--soft", usage="usage_resetSoft")
    private boolean soft = false;
    @Option(name="--mixed", usage="usage_resetMixed")
    private boolean mixed = false;
    @Option(name="--hard", usage="usage_resetHard")
    private boolean hard = false;
    @Argument(required=true, metaVar="metaVar_name", usage="usage_reset")
    private String commit;

    Reset() {
    }

    protected void run() throws Exception {
        ResetCommand command = new Git(this.db).reset();
        command.setRef(this.commit);
        ResetCommand.ResetType mode = null;
        if (this.soft) {
            mode = Reset.selectMode(mode, ResetCommand.ResetType.SOFT);
        }
        if (this.mixed) {
            mode = Reset.selectMode(mode, ResetCommand.ResetType.MIXED);
        }
        if (this.hard) {
            mode = Reset.selectMode(mode, ResetCommand.ResetType.HARD);
        }
        if (mode == null) {
            throw Reset.die("no reset mode set");
        }
        command.setMode(mode);
        command.call();
    }

    private static ResetCommand.ResetType selectMode(ResetCommand.ResetType mode, ResetCommand.ResetType want) {
        if (mode != null) {
            throw Reset.die("reset modes are mutually exclusive, select one");
        }
        return want;
    }
}

