/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.source;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jpt.common.core.internal.resource.java.AttributeKey;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAbstractType;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceEnum;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceField;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceMethod;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.JDTType;
import org.eclipse.jpt.common.core.internal.utility.jdt.JavaResourceTypeBinding;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.jdt.Type;
import org.eclipse.jpt.common.core.utility.jdt.TypeBinding;
import org.eclipse.jpt.common.utility.MethodSignature;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.reference.SimpleIntReference;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SourceType
extends SourceAbstractType<Type>
implements JavaResourceType {
    private String superclassQualifiedName;
    private boolean abstract_;
    private boolean hasNoArgConstructor;
    private boolean hasPrivateNoArgConstructor;
    private final Vector<JavaResourceType> types = new Vector();
    private final Vector<JavaResourceEnum> enums = new Vector();
    private final Vector<JavaResourceField> fields = new Vector();
    private final Vector<JavaResourceMethod> methods = new Vector();
    private final Map<AttributeKey, JavaResourceTypeBinding> inheritedFieldTypes = new Hashtable<AttributeKey, JavaResourceTypeBinding>();
    private final Map<AttributeKey, JavaResourceTypeBinding> inheritedMethodTypes = new Hashtable<AttributeKey, JavaResourceTypeBinding>();
    private static final Transformer<JavaResourceType, Iterable<? extends JavaResourceType>> TYPES_TRANSFORMER = new TypesTransformer();

    static JavaResourceType newInstance(JavaResourceCompilationUnit javaResourceCompilationUnit, TypeDeclaration typeDeclaration) {
        JDTType type = new JDTType(typeDeclaration, javaResourceCompilationUnit.getCompilationUnit(), javaResourceCompilationUnit.getModifySharedDocumentCommandContext(), javaResourceCompilationUnit.getAnnotationEditFormatter());
        SourceType jrpt = new SourceType(javaResourceCompilationUnit, type);
        jrpt.initialize(typeDeclaration);
        return jrpt;
    }

    private static JavaResourceType newInstance(JavaResourceCompilationUnit javaResourceCompilationUnit, Type declaringType, TypeDeclaration typeDeclaration, int occurrence) {
        JDTType type = new JDTType(declaringType, typeDeclaration, occurrence, javaResourceCompilationUnit.getCompilationUnit(), javaResourceCompilationUnit.getModifySharedDocumentCommandContext(), javaResourceCompilationUnit.getAnnotationEditFormatter());
        SourceType jrpt = new SourceType(javaResourceCompilationUnit, type);
        jrpt.initialize(typeDeclaration);
        return jrpt;
    }

    private SourceType(JavaResourceCompilationUnit javaResourceCompilationUnit, Type type) {
        super(javaResourceCompilationUnit, type);
    }

    protected void initialize(TypeDeclaration typeDeclaration) {
        super.initialize((AbstractTypeDeclaration)typeDeclaration);
        this.initializeTypes(typeDeclaration);
        this.initializeEnums(typeDeclaration);
        this.initializeFields(typeDeclaration);
        this.initializeMethods(typeDeclaration);
    }

    @Override
    protected void initialize(ITypeBinding typeBinding) {
        super.initialize(typeBinding);
        this.superclassQualifiedName = this.buildSuperclassQualifiedName(typeBinding);
        this.abstract_ = this.buildAbstract(typeBinding);
        this.hasNoArgConstructor = this.buildHasNoArgConstructor(typeBinding);
        this.hasPrivateNoArgConstructor = this.buildHasPrivateNoArgConstructor(typeBinding);
        this.initInheritedFieldTypes(typeBinding);
        this.initInheritedMethodTypes(typeBinding);
    }

    @Override
    public void synchronizeWith(TypeDeclaration typeDeclaration) {
        super.synchronizeWith((AbstractTypeDeclaration)typeDeclaration);
        this.syncTypes(typeDeclaration);
        this.syncEnums(typeDeclaration);
        this.syncFields(typeDeclaration);
        this.syncMethods(typeDeclaration);
    }

    @Override
    protected void synchronizeWith(ITypeBinding typeBinding) {
        super.synchronizeWith(typeBinding);
        this.syncSuperclassQualifiedName(this.buildSuperclassQualifiedName(typeBinding));
        this.syncAbstract(this.buildAbstract(typeBinding));
        this.syncHasNoArgConstructor(this.buildHasNoArgConstructor(typeBinding));
        this.syncHasPrivateNoArgConstructor(this.buildHasPrivateNoArgConstructor(typeBinding));
        this.syncInheritedFieldTypes(typeBinding);
        this.syncInheritedMethodTypes(typeBinding);
    }

    @Override
    public void resolveTypes(TypeDeclaration typeDeclaration) {
        this.syncSuperclassQualifiedName(this.buildSuperclassQualifiedName(typeDeclaration.resolveBinding()));
        FieldDeclaration[] fieldDeclarations = typeDeclaration.getFields();
        CounterMap counters = new CounterMap(fieldDeclarations.length);
        HashSet<JavaResourceField> remainingFields = new HashSet<JavaResourceField>(this.fields);
        FieldDeclaration[] fieldDeclarationArray = fieldDeclarations;
        int n = fieldDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            for (VariableDeclarationFragment fragment : SourceType.fragments(fieldDeclaration)) {
                String fieldName = fragment.getName().getFullyQualifiedName();
                int occurrence = counters.increment(fieldName);
                JavaResourceField field = SourceType.getField(remainingFields, fieldName, occurrence);
                field.resolveTypes(fieldDeclaration, fragment);
                remainingFields.remove(field);
            }
            ++n2;
        }
        this.syncMethods(typeDeclaration);
        TypeDeclaration[] typeDeclarations = typeDeclaration.getTypes();
        int i = 0;
        for (JavaResourceType type : this.getTypes()) {
            type.resolveTypes(typeDeclarations[i++]);
        }
        EnumDeclaration[] enumDeclarations = SourceType.enums(typeDeclaration);
        i = 0;
        for (JavaResourceEnum enum_ : this.getEnums()) {
            enum_.resolveTypes(enumDeclarations[i++]);
        }
    }

    @Override
    public JavaResourceAnnotatedElement.AstNodeType getAstNodeType() {
        return JavaResourceAnnotatedElement.AstNodeType.TYPE;
    }

    @Override
    public String getSuperclassQualifiedName() {
        return this.superclassQualifiedName;
    }

    private void syncSuperclassQualifiedName(String astSuperclassQualifiedName) {
        String old = this.superclassQualifiedName;
        this.superclassQualifiedName = astSuperclassQualifiedName;
        this.firePropertyChanged("superclassQualifiedName", old, astSuperclassQualifiedName);
    }

    private String buildSuperclassQualifiedName(ITypeBinding binding) {
        ITypeBinding superclass = binding == null ? null : binding.getSuperclass();
        return superclass == null ? null : superclass.getTypeDeclaration().getQualifiedName();
    }

    @Override
    public boolean isAbstract() {
        return this.abstract_;
    }

    private void syncAbstract(boolean astAbstract) {
        boolean old = this.abstract_;
        this.abstract_ = astAbstract;
        this.firePropertyChanged("abstract", old, astAbstract);
    }

    private boolean buildAbstract(ITypeBinding binding) {
        return binding == null ? false : Modifier.isAbstract((int)binding.getModifiers());
    }

    @Override
    public boolean hasNoArgConstructor() {
        return this.hasNoArgConstructor;
    }

    private void syncHasNoArgConstructor(boolean astHasNoArgConstructor) {
        boolean old = this.hasNoArgConstructor;
        this.hasNoArgConstructor = astHasNoArgConstructor;
        this.firePropertyChanged("noArgConstructor", old, astHasNoArgConstructor);
    }

    private boolean buildHasNoArgConstructor(ITypeBinding binding) {
        return binding == null ? false : SourceType.typeHasNoArgConstructor(binding);
    }

    protected static boolean typeHasNoArgConstructor(ITypeBinding binding) {
        return SourceType.findNoArgConstructor(binding) != null;
    }

    protected static IMethodBinding findNoArgConstructor(ITypeBinding binding) {
        IMethodBinding[] iMethodBindingArray = binding.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding method = iMethodBindingArray[n2];
            if (method.isConstructor() && method.getParameterTypes().length == 0) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public boolean hasPrivateNoArgConstructor() {
        return this.hasPrivateNoArgConstructor;
    }

    private void syncHasPrivateNoArgConstructor(boolean astHasPrivateNoArgConstructor) {
        boolean old = this.hasPrivateNoArgConstructor;
        this.hasPrivateNoArgConstructor = astHasPrivateNoArgConstructor;
        this.firePropertyChanged("privateNoArgConstructor", old, astHasPrivateNoArgConstructor);
    }

    private boolean buildHasPrivateNoArgConstructor(ITypeBinding binding) {
        return binding == null ? false : SourceType.typeHasPrivateNoArgConstructor(binding);
    }

    protected static boolean typeHasPrivateNoArgConstructor(ITypeBinding binding) {
        IMethodBinding method = SourceType.findNoArgConstructor(binding);
        return method != null && Modifier.isPrivate((int)method.getModifiers());
    }

    @Override
    public boolean hasPublicOrProtectedNoArgConstructor() {
        Iterable<JavaResourceMethod> constructors = this.getConstructors();
        if (IterableTools.size(constructors) == 0) {
            return true;
        }
        for (JavaResourceMethod constructor : constructors) {
            if (constructor.getParametersSize() != 0) continue;
            return Modifier.isPublic((int)constructor.getModifiers()) || Modifier.isProtected((int)constructor.getModifiers());
        }
        return false;
    }

    @Override
    public boolean hasPublicNoArgConstructor() {
        Iterable<JavaResourceMethod> constructors = this.getConstructors();
        if (IterableTools.size(constructors) == 0) {
            return true;
        }
        for (JavaResourceMethod constructor : constructors) {
            if (constructor.getParametersSize() != 0) continue;
            return Modifier.isPublic((int)constructor.getModifiers());
        }
        return false;
    }

    protected Iterable<JavaResourceMethod> getConstructors() {
        return IterableTools.filter(this.getMethods(), JavaResourceMethod.IS_CONSTRUCTOR);
    }

    @Override
    public Iterable<JavaResourceType> getTypes() {
        return IterableTools.cloneLive(this.types);
    }

    @Override
    public Iterable<JavaResourceType> getAllTypes() {
        return ObjectTools.tree((Object)this, TYPES_TRANSFORMER);
    }

    private JavaResourceType getType(String typeName, int occurrence) {
        for (JavaResourceType type : this.getTypes()) {
            if (!type.isFor(typeName, occurrence)) continue;
            return type;
        }
        return null;
    }

    private void addType(JavaResourceType type) {
        this.addItemToCollection(type, this.types, "types");
    }

    private void removeTypes(Collection<JavaResourceType> remove) {
        this.removeItemsFromCollection(remove, this.types, "types");
    }

    private void initializeTypes(TypeDeclaration typeDeclaration) {
        TypeDeclaration[] typeDeclarations = typeDeclaration.getTypes();
        CounterMap counters = new CounterMap(typeDeclarations.length);
        TypeDeclaration[] typeDeclarationArray = typeDeclarations;
        int n = typeDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDeclaration nestedTypeDeclaration = typeDeclarationArray[n2];
            String tdName = nestedTypeDeclaration.getName().getFullyQualifiedName();
            int occurrence = counters.increment(tdName);
            this.types.add(this.buildType(nestedTypeDeclaration, occurrence));
            ++n2;
        }
    }

    private void syncTypes(TypeDeclaration typeDeclaration) {
        TypeDeclaration[] typeDeclarations = typeDeclaration.getTypes();
        CounterMap counters = new CounterMap(typeDeclarations.length);
        HashSet<JavaResourceType> typesToRemove = new HashSet<JavaResourceType>(this.types);
        TypeDeclaration[] typeDeclarationArray = typeDeclarations;
        int n = typeDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            int occurrence;
            TypeDeclaration nestedTypeDeclaration = typeDeclarationArray[n2];
            String tdName = nestedTypeDeclaration.getName().getFullyQualifiedName();
            JavaResourceType type = this.getType(tdName, occurrence = counters.increment(tdName));
            if (type == null) {
                this.addType(this.buildType(nestedTypeDeclaration, occurrence));
            } else {
                typesToRemove.remove(type);
                type.synchronizeWith(nestedTypeDeclaration);
            }
            ++n2;
        }
        this.removeTypes(typesToRemove);
    }

    private JavaResourceType buildType(TypeDeclaration nestedTypeDeclaration, int occurrence) {
        return SourceType.newInstance(this.getJavaResourceCompilationUnit(), (Type)this.annotatedElement, nestedTypeDeclaration, occurrence);
    }

    @Override
    public Iterable<JavaResourceEnum> getEnums() {
        return IterableTools.cloneLive(this.enums);
    }

    @Override
    public Iterable<JavaResourceEnum> getAllEnums() {
        return this.getEnums();
    }

    private JavaResourceEnum getEnum(String enumName, int occurrence) {
        for (JavaResourceEnum enum_ : this.getEnums()) {
            if (!enum_.isFor(enumName, occurrence)) continue;
            return enum_;
        }
        return null;
    }

    private void addEnum(JavaResourceEnum enum_) {
        this.addItemToCollection(enum_, this.enums, "enums");
    }

    private void removeEnums(Collection<JavaResourceEnum> remove) {
        this.removeItemsFromCollection(remove, this.enums, "enums");
    }

    private void initializeEnums(TypeDeclaration typeDeclaration) {
        EnumDeclaration[] enumDeclarations = SourceType.enums(typeDeclaration);
        CounterMap counters = new CounterMap(enumDeclarations.length);
        EnumDeclaration[] enumDeclarationArray = enumDeclarations;
        int n = enumDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            EnumDeclaration ed = enumDeclarationArray[n2];
            String tdName = ed.getName().getFullyQualifiedName();
            int occurrence = counters.increment(tdName);
            this.enums.add(this.buildEnum(ed, occurrence));
            ++n2;
        }
    }

    private void syncEnums(TypeDeclaration typeDeclaration) {
        EnumDeclaration[] enumDeclarations = SourceType.enums(typeDeclaration);
        CounterMap counters = new CounterMap(enumDeclarations.length);
        HashSet<JavaResourceEnum> enumsToRemove = new HashSet<JavaResourceEnum>(this.enums);
        EnumDeclaration[] enumDeclarationArray = enumDeclarations;
        int n = enumDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            int occurrence;
            EnumDeclaration enumDeclaration = enumDeclarationArray[n2];
            String tdName = enumDeclaration.getName().getFullyQualifiedName();
            JavaResourceEnum enum_ = this.getEnum(tdName, occurrence = counters.increment(tdName));
            if (enum_ == null) {
                this.addEnum(this.buildEnum(enumDeclaration, occurrence));
            } else {
                enumsToRemove.remove(enum_);
                enum_.synchronizeWith(enumDeclaration);
            }
            ++n2;
        }
        this.removeEnums(enumsToRemove);
    }

    private JavaResourceEnum buildEnum(EnumDeclaration nestedEnumDeclaration, int occurrence) {
        return SourceEnum.newInstance(this.getJavaResourceCompilationUnit(), (Type)this.annotatedElement, nestedEnumDeclaration, occurrence);
    }

    @Override
    public Iterable<JavaResourceField> getFields() {
        return IterableTools.cloneLive(this.fields);
    }

    private void addField(JavaResourceField field) {
        this.addItemToCollection(field, this.fields, "fields");
    }

    private static JavaResourceField getField(Collection<JavaResourceField> fields, String fieldName, int occurrence) {
        for (JavaResourceField field : fields) {
            if (!field.isFor(fieldName, occurrence)) continue;
            return field;
        }
        return null;
    }

    private void removeFields(Collection<JavaResourceField> remove) {
        this.removeItemsFromCollection(remove, this.fields, "fields");
    }

    private void initializeFields(TypeDeclaration typeDeclaration) {
        FieldDeclaration[] fieldDeclarations = typeDeclaration.getFields();
        CounterMap counters = new CounterMap(fieldDeclarations.length);
        FieldDeclaration[] fieldDeclarationArray = fieldDeclarations;
        int n = fieldDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            for (VariableDeclarationFragment fragment : SourceType.fragments(fieldDeclaration)) {
                String fieldName = fragment.getName().getFullyQualifiedName();
                int occurrence = counters.increment(fieldName);
                this.fields.add(this.buildField(fieldName, occurrence, fieldDeclaration, fragment));
            }
            ++n2;
        }
    }

    private void syncFields(TypeDeclaration typeDeclaration) {
        FieldDeclaration[] fieldDeclarations = typeDeclaration.getFields();
        CounterMap counters = new CounterMap(fieldDeclarations.length);
        HashSet<JavaResourceField> fieldsToRemove = new HashSet<JavaResourceField>(this.fields);
        FieldDeclaration[] fieldDeclarationArray = fieldDeclarations;
        int n = fieldDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            for (VariableDeclarationFragment fragment : SourceType.fragments(fieldDeclaration)) {
                int occurrence;
                String fieldName = fragment.getName().getFullyQualifiedName();
                JavaResourceField field = SourceType.getField(fieldsToRemove, fieldName, occurrence = counters.increment(fieldName));
                if (field == null) {
                    this.addField(this.buildField(fieldName, occurrence, fieldDeclaration, fragment));
                    continue;
                }
                fieldsToRemove.remove(field);
                field.synchronizeWith(fieldDeclaration, fragment);
            }
            ++n2;
        }
        this.removeFields(fieldsToRemove);
    }

    private JavaResourceField buildField(String fieldName, int occurrence, FieldDeclaration fieldDeclaration, VariableDeclarationFragment variableDeclaration) {
        return SourceField.newInstance(this, (Type)this.annotatedElement, fieldName, occurrence, this.getJavaResourceCompilationUnit(), fieldDeclaration, variableDeclaration);
    }

    @Override
    public JavaResourceField getField(String name) {
        for (JavaResourceField field : this.getFields()) {
            if (!ObjectTools.equals((Object)field.getName(), (Object)name)) continue;
            return field;
        }
        return null;
    }

    private static List<VariableDeclarationFragment> fragments(FieldDeclaration fd) {
        return fd.fragments();
    }

    @Override
    public Iterable<JavaResourceMethod> getMethods() {
        return IterableTools.cloneLive(this.methods);
    }

    private static JavaResourceMethod getMethod(Collection<JavaResourceMethod> methods, MethodSignature signature, int occurrence) {
        for (JavaResourceMethod method : methods) {
            if (!method.isFor(signature, occurrence)) continue;
            return method;
        }
        return null;
    }

    private void addMethod(JavaResourceMethod method) {
        this.addItemToCollection(method, this.methods, "methods");
    }

    private void removeMethods(Collection<JavaResourceMethod> remove) {
        this.removeItemsFromCollection(remove, this.methods, "methods");
    }

    private void initializeMethods(TypeDeclaration typeDeclaration) {
        MethodDeclaration[] methodDeclarations = typeDeclaration.getMethods();
        CounterMap counters = new CounterMap(methodDeclarations.length);
        MethodDeclaration[] methodDeclarationArray = methodDeclarations;
        int n = methodDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            MethodSignature signature = ASTTools.buildMethodSignature(methodDeclaration);
            int occurrence = counters.increment(signature);
            this.methods.add(this.buildMethod(signature, occurrence, methodDeclaration));
            ++n2;
        }
    }

    private void syncMethods(TypeDeclaration typeDeclaration) {
        MethodDeclaration[] methodDeclarations = typeDeclaration.getMethods();
        CounterMap counters = new CounterMap(methodDeclarations.length);
        HashSet<JavaResourceMethod> methodsToRemove = new HashSet<JavaResourceMethod>(this.methods);
        MethodDeclaration[] methodDeclarationArray = methodDeclarations;
        int n = methodDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            int occurrence;
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            MethodSignature signature = ASTTools.buildMethodSignature(methodDeclaration);
            JavaResourceMethod method = SourceType.getMethod(methodsToRemove, signature, occurrence = counters.increment(signature));
            if (method == null) {
                this.addMethod(this.buildMethod(signature, occurrence, methodDeclaration));
            } else {
                methodsToRemove.remove(method);
                method.synchronizeWith(methodDeclaration);
            }
            ++n2;
        }
        this.removeMethods(methodsToRemove);
    }

    private JavaResourceMethod buildMethod(MethodSignature signature, int occurrence, MethodDeclaration methodDeclaration) {
        return SourceMethod.newInstance(this, (Type)this.annotatedElement, signature, occurrence, this.getJavaResourceCompilationUnit(), methodDeclaration);
    }

    @Override
    public JavaResourceMethod getMethod(String propertyName) {
        for (JavaResourceMethod method : this.getMethods()) {
            if (!ObjectTools.equals((Object)method.getMethodName(), (Object)propertyName)) continue;
            return method;
        }
        return null;
    }

    @Override
    public boolean hasAnyAnnotatedFields() {
        for (JavaResourceField field : this.getFields()) {
            if (!field.isAnnotated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAnyAnnotatedMethods() {
        for (JavaResourceMethod method : this.getMethods()) {
            if (!method.isAnnotated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasEqualsMethod() {
        for (JavaResourceMethod method : this.getMethods()) {
            if (!ObjectTools.equals((Object)method.getMethodName(), (Object)"equals") || method.getParametersSize() != 1 || !ObjectTools.equals((Object)method.getParameterTypeName(0), (Object)Object.class.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasHashCodeMethod() {
        for (JavaResourceMethod method : this.getMethods()) {
            if (!ObjectTools.equals((Object)method.getMethodName(), (Object)"hashCode") || method.getParametersSize() != 0) continue;
            return true;
        }
        return false;
    }

    private void initInheritedFieldTypes(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return;
        }
        ITypeBinding scTypeBinding = typeBinding.getSuperclass();
        while (scTypeBinding != null && scTypeBinding.isParameterizedType()) {
            this.initInheritedFieldTypes_(scTypeBinding);
            scTypeBinding = scTypeBinding.getSuperclass();
        }
    }

    private void initInheritedFieldTypes_(ITypeBinding typeBinding) {
        String typeName = typeBinding.getTypeDeclaration().getQualifiedName();
        IVariableBinding[] astFields = typeBinding.getDeclaredFields();
        CounterMap counters = new CounterMap(astFields.length);
        IVariableBinding[] iVariableBindingArray = astFields;
        int n = astFields.length;
        int n2 = 0;
        while (n2 < n) {
            IVariableBinding astField = iVariableBindingArray[n2];
            String fieldName = astField.getName();
            int occurrence = counters.increment(fieldName);
            if (occurrence == 1) {
                this.inheritedFieldTypes.put(new AttributeKey(typeName, fieldName), new JavaResourceTypeBinding(astField.getType()));
            }
            ++n2;
        }
    }

    private void syncInheritedFieldTypes(ITypeBinding typeBinding) {
        ITypeBinding scTypeBinding = typeBinding == null ? null : typeBinding.getSuperclass();
        HashMap<AttributeKey, JavaResourceTypeBinding> removedTypes = new HashMap<AttributeKey, JavaResourceTypeBinding>(this.inheritedFieldTypes);
        while (scTypeBinding != null && scTypeBinding.isParameterizedType()) {
            this.syncInheritedFieldTypes_(scTypeBinding, removedTypes);
            scTypeBinding = scTypeBinding.getSuperclass();
        }
        for (AttributeKey removedTypeKey : removedTypes.keySet()) {
            this.inheritedFieldTypes.remove(removedTypeKey);
        }
    }

    private void syncInheritedFieldTypes_(ITypeBinding typeBinding, Map<AttributeKey, JavaResourceTypeBinding> removedTypes) {
        String typeName = typeBinding.getTypeDeclaration().getQualifiedName();
        IVariableBinding[] astFields = typeBinding.getDeclaredFields();
        CounterMap counters = new CounterMap(astFields.length);
        IVariableBinding[] iVariableBindingArray = astFields;
        int n = astFields.length;
        int n2 = 0;
        while (n2 < n) {
            IVariableBinding astField = iVariableBindingArray[n2];
            String fieldName = astField.getName();
            int occurrence = counters.increment(fieldName);
            if (occurrence == 1) {
                AttributeKey key = new AttributeKey(typeName, fieldName);
                this.inheritedFieldTypes.put(key, new JavaResourceTypeBinding(astField.getType()));
                removedTypes.remove(key);
            }
            ++n2;
        }
    }

    private void initInheritedMethodTypes(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return;
        }
        ITypeBinding scTypeBinding = typeBinding.getSuperclass();
        while (scTypeBinding != null && scTypeBinding.isParameterizedType()) {
            this.initInheritedMethodTypes_(scTypeBinding);
            scTypeBinding = scTypeBinding.getSuperclass();
        }
    }

    private void initInheritedMethodTypes_(ITypeBinding typeBinding) {
        String typeName = typeBinding.getTypeDeclaration().getQualifiedName();
        IMethodBinding[] astMethods = typeBinding.getDeclaredMethods();
        CounterMap counters = new CounterMap(astMethods.length);
        IMethodBinding[] iMethodBindingArray = astMethods;
        int n = astMethods.length;
        int n2 = 0;
        while (n2 < n) {
            String methodName;
            int occurrence;
            IMethodBinding astMethod = iMethodBindingArray[n2];
            if (astMethod.getParameterTypes().length == 0 && (occurrence = counters.increment(methodName = astMethod.getName())) == 1) {
                this.inheritedMethodTypes.put(new AttributeKey(typeName, methodName), new JavaResourceTypeBinding(astMethod.getReturnType()));
            }
            ++n2;
        }
    }

    private void syncInheritedMethodTypes(ITypeBinding typeBinding) {
        ITypeBinding scTypeBinding = typeBinding == null ? null : typeBinding.getSuperclass();
        HashMap<AttributeKey, JavaResourceTypeBinding> removedTypes = new HashMap<AttributeKey, JavaResourceTypeBinding>(this.inheritedMethodTypes);
        while (scTypeBinding != null && scTypeBinding.isParameterizedType()) {
            this.syncInheritedMethodTypes_(scTypeBinding, removedTypes);
            scTypeBinding = scTypeBinding.getSuperclass();
        }
        for (AttributeKey removedTypeKey : removedTypes.keySet()) {
            this.inheritedMethodTypes.remove(removedTypeKey);
        }
    }

    private void syncInheritedMethodTypes_(ITypeBinding typeBinding, Map<AttributeKey, JavaResourceTypeBinding> removedTypes) {
        String typeName = typeBinding.getTypeDeclaration().getQualifiedName();
        IMethodBinding[] astMethods = typeBinding.getDeclaredMethods();
        CounterMap counters = new CounterMap(astMethods.length);
        IMethodBinding[] iMethodBindingArray = astMethods;
        int n = astMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding astMethod = iMethodBindingArray[n2];
            String methodName = astMethod.getName();
            int occurrence = counters.increment(methodName);
            if (occurrence == 1) {
                AttributeKey key = new AttributeKey(typeName, methodName);
                this.inheritedMethodTypes.put(key, new JavaResourceTypeBinding(astMethod.getReturnType()));
                removedTypes.remove(key);
            }
            ++n2;
        }
    }

    @Override
    public TypeBinding getAttributeTypeBinding(JavaResourceAttribute attribute) {
        if (attribute.getParent() == this) {
            return attribute.getTypeBinding();
        }
        AttributeKey key = new AttributeKey(attribute.getParent().getTypeBinding().getQualifiedName(), attribute.getName());
        if (attribute.getAstNodeType() == JavaResourceAnnotatedElement.AstNodeType.FIELD) {
            return this.inheritedFieldTypes.get(key);
        }
        return this.inheritedMethodTypes.get(key);
    }

    public TypeDeclaration[] getTypes(TypeDeclaration typeDeclaration) {
        return typeDeclaration.getTypes();
    }

    public EnumDeclaration[] getEnums(TypeDeclaration typeDeclaration) {
        return SourceType.enums(typeDeclaration);
    }

    public FieldDeclaration[] getFields(TypeDeclaration typeDeclaration) {
        return typeDeclaration.getFields();
    }

    public MethodDeclaration[] getMethods(TypeDeclaration typeDeclaration) {
        return typeDeclaration.getMethods();
    }

    protected static EnumDeclaration[] enums(TypeDeclaration declaringTypeDeclaration) {
        List<BodyDeclaration> bd = SourceType.bodyDeclarations(declaringTypeDeclaration);
        int typeCount = 0;
        ListIterator<BodyDeclaration> it = bd.listIterator();
        while (it.hasNext()) {
            if (((BodyDeclaration)it.next()).getNodeType() != 71) continue;
            ++typeCount;
        }
        EnumDeclaration[] memberEnums = new EnumDeclaration[typeCount];
        int next = 0;
        ListIterator<BodyDeclaration> it2 = bd.listIterator();
        while (it2.hasNext()) {
            BodyDeclaration decl = (BodyDeclaration)it2.next();
            if (decl.getNodeType() != 71) continue;
            memberEnums[next++] = (EnumDeclaration)decl;
        }
        return memberEnums;
    }

    protected static List<BodyDeclaration> bodyDeclarations(TypeDeclaration typeDeclaration) {
        return typeDeclaration.bodyDeclarations();
    }

    protected static class CounterMap {
        private final HashMap<Object, SimpleIntReference> counters;

        protected CounterMap(int initialCapacity) {
            this.counters = new HashMap(initialCapacity);
        }

        int increment(Object o) {
            SimpleIntReference counter = this.counters.get(o);
            if (counter == null) {
                counter = new SimpleIntReference();
                this.counters.put(o, counter);
            }
            counter.increment();
            return counter.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TypesTransformer
    extends TransformerAdapter<JavaResourceType, Iterable<? extends JavaResourceType>> {
        TypesTransformer() {
        }

        public Iterable<? extends JavaResourceType> transform(JavaResourceType type) {
            return type.getTypes();
        }
    }
}

