/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java.hover;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.wst.jsdt.core.ICodeAssist;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.wst.jsdt.internal.ui.text.JavaWordFinder;
import org.eclipse.wst.jsdt.internal.ui.text.html.HTMLPrinter;
import org.eclipse.wst.jsdt.internal.ui.text.html.HTMLTextPresenter;
import org.eclipse.wst.jsdt.ui.text.java.hover.IJavaEditorTextHover;
import org.osgi.framework.Bundle;

public abstract class AbstractJavaEditorTextHover
implements IJavaEditorTextHover,
ITextHoverExtension {
    private static String fgStyleSheet;
    private IEditorPart fEditor;

    @Override
    public void setEditor(IEditorPart editor) {
        this.fEditor = editor;
    }

    protected IEditorPart getEditor() {
        return this.fEditor;
    }

    protected ICodeAssist getCodeAssist() {
        if (this.fEditor != null) {
            IEditorInput input = this.fEditor.getEditorInput();
            if (input instanceof IClassFileEditorInput) {
                IClassFileEditorInput cfeInput = (IClassFileEditorInput)input;
                return cfeInput.getClassFile();
            }
            WorkingCopyManager manager = JavaScriptPlugin.getDefault().getWorkingCopyManager();
            return manager.getWorkingCopy(input, false);
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return JavaWordFinder.findWord(textViewer.getDocument(), offset);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (hoverRegion.getLength() == 0) {
            return null;
        }
        ICodeAssist resolve = this.getCodeAssist();
        if (resolve != null) {
            IJavaScriptElement[] result;
            block7: {
                block6: {
                    try {
                        result = resolve.codeSelect(hoverRegion.getOffset(), hoverRegion.getLength());
                        if (result != null) break block6;
                        return null;
                    }
                    catch (JavaScriptModelException javaScriptModelException) {
                        return null;
                    }
                }
                int nResults = result.length;
                if (nResults != 0) break block7;
                return null;
            }
            return this.getHoverInfo(result);
        }
        return null;
    }

    protected String getHoverInfo(IJavaScriptElement[] javaElements) {
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), EditorsUI.getTooltipAffordanceString());
            }
        };
    }

    protected static String getStyleSheet() {
        String css;
        if (fgStyleSheet == null) {
            fgStyleSheet = AbstractJavaEditorTextHover.loadStyleSheet();
        }
        if ((css = fgStyleSheet) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.wst.jsdt.ui.javadocfont")[0];
            css = HTMLPrinter.convertTopLevelFont(css, fontData);
        }
        return css;
    }

    private static String loadStyleSheet() {
        Bundle bundle = Platform.getBundle((String)JavaScriptPlugin.getPluginId());
        URL styleSheetURL = bundle.getEntry("/JavadocHoverStyleSheet.css");
        if (styleSheetURL != null) {
            try {
                styleSheetURL = FileLocator.toFileURL((URL)styleSheetURL);
                BufferedReader reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
                StringBuffer buffer = new StringBuffer(200);
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    buffer.append('\n');
                    line = reader.readLine();
                }
                return buffer.toString();
            }
            catch (IOException ex) {
                JavaScriptPlugin.log(ex);
                return "";
            }
        }
        return null;
    }
}

