/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ClassFileEditorInputFactory;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public class InternalClassFileEditorInput
implements IClassFileEditorInput,
IPersistableElement {
    private IClassFile fClassFile;

    public InternalClassFileEditorInput(IClassFile classFile) {
        this.fClassFile = classFile;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InternalClassFileEditorInput)) {
            return false;
        }
        InternalClassFileEditorInput other = (InternalClassFileEditorInput)obj;
        return this.fClassFile.equals(other.fClassFile);
    }

    public int hashCode() {
        return this.fClassFile.hashCode();
    }

    @Override
    public IClassFile getClassFile() {
        return this.fClassFile;
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getName() {
        return this.fClassFile.getDisplayName();
    }

    public String getToolTipText() {
        StringBuffer s = new StringBuffer();
        JavaScriptElementLabels.getElementLabel((IJavaScriptElement)this.fClassFile, JavaScriptElementLabels.ALL_POST_QUALIFIED | 0x80000000000L, s);
        return s.toString();
    }

    public ImageDescriptor getImageDescriptor() {
        try {
            if (this.fClassFile.isClass()) {
                return JavaPluginImages.DESC_OBJS_CFILECLASS;
            }
            return JavaPluginImages.DESC_OBJS_CFILEINT;
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return JavaPluginImages.DESC_OBJS_CFILE;
        }
    }

    public boolean exists() {
        return this.fClassFile.exists();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IClassFile.class) {
            return this.fClassFile;
        }
        if (adapter == IJavaScriptElement.class) {
            return this.fClassFile;
        }
        return null;
    }

    public void saveState(IMemento memento) {
        ClassFileEditorInputFactory.saveState(memento, this);
    }

    public String getFactoryId() {
        return "org.eclipse.wst.jsdt.ui.ClassFileEditorInputFactory";
    }
}

