/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.internal.utility.ValidationMessageTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TableColumn;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNamedColumnValidator<C extends NamedColumn>
implements JpaValidator {
    protected final PersistentAttribute persistentAttribute;
    protected final C column;
    protected final TableDescriptionProvider tableDescriptionProvider;
    protected final JpaValidator tableValidator;

    protected AbstractNamedColumnValidator(C column) {
        this(null, column);
    }

    protected AbstractNamedColumnValidator(C column, TableDescriptionProvider provider) {
        this(null, column, provider);
    }

    protected AbstractNamedColumnValidator(PersistentAttribute persistentAttribute, C column) {
        this(persistentAttribute, column, TableDescriptionProvider.Null.instance());
    }

    protected AbstractNamedColumnValidator(PersistentAttribute persistentAttribute, C column, TableDescriptionProvider tableDescriptionProvider) {
        this.persistentAttribute = persistentAttribute;
        this.column = column;
        this.tableDescriptionProvider = tableDescriptionProvider;
        this.tableValidator = this.buildTableValidator();
    }

    protected JpaValidator buildTableValidator() {
        return new ExistenceTableValidator();
    }

    @Override
    public final boolean validate(List<IMessage> messages, IReporter reporter) {
        if (this.tableValidator.validate(messages, reporter)) {
            this.validateName(messages);
        }
        return true;
    }

    protected void validateName(List<IMessage> messages) {
        Table dbTable = this.column.getDbTable();
        if (dbTable != null && !this.column.isResolved()) {
            messages.add(this.buildUnresolvedNameMessage());
        }
    }

    protected IMessage buildUnresolvedNameMessage() {
        return this.columnIsPartOfVirtualAttribute() ? this.buildVirtualAttributeUnresolvedNameMessage() : this.buildUnresolvedNameMessage(this.getUnresolvedNameMessage());
    }

    protected IMessage buildUnresolvedNameMessage(ValidationMessage message) {
        return ValidationMessageTools.buildValidationMessage((IResource)this.column.getResource(), (TextRange)this.column.getNameValidationTextRange(), (ValidationMessage)message, (Object[])new Object[]{this.column.getName(), this.column.getDbTable().getName()});
    }

    protected abstract ValidationMessage getUnresolvedNameMessage();

    protected IMessage buildVirtualAttributeUnresolvedNameMessage() {
        return ValidationMessageTools.buildValidationMessage((IResource)this.column.getResource(), (TextRange)this.getVirtualAttributeTextRange(), (ValidationMessage)this.getVirtualAttributeUnresolvedNameMessage(), (Object[])new Object[]{this.persistentAttribute.getName(), this.column.getName(), this.column.getDbTable().getName()});
    }

    protected abstract ValidationMessage getVirtualAttributeUnresolvedNameMessage();

    protected boolean columnIsPartOfVirtualAttribute() {
        return this.persistentAttribute != null && this.persistentAttribute.isVirtual();
    }

    protected TextRange getVirtualAttributeTextRange() {
        return this.persistentAttribute.getValidationTextRange();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class BaseColumnTableValidator
    implements JpaValidator {
        protected BaseColumnTableValidator() {
        }

        @Override
        public boolean validate(List<IMessage> messages, IReporter reporter) {
            String specifiedTable = this.getColumn().getSpecifiedTableName();
            String defaultTable = this.getColumn().getDefaultTableName();
            if (specifiedTable == null || ObjectTools.equals((Object)specifiedTable, (Object)defaultTable)) {
                return true;
            }
            if (this.getColumn().tableNameIsInvalid()) {
                messages.add(this.buildTableNotValidMessage());
                return false;
            }
            return true;
        }

        protected TableColumn getColumn() {
            return (TableColumn)AbstractNamedColumnValidator.this.column;
        }

        protected IMessage buildTableNotValidMessage() {
            return AbstractNamedColumnValidator.this.columnIsPartOfVirtualAttribute() ? this.buildVirtualAttributeTableNotValidMessage() : this.buildTableNotValidMessage_();
        }

        protected IMessage buildTableNotValidMessage_() {
            return ValidationMessageTools.buildValidationMessage((IResource)this.getColumn().getResource(), (TextRange)this.getColumn().getTableNameValidationTextRange(), (ValidationMessage)this.getColumnTableNotValidMessage(), (Object[])new Object[]{this.getColumn().getTableName(), this.getColumn().getName(), this.getColumnTableDescriptionMessage()});
        }

        protected ValidationMessage getColumnTableNotValidMessage() {
            return JptJpaCoreValidationMessages.COLUMN_TABLE_NOT_VALID;
        }

        protected String getColumnTableDescriptionMessage() {
            return AbstractNamedColumnValidator.this.tableDescriptionProvider.getColumnTableDescriptionMessage();
        }

        protected IMessage buildVirtualAttributeTableNotValidMessage() {
            return ValidationMessageTools.buildValidationMessage((IResource)this.getColumn().getResource(), (TextRange)AbstractNamedColumnValidator.this.getVirtualAttributeTextRange(), (ValidationMessage)this.getVirtualAttributeColumnTableNotValidMessage(), (Object[])new Object[]{AbstractNamedColumnValidator.this.persistentAttribute.getName(), this.getColumn().getTableName(), this.getColumn().getName(), this.getColumnTableDescriptionMessage()});
        }

        protected ValidationMessage getVirtualAttributeColumnTableNotValidMessage() {
            return JptJpaCoreValidationMessages.VIRTUAL_ATTRIBUTE_COLUMN_TABLE_NOT_VALID;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ExistenceTableValidator
    implements JpaValidator {
        protected ExistenceTableValidator() {
        }

        @Override
        public boolean validate(List<IMessage> messages, IReporter reporter) {
            return AbstractNamedColumnValidator.this.column.getDbTable() != null;
        }
    }

    public static interface TableDescriptionProvider {
        public String getColumnTableDescriptionMessage();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Null
        implements TableDescriptionProvider {
            private static final TableDescriptionProvider INSTANCE = new Null();

            public static TableDescriptionProvider instance() {
                return INSTANCE;
            }

            private Null() {
            }

            @Override
            public String getColumnTableDescriptionMessage() {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return ObjectTools.singletonToString((Object)this);
            }
        }
    }
}

