/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.ui.model;

import com.unisys.os2200.util.TDECoreUtilities;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.debug.core.comm.ProgramInfo;
import com.unisys.tde.debug.core.model.OS2200DebugTarget;
import com.unisys.tde.debug.core.model.OS2200Register;
import com.unisys.tde.debug.core.model.OS2200RegisterGroup;
import com.unisys.tde.debug.core.model.OS2200RegisterValue;
import com.unisys.tde.debug.core.model.OS2200StackFrame;
import com.unisys.tde.debug.core.model.OS2200Thread;
import com.unisys.tde.debug.core.model.OS2200Value;
import com.unisys.tde.debug.core.model.OS2200Variable;
import com.unisys.tde.debug.core.model.OS2200Watchpoint;
import com.unisys.tde.debug.ui.model.OS2200LableProviderListener;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.core.WatchExpression;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class OS2200ModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    public static final String debugModelId = "com.unisys.tde.debug.os2200";

    public void setAttribute(String string, Object object) {
        String string2 = "city";
        string2 = String.valueOf(string2);
    }

    public OS2200ModelPresentation() {
        this.addListener(new OS2200LableProviderListener(){

            @Override
            public void labelProviderChanged(LabelProviderChangedEvent labelProviderChangedEvent) {
                labelProviderChangedEvent.getElement();
                labelProviderChangedEvent.getSource();
                System.out.println("lblSrc");
            }
        });
    }

    public Image getImage(Object object) {
        try {
            if (object instanceof OS2200Variable) {
                OS2200Variable oS2200Variable = (OS2200Variable)object;
                return oS2200Variable.getImage();
            }
            if (object instanceof OS2200Watchpoint) {
                ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.unisys.tde.debug.ui", (String)"icons/watchdot.gif");
                Image image = imageDescriptor.createImage();
                return image;
            }
            if (object instanceof OS2200Register || object instanceof OS2200RegisterGroup) {
                ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.unisys.tde.debug.ui", (String)"icons/register.gif");
                Image image = imageDescriptor.createImage();
                return image;
            }
            if (object instanceof IBreakpoint) {
                ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.unisys.tde.debug.ui", (String)"icons/basedot.gif");
                Image image = imageDescriptor.createImage();
                return image;
            }
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.unisys.tde.debug.ui", (String)"icons/run_exc_2200.gif");
            Image image = imageDescriptor.createImage();
            return image;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getText(Object object) {
        if (object instanceof OS2200DebugTarget) {
            OS2200DebugTarget oS2200DebugTarget = (OS2200DebugTarget)object;
            if (oS2200DebugTarget.isStarted()) {
                ProgramInfo programInfo = oS2200DebugTarget.getProgramInfo();
                String string = String.valueOf(programInfo.getOmPart()) + " " + programInfo.getProg();
                return string;
            }
            return "Waiting for program to start";
        }
        if (object instanceof OS2200Thread) {
            OS2200Thread oS2200Thread = (OS2200Thread)object;
            if (oS2200Thread.isStarted()) {
                try {
                    return oS2200Thread.getName();
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                    return "Error debugging";
                }
            }
            return "Waiting for program to start";
        }
        if (object instanceof OS2200StackFrame) {
            try {
                OS2200StackFrame oS2200StackFrame = (OS2200StackFrame)object;
                return oS2200StackFrame.displayText();
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                return "Error getting frame text";
            }
        }
        if (object instanceof OS2200RegisterGroup) {
            try {
                OS2200RegisterGroup oS2200RegisterGroup = (OS2200RegisterGroup)object;
                return oS2200RegisterGroup.getName();
            }
            catch (DebugException debugException) {
                OS2200CorePlugin.logger.error((Object)debugException.getMessage(), (Throwable)debugException);
                return "Error getting register Group Text";
            }
        }
        if (object instanceof OS2200Watchpoint) {
            OS2200Watchpoint oS2200Watchpoint = (OS2200Watchpoint)object;
            IMarker iMarker = oS2200Watchpoint.getMarker();
            String string = oS2200Watchpoint.getVariableName();
            String string2 = iMarker.getResource().getName();
            String string3 = "Watchpoint on " + string + " in " + string2;
            return string3;
        }
        if (object instanceof IBreakpoint) {
            IBreakpoint iBreakpoint = (IBreakpoint)object;
            IMarker iMarker = iBreakpoint.getMarker();
            int n = iMarker.getAttribute("lineNumber", 1);
            String string = iMarker.getResource().getName();
            String string4 = String.valueOf(string) + " at line " + Integer.toString(n);
            return string4;
        }
        if (object instanceof WatchExpression) {
            WatchExpression watchExpression = (WatchExpression)object;
            try {
                String string = watchExpression.getModelIdentifier();
                if (string.equals(debugModelId) && watchExpression.isEnabled()) {
                    String string5 = watchExpression.getExpressionText();
                    IValue iValue = watchExpression.getValue();
                    String string6 = "";
                    String string7 = "";
                    if (iValue != null) {
                        string6 = iValue.getReferenceTypeName();
                        string7 = iValue.getValueString();
                        if (string6 == null) {
                            string6 = "";
                        }
                        if (string7 == null) {
                            string7 = "";
                        }
                    }
                    String string8 = String.valueOf(string5) + " -- " + string6 + " -- " + string7;
                    return string8;
                }
                return "";
            }
            catch (DebugException debugException) {
                OS2200CorePlugin.logger.error((Object)("error evaluating " + watchExpression.getExpressionText() + " input messages"), (Throwable)debugException);
                return debugException.getLocalizedMessage();
            }
        }
        Class<?> clazz = object.getClass();
        String string = "Model Presentation - else: " + clazz.getName();
        OS2200CorePlugin.logger.debug((Object)string);
        return "Something else";
    }

    public void computeDetail(IValue iValue, IValueDetailListener iValueDetailListener) {
        String string = "";
        if (iValue instanceof OS2200Value) {
            string = ((OS2200Value)iValue).getValueRet();
        } else if (iValue instanceof OS2200RegisterValue) {
            try {
                string = ((OS2200RegisterValue)iValue).getValueString();
            }
            catch (DebugException debugException) {
                debugException.printStackTrace();
                OS2200CorePlugin.logger.error((Object)("error evaluating Registry in OS2200ModelPresentation.computeDetail method." + (Object)((Object)debugException)));
            }
        }
        if (string == "") {
            OS2200CorePlugin.logger.debug((Object)"Setting empty string value while evaluating Registry in OS2200ModelPresentation.computeDetail method.");
        }
        iValueDetailListener.detailComputed(iValue, string);
    }

    public IEditorInput getEditorInput(Object object) {
        if (object instanceof IFile) {
            String string = ((IFile)object).getRawLocation().toOSString();
            final File file = new File(string);
            final String string2 = TDECoreUtilities.getCIFSPathFromFilePath((String)string);
            if (!file.exists()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        TDECoreUtilities.getInstance().initiateCopying(new File(string2), file, 2);
                    }
                });
            }
            try {
                ((IFile)object).refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            return new FileEditorInput((IFile)object);
        }
        if (object instanceof ILineBreakpoint) {
            FileEditorInput fileEditorInput = new FileEditorInput((IFile)((ILineBreakpoint)object).getMarker().getResource());
            return fileEditorInput;
        }
        return null;
    }

    public String getEditorId(IEditorInput iEditorInput, Object object) {
        if ((object instanceof IFile || object instanceof ILineBreakpoint) && iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            IFile iFile = iFileEditorInput.getFile();
            IPath iPath = iFile.getProjectRelativePath();
            String string = iPath.getFileExtension();
            if (string.equalsIgnoreCase("C")) {
                return "org.eclipse.cdt.ui.editor.CEditor";
            }
            if (string.equalsIgnoreCase("PLS")) {
                return "com.unisys.tde.plus.editor.PlusEditor";
            }
            if (string.equalsIgnoreCase("COB")) {
                return "org.eclipse.cobol.ui.editor.COBOLEditor";
            }
            if (string.equalsIgnoreCase("FOR")) {
                return "org.eclipse.photran.ui.FixedFormFortranEditor";
            }
        }
        return null;
    }
}

