/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.debug.ui.launching;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.debug.core.DebugStop;
import com.unisys.tde.debug.ui.launching.OS2200LaunchTab;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class OS2200MainLaunchTab
extends OS2200LaunchTab {
    Label project;
    Text txtProject;
    Label executeLine;
    Text txtDebugID;
    Label portNumber;
    Text txtPortNumber;
    IProject prij;
    String projectName;
    String debugID;
    String dbPortNumber;
    public static final String pName = "ProjectName";
    public static final String sString = "StartString";
    private static final int SIZING_TEXT_FIELD_WIDTH = 50;
    private DebugStop dbStop;
    ModifyListener fModListen = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            OS2200MainLaunchTab.this.updateLaunchConfigurationDialog();
        }
    };
    SelectionListener fRBSelListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            OS2200MainLaunchTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };
    private Composite fsComp;
    private Button[] rbFirstStops;

    public OS2200MainLaunchTab() {
        System.out.println("openning main tab");
        this.projectName = "";
        this.debugID = "";
        this.dbPortNumber = "";
        this.dbStop = DebugStop.firstLineNoBkpt;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "com.unisys.tde.ui.context_start_os_2200_debug_session");
        composite2.setLayoutData((Object)new GridData(768));
        this.setControl((Control)composite2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        this.createProjectEditor(composite2);
        this.createVerticalSpacer(composite2, 1);
        this.createVerticalSpacer(composite2, 1);
        new GridData();
        Dialog.applyDialogFont((Control)composite);
    }

    public void setParms(ILaunchConfiguration iLaunchConfiguration) {
        try {
            IProject iProject;
            this.projectName = iLaunchConfiguration.getAttribute("Project_Name", "");
            this.debugID = iLaunchConfiguration.getAttribute("OS2200_DEBUG_ID", "");
            this.dbPortNumber = iLaunchConfiguration.getAttribute("OS2200_DEBUG_PORT_NUMBER", "");
            String string = iLaunchConfiguration.getAttribute("DebugFirstStop", DebugStop.firstLineNoBkpt.toString());
            this.dbStop = DebugStop.valueOf((String)string);
            if (this.projectName.equals("") && (iProject = this.getContext()) != null) {
                this.projectName = iProject.getName();
                try {
                    Properties properties = OS2200ProjectUpdate.getProperties((IProject)iProject);
                    this.debugID = properties.getProperty("DebugID");
                    this.dbPortNumber = properties.getProperty("DebugPortNumber");
                }
                catch (CoreException coreException) {
                    OS2200CorePlugin.logger.error((Object)"Error getting Debug Properties", (Throwable)coreException);
                }
            }
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)"error get debug parameters", (Throwable)coreException);
        }
    }

    private DebugStop getDebugStopper() {
        DebugStop[] debugStopArray;
        DebugStop[] debugStopArray2 = debugStopArray = DebugStop.values();
        int n = debugStopArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugStop debugStop = debugStopArray2[n2];
            if (this.rbFirstStops[debugStop.value()].getSelection()) {
                return debugStop;
            }
            ++n2;
        }
        return DebugStop.firstLineNoBkpt;
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("Project_Name", this.txtProject.getText());
        iLaunchConfigurationWorkingCopy.setAttribute("OS2200_DEBUG_ID", this.txtDebugID.getText());
        iLaunchConfigurationWorkingCopy.setAttribute("OS2200_DEBUG_PORT_NUMBER", this.txtPortNumber.getText());
        iLaunchConfigurationWorkingCopy.setAttribute("DebugFirstStop", this.getDebugStopper().toString());
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        try {
            IProject iProject;
            this.projectName = iLaunchConfigurationWorkingCopy.getAttribute("Project_Name", "");
            this.debugID = iLaunchConfigurationWorkingCopy.getAttribute("OS2200_DEBUG_ID", "");
            this.dbPortNumber = iLaunchConfigurationWorkingCopy.getAttribute("OS2200_DEBUG_PORT_NUMBER", "");
            String string = "";
            this.debugID = "";
            this.dbPortNumber = "";
            this.prij = iProject = this.getContext();
            if (iProject != null) {
                this.projectName = string = iProject.getName();
                iLaunchConfigurationWorkingCopy.rename(this.getLaunchManager().generateLaunchConfigurationName(this.projectName));
                Properties properties = OS2200ProjectUpdate.getProperties((IProject)iProject);
                this.debugID = properties.getProperty("DebugID");
                this.dbPortNumber = properties.getProperty("DebugPortNumber");
            }
            this.dbStop = DebugStop.firstLineNoBkpt;
        }
        catch (CoreException coreException) {
            OS2200CorePlugin.logger.error((Object)"error gettings default debug settings", (Throwable)coreException);
        }
    }

    @Override
    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this.setParms(iLaunchConfiguration);
        this.txtProject.setText(this.projectName);
        this.txtDebugID.setText(this.debugID);
        this.txtPortNumber.setText(this.dbPortNumber);
        int n = 0;
        while (n < this.rbFirstStops.length) {
            this.rbFirstStops[n].setSelection(false);
            ++n;
        }
        this.rbFirstStops[this.dbStop.value()].setSelection(true);
    }

    void createProjectEditor(Composite composite) {
        this.project = new Label(composite, 0);
        this.project.setText(Messages.getString((String)"OS2200MainLaunchTab_0"));
        GridData gridData = new GridData(768);
        gridData.widthHint = 50;
        this.txtProject = new Text(composite, 2048);
        this.txtProject.setLayoutData((Object)gridData);
        this.txtProject.setText(this.projectName);
        this.txtProject.addModifyListener(this.fModListen);
        this.executeLine = new Label(composite, 0);
        this.txtDebugID = new Text(composite, 2048);
        this.txtDebugID.setLayoutData((Object)gridData);
        this.executeLine.setText(Messages.getString((String)"OS2200MainLaunchTab_1"));
        this.txtDebugID.addModifyListener(this.fModListen);
        this.txtDebugID.setText(this.debugID);
        this.portNumber = new Label(composite, 0);
        this.portNumber.setText(Messages.getString((String)"OS2200MainLaunchTab_2"));
        this.txtPortNumber = new Text(composite, 2048);
        this.txtPortNumber.setLayoutData((Object)gridData);
        this.txtPortNumber.setText(this.dbPortNumber);
        this.txtPortNumber.addModifyListener(this.fModListen);
        this.fsComp = new Composite(composite, 2048);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.fsComp.setLayout((Layout)gridLayout);
        this.rbFirstStops = new Button[3];
        this.rbFirstStops[DebugStop.firstLine.value()] = new Button(this.fsComp, 16);
        this.rbFirstStops[DebugStop.firstLineNoBkpt.value()] = new Button(this.fsComp, 16);
        this.rbFirstStops[DebugStop.firstBkpt.value()] = new Button(this.fsComp, 16);
        this.rbFirstStops[DebugStop.firstLine.value()].setText(Messages.getString((String)"OS2200MainLaunchTab_3"));
        this.rbFirstStops[DebugStop.firstLineNoBkpt.value()].setText(Messages.getString((String)"OS2200MainLaunchTab_4"));
        this.rbFirstStops[DebugStop.firstBkpt.value()].setText(Messages.getString((String)"OS2200MainLaunchTab_5"));
        int n = 0;
        while (n < this.rbFirstStops.length) {
            this.rbFirstStops[n].addSelectionListener(this.fRBSelListener);
            ++n;
        }
    }
}

