/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.common.util;

import com.unisys.common.util.RegistryUtil;
import com.unisys.logging.core.UtilLogger;
import org.apache.log4j.Logger;

public class OSTypeFactory {
    private static final String OS_X86 = "x86";
    private static final String OS_X64 = "64";
    private static final String WIN32_X86_REGISTRY32 = "com.unisys.win32.x86.util.Registry32Util";
    private static final String WIN32_X64_REGISTRY64 = "com.unisys.win32.x64.util.Registry64Util";

    public static RegistryUtil createInstance(String os) throws Exception, IllegalAccessException {
        Class<?> osClassUtil = null;
        RegistryUtil reg = null;
        Logger logger = UtilLogger.getLogger();
        if (os.equalsIgnoreCase(OS_X86)) {
            try {
                osClassUtil = Class.forName(WIN32_X86_REGISTRY32);
                logger.info((Object)("class from class.forname.32....." + osClassUtil));
                reg = (RegistryUtil)osClassUtil.newInstance();
                logger.info((Object)("Returned class....." + reg));
            }
            catch (ClassNotFoundException ce) {
                logger.error((Object)("Class Not Found 32 bit:" + ce.getMessage()));
            }
        } else if (os.contains(OS_X64)) {
            try {
                osClassUtil = Class.forName(WIN32_X64_REGISTRY64);
                logger.info((Object)("class from class.forname.64...." + osClassUtil));
                reg = (RegistryUtil)osClassUtil.newInstance();
                logger.info((Object)("Returned class....." + reg));
            }
            catch (ClassNotFoundException ce) {
                logger.error((Object)("Class Not Found 64 bit:" + ce.getMessage()));
                ce.printStackTrace();
            }
        }
        return reg;
    }
}

