/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.editor.editors;

import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.MemChecker;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileEditorInput;
import com.unisys.tde.core.OS2200ProjectUpdate;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class UDTEditorDocumentProvider
extends FileDocumentProvider {
    private final int LIMITED_FILE_SIZE = 0x500000;
    private final int BUFF_SIZE_ONE_MB = 1000000;
    protected static String END_OF_LINE = "\n";
    private IFile file = null;
    private String strEncoding;
    private String fileNameforProgress;
    String path = null;
    private IEditorInput editorInput;
    private boolean readOnly;
    private static final String QUALIFIED_FILE_STATUS_RESTORE = "fileStatus";
    private static final String CHARSET_UTF_16 = "UTF-16";
    private static final String CHARSET_UTF_16LE = "UTF-16LE";
    private static final String CHARSET_UTF_8 = "UTF-8";

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object object) throws CoreException {
        if (object instanceof IFileEditorInput) {
            Object object2;
            IFile iFile;
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            this.file = iFile = iFileEditorInput.getFile();
            IProject iProject = iFile.getProject();
            try {
                this.refreshFile(iFileEditorInput.getFile());
            }
            catch (CoreException coreException) {
                this.handleCoreException(coreException, "CoreException : while refreshing element info.");
            }
            IDocument iDocument = null;
            IStatus iStatus = null;
            try {
                if (((IFileEditorInput)object).exists()) {
                    iDocument = this.createDocument(object);
                }
            }
            catch (CoreException coreException) {
                this.handleCoreException(coreException, "CoreException : while creating document");
                iStatus = coreException.getStatus();
                if (iStatus instanceof ResourceStatus && iStatus.getCode() == 271) {
                    iStatus = this.remakeStatus((ResourceStatus)iStatus, iProject);
                }
                iDocument = this.createEmptyDocument();
            }
            if (iDocument instanceof IDocumentExtension4 && (object2 = this.getLineDelimiterPreference(iFileEditorInput.getFile())) != null) {
                ((IDocumentExtension4)iDocument).setInitialLineDelimiter((String)object2);
            }
            object2 = this.createAnnotationModel(object);
            FileDocumentProvider.FileSynchronizer fileSynchronizer = new FileDocumentProvider.FileSynchronizer((FileDocumentProvider)this, iFileEditorInput);
            fileSynchronizer.install();
            FileDocumentProvider.FileInfo fileInfo = new FileDocumentProvider.FileInfo((FileDocumentProvider)this, iDocument, object2, fileSynchronizer);
            fileInfo.fModificationStamp = this.computeModificationStamp((IResource)iFileEditorInput.getFile());
            fileInfo.fStatus = iStatus;
            fileInfo.fEncoding = this.getPersistedEncoding(object);
            this.cacheEncodingState(object);
            return fileInfo;
        }
        if (object instanceof OS2200FileEditorInput) {
            OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)object;
            IDocument iDocument = null;
            Object var4_9 = null;
            try {
                if (((OS2200FileEditorInput)object).exists()) {
                    iDocument = this.createDocument(object);
                }
            }
            catch (CoreException coreException) {
                this.handleCoreException(coreException, "CoreException : while creating document");
                iDocument = this.createEmptyDocument();
            }
            IAnnotationModel iAnnotationModel = this.createAnnotationModel(object);
            FileDocumentProvider.FileInfo fileInfo = new FileDocumentProvider.FileInfo((FileDocumentProvider)this, iDocument, iAnnotationModel, null);
            fileInfo.fModificationStamp = this.computeModificationStamp(oS2200FileEditorInput.getPath().toFile());
            fileInfo.fStatus = var4_9;
            fileInfo.fEncoding = ((OS2200FileEditorInput)object).getEncoding();
            this.cacheEncodingState(object);
            return fileInfo;
        }
        if (object instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)object;
            IDocument iDocument = null;
            Object var4_10 = null;
            try {
                if (((FileStoreEditorInput)object).exists()) {
                    iDocument = this.createDocument(object);
                }
            }
            catch (CoreException coreException) {
                this.handleCoreException(coreException, "CoreException : while creating document");
                iDocument = this.createEmptyDocument();
            }
            IAnnotationModel iAnnotationModel = this.createAnnotationModel(object);
            FileDocumentProvider.FileInfo fileInfo = new FileDocumentProvider.FileInfo((FileDocumentProvider)this, iDocument, iAnnotationModel, null);
            fileInfo.fModificationStamp = this.computeModificationStamp(new File(fileStoreEditorInput.getURI().getPath()));
            fileInfo.fStatus = var4_10;
            fileInfo.fEncoding = this.getPersistedEncoding(object);
            this.cacheEncodingState(object);
            return fileInfo;
        }
        return super.createElementInfo(object);
    }

    public String getEncoding(Object object) {
        if (object instanceof OS2200FileEditorInput) {
            return ((OS2200FileEditorInput)object).getEncoding();
        }
        return super.getEncoding(object);
    }

    protected String getPersistedEncoding(Object object) {
        if (object instanceof OS2200FileEditorInput) {
            return ((OS2200FileEditorInput)object).getEncoding();
        }
        return super.getPersistedEncoding(object);
    }

    protected boolean setDocumentContent(IDocument iDocument, IEditorInput iEditorInput, String string) throws CoreException {
        this.setReadOnly(false);
        if (iEditorInput instanceof OS2200FileEditorInput) {
            OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)iEditorInput;
            this.setEditorInput((IEditorInput)oS2200FileEditorInput);
            File file = new File(oS2200FileEditorInput.getPath().toOSString());
            if (!file.canWrite()) {
                this.setReadOnly(true);
            }
            this.path = file.getPath();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                OS2200CorePlugin.logger.error((Object)fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
                return false;
            }
            try {
                this.setDocumentContent(iDocument, fileInputStream, string);
            }
            finally {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    OS2200CorePlugin.logger.error((Object)iOException.getMessage());
                }
            }
            return true;
        }
        if (iEditorInput instanceof FileStoreEditorInput) {
            block39: {
                FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)iEditorInput;
                this.setEditorInput((IEditorInput)fileStoreEditorInput);
                URI uRI = ((FileStoreEditorInput)iEditorInput).getURI();
                try {
                    File file = new File(uRI.getPath());
                    FileInputStream fileInputStream = new FileInputStream(file);
                    this.path = uRI.getPath();
                    if (!file.canWrite()) {
                        this.setReadOnly(true);
                    }
                    try {
                        try {
                            this.setDocumentContent(iDocument, fileInputStream, string);
                        }
                        catch (Exception exception) {
                            OS2200CorePlugin.logger.error((Object)exception.getMessage(), (Throwable)exception);
                            try {
                                ((InputStream)fileInputStream).close();
                            }
                            catch (IOException iOException) {}
                            break block39;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                catch (FileNotFoundException fileNotFoundException) {
                    OS2200CorePlugin.logger.error((Object)fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
                }
            }
            return true;
        }
        if (iEditorInput instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)iEditorInput;
            IFile iFile = fileEditorInput.getFile();
            if (OS2200ProjectUpdate.hasCharConversion((IFile)iFile)) {
                string = "LETSJ";
                PlatformUI.getPreferenceStore().setValue(iFile.getName(), "LETSJ");
            }
            this.setEditorInput((IEditorInput)fileEditorInput);
            File file = new File(fileEditorInput.getPath().toOSString());
            if (!file.canWrite()) {
                this.setReadOnly(true);
            }
            this.path = file.getPath();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
            try {
                this.setDocumentContent(iDocument, fileInputStream, string);
            }
            finally {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    OS2200CorePlugin.logger.error((Object)iOException.getMessage());
                }
            }
            return true;
        }
        return super.setDocumentContent(iDocument, iEditorInput, string);
    }

    protected void setDocumentContent(final IDocument iDocument, InputStream inputStream, String string) throws CoreException {
        if (string == null) {
            string = this.getDefaultEncoding();
        }
        this.strEncoding = string;
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
        FileInputStream fileInputStream = (FileInputStream)inputStream;
        final FileChannel fileChannel = fileInputStream.getChannel();
        try {
            try {
                final int n = (int)fileChannel.size();
                if (MemChecker.getInstance().isLargeFile((long)n)) {
                    Status status = new Status(4, "com.unisys.os2200.editor", 0, Messages.getString((String)"UDTEditorDocumentProvider_9"), null);
                    throw new CoreException((IStatus)status);
                }
                progressMonitorDialog.run(true, false, new IRunnableWithProgress(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                        block46: {
                            try {
                                END_OF_LINE = "\n";
                                ByteBuffer byteBuffer = null;
                                CharBuffer charBuffer = null;
                                try {
                                    Object object;
                                    int n7 = 0;
                                    int n2 = 0;
                                    int n3 = 0;
                                    String string = "";
                                    string = UDTEditorDocumentProvider.this.getStringForMonitor(UDTEditorDocumentProvider.this.file);
                                    IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
                                    String string2 = iPreferenceStore.getString("ControlChar");
                                    String string3 = null;
                                    IEditorInput iEditorInput = UDTEditorDocumentProvider.this.getEditorInput();
                                    boolean bl = false;
                                    if (iEditorInput instanceof OS2200FileEditorInput) {
                                        if (UDTEditorDocumentProvider.this.strEncoding.equalsIgnoreCase("LETSJ")) {
                                            bl = true;
                                        }
                                    } else if (iEditorInput instanceof IFileEditorInput) {
                                        object = (IFileEditorInput)iEditorInput;
                                        IFile iFile = object.getFile();
                                        string3 = iFile.getRawLocation().toOSString();
                                        if (UDTEditorDocumentProvider.this.strEncoding == null) {
                                            UDTEditorDocumentProvider.this.strEncoding = iPreferenceStore.getString(iFile.getName());
                                        }
                                        if (string3.contains("tpsv")) {
                                            bl = true;
                                        }
                                    }
                                    if (n <= 0x500000) {
                                        iProgressMonitor.beginTask(string, -1);
                                        iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"UDTEditorDocumentProvider_14")) + n);
                                        n3 = n;
                                        byteBuffer = ByteBuffer.allocate(n3);
                                        fileChannel.read(byteBuffer);
                                        byteBuffer.flip();
                                        object = Charset.forName(UDTEditorDocumentProvider.this.strEncoding);
                                        charBuffer = ((Charset)object).decode(byteBuffer);
                                        String string4 = new String(charBuffer.array());
                                        if (!bl) {
                                            if (iPreferenceStore.getBoolean("EnableControlChar")) {
                                                long l = System.currentTimeMillis();
                                                Pattern pattern = Pattern.compile("[\\x00]");
                                                Matcher matcher = pattern.matcher("");
                                                matcher.reset(string4);
                                                Matcher matcher2 = pattern.matcher(string4);
                                                long l2 = System.currentTimeMillis();
                                                if (OS2200CorePlugin.logger.isInfoEnabled()) {
                                                    OS2200CorePlugin.logger.info((Object)("Time taken to search control char:" + (l2 - l) + " milliseconds"));
                                                }
                                                if (matcher2.find()) {
                                                    String string5;
                                                    boolean bl2 = false;
                                                    if (!UDTEditorDocumentProvider.this.isReadOnly()) {
                                                        if (OS2200CorePlugin.logger.isInfoEnabled()) {
                                                            OS2200CorePlugin.logger.info((Object)(String.valueOf(Messages.getResourceBundle().getString("ControlCharacter.nul1")) + "'" + string2 + "'" + ". Do you want to proceed?"));
                                                        }
                                                        string5 = string2.equals("&") ? "&" + string2 : string2;
                                                        bl2 = MessageDialog.openQuestion((Shell)UDTEditorDocumentProvider.getShell(), (String)Messages.getString((String)"UDTEditorDocumentProvider_23"), (String)(String.valueOf(Messages.getResourceBundle().getString("ControlCharacter.nul1")) + Messages.getString((String)"UDTEditorDocumentProvider_25") + string5 + Messages.getString((String)"UDTEditorDocumentProvider_26") + Messages.getString((String)"UDTEditorDocumentProvider_27")));
                                                    }
                                                    if (bl2) {
                                                        if (string2.equals("$") || string2.equals("\\")) {
                                                            string2 = "\\" + string2;
                                                        }
                                                        string5 = matcher.replaceAll(string2);
                                                        UDTEditorDocumentProvider.this.handleControlCharFile(iDocument, string5, UDTEditorDocumentProvider.this.isReadOnly(), bl2);
                                                        long l3 = System.currentTimeMillis();
                                                        if (OS2200CorePlugin.logger.isInfoEnabled()) {
                                                            OS2200CorePlugin.logger.info((Object)("Time taken to search and replace control char:" + (l3 - l) + " milliseconds"));
                                                        }
                                                        break block46;
                                                    }
                                                    UDTEditorDocumentProvider.this.handleControlCharFile(iDocument, string4, UDTEditorDocumentProvider.this.isReadOnly(), bl2);
                                                    long l4 = System.currentTimeMillis();
                                                    if (OS2200CorePlugin.logger.isInfoEnabled()) {
                                                        OS2200CorePlugin.logger.info((Object)("Time taken to search and without replacing control char:" + (l4 - l) + " milliseconds"));
                                                    }
                                                    break block46;
                                                }
                                                iDocument.set(string4);
                                                long l5 = System.currentTimeMillis();
                                                if (OS2200CorePlugin.logger.isInfoEnabled()) {
                                                    OS2200CorePlugin.logger.info((Object)("Time taken to set data without control char:" + (l5 - l) + " milliseconds"));
                                                }
                                                break block46;
                                            }
                                            iDocument.set(string4);
                                            break block46;
                                        }
                                        iDocument.set(string4);
                                        break block46;
                                    }
                                    int n4 = n / 1000000;
                                    iProgressMonitor.beginTask(string, n4 + 2);
                                    String string6 = new String(new byte[n]);
                                    iDocument.set(string6);
                                    int n5 = n % 1000000;
                                    int n6 = n4;
                                    n3 = 1000000;
                                    byteBuffer = ByteBuffer.allocate(n3);
                                    if (!bl) {
                                        if (iPreferenceStore.getBoolean("EnableControlChar")) {
                                            boolean bl3 = false;
                                            boolean bl4 = false;
                                            while (true) {
                                                if (n7 > n6) {
                                                    UDTEditorDocumentProvider.this.setFileOriginalFileStatus(UDTEditorDocumentProvider.this.isReadOnly(), bl3);
                                                    break block46;
                                                }
                                                byteBuffer.clear();
                                                fileChannel.read(byteBuffer, n2);
                                                byteBuffer.flip();
                                                Charset charset = Charset.forName(UDTEditorDocumentProvider.this.strEncoding);
                                                charBuffer = charset.decode(byteBuffer);
                                                String string7 = null;
                                                try {
                                                    string7 = new String(charBuffer.array());
                                                    long l = System.currentTimeMillis();
                                                    Pattern pattern = Pattern.compile("[\\x00]");
                                                    Matcher matcher = pattern.matcher("");
                                                    matcher.reset(string7);
                                                    Matcher matcher3 = pattern.matcher(string7);
                                                    long l6 = System.currentTimeMillis();
                                                    if (OS2200CorePlugin.logger.isInfoEnabled()) {
                                                        OS2200CorePlugin.logger.info((Object)("Time taken to search control char:" + (l6 - l) + " milliseconds"));
                                                    }
                                                    if (matcher3.find()) {
                                                        String string8;
                                                        if (!UDTEditorDocumentProvider.this.isReadOnly()) {
                                                            if (OS2200CorePlugin.logger.isInfoEnabled()) {
                                                                OS2200CorePlugin.logger.info((Object)(String.valueOf(Messages.getResourceBundle().getString("ControlCharacter.nul1")) + "'" + string2 + "'" + ". Do you want to proceed?"));
                                                            }
                                                            if (!bl4) {
                                                                string8 = string2.equals("&") ? "&" + string2 : string2;
                                                                bl3 = MessageDialog.openQuestion((Shell)UDTEditorDocumentProvider.getShell(), (String)Messages.getString((String)"UDTEditorDocumentProvider_45"), (String)(String.valueOf(Messages.getResourceBundle().getString("ControlCharacter.nul1")) + Messages.getString((String)"UDTEditorDocumentProvider_47") + string8 + Messages.getString((String)"UDTEditorDocumentProvider_48") + Messages.getString((String)"UDTEditorDocumentProvider_49")));
                                                            }
                                                        }
                                                        if (bl3) {
                                                            bl4 = true;
                                                            if (string2.equals("$") || string2.equals("\\")) {
                                                                string2 = "\\" + string2;
                                                            }
                                                            string8 = matcher.replaceAll(string2);
                                                            iDocument.replace(n2, string8.length(), string8);
                                                        } else {
                                                            bl4 = true;
                                                            iDocument.replace(n2, string7.length(), string7);
                                                        }
                                                    } else {
                                                        iDocument.replace(n2, string7.length(), string7);
                                                    }
                                                    n2 += string7.length();
                                                }
                                                catch (BadLocationException badLocationException) {}
                                                iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"UDTEditorDocumentProvider_53")) + n2 + Messages.getString((String)"UDTEditorDocumentProvider_54") + n + Messages.getString((String)"UDTEditorDocumentProvider_55"));
                                                if (n7 == n6 && n5 > 0) {
                                                    --n7;
                                                    n3 = n5;
                                                    n5 = 0;
                                                }
                                                ++n7;
                                                iProgressMonitor.worked(1);
                                            }
                                        }
                                        while (n7 <= n6) {
                                            byteBuffer.clear();
                                            fileChannel.read(byteBuffer, n2);
                                            byteBuffer.flip();
                                            Charset charset = Charset.forName(UDTEditorDocumentProvider.this.strEncoding);
                                            charBuffer = charset.decode(byteBuffer);
                                            String string9 = null;
                                            try {
                                                string9 = new String(charBuffer.array());
                                                iDocument.replace(n2, string9.length(), string9);
                                                n2 += string9.length();
                                            }
                                            catch (BadLocationException badLocationException) {}
                                            iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"UDTEditorDocumentProvider_56")) + n2 + Messages.getString((String)"UDTEditorDocumentProvider_57") + n + Messages.getString((String)"UDTEditorDocumentProvider_58"));
                                            if (n7 == n6 && n5 > 0) {
                                                --n7;
                                                n3 = n5;
                                                n5 = 0;
                                            }
                                            ++n7;
                                            iProgressMonitor.worked(1);
                                        }
                                        break block46;
                                    }
                                    while (n7 <= n6) {
                                        byteBuffer.clear();
                                        fileChannel.read(byteBuffer, n2);
                                        byteBuffer.flip();
                                        Charset charset = Charset.forName(UDTEditorDocumentProvider.this.strEncoding);
                                        charBuffer = charset.decode(byteBuffer);
                                        String string10 = null;
                                        try {
                                            string10 = new String(new String(charBuffer.array()));
                                            iDocument.replace(n2, string10.length(), string10);
                                            n2 += string10.length();
                                        }
                                        catch (BadLocationException badLocationException) {}
                                        iProgressMonitor.subTask(String.valueOf(Messages.getString((String)"UDTEditorDocumentProvider_59")) + n2 + Messages.getString((String)"UDTEditorDocumentProvider_60") + n + Messages.getString((String)"UDTEditorDocumentProvider_61"));
                                        if (n7 == n6 && n5 > 0) {
                                            --n7;
                                            n3 = n5;
                                            n5 = 0;
                                        }
                                        ++n7;
                                        iProgressMonitor.worked(1);
                                    }
                                }
                                catch (IOException iOException) {
                                    String string = iOException.getMessage() == null ? "" : iOException.getMessage();
                                    Status status = new Status(4, "com.unisys.os2200.editor", 0, string, (Throwable)iOException);
                                    throw new CoreException((IStatus)status);
                                }
                            }
                            catch (CoreException coreException) {
                                throw new InvocationTargetException(coreException);
                            }
                        }
                        iProgressMonitor.done();
                    }
                });
            }
            catch (CoreException coreException) {
                throw coreException;
            }
            catch (Exception exception) {
                String string2 = exception.getMessage() == null ? "" : exception.getMessage();
                Status status = new Status(4, "com.unisys.os2200.editor", 0, string2, (Throwable)exception);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException iOException) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    OS2200CorePlugin.logger.error((Object)iOException.getMessage());
                }
            }
            throw throwable;
        }
        if (fileChannel != null) {
            try {
                fileChannel.close();
            }
            catch (IOException iOException) {}
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                OS2200CorePlugin.logger.error((Object)iOException.getMessage());
            }
        }
    }

    protected void doSaveDocument(IProgressMonitor iProgressMonitor, Object object, IDocument iDocument, boolean bl) throws CoreException {
        if (object instanceof OS2200FileEditorInput) {
            Object object2;
            OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)object;
            String string = null;
            FileDocumentProvider.FileInfo fileInfo = (FileDocumentProvider.FileInfo)this.getElementInfo(object);
            string = oS2200FileEditorInput.getEncoding();
            if (string == null) {
                string = this.getDefaultEncoding();
            }
            if (fileInfo != null && CHARSET_UTF_16.equals(string)) {
                string = CHARSET_UTF_16LE;
            }
            Charset charset = null;
            try {
                charset = Charset.forName(string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {}
            CharsetEncoder charsetEncoder = charset.newEncoder();
            charsetEncoder.onMalformedInput(CodingErrorAction.REPLACE);
            charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            InputStream inputStream = null;
            try {
                ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(iDocument.get()));
                if (byteBuffer.hasArray()) {
                    object2 = byteBuffer.array();
                } else {
                    object2 = new byte[byteBuffer.limit()];
                    byteBuffer.get((byte[])object2);
                }
                inputStream = new ByteArrayInputStream((byte[])object2, 0, byteBuffer.limit());
            }
            catch (CharacterCodingException characterCodingException) {
                Assert.isTrue((boolean)(characterCodingException instanceof UnmappableCharacterException));
            }
            if (fileInfo != null && CHARSET_UTF_8.equals(string)) {
                inputStream = new SequenceInputStream(new ByteArrayInputStream(IContentDescription.BOM_UTF_8), inputStream);
            }
            if (fileInfo != null && CHARSET_UTF_16LE.equals(string)) {
                inputStream = new SequenceInputStream(new ByteArrayInputStream(IContentDescription.BOM_UTF_16LE), inputStream);
            }
            if (oS2200FileEditorInput.getPath().toFile().exists()) {
                if (fileInfo != null && !bl) {
                    this.checkSynchronizationState(fileInfo.fModificationStamp, oS2200FileEditorInput.getPath().toFile());
                }
                this.fireElementStateChanging(object);
                try {
                    object2 = iDocument.get().getBytes();
                    new ByteArrayInputStream((byte[])object2);
                    int n = 0;
                    OutputStream outputStream = oS2200FileEditorInput.getfFile().openOutputStream(n, Policy.subMonitorFor((IProgressMonitor)iProgressMonitor, (int)0));
                    FileUtil.transferStreams((InputStream)inputStream, (OutputStream)outputStream, (String)oS2200FileEditorInput.getfFile().toString(), (IProgressMonitor)iProgressMonitor);
                }
                catch (CoreException coreException) {
                    this.fireElementStateChangeFailed(object);
                    throw coreException;
                }
                catch (RuntimeException runtimeException) {
                    this.fireElementStateChangeFailed(object);
                    throw runtimeException;
                }
                if (fileInfo != null) {
                    object2 = (ResourceMarkerAnnotationModel)fileInfo.fModel;
                    if (object2 != null) {
                        object2.updateMarkers(fileInfo.fDocument);
                    }
                    fileInfo.fModificationStamp = this.computeModificationStamp(oS2200FileEditorInput.getPath().toFile());
                }
            }
        } else if (object instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)object;
            FileDocumentProvider.FileInfo fileInfo = (FileDocumentProvider.FileInfo)this.getElementInfo(object);
            File file = new File(fileStoreEditorInput.getURI().getPath());
            if (file.exists()) {
                Object object3;
                if (fileInfo != null && !bl) {
                    this.checkSynchronizationState(fileInfo.fModificationStamp, file);
                }
                this.fireElementStateChanging(object);
                try {
                    object3 = iDocument.get().getBytes();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object3);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    FileUtil.transferStreams((InputStream)byteArrayInputStream, (OutputStream)fileOutputStream, (String)file.getAbsolutePath(), (IProgressMonitor)iProgressMonitor);
                }
                catch (CoreException coreException) {
                    this.fireElementStateChangeFailed(object);
                    fileInfo.fModificationStamp = this.computeModificationStamp(file);
                    throw coreException;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                if (fileInfo != null) {
                    object3 = (ResourceMarkerAnnotationModel)fileInfo.fModel;
                    if (object3 != null) {
                        object3.updateMarkers(fileInfo.fDocument);
                    }
                    fileInfo.fModificationStamp = this.computeModificationStamp(file);
                }
            }
        } else {
            super.doSaveDocument(iProgressMonitor, object, iDocument, bl);
        }
    }

    private void saveExternalFile(OS2200FileEditorInput oS2200FileEditorInput, IDocument iDocument) throws IOException {
        try (FileOutputStream fileOutputStream = null;){
            File file = oS2200FileEditorInput.getPath().toFile();
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = iDocument.get().getBytes();
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
        }
    }

    protected String getLineDelimiterPreference(IFile iFile) {
        IScopeContext[] iScopeContextArray;
        if (iFile != null && iFile.getProject() != null) {
            iScopeContextArray = new IScopeContext[]{new ProjectScope(iFile.getProject())};
            String string = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, iScopeContextArray);
            if (string != null) {
                return string;
            }
        }
        iScopeContextArray = new IScopeContext[]{new InstanceScope()};
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, iScopeContextArray);
    }

    ResourceStatus remakeStatus(ResourceStatus resourceStatus, IProject iProject) {
        int n;
        String string;
        String string2 = resourceStatus.getMessage();
        if (string2.indexOf("File not found") >= 0 && (string = this.getWorkFile(iProject)) != null && (n = string2.lastIndexOf("\\")) > 0) {
            String string3 = string2.substring(n + 1);
            if ((string3 = string3.trim()).endsWith(".")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            string3 = string3.replace(".", "/");
            ResourceStatus resourceStatus2 = new ResourceStatus(271, String.valueOf(Messages.getString((String)"UDTEditorDocumentProvider_69")) + string3 + Messages.getString((String)"UDTEditorDocumentProvider_70") + string);
            return resourceStatus2;
        }
        return resourceStatus;
    }

    String getWorkFile(IProject iProject) {
        if (iProject != null && iProject.isOpen()) {
            try {
                if (iProject.getNature("com.unisys.tde.core.OS2200") != null) {
                    String string;
                    Preferences preferences = Platform.getPreferencesService().getRootNode().node("project");
                    preferences = preferences.nodeExists(string = String.valueOf(iProject.getName()) + '/' + "org.eclipse.core.resources") ? preferences.node(string) : null;
                    preferences = preferences.node("workFile");
                    String string2 = preferences.get("<project>", null);
                    return string2;
                }
            }
            catch (CoreException coreException) {
                return null;
            }
            catch (BackingStoreException backingStoreException) {
                return null;
            }
        }
        return null;
    }

    private String getStringForMonitor(IFile iFile) {
        block10: {
            try {
                String[] stringArray = null;
                int n = 0;
                if (iFile == null) {
                    if (this.path == null) break block10;
                    try {
                        if (this.path.contains(":/")) {
                            stringArray = this.path.split("/");
                            n = stringArray.length - 1;
                            this.fileNameforProgress = String.valueOf(Messages.getString((String)"UDTEditorDocumentProvider_76")) + stringArray[n].toUpperCase() + Messages.getString((String)"UDTEditorDocumentProvider_77");
                        } else if (this.path.contains(":\\")) {
                            stringArray = this.path.split("\\\\");
                            n = stringArray.length - 1;
                            this.fileNameforProgress = String.valueOf(Messages.getString((String)"UDTEditorDocumentProvider_80")) + stringArray[n].toUpperCase() + Messages.getString((String)"UDTEditorDocumentProvider_81");
                        } else if (this.path.contains("\\")) {
                            stringArray = this.path.split("\\\\");
                            n = stringArray.length - 1;
                            this.fileNameforProgress = n == 5 ? String.valueOf(Messages.getString((String)"UDTEditorDocumentProvider_84")) + stringArray[n - 1] + Messages.getString((String)"UDTEditorDocumentProvider_85") + stringArray[n] + Messages.getString((String)"UDTEditorDocumentProvider_86") : String.valueOf(Messages.getString((String)"UDTEditorDocumentProvider_87")) + stringArray[n] + Messages.getString((String)"UDTEditorDocumentProvider_88") + stringArray[n - 2] + Messages.getString((String)"UDTEditorDocumentProvider_89") + stringArray[n - 1] + Messages.getString((String)"UDTEditorDocumentProvider_90");
                        }
                    }
                    catch (Exception exception) {}
                    return this.fileNameforProgress;
                }
                IProject iProject = iFile.getProject();
                Properties properties = OS2200ProjectUpdate.getProperties((IProject)iProject);
                String string = properties.getProperty("workFile");
                String string2 = iFile.getName().replace('.', '/');
                return String.valueOf(Messages.getString((String)"UDTEditorDocumentProvider_91")) + string2 + Messages.getString((String)"UDTEditorDocumentProvider_92") + string;
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
        return null;
    }

    public boolean isModifiable(Object object) {
        if (object instanceof OS2200FileEditorInput) {
            OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)object;
            File file = oS2200FileEditorInput.getPath().toFile();
            return file.canWrite();
        }
        if (object instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)object;
            File file = new File(fileStoreEditorInput.getURI().getPath());
            return file.canWrite();
        }
        if (!this.isStateValidated(object) && object instanceof IFileEditorInput) {
            return true;
        }
        return super.isModifiable(object);
    }

    public boolean isSynchronized(Object object) {
        if (object instanceof OS2200FileEditorInput) {
            if (this.getElementInfo(object) != null) {
                long l = this.getModificationStamp(object);
                return l == this.getSynchronizationStamp(object);
            }
            return false;
        }
        if (object instanceof FileStoreEditorInput) {
            if (this.getElementInfo(object) != null) {
                long l = this.getModificationStamp(object);
                return l == this.getSynchronizationStamp(object);
            }
            return false;
        }
        return super.isSynchronized(object);
    }

    public long getModificationStamp(Object object) {
        if (object instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            return this.computeModificationStamp((IResource)iFileEditorInput.getFile());
        }
        if (object instanceof OS2200FileEditorInput) {
            OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)object;
            return this.computeModificationStamp(oS2200FileEditorInput.getPath().toFile());
        }
        if (object instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)object;
            return this.computeModificationStamp(new File(fileStoreEditorInput.getURI().getPath()));
        }
        return super.getModificationStamp(object);
    }

    protected long computeModificationStamp(File file) {
        int n = 0;
        while (!file.exists() && n <= 10) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            ++n;
        }
        long l = file.lastModified();
        return l;
    }

    public boolean isDeleted(Object object) {
        if (object instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            IPath iPath = iFileEditorInput.getFile().getLocation();
            if (iPath == null) {
                return true;
            }
            return !iPath.toFile().exists();
        }
        if (object instanceof OS2200FileEditorInput) {
            OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)object;
            IPath iPath = oS2200FileEditorInput.getPath();
            if (iPath == null) {
                return true;
            }
            return !iPath.toFile().exists();
        }
        if (object instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)object;
            Path path = new Path(fileStoreEditorInput.getURI().getPath());
            if (path == null) {
                return true;
            }
            return !path.toFile().exists();
        }
        return super.isDeleted(object);
    }

    protected void doSynchronize(Object object, IProgressMonitor iProgressMonitor) throws CoreException {
        if (object instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            FileDocumentProvider.FileInfo fileInfo = (FileDocumentProvider.FileInfo)this.getElementInfo(object);
            if (fileInfo != null) {
                if (fileInfo.fFileSynchronizer != null) {
                    fileInfo.fFileSynchronizer.uninstall();
                    this.refreshFile(iFileEditorInput.getFile(), iProgressMonitor);
                    fileInfo.fFileSynchronizer.install();
                } else {
                    this.refreshFile(iFileEditorInput.getFile(), iProgressMonitor);
                }
                this.handleElementContentChanged((IFileEditorInput)object);
            }
            return;
        }
        if (object instanceof OS2200FileEditorInput) {
            OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)object;
            this.handleElementContentChanged1(oS2200FileEditorInput);
            return;
        }
        if (object instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)object;
            this.handleElementContentChanged2(fileStoreEditorInput);
            return;
        }
    }

    public void handleElementContentChanged(IFileEditorInput iFileEditorInput) {
        super.handleElementContentChanged(iFileEditorInput);
    }

    public void handleElementContentChanged1(OS2200FileEditorInput oS2200FileEditorInput) {
        FileDocumentProvider.FileInfo fileInfo = (FileDocumentProvider.FileInfo)this.getElementInfo(oS2200FileEditorInput);
        if (!(oS2200FileEditorInput instanceof OS2200FileEditorInput) && fileInfo == null) {
            return;
        }
        IDocument iDocument = this.createEmptyDocument();
        IStatus iStatus = null;
        try {
            this.cacheEncodingState(oS2200FileEditorInput);
            this.setDocumentContent(iDocument, (IEditorInput)oS2200FileEditorInput, fileInfo.fEncoding);
        }
        catch (CoreException coreException) {
            iStatus = coreException.getStatus();
        }
        String string = iDocument.get();
        if (!string.equals(fileInfo.fDocument.get())) {
            this.fireElementContentAboutToBeReplaced(oS2200FileEditorInput);
            this.removeUnchangedElementListeners(oS2200FileEditorInput, (AbstractDocumentProvider.ElementInfo)fileInfo);
            fileInfo.fDocument.removeDocumentListener((IDocumentListener)fileInfo);
            fileInfo.fDocument.set(string);
            fileInfo.fCanBeSaved = false;
            fileInfo.fModificationStamp = this.computeModificationStamp(oS2200FileEditorInput.getPath().toFile());
            fileInfo.fStatus = iStatus;
            this.addUnchangedElementListeners(oS2200FileEditorInput, (AbstractDocumentProvider.ElementInfo)fileInfo);
            this.fireElementContentReplaced(oS2200FileEditorInput);
        } else {
            this.removeUnchangedElementListeners(oS2200FileEditorInput, (AbstractDocumentProvider.ElementInfo)fileInfo);
            fileInfo.fCanBeSaved = false;
            fileInfo.fModificationStamp = this.computeModificationStamp(oS2200FileEditorInput.getPath().toFile());
            fileInfo.fStatus = iStatus;
            this.addUnchangedElementListeners(oS2200FileEditorInput, (AbstractDocumentProvider.ElementInfo)fileInfo);
            this.fireElementDirtyStateChanged(oS2200FileEditorInput, false);
        }
    }

    public void handleElementContentChanged2(FileStoreEditorInput fileStoreEditorInput) {
        FileDocumentProvider.FileInfo fileInfo = (FileDocumentProvider.FileInfo)this.getElementInfo(fileStoreEditorInput);
        if (!(fileStoreEditorInput instanceof FileStoreEditorInput) && fileInfo == null) {
            return;
        }
        IDocument iDocument = this.createEmptyDocument();
        IStatus iStatus = null;
        try {
            this.cacheEncodingState(fileStoreEditorInput);
            this.setDocumentContent(iDocument, (IEditorInput)fileStoreEditorInput, null);
        }
        catch (CoreException coreException) {
            iStatus = coreException.getStatus();
        }
        String string = iDocument.get();
        if (!string.equals(fileInfo.fDocument.get())) {
            this.fireElementContentAboutToBeReplaced(fileStoreEditorInput);
            this.removeUnchangedElementListeners(fileStoreEditorInput, (AbstractDocumentProvider.ElementInfo)fileInfo);
            fileInfo.fDocument.removeDocumentListener((IDocumentListener)fileInfo);
            fileInfo.fDocument.set(string);
            fileInfo.fCanBeSaved = false;
            fileInfo.fModificationStamp = this.computeModificationStamp(new File(fileStoreEditorInput.getURI().getPath()));
            fileInfo.fStatus = iStatus;
            this.addUnchangedElementListeners(fileStoreEditorInput, (AbstractDocumentProvider.ElementInfo)fileInfo);
            this.fireElementContentReplaced(fileStoreEditorInput);
        } else {
            this.removeUnchangedElementListeners(fileStoreEditorInput, (AbstractDocumentProvider.ElementInfo)fileInfo);
            fileInfo.fCanBeSaved = false;
            fileInfo.fModificationStamp = this.computeModificationStamp(new File(fileStoreEditorInput.getURI().getPath()));
            fileInfo.fStatus = iStatus;
            this.addUnchangedElementListeners(fileStoreEditorInput, (AbstractDocumentProvider.ElementInfo)fileInfo);
            this.fireElementDirtyStateChanged(fileStoreEditorInput, false);
        }
    }

    public long getSynchronizationStamp(Object object) {
        FileDocumentProvider.FileInfo fileInfo;
        if (object instanceof IFileEditorInput) {
            FileDocumentProvider.FileInfo fileInfo2 = (FileDocumentProvider.FileInfo)this.getElementInfo(object);
            if (fileInfo2 != null) {
                return fileInfo2.fModificationStamp;
            }
        } else if (object instanceof OS2200FileEditorInput) {
            FileDocumentProvider.FileInfo fileInfo3 = (FileDocumentProvider.FileInfo)this.getElementInfo(object);
            if (fileInfo3 != null) {
                return fileInfo3.fModificationStamp;
            }
        } else if (object instanceof FileStoreEditorInput && (fileInfo = (FileDocumentProvider.FileInfo)this.getElementInfo(object)) != null) {
            return fileInfo.fModificationStamp;
        }
        return super.getSynchronizationStamp(object);
    }

    protected void checkSynchronizationState(long l, File file) throws CoreException {
        if (l != this.computeModificationStamp(file)) {
            Status status = new Status(4, "org.eclipse.ui", 274, Messages.getString((String)"UDTEditorDocumentProvider_93"), null);
            throw new CoreException((IStatus)status);
        }
    }

    public IEditorInput getEditorInput() {
        return this.editorInput;
    }

    public void setEditorInput(IEditorInput iEditorInput) {
        this.editorInput = iEditorInput;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    private static Shell getShell() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = new Display();
        }
        Shell shell = new Shell(display.getActiveShell(), 0);
        return shell;
    }

    private void handleControlCharFile(IDocument iDocument, String string, boolean bl, boolean bl2) throws CoreException {
        QualifiedName qualifiedName = new QualifiedName(QUALIFIED_FILE_STATUS_RESTORE, QUALIFIED_FILE_STATUS_RESTORE);
        Boolean bl3 = null;
        IFile iFile = null;
        if (this.getEditorInput() instanceof OS2200FileEditorInput) {
            OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)this.editorInput;
            File file = new File(oS2200FileEditorInput.getURI().getPath());
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            if (bl2) {
                bl3 = new Boolean(false);
                file.setReadOnly();
            }
            iWorkspaceRoot.setSessionProperty(qualifiedName, bl3);
        } else if (this.getEditorInput() instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)this.editorInput;
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            File file = new File(fileStoreEditorInput.getURI().getPath());
            if (bl2) {
                bl3 = new Boolean(false);
                file.setReadOnly();
            }
            iWorkspaceRoot.setSessionProperty(qualifiedName, (Object)bl3);
        } else if (this.getEditorInput() instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)this.editorInput;
            iFile = fileEditorInput.getFile();
            if (bl2) {
                bl3 = new Boolean(false);
                iFile.setReadOnly(true);
            }
            iFile.setSessionProperty(qualifiedName, (Object)bl3);
        }
        iDocument.set(string);
    }

    private void setFileOriginalFileStatus(boolean bl, boolean bl2) throws CoreException {
        QualifiedName qualifiedName = new QualifiedName(QUALIFIED_FILE_STATUS_RESTORE, QUALIFIED_FILE_STATUS_RESTORE);
        Boolean bl3 = null;
        IFile iFile = null;
        if (this.getEditorInput() instanceof OS2200FileEditorInput) {
            OS2200FileEditorInput oS2200FileEditorInput = (OS2200FileEditorInput)this.editorInput;
            File file = new File(oS2200FileEditorInput.getURI().getPath());
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            if (bl2) {
                bl3 = new Boolean(false);
                file.setReadOnly();
            }
            iWorkspaceRoot.setSessionProperty(qualifiedName, bl3);
        } else if (this.getEditorInput() instanceof FileStoreEditorInput) {
            FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)this.editorInput;
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            File file = new File(fileStoreEditorInput.getURI().getPath());
            if (bl2) {
                bl3 = new Boolean(false);
                file.setReadOnly();
            }
            iWorkspaceRoot.setSessionProperty(qualifiedName, (Object)bl3);
        } else if (this.getEditorInput() instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)this.editorInput;
            iFile = fileEditorInput.getFile();
            if (bl2) {
                bl3 = new Boolean(false);
                iFile.setReadOnly(true);
            }
            iFile.setSessionProperty(qualifiedName, (Object)bl3);
        }
    }

    private void processBufferData() {
    }

    public String getPath() {
        return this.path;
    }
}

