/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.editor.editors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class UDTEditorAnnotationHover
implements IAnnotationHover {
    public String getHoverInfo(ISourceViewer iSourceViewer, int n) {
        List list = this.getMarkersForLine(iSourceViewer, n);
        if (list != null) {
            if (list.size() == 1) {
                IMarker iMarker = (IMarker)list.get(0);
                String string = iMarker.getAttribute("message", null);
                if (string != null && string.trim().length() > 0) {
                    return this.formatSingleMessage(string);
                }
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (IMarker iMarker : list) {
                    String string = iMarker.getAttribute("message", null);
                    if (string == null || string.trim().length() <= 0) continue;
                    arrayList.add(string.trim());
                }
                if (arrayList.size() == 1) {
                    return this.formatSingleMessage((String)arrayList.get(0));
                }
                if (arrayList.size() > 1) {
                    return this.formatMultipleMessages(arrayList);
                }
            }
        }
        return null;
    }

    protected List getMarkersForLine(ISourceViewer iSourceViewer, int n) {
        IDocument iDocument = iSourceViewer.getDocument();
        IAnnotationModel iAnnotationModel = iSourceViewer.getAnnotationModel();
        if (iAnnotationModel == null) {
            return null;
        }
        ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
        ArrayList<IMarker> arrayList2 = new ArrayList<IMarker>();
        Iterator iterator = iAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof MarkerAnnotation)) continue;
            MarkerAnnotation markerAnnotation = (MarkerAnnotation)e;
            switch (this.compareRulerLine(iAnnotationModel.getPosition((Annotation)markerAnnotation), iDocument, n)) {
                case 1: {
                    arrayList.add(markerAnnotation.getMarker());
                    break;
                }
                case 2: {
                    arrayList2.add(markerAnnotation.getMarker());
                }
            }
        }
        return this.select(arrayList, arrayList2);
    }

    protected List select(List list, List list2) {
        return list;
    }

    private String formatSingleMessage(String string) {
        return string;
    }

    private String formatMultipleMessages(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    protected int compareRulerLine(Position position, IDocument iDocument, int n) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            int n2;
            block5: {
                try {
                    n2 = iDocument.getLineOfOffset(position.getOffset());
                    if (n != n2) break block5;
                    return 1;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (n2 <= n && n <= iDocument.getLineOfOffset(position.getOffset() + position.getLength())) {
                return 2;
            }
        }
        return 0;
    }
}

