/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.editor.editors;

import com.unisys.os2200.cbs.dump.IRegisterCBSDump;
import com.unisys.os2200.editor.actions.UDTEditorRefreshAction;
import com.unisys.os2200.editor.content.renderer.UDTEditorContentAssistAction;
import com.unisys.os2200.editor.editors.UDTEditorDocumentProvider;
import com.unisys.os2200.editor.editors.UDTEditorSourceViewer;
import com.unisys.os2200.editor.editors.UDTEditorSourceViewerConfiguration;
import com.unisys.os2200.i18nSupport.Messages;
import com.unisys.os2200.util.ExclusiveFileLockChecker;
import com.unisys.os2200.util.UtilLogger;
import com.unisys.tde.core.ElementSelectionObject;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.OS2200FileEditorInput;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.OS2200NonExistingFileEditorInput;
import com.unisys.tde.core.OS2200ProjectUpdate;
import com.unisys.tde.core.utils.EditorRelatedUtils;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IChangeRulerColumn;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineChangeHover;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextEditorAction;

public class UDTEditor
extends AbstractDecoratedTextEditor {
    private UDTEditorDocumentProvider ueDocProvider = null;
    public static final String PLUGIN_ID = "com.unisys.os2200.editor";
    public static final String UDT_EDITOR_ID = "com.unisys.os2200.editor.UDTEditor";
    private final String CONTENT_ASSIST_ACTION_ID = "ContentAssistProposal";
    private final String CONTENT_ASSIST_RESOURCE_KEY_PREFIX = "ContentAssistProposal.";
    private TextEditorAction fContentAssistAction = null;
    private static String statusMassage = "";
    private static boolean isStatusMsgClean = false;
    private String acctPrintRec = "";
    private int acctPrintRecOffset = -1;
    public boolean isAccPrintFile = false;
    public static final int ACC_PRINT_REC_LMT = 17;
    public static final String ACCOUNT_PRINT_RECORD_END_STRING = "REC";
    public static final String ACC_PRINT_FILE_HEADER = "GENERAL DATABASE PRINT FACILITY";
    private String titleToolTip = null;
    private UDTEditorSourceViewerConfiguration fUDTEditorSourceViewerConfiguration;
    private UDTEditorSourceViewer svr = null;
    private static IRegisterCBSDump registerCBSDump = null;
    private static String fOpenFilePath = new String("");

    public UDTEditor() {
        this.setEditorContextMenuId("#UDTTextEditorContext");
        this.setRulerContextMenuId("#UDTTextRulerContext");
    }

    public UDTEditorSourceViewer getUDTEditorSourceViewer() {
        return this.svr;
    }

    protected void initializeEditor() {
        super.initializeEditor();
    }

    protected void initializeKeyBindingScopes() {
        super.initializeKeyBindingScopes();
    }

    public void dispose() {
        super.dispose();
    }

    protected ISourceViewer createSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, int n) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        this.svr = new UDTEditorSourceViewer(composite, iVerticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), n, this);
        this.getSourceViewerDecorationSupport((ISourceViewer)this.svr);
        return this.svr;
    }

    protected ISharedTextColors getSharedColors() {
        return super.getSharedColors();
    }

    protected IOverviewRuler createOverviewRuler(ISharedTextColors iSharedTextColors) {
        return super.createOverviewRuler(iSharedTextColors);
    }

    protected IAnnotationAccess createAnnotationAccess() {
        return super.createAnnotationAccess();
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport sourceViewerDecorationSupport) {
        super.configureSourceViewerDecorationSupport(sourceViewerDecorationSupport);
    }

    public void createPartControl(Composite composite) {
        OS2200CorePlugin.logger.debug((Object)"In UDTEditor.createPartControl()");
        if (this.getSourceViewer() != null) {
            this.getSourceViewer().configure((SourceViewerConfiguration)this.fUDTEditorSourceViewerConfiguration);
        }
        super.createPartControl(composite);
        this.checkForPrintHeader();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (UDTEditor.getRegisterCBSDump() != null) {
                    IEditorInput iEditorInput = UDTEditor.this.getEditorInput();
                    IDocumentProvider iDocumentProvider = UDTEditor.this.getDocumentProvider();
                    IDocument iDocument = iDocumentProvider.getDocument((Object)iEditorInput);
                    if (iEditorInput instanceof FileEditorInput) {
                        IFile iFile = ((FileEditorInput)iEditorInput).getFile();
                        UDTEditor.getRegisterCBSDump().regDump(iFile.getName(), iDocument);
                    } else if (iEditorInput instanceof OS2200FileEditorInput) {
                        File file = ((OS2200FileEditorInput)iEditorInput).getFile();
                        UDTEditor.getRegisterCBSDump().regDump(file.getName(), iDocument);
                    } else if (iEditorInput instanceof FileStoreEditorInput) {
                        URI uRI = ((FileStoreEditorInput)iEditorInput).getURI();
                        File file = new File(uRI.getPath());
                        UDTEditor.getRegisterCBSDump().regDump(file.getName(), iDocument);
                    }
                }
            }
        });
        this.getSourceViewer().getTextWidget().addCaretListener(new CaretListener(){

            public void caretMoved(CaretEvent caretEvent) {
                block5: {
                    StyledText styledText = null;
                    if (caretEvent.getSource() != null && caretEvent.getSource() instanceof StyledText) {
                        styledText = (StyledText)caretEvent.getSource();
                    }
                    try {
                        if (!UDTEditor.this.isAccPrintFile) break block5;
                        int n = styledText.getLineAtOffset(caretEvent.caretOffset);
                        String string = null;
                        String string2 = null;
                        UDTEditor.this.acctPrintRec = "";
                        int n2 = n;
                        while (n2 >= 0) {
                            string = null;
                            string2 = null;
                            string = styledText.getLine(n2);
                            if (string.length() > 17 && (string2 = string.substring(0, 17).trim()).toUpperCase().endsWith(UDTEditor.ACCOUNT_PRINT_RECORD_END_STRING) && !string2.contains(" ")) {
                                UDTEditor.this.acctPrintRec = string2.substring(0, string2.indexOf(UDTEditor.ACCOUNT_PRINT_RECORD_END_STRING));
                                break;
                            }
                            --n2;
                        }
                    }
                    catch (Exception exception) {
                        OS2200CorePlugin.logger.error((Object)"In UDTEditor in caret moved event", (Throwable)exception);
                    }
                }
            }
        });
    }

    public void checkForPrintHeader() {
        try {
            StyledText styledText = this.getSourceViewer().getTextWidget();
            String string = null;
            if (styledText == null) {
                return;
            }
            int n = Math.min(50, styledText.getLineCount());
            int n2 = 0;
            while (n2 < n) {
                string = styledText.getLine(n2);
                if (string != null && string.trim().equalsIgnoreCase(ACC_PRINT_FILE_HEADER)) {
                    this.isAccPrintFile = true;
                    break;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.error((Object)"Error in UDTEditor.checkForPrintHeader method", (Throwable)exception);
        }
    }

    protected void createOverviewRulerContextMenu() {
        super.createOverviewRulerContextMenu();
    }

    protected IMenuListener createContextMenuListener() {
        return super.createContextMenuListener();
    }

    protected Control createStatusControl(Composite composite, IStatus iStatus) {
        return super.createStatusControl(composite, iStatus);
    }

    protected boolean isOverviewRulerVisible() {
        return super.isOverviewRulerVisible();
    }

    public void showChangeInformation(boolean bl) {
        super.showChangeInformation(bl);
    }

    public boolean isChangeInformationShowing() {
        return super.isChangeInformationShowing();
    }

    public void showRevisionInformation(RevisionInformation revisionInformation, String string) {
        super.showRevisionInformation(revisionInformation, string);
    }

    protected boolean isLineNumberRulerVisible() {
        return super.isLineNumberRulerVisible();
    }

    protected boolean isOverwriteModeEnabled() {
        return super.isOverwriteModeEnabled();
    }

    protected boolean isPrefQuickDiffAlwaysOn() {
        return false;
    }

    protected void initializeLineNumberRulerColumn(LineNumberRulerColumn lineNumberRulerColumn) {
        super.initializeLineNumberRulerColumn(lineNumberRulerColumn);
    }

    protected IVerticalRulerColumn createLineNumberRulerColumn() {
        return super.createLineNumberRulerColumn();
    }

    protected LineChangeHover createChangeHover() {
        return super.createChangeHover();
    }

    protected IChangeRulerColumn createChangeRulerColumn() {
        return super.createChangeRulerColumn();
    }

    protected IVerticalRuler createVerticalRuler() {
        return super.createVerticalRuler();
    }

    protected CompositeRuler createCompositeRuler() {
        return super.createCompositeRuler();
    }

    protected IVerticalRulerColumn createAnnotationRulerColumn(CompositeRuler compositeRuler) {
        return super.createAnnotationRulerColumn(compositeRuler);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent propertyChangeEvent) {
        super.handlePreferenceStoreChanged(propertyChangeEvent);
    }

    protected void showOverviewRuler() {
        super.showOverviewRuler();
    }

    protected void hideOverviewRuler() {
        super.hideOverviewRuler();
    }

    protected IAnnotationAccess getAnnotationAccess() {
        return super.getAnnotationAccess();
    }

    protected AnnotationPreferenceLookup getAnnotationPreferenceLookup() {
        return super.getAnnotationPreferenceLookup();
    }

    protected IOverviewRuler getOverviewRuler() {
        return super.getOverviewRuler();
    }

    protected SourceViewerDecorationSupport getSourceViewerDecorationSupport(ISourceViewer iSourceViewer) {
        return super.getSourceViewerDecorationSupport(iSourceViewer);
    }

    protected MarkerAnnotationPreferences getAnnotationPreferences() {
        return super.getAnnotationPreferences();
    }

    public void gotoMarker(IMarker iMarker) {
        super.gotoMarker(iMarker);
    }

    public boolean isEditable() {
        return super.isEditable();
    }

    public boolean validateEditorInputState() {
        return super.validateEditorInputState();
    }

    protected boolean isErrorStatus(IStatus iStatus) {
        return super.isErrorStatus(iStatus);
    }

    protected void createActions() {
        super.createActions();
        this.fContentAssistAction = new UDTEditorContentAssistAction(Messages.getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this, 13);
        this.fContentAssistAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        UDTEditorRefreshAction uDTEditorRefreshAction = new UDTEditorRefreshAction((IShellProvider)this.getSite());
        uDTEditorRefreshAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
        this.markAsStateDependentAction("org.eclipse.ui.file.refresh", true);
        this.setAction("org.eclipse.ui.file.refresh", (IAction)uDTEditorRefreshAction);
        this.setAction("ContentAssistProposal", (IAction)this.fContentAssistAction);
        this.markAsStateDependentAction("ContentAssistProposal", true);
    }

    public Object getAdapter(Class clazz) {
        return super.getAdapter(clazz);
    }

    protected void setDocumentProvider(IEditorInput iEditorInput) {
        super.setDocumentProvider(iEditorInput);
    }

    public IDocumentProvider getDocumentProvider() {
        return super.getDocumentProvider();
    }

    protected void disposeDocumentProvider() {
        super.disposeDocumentProvider();
    }

    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        this.ueDocProvider = new UDTEditorDocumentProvider();
        this.fUDTEditorSourceViewerConfiguration = new UDTEditorSourceViewerConfiguration();
        if (iEditorInput == null || iEditorInput instanceof OS2200NonExistingFileEditorInput) {
            super.doSetInput(iEditorInput);
            this.setSourceViewerConfiguration(this.fUDTEditorSourceViewerConfiguration);
        } else {
            this.setDocumentProvider((IDocumentProvider)this.ueDocProvider);
            this.setSourceViewerConfiguration(this.fUDTEditorSourceViewerConfiguration);
            super.doSetInput(iEditorInput);
        }
    }

    public static IRegisterCBSDump getRegisterCBSDump() {
        return registerCBSDump;
    }

    public static void setRegisterCBSDump(IRegisterCBSDump iRegisterCBSDump) {
        registerCBSDump = iRegisterCBSDump;
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        String string = null;
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)this.getEditorInput();
            IPath iPath = iFileEditorInput.getFile().getFullPath();
            FileInputStream fileInputStream = null;
            try {
                try {
                    IResource iResource = iFileEditorInput.getFile().getProject().findMember(iPath.segment(1));
                    if (iResource instanceof IFile) {
                        IPath iPath2 = ((IFile)iResource).getRawLocation();
                        if (iPath2 != null) {
                            fileInputStream = new FileInputStream(iPath2.toOSString());
                        }
                        string = this.getworkFile((IFile)iResource);
                    }
                }
                catch (Exception exception) {
                    String string2 = exception.getMessage();
                    ExclusiveFileLockChecker.HandleForExclusiveFileHold((String)string2, string, (String)string2);
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                            fileInputStream = null;
                        }
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                    return;
                }
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                        fileInputStream = null;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        super.doSave(iProgressMonitor);
    }

    private String getworkFile(IFile iFile) throws CoreException {
        IProject iProject = iFile.getProject();
        Properties properties = OS2200ProjectUpdate.getProperties((IProject)iProject);
        String string = properties.getProperty("workFile");
        return string;
    }

    protected void performSaveAs(IProgressMonitor iProgressMonitor) {
        String string;
        String string2;
        Object object;
        boolean bl;
        Object object2;
        IEditorInput iEditorInput;
        block31: {
            Object object3;
            IWorkspace iWorkspace;
            Object object4;
            Shell shell = this.getSite().getShell();
            SaveAsDialog saveAsDialog = new SaveAsDialog(shell);
            iEditorInput = this.getEditorInput();
            if (iEditorInput instanceof IFileEditorInput) {
                saveAsDialog.setOriginalFile(((IFileEditorInput)iEditorInput).getFile());
            } else if (iEditorInput instanceof OS2200FileEditorInput) {
                saveAsDialog.setOriginalName(((OS2200FileEditorInput)iEditorInput).getName().toUpperCase());
            } else if (iEditorInput instanceof FileStoreEditorInput) {
                saveAsDialog.setOriginalName(((FileStoreEditorInput)iEditorInput).getName().toUpperCase());
            } else if (iEditorInput instanceof OS2200NonExistingFileEditorInput) {
                saveAsDialog.setOriginalName(((OS2200NonExistingFileEditorInput)iEditorInput).getName());
            }
            saveAsDialog.open();
            IPath iPath = saveAsDialog.getResult();
            if (iPath == null) {
                if (iProgressMonitor != null) {
                    iProgressMonitor.setCanceled(true);
                }
                return;
            }
            if (iEditorInput instanceof OS2200NonExistingFileEditorInput) {
                UtilLogger.getLogger().debug((Object)" Saving Non-Existing File type.");
                object4 = iPath.segment(0).trim();
                iWorkspace = ResourcesPlugin.getWorkspace().getRoot().getProject((String)object4);
                if (iWorkspace != null) {
                    try {
                        long l = OS2200ProjectUpdate.connectOS2200((IProject)iWorkspace, (boolean)true);
                        if (l != 0L) {
                            String string3 = String.format(Messages.getString((String)"UDTEditor.2"), iPath.segment(1));
                            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"UDTEditor.1"), (String)string3);
                            UtilLogger.getLogger().debug((Object)(" Connection does not exist. " + string3));
                            this.firePropertyChange(257);
                            iProgressMonitor.setCanceled(true);
                            return;
                        }
                    }
                    catch (Exception exception) {
                        UtilLogger.getLogger().error((Object)exception.getMessage(), (Throwable)exception);
                    }
                    object2 = OS2200FileInterface.getCIFSDir((IProject)iWorkspace);
                    if (object2 != null) {
                        object3 = new File((String)object2);
                        if (!((File)object3).exists()) {
                            OS2200FileInterface.validatedWorkFileMsg((IProject)iWorkspace, (String)"DIRNOTREACHABLE");
                            iProgressMonitor.setCanceled(true);
                            return;
                        }
                        if (!((File)object3).isDirectory()) {
                            OS2200FileInterface.validatedWorkFileMsg((IProject)iWorkspace, (String)"ISNOTDIR");
                            iProgressMonitor.setCanceled(true);
                            return;
                        }
                        if (!((File)object3).canWrite()) {
                            OS2200FileInterface.validatedWorkFileMsg((IProject)iWorkspace, (String)"READONLYDIR");
                            iProgressMonitor.setCanceled(true);
                            return;
                        }
                    }
                }
                iWorkspace = null;
                object4 = null;
            }
            object4 = this.getDocumentProvider();
            iWorkspace = ResourcesPlugin.getWorkspace();
            object2 = iWorkspace.getRoot().getFile(iPath);
            object3 = new FileEditorInput(object2);
            if (object4 == null) {
                return;
            }
            bl = false;
            try {
                try {
                    object4.aboutToChange(object3);
                    object4.saveDocument(iProgressMonitor, object3, object4.getDocument((Object)iEditorInput), true);
                    bl = true;
                }
                catch (CoreException coreException) {
                    object = coreException.getStatus();
                    if (object == null || object.getSeverity() != 8) {
                        string2 = Messages.getString((String)"UDTEditor.19");
                        string = NLSUtility.format((String)Messages.getString((String)"UDTEditor.20"), (Object)coreException.getMessage());
                        MessageDialog.openError((Shell)shell, (String)string2, (String)string);
                    }
                    object4.changed(object3);
                    break block31;
                }
            }
            catch (Throwable throwable) {
                object4.changed(object3);
                throw throwable;
            }
            object4.changed(object3);
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.setCanceled(!bl);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        object = "<default>";
        if (object2.getFileExtension() != null) {
            object = object2.getFileExtension();
        }
        string2 = new ElementSelectionObject(object2.getName(), object2.getName(), (String)object);
        arrayList.add(string2);
        try {
            OS2200ProjectUpdate.addLinks((IProject)object2.getProject(), arrayList, (IProgressMonitor)iProgressMonitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            operationCanceledException.printStackTrace();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        if (bl) {
            string = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getPages()[0];
            string.closeEditor(string.findEditor(iEditorInput), false);
        }
    }

    protected void openSaveErrorDialog(String string, String string2, CoreException coreException) {
        super.openSaveErrorDialog(string, string2, coreException);
    }

    protected void setOverviewRulerContextMenuId(String string) {
        super.setOverviewRulerContextMenuId(string);
    }

    protected void overviewRulerContextMenuAboutToShow(IMenuManager iMenuManager) {
        super.overviewRulerContextMenuAboutToShow(iMenuManager);
    }

    protected void rulerContextMenuAboutToShow(IMenuManager iMenuManager) {
        super.rulerContextMenuAboutToShow(iMenuManager);
    }

    protected void editorContextMenuAboutToShow(IMenuManager iMenuManager) {
        super.editorContextMenuAboutToShow(iMenuManager);
    }

    protected String[] collectContextMenuPreferencePages() {
        return super.collectContextMenuPreferencePages();
    }

    protected String[] collectRulerMenuPreferencePages() {
        return super.collectRulerMenuPreferencePages();
    }

    protected String[] collectOverviewRulerMenuPreferencePages() {
        return super.collectOverviewRulerMenuPreferencePages();
    }

    protected IOperationApprover getUndoRedoOperationApprover(IUndoContext iUndoContext) {
        return super.getUndoRedoOperationApprover(iUndoContext);
    }

    protected boolean isNavigationTarget(Annotation annotation) {
        return super.isNavigationTarget(annotation);
    }

    public Annotation gotoAnnotation(boolean bl) {
        return super.gotoAnnotation(bl);
    }

    protected void updateMarkerViews(Annotation annotation) {
        super.updateMarkerViews(annotation);
    }

    protected boolean isTabsToSpacesConversionEnabled() {
        return super.isTabsToSpacesConversionEnabled();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isEditorInputReadOnly() {
        if (this.getEditorInput() instanceof OS2200FileEditorInput) {
            File file = new File(((OS2200FileEditorInput)this.getEditorInput()).getPath().toOSString());
            return !file.canWrite();
        }
        if (this.getEditorInput() instanceof FileEditorInput) {
            File file = new File(((FileEditorInput)this.getEditorInput()).getPath().toOSString());
            return !file.canWrite();
        }
        if (this.getEditorInput() instanceof FileStoreEditorInput) {
            File file = new File(((FileStoreEditorInput)this.getEditorInput()).getURI().getPath());
            return !file.canWrite();
        }
        return false;
    }

    public String getPartName() {
        return super.getPartName().toUpperCase();
    }

    protected void setPartName(String string) {
        super.setPartName(string.toUpperCase());
    }

    public void updateStatusField(String string) {
        try {
            if ("InputPosition".equals(string)) {
                IStatusLineManager iStatusLineManager;
                EditorSite editorSite;
                IActionBars iActionBars;
                IWorkbench iWorkbench;
                IWorkbenchWindow iWorkbenchWindow;
                IWorkbenchPage iWorkbenchPage;
                IWorkbenchPart iWorkbenchPart;
                IWorkbenchPartSite iWorkbenchPartSite;
                if (isStatusMsgClean && (iWorkbenchPartSite = (iWorkbenchPart = (iWorkbenchPage = (iWorkbenchWindow = (iWorkbench = PlatformUI.getWorkbench()).getActiveWorkbenchWindow()).getActivePage()).getActivePart()).getSite()) instanceof EditorSite && (iActionBars = (editorSite = (EditorSite)iWorkbenchPartSite).getActionBars()) != null && (iStatusLineManager = iActionBars.getStatusLineManager()) != null) {
                    iStatusLineManager.setMessage("");
                }
                if ((iWorkbench = this.getStatusField("InputPosition")) != null) {
                    iWorkbench.setText(this.getCursorPosition());
                }
                if ((iWorkbenchWindow = this.getStatusField("TextSelect")) != null) {
                    iWorkbenchWindow.setText(statusMassage);
                }
            } else {
                IWorkbench iWorkbench = PlatformUI.getWorkbench();
                IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
                IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                IWorkbenchPart iWorkbenchPart = iWorkbenchPage.getActivePart();
                IWorkbenchPartSite iWorkbenchPartSite = iWorkbenchPart.getSite();
                if (iWorkbenchPartSite instanceof EditorSite) {
                    EditorSite editorSite = (EditorSite)iWorkbenchPartSite;
                    editorSite.getActionBars();
                }
                super.updateStatusField(string);
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    public static void setStatusMessage(String string, boolean bl) {
        statusMassage = string;
        isStatusMsgClean = bl;
    }

    public String getTitleToolTip() {
        if (this.titleToolTip == null) {
            this.titleToolTip = EditorRelatedUtils.getPathIn2200Format((IEditorInput)this.getEditorInput(), null);
        }
        return this.titleToolTip;
    }

    public String getAcctPrintRec() {
        return this.acctPrintRec;
    }

    public void setAcctPrintRec(String string) {
        this.acctPrintRec = string;
    }

    public int getAcctPrintRecOffset() {
        return this.acctPrintRecOffset;
    }

    public void setAcctPrintRecOffset(int n) {
        this.acctPrintRecOffset = n;
    }

    private void setOpenFilePath() {
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof IStorageEditorInput) {
            try {
                fOpenFilePath = ((IStorageEditorInput)iEditorInput).getStorage().getFullPath().toString();
            }
            catch (CoreException coreException) {}
        } else if (iEditorInput instanceof IPathEditorInput) {
            fOpenFilePath = ((IPathEditorInput)iEditorInput).getPath().toPortableString();
        } else if (iEditorInput instanceof FileStoreEditorInput) {
            fOpenFilePath = ((FileStoreEditorInput)iEditorInput).getURI().getPath();
        } else if (!(iEditorInput instanceof OS2200NonExistingFileEditorInput)) {
            FileEditorInput fileEditorInput = (FileEditorInput)this.getEditorInput();
            IFile iFile = fileEditorInput.getFile();
            fOpenFilePath = iFile.getFullPath().toString();
        }
    }
}

