/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.editor.contentassistant;

import com.unisys.os2200.editor.contentassistant.Category;
import com.unisys.os2200.editor.contentassistant.UDTEditorTemplate;
import com.unisys.tde.core.OS2200CorePlugin;
import com.unisys.tde.core.characterset.OS2200CharSetPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.templates.Template;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class UDTEditorTemplateManager {
    public static final String TEMPLATE_FILE = "templates.xml";
    private static final String ROOT_TAG = "syntaxtemplate";
    private static final String CATEGORY_TAG = "category";
    private static final String TEMPLATE_TAG = "template";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String KEYWORD_ATTRIBUTE = "keyword";
    private static final String EXPANDED_ATTRIBUTE = "expanded";
    private static final String TEXT_TAG = "#text";
    private static final String TRUE = "true";
    private static UDTEditorTemplateManager fTemplateManager = null;
    private ArrayList<Template> fAllTemplates = null;
    private final String packageName = "com.unisys.os2200.editor";
    private final String fileName = "ecl-templates.xml";

    private UDTEditorTemplateManager() {
    }

    public static UDTEditorTemplateManager getInstance() {
        if (fTemplateManager == null) {
            fTemplateManager = new UDTEditorTemplateManager();
            fTemplateManager.create();
        }
        return fTemplateManager;
    }

    public void addFromStream(InputStream inputStream) throws Exception {
        try {
            Object object;
            Object object2;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(inputStream));
            Category category = Category.getRootCategoryInstance();
            Node node = document.getElementsByTagName(ROOT_TAG).item(0);
            NamedNodeMap namedNodeMap = node.getAttributes();
            try {
                if (namedNodeMap != null && (object2 = namedNodeMap.getNamedItem(EXPANDED_ATTRIBUTE)) != null && (object = object2.getNodeValue()) != null) {
                    object = ((String)object).trim();
                    category.setExpandedState(((String)object).equalsIgnoreCase(TRUE));
                }
            }
            catch (NullPointerException nullPointerException) {
                OS2200CorePlugin.logger.error((Object)nullPointerException);
            }
            object2 = document.getElementsByTagName(ROOT_TAG).item(0).getChildNodes();
            object = new Stack();
            ((Stack)object).push(category);
            ((Stack)object).push(object2);
            this.populateTreeModel((Stack<Object>)object);
        }
        catch (Exception exception) {
            OS2200CorePlugin.logger.warn((Object)exception);
        }
    }

    private Category getExistingCategory(String string, Category category) {
        Category[] categoryArray = category.getCategoryChildren();
        int n = categoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (string.equalsIgnoreCase(categoryArray[n2].getName())) {
                return categoryArray[n2];
            }
            ++n2;
        }
        return null;
    }

    private void populateTreeModel(Stack<Object> stack) throws Exception {
        String string = "";
        String string2 = "";
        Category category = null;
        NodeList nodeList = null;
        while (!stack.empty()) {
            nodeList = (NodeList)stack.pop();
            category = (Category)stack.pop();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 != n) {
                NamedNodeMap namedNodeMap;
                Node node = nodeList.item(n2);
                if (!node.getNodeName().equals(TEXT_TAG) && (namedNodeMap = node.getAttributes()) != null) {
                    Object object;
                    string = namedNodeMap.getNamedItem(NAME_ATTRIBUTE).getNodeValue();
                    string2 = namedNodeMap.getNamedItem(DESCRIPTION_ATTRIBUTE).getNodeValue();
                    if (node.getNodeName().equals(CATEGORY_TAG)) {
                        object = null;
                        object = this.getExistingCategory(string, category);
                        if (object == null) {
                            object = new Category(string, string2, category);
                            category.addCategoryChild((Category)object);
                        } else {
                            object.setDescription(string2);
                        }
                        try {
                            String string3 = namedNodeMap.getNamedItem(EXPANDED_ATTRIBUTE).getNodeValue();
                            if (string3 != null) {
                                string3 = string3.trim();
                                object.setExpandedState(string3.equalsIgnoreCase(TRUE));
                            }
                        }
                        catch (NullPointerException nullPointerException) {
                            OS2200CorePlugin.logger.error((Object)nullPointerException);
                        }
                        stack.push(object);
                        stack.push(node.getChildNodes());
                    } else if (node.getNodeName().equals(TEMPLATE_TAG)) {
                        object = null;
                        String string4 = namedNodeMap.getNamedItem(KEYWORD_ATTRIBUTE).getNodeValue();
                        NodeList nodeList2 = node.getChildNodes();
                        String string5 = "";
                        if (nodeList2.getLength() != 0) {
                            string5 = nodeList2.item(0).getNodeValue();
                        }
                        object = new UDTEditorTemplate(string, string2, string4, string5, category);
                        category.addTemplateChild((UDTEditorTemplate)((Object)object));
                    }
                }
                ++n2;
            }
        }
    }

    public void clear(Category category) {
        category.clearChildren();
        category = null;
    }

    public ArrayList<Template> getAllTemplates() {
        if (this.fAllTemplates == null) {
            Category category = Category.getRootCategoryInstance();
            this.fAllTemplates = new ArrayList();
            this.populateTemplateList(category);
        }
        return this.fAllTemplates;
    }

    private void populateTemplateList(Category category) {
        Object[] objectArray;
        ArrayList<UDTEditorTemplate> arrayList = new ArrayList<UDTEditorTemplate>();
        if (category != null) {
            Category[] categoryArray;
            objectArray = category.getTemplateChildren();
            int n = objectArray.length;
            if (objectArray != null && n > 0) {
                int n2 = 0;
                while (n2 < n) {
                    arrayList.add(objectArray[n2]);
                    ++n2;
                }
            }
            if ((categoryArray = category.getCategoryChildren()) != null) {
                int n3 = categoryArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    this.populateTemplateList(categoryArray[n4]);
                    ++n4;
                }
            }
        }
        objectArray = null;
        UDTEditorTemplate uDTEditorTemplate = null;
        int n = 0;
        while (n < arrayList.size()) {
            uDTEditorTemplate = (UDTEditorTemplate)((Object)arrayList.get(n));
            objectArray = new String[]{uDTEditorTemplate.getName(), uDTEditorTemplate.getKeyword(), uDTEditorTemplate.getDescription(), uDTEditorTemplate.getPattern()};
            this.fAllTemplates.add(uDTEditorTemplate);
            ++n;
        }
    }

    public void create() {
        block12: {
            InputStream inputStream = null;
            try {
                try {
                    File file = OS2200CharSetPlugin.getFilePath((String)"ecl-templates.xml");
                    inputStream = new FileInputStream(file);
                    this.addFromStream(inputStream);
                }
                catch (Exception exception) {
                    OS2200CorePlugin.logger.error((Object)exception);
                    if (inputStream == null) break block12;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        OS2200CorePlugin.logger.info((Object)iOException);
                    }
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        OS2200CorePlugin.logger.info((Object)iOException);
                    }
                }
            }
        }
    }

    public static String getPluginDirectoryPath(String string, String string2) {
        Path path;
        block4: {
            if (OS2200CorePlugin.logger.isInfoEnabled()) {
                OS2200CorePlugin.logger.info((Object)"");
            }
            path = null;
            try {
                Bundle bundle = Platform.getBundle((String)string);
                if (bundle != null) {
                    URL uRL = FileLocator.resolve((URL)bundle.getEntry("/"));
                    path = new Path(uRL.getFile());
                    path = path.append(string2);
                    break block4;
                }
                return null;
            }
            catch (Exception exception) {
                OS2200CorePlugin.logger.error((Object)exception);
            }
        }
        return path.toOSString();
    }
}

